﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CamNet;

namespace CamNetTest
{
    public partial class Form_SaveOption : Form
    {
        public enum SAVE_TYPE
        {
            SAVE_DATE = 0,
            SAVE_CUSTOM = 1
        };

        public SAVE_TYPE m_SaveType = SAVE_TYPE.SAVE_DATE;

        public String m_strSaveFileName = "";
        public String m_strSaveFilePath = "";

        public bool m_bEnableViewer=false;
        public bool m_bUseGps=false;
        public bool m_bHistoEqual=false;

        public bool m_bAutoInit = true;
        public bool m_UseEXIF = true;
        public bool m_bDateTime = false;
        public Cam m_Cam;

        public bool m_bOK = false;

        public String APPVERSION = "1.2.0";
        public String APPRELEASE = "2014-01-15";
        
        public Form_SaveOption(Cam cam)
        {
            InitializeComponent();
            m_Cam = cam;
        }

        private void Form_SaveOption_Load(object sender, EventArgs e)
        {
            StringBuilder tmp1=new StringBuilder();
            StringBuilder tmp2 = new StringBuilder();

            m_Cam.GetVersion(tmp1, tmp2);
            m_szAPP_version.Text = "APP:" + APPVERSION + " (" + APPRELEASE + ")";
            string tmp3, tmp4;
            m_Cam.GetNetVersion(out tmp3, out tmp4);
            m_szNetDLL_version.Text = "Net DLL:" + tmp3 + " (" + tmp4 + ")";
            m_szDLL_version.Text = "DLL:" + tmp1 + " (" + tmp2 + ")"; 

            textBox_SaveFolder.Text = m_strSaveFilePath;
            textBox_SaveName.Text = m_strSaveFileName;

            comboBox_Compression.Items.Insert(0, "Low Quality");
            comboBox_Compression.Items.Insert(1, "Normal quality");
            comboBox_Compression.Items.Insert(2, "High quality");
            comboBox_Compression.SelectedIndex = m_Cam.GetQuality();

            comboBox_SaveMode.Items.Insert(0, "Date Mode");
            comboBox_SaveMode.Items.Insert(1, "Custom Mode");
            comboBox_SaveMode.SelectedIndex = (int)m_SaveType;


            if (m_bAutoInit)
                checkBox_AutoPreview.Checked = true;
            else
                checkBox_AutoPreview.Checked = false;

            if (m_UseEXIF)
                checkBox_UseEXIF.Checked = true;
            else
                checkBox_UseEXIF.Checked = false;

            if (m_bDateTime)
                CheckDateTime.Checked=true;
            else
                CheckDateTime.Checked=false;

            ChangeSaveMode();
        }

        private void comboBox_SaveMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            ChangeSaveMode();
        }

        private void ChangeSaveMode()
        {
            if(comboBox_SaveMode.SelectedIndex == (int)SAVE_TYPE.SAVE_DATE)
            {
                label_SaveName.Enabled = false;
                textBox_SaveName.Enabled = false;

            }
            else
            {
                label_SaveName.Enabled = true;
                textBox_SaveName.Enabled = true;
            }
        }

        private void menuItem_OK_Click(object sender, EventArgs e)
        {
            m_Cam.SetQuality(comboBox_Compression.SelectedIndex);
            m_strSaveFilePath = textBox_SaveFolder.Text;
            m_strSaveFileName = textBox_SaveName.Text;

            m_SaveType = (SAVE_TYPE)comboBox_SaveMode.SelectedIndex;

            if (m_SaveType == SAVE_TYPE.SAVE_CUSTOM)
            {
                if(m_strSaveFileName.CompareTo("")==0)
                {
                    MessageBox.Show("Input Save Filename!!");
                    return;
                }
            }

            if (m_strSaveFileName.CompareTo("") != 0)
            {
                if(m_strSaveFileName.IndexOf(".j")==-1 && m_strSaveFileName.IndexOf(".b")==-1 && m_strSaveFileName.IndexOf(".J")==-1 && m_strSaveFileName.IndexOf(".B")==-1)
                {
                    m_strSaveFileName += ".jpg";
                    /*
                        if(m_bHistoEqual)
                                                    m_strSaveFileName += ".bmp";
                                                else
                                                    m_strSaveFileName += ".jpg";*/
                        
                }
            }

            m_bAutoInit = checkBox_AutoPreview.Checked;
            m_UseEXIF = checkBox_UseEXIF.Checked;
            
            m_bOK = true;

            m_Cam.UseGPSExifData(checkBox_Exif_Gps.Checked);

            m_bDateTime = CheckDateTime.Checked;
            m_bEnableViewer = checkBox_ViewAfterCapturing.Checked;

            Close();

        }

        private void menuItem_Cancel_Click(object sender, EventArgs e)
        {
            m_bOK = false;

            Close();
        }

        private void checkBox_UseEXIF_CheckStateChanged(object sender, EventArgs e)
        {
            if(checkBox_UseEXIF.Checked == true)
            {
                checkBox_Exif_Gps.Enabled = true;
            }
            else
            {
                checkBox_Exif_Gps.Checked = false;
                checkBox_Exif_Gps.Enabled = false;
            }
        }

        private void CheckDateTime_CheckStateChanged(object sender, EventArgs e)
        {
           
        }



    }
}