﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;
using CamNet;

namespace CamNetTest
{
    public partial class Form_ImageOption : Form
    {
        Cam m_Cam;
        public AF_MODE m_AFMode = AF_MODE.AF_MANUAL;

        public bool m_bHistoEqual;
        public bool m_bDateTime;
        public int m_nWBValue;
        public bool m_bUseEXIF;
        public int m_nBrightnessValue;
        public int m_nContrastValue;
        public int m_nSharpnessValue;

        public bool m_bOK = false;

        public Form_ImageOption(Cam cam)
        {
            InitializeComponent();

            m_Cam = cam;
        }

        private void Form_ImageOption_Load(object sender, EventArgs e)
        {
            MODEL_TYPE model = m_Cam.GetModelType();

            InitResolutionUI();

            int nValue;
            nValue = m_Cam.GetResolution();
            comboBox_Resolution.SelectedIndex = nValue;

            comboBox_WhiteBalance.Items.Insert((int)WHITE_BALANCE.WB_Auto, "Auto");
            comboBox_WhiteBalance.Items.Insert((int)WHITE_BALANCE.WB_Sunny, "Sunny");
            comboBox_WhiteBalance.Items.Insert((int)WHITE_BALANCE.WB_Cloudy, "Cloudy");
            comboBox_WhiteBalance.Items.Insert((int)WHITE_BALANCE.WB_Fluorescent, "Fluorescent");
            comboBox_WhiteBalance.Items.Insert((int)WHITE_BALANCE.WB_Incandescent, "Incandescent");
            comboBox_WhiteBalance.SelectedIndex = m_nWBValue;
            switch (model)
            {
                case MODEL_TYPE.MODEL_MM3:
                    {
                        comboBox_Brightness.Items.Insert(0, "+3");
                        comboBox_Brightness.Items.Insert(1, "+2");
                        comboBox_Brightness.Items.Insert(2, "+1");
                        comboBox_Brightness.Items.Insert(3, "0");
                        comboBox_Brightness.Items.Insert(4, "-1");
                        comboBox_Brightness.Items.Insert(5, "-2");
                        comboBox_Brightness.Items.Insert(6, "-3");

                        nValue = (m_nBrightnessValue - 3) * -1;
                        comboBox_Brightness.SelectedIndex = nValue;

                        comboBox_Contrast.Items.Insert(0, "Not Supported");
                        comboBox_Contrast.SelectedIndex = 0;
                        comboBox_Contrast.Enabled = false;

                        comboBox_Sharpness.Items.Insert(0, "Not Supported");
                        comboBox_Sharpness.SelectedIndex = 0;
                        comboBox_Sharpness.Enabled = false;

                        comboBox_SmartSetting.Items.Insert(0, "Not Supported");
                        comboBox_SmartSetting.SelectedIndex = 0;
                        comboBox_SmartSetting.Enabled = false;

                        comboBox_AfMode.Items.Insert(0, "Fixed Focus");
                        comboBox_AfMode.SelectedIndex = 0;
                        comboBox_AfMode.Enabled = false;
                    }
                    break;

                case MODEL_TYPE.MODEL_SKY:
                    {
                        comboBox_Brightness.Items.Insert(0, "+3");
                        comboBox_Brightness.Items.Insert(1, "+2");
                        comboBox_Brightness.Items.Insert(2, "+1");
                        comboBox_Brightness.Items.Insert(3, "0");
                        comboBox_Brightness.Items.Insert(4, "-1");
                        comboBox_Brightness.Items.Insert(5, "-2");
                        comboBox_Brightness.Items.Insert(6, "-3");
                        nValue = (m_nBrightnessValue - 3) * -1;
                        comboBox_Brightness.SelectedIndex = nValue;

                        comboBox_Contrast.Items.Insert(0, "Not Supported");
                        comboBox_Contrast.SelectedIndex = 0;
                        comboBox_Sharpness.Items.Insert(0, "Not Supported");
                        comboBox_Sharpness.SelectedIndex = 0;
                        comboBox_SmartSetting.Items.Insert(0, "Not Supported");
                        comboBox_SmartSetting.SelectedIndex = 0;


                        comboBox_Contrast.Enabled = false;
                        comboBox_Sharpness.Enabled = false;
                        comboBox_SmartSetting.Enabled = false;

                        comboBox_AfMode.Items.Insert(0, "Manual AF");
                        comboBox_AfMode.Items.Insert(1, "Always AF");
                        comboBox_AfMode.Items.Insert(2, "Auto AF");
                        comboBox_AfMode.SelectedIndex = (int)m_AFMode;

                    }
                    break;

                case MODEL_TYPE.MODEL_ORANGE:
                    {
                        comboBox_Brightness.Items.Insert(0, "+5");
                        comboBox_Brightness.Items.Insert(1, "+4");
                        comboBox_Brightness.Items.Insert(2, "+3");
                        comboBox_Brightness.Items.Insert(3, "+2");
                        comboBox_Brightness.Items.Insert(4, "+1");
                        comboBox_Brightness.Items.Insert(5, "0");
                        comboBox_Brightness.Items.Insert(6, "-1");
                        comboBox_Brightness.Items.Insert(7, "-2");
                        comboBox_Brightness.Items.Insert(8, "-3");
                        comboBox_Brightness.Items.Insert(9, "-4");
                        comboBox_Brightness.Items.Insert(10, "-5");
                        nValue = (m_nBrightnessValue - 5) * -1;
                        comboBox_Brightness.SelectedIndex = nValue;

                        comboBox_Contrast.Items.Insert(0, "+4");
                        comboBox_Contrast.Items.Insert(1, "+3");
                        comboBox_Contrast.Items.Insert(2, "+2");
                        comboBox_Contrast.Items.Insert(3, "+1");
                        comboBox_Contrast.Items.Insert(4, "0");
                        comboBox_Contrast.Items.Insert(5, "-1");
                        comboBox_Contrast.Items.Insert(6, "-2");
                        comboBox_Contrast.Items.Insert(7, "-3");
                        comboBox_Contrast.Items.Insert(8, "-4");
                        nValue = 4 - m_nContrastValue;
                        comboBox_Contrast.SelectedIndex = nValue;

                        comboBox_Sharpness.Items.Insert(0, "0");
                        comboBox_Sharpness.Items.Insert(1, "1");
                        comboBox_Sharpness.Items.Insert(2, "2");
                        comboBox_Sharpness.Items.Insert(3, "3");
                        comboBox_Sharpness.Items.Insert(4, "4");
                        comboBox_Sharpness.Items.Insert(5, "5");
                        comboBox_Sharpness.Items.Insert(6, "6");
                        comboBox_Sharpness.Items.Insert(7, "7");
                        comboBox_Sharpness.Items.Insert(8, "8");
                        nValue = m_nSharpnessValue;
                        comboBox_Sharpness.SelectedIndex = nValue;

                        comboBox_SmartSetting.Items.Insert(0, "Not set");
                        comboBox_SmartSetting.Items.Insert(1, "Room");
                        comboBox_SmartSetting.Items.Insert(2, "Outside in the day");
                        comboBox_SmartSetting.Items.Insert(3, "Outside in the night");
                        comboBox_SmartSetting.SelectedIndex = 0;

                        comboBox_AfMode.Items.Insert(0, "Manual AF");
                        comboBox_AfMode.Items.Insert(1, "Always AF");
                        comboBox_AfMode.Items.Insert(2, "Auto AF");
                        comboBox_AfMode.SelectedIndex = (int)m_AFMode;
                    }
                    break;

                case MODEL_TYPE.MODEL_SMART:
                case MODEL_TYPE.MODEL_ORANGE_PLUS:
                    {
                        comboBox_Brightness.Items.Insert(0, "+5");
                        comboBox_Brightness.Items.Insert(1, "+4");
                        comboBox_Brightness.Items.Insert(2, "+3");
                        comboBox_Brightness.Items.Insert(3, "+2");
                        comboBox_Brightness.Items.Insert(4, "+1");
                        comboBox_Brightness.Items.Insert(5, "0");
                        comboBox_Brightness.Items.Insert(6, "-1");
                        comboBox_Brightness.Items.Insert(7, "-2");
                        comboBox_Brightness.Items.Insert(8, "-3");
                        comboBox_Brightness.Items.Insert(9, "-4");
                        comboBox_Brightness.Items.Insert(10, "-5");
                        nValue = 10 - m_nBrightnessValue;
                        comboBox_Brightness.SelectedIndex = nValue;

                        comboBox_Contrast.Items.Insert(0, "+4");
                        comboBox_Contrast.Items.Insert(1, "+3");
                        comboBox_Contrast.Items.Insert(2, "+2");
                        comboBox_Contrast.Items.Insert(3, "+1");
                        comboBox_Contrast.Items.Insert(4, "0");
                        comboBox_Contrast.Items.Insert(5, "-1");
                        comboBox_Contrast.Items.Insert(6, "-2");
                        comboBox_Contrast.Items.Insert(7, "-3");
                        comboBox_Contrast.Items.Insert(8, "-4");
                        nValue = (8 - m_nContrastValue);
                        comboBox_Contrast.SelectedIndex = nValue;

                        comboBox_Sharpness.Items.Insert(0, "0");
                        comboBox_Sharpness.Items.Insert(1, "1");
                        comboBox_Sharpness.Items.Insert(2, "2");
                        comboBox_Sharpness.Items.Insert(3, "3");
                        comboBox_Sharpness.Items.Insert(4, "4");
                        comboBox_Sharpness.Items.Insert(5, "5");
                        comboBox_Sharpness.Items.Insert(6, "6");
                        comboBox_Sharpness.Items.Insert(7, "7");
                        comboBox_Sharpness.Items.Insert(8, "8");
                        nValue = m_nSharpnessValue;
                        comboBox_Sharpness.SelectedIndex = nValue;

                        comboBox_SmartSetting.Items.Insert(0, "Not Supported");
                        comboBox_SmartSetting.SelectedIndex = 0;
                        comboBox_SmartSetting.Enabled = false;

                        comboBox_AfMode.Items.Insert(0, "Manual AF");
                        comboBox_AfMode.Items.Insert(1, "Always AF");

                        comboBox_AfMode.SelectedIndex = (int)m_AFMode;
                    }
                    break;
                case MODEL_TYPE.MODEL_BLACK:
                    {
                        comboBox_Brightness.Items.Insert(0, "+4");
                        comboBox_Brightness.Items.Insert(1, "+3");
                        comboBox_Brightness.Items.Insert(2, "+2");
                        comboBox_Brightness.Items.Insert(3, "+1");
                        comboBox_Brightness.Items.Insert(4, "0");
                        comboBox_Brightness.Items.Insert(5, "-1");
                        comboBox_Brightness.Items.Insert(6, "-2");
                        comboBox_Brightness.Items.Insert(7, "-3");
                        comboBox_Brightness.Items.Insert(8, "-4");
                        nValue = (m_nBrightnessValue - 4) * -1;
                        comboBox_Brightness.SelectedIndex = nValue;

                        comboBox_Contrast.Items.Insert(0, "Not Supported");
                        comboBox_Contrast.SelectedIndex = 0;
                        comboBox_Contrast.Enabled = false;

                        comboBox_Sharpness.Items.Insert(0, "Not Supported");
                        comboBox_Sharpness.SelectedIndex = 0;
                        comboBox_Sharpness.Enabled = false;

                        comboBox_SmartSetting.Items.Insert(0, "Not Supported");
                        comboBox_SmartSetting.SelectedIndex = 0;
                        comboBox_SmartSetting.Enabled = false;

                        comboBox_AfMode.Items.Insert((int)AF_MODE.AF_MANUAL, "Manual AF");
                        comboBox_AfMode.Items.Insert((int)AF_MODE.AF_ALWAYS, "Always AF");

                        comboBox_AfMode.SelectedIndex = (int)m_AFMode;
                    }
                    break;
            }

            checkBox_NightMode.Checked = m_bHistoEqual;

            m_Cam.Close();
        }

        private void InitResolutionUI()
        {
            string strValueName = "OptionNum";
            string strPath = "Software\\Microsoft\\Pictures\\Camera\\OEM\\PictureResolution";
            int nResolutionIndex;


            //		Reg reg = new Reg();

            uint dwordItemCount = 0;
            //	The key HKEY_LOCAL_MACHINE\Software\Microsoft\Pictures\Camera\OEM\PictureResolution\ defines the total number of resolution settings available on a device.
            //	This value represents the number of available resolutions.


            dwordItemCount = Convert.ToUInt32(Registry.LocalMachine.OpenSubKey(strPath).GetValue(strValueName));

            if (0 != dwordItemCount)
            {
                uint[] ItemName = new uint[dwordItemCount * 2];

                RegistryKey hMainKey = Registry.LocalMachine.OpenSubKey(strPath);

                nResolutionIndex = 0;

                foreach (String SubKeyName in hMainKey.GetSubKeyNames())
                {
                    String SubKeyPath = "Software\\Microsoft\\Pictures\\Camera\\OEM\\PictureResolution\\" + SubKeyName;
                    nResolutionIndex = Convert.ToInt32(SubKeyName);

                    RegistryKey SubKey = Registry.LocalMachine.OpenSubKey(SubKeyPath);
                    ItemName[nResolutionIndex * 2 - 2] = Convert.ToUInt32(SubKey.GetValue("Width"));
                    ItemName[nResolutionIndex * 2 - 1] = Convert.ToUInt32(SubKey.GetValue("Height"));
                    nResolutionIndex += 1;
                }

                nResolutionIndex = 0;
                while (nResolutionIndex < dwordItemCount)
                {
                    comboBox_Resolution.Items.Add(Convert.ToString(ItemName[nResolutionIndex * 2]) + "x" + Convert.ToString(ItemName[nResolutionIndex * 2 + 1]));
                    nResolutionIndex += 1;
                }
            }


        }

        private void menuItem_OK_Click(object sender, EventArgs e)
        {
            MODEL_TYPE model = m_Cam.GetModelType();
            int nValue;

            nValue = comboBox_Resolution.SelectedIndex;
            m_Cam.SetResolution(nValue);

            if ((model == MODEL_TYPE.MODEL_MM3 || model == MODEL_TYPE.MODEL_ORANGE
                || model == MODEL_TYPE.MODEL_SKY || model == MODEL_TYPE.MODEL_BLACK) && nValue == 0 && m_bDateTime)
                m_bDateTime = false;

            if (checkBox_NightMode.Checked == true)
            {
                m_Cam.SetHistoEqual(true);
                m_bHistoEqual = true;
            }
            else
            {
                m_Cam.SetHistoEqual(false);
                m_bHistoEqual = false;
            }

            m_nWBValue = comboBox_WhiteBalance.SelectedIndex;

            switch (model)
            {
                case MODEL_TYPE.MODEL_MM3:
                    m_nBrightnessValue = (comboBox_Brightness.SelectedIndex - 3) * -1;
                    break;

                case MODEL_TYPE.MODEL_SKY:
                    m_nBrightnessValue = (comboBox_Brightness.SelectedIndex - 3) * -1;
                    m_AFMode = (AF_MODE)comboBox_AfMode.SelectedIndex;
                    break;

                case MODEL_TYPE.MODEL_ORANGE:
                    m_nContrastValue = (comboBox_Contrast.SelectedIndex - 4) * -1;
                    m_nSharpnessValue = comboBox_Sharpness.SelectedIndex;
                    m_nBrightnessValue = (comboBox_Brightness.SelectedIndex - 5) * -1;
                    m_AFMode = (AF_MODE)comboBox_AfMode.SelectedIndex;
                    break;

                case MODEL_TYPE.MODEL_ORANGE_PLUS:
                case MODEL_TYPE.MODEL_SMART:
                    m_nSharpnessValue = (comboBox_Sharpness.SelectedIndex);
                    m_nContrastValue = (8 - comboBox_Contrast.SelectedIndex);
                    m_nBrightnessValue = (10 - comboBox_Brightness.SelectedIndex);
                    m_AFMode = (AF_MODE)comboBox_AfMode.SelectedIndex;
                    break;

                case MODEL_TYPE.MODEL_BLACK:
                    m_nBrightnessValue = (comboBox_Brightness.SelectedIndex - 4) * -1;
                    m_AFMode = (AF_MODE)comboBox_AfMode.SelectedIndex;
                    break;
            }
            
            m_bOK = true;
            Close();
        }

        private void menuItem_Cancel_Click(object sender, EventArgs e)
        {
            m_bOK = true;
            Close();
        }
    }
}