﻿/********************************************************************
created		:	2011/10/11
file base	:   CamTestNet.exe
file ext    :   cs
author      :   Kevin
purpose     :   WM Camera C# Demo Program
Report      :   2012. 01. 13 [01/13/2012 khj1528] v1.0.0 - Release Version 
 * v.1.1.0   Orange Plus 추가 및 동영상 녹화 기능 제거 [8/7/2013 JJ]
 * v.1.2.0  BLACK 추가 2014-01-15
*********************************************************************/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Threading;
using Microsoft.WindowsCE.Forms;
using CamNet;
using Microsoft.Win32;
using System.Diagnostics;

namespace CamNetTest
{

    public partial class Form_Cam : Form
    {
        // Const
        const int HWND_BROADCAST = 0xffff;
        const int WM_USER = 0x0400;
        const int WM_CONVERT = WM_USER + 232;

        Cam m_Cam = new Cam();
        CameraMessage m_CamMessage = new CameraMessage();

        // Flag
        bool m_bPreviewOn = false;
        bool m_bFlashOn = false;
        bool m_bAutoFocusing = false;
        bool m_bStillCapturing = false;
        bool m_bCameraOpen = false;
        bool m_bUseExif = true;
        bool m_bExifGps= true;
        bool m_bHistoEqual = false;
        bool bRegister = false;
        int m_dwBackupCameraKey = 0;
        int m_dwBackupScannerKey = 0;
        bool m_bEnableViewer = false;
        bool m_bWakeUp = false;
        bool m_bDateTime = false;
        bool m_bPressedCaptureKey = false;
        SAVE_TYPE m_SaveType = SAVE_TYPE.SAVE_DATE;

        // Setting
        bool m_bAutoInit = true;
        MODEL_TYPE m_ModelType = MODEL_TYPE.MODEL_UNKONWN;
        AF_MODE m_AFMode = AF_MODE.AF_MANUAL;

        StringBuilder m_tzSaveFilePath = new StringBuilder(260);
        StringBuilder m_tzSaveFileName = new StringBuilder(260);

        // For Timer
        public System.Windows.Forms.Timer m_CaptureTimer = new System.Windows.Forms.Timer();
        public delegate void DelegateUpdateResultMsg(String strMsg);
        public delegate void DelegateUpdateRecTime();

        public DelegateUpdateResultMsg ResultMsgFunc;
        public DelegateUpdateRecTime RecTimeFunc;

        public CameraTimer m_CameraTimerClass;

        public TimerCallback m_TimerRecTimeCallback;
        public TimerCallback m_TimerResultMsgCallback;

        public System.Threading.Timer m_TimerRecTime;
        public System.Threading.Timer m_TimerResultMsg;
        //

        [DllImport("coredll.dll")]
        static extern int GetSystemMetrics(int smIndex);

        [DllImport("coredll.dll")]
        public static extern int PostMessage(int hwnd, int wMsg, int wParam, int lParam);

        public enum SND
        {
            SND_SYNC = 0x0000,/* play synchronously (default) */
            SND_ASYNC = 0x0001, /* play asynchronously */
            SND_NODEFAULT = 0x0002, /* silence (!default) if sound not found */
            SND_MEMORY = 0x0004, /* pszSound points to a memory file */
            SND_LOOP = 0x0008, /* loop the sound until next sndPlaySound */
            SND_NOSTOP = 0x0010, /* don't stop any currently playing sound */
            SND_NOWAIT = 0x00002000, /* don't wait if the driver is busy */
            SND_ALIAS = 0x00010000,/* name is a registry alias */
            SND_ALIAS_ID = 0x00110000, /* alias is a pre d ID */
            SND_FILENAME = 0x00020000, /* name is file name */
            SND_RESOURCE = 0x00040004, /* name is resource name or atom */
            SND_PURGE = 0x0040,  /* purge non-static events for task */
            SND_APPLICATION = 0x0080,  /* look for application specific */
        };

        public Form_Cam()
        {
            InitializeComponent();
        }

        private void Form_Cam_Load(object sender, EventArgs e)
        {
            m_ModelType = m_Cam.GetModelType();
            
            m_bDateTime = m_Cam.GetRegInsertDateTimeEnable();

            if (m_bDateTime)
                m_Cam.SetInsertDateTimeEnable(true);

            m_bAutoInit = true;

            LoadRegCamOption();

            m_Cam.EnableShutterSound(true);

            CameraOpen(true);

            RegisterCameraKey(true);

            // Load Setting
            m_AFMode = m_Cam.GetAfMode();
            m_Cam.SetAfMode(m_AFMode);

            m_bUseExif = m_Cam.GetRegExifEnable();
            m_bExifGps = m_Cam.GetRegExifGpsEnable();

            if (m_bExifGps)
                m_Cam.UseGPSExifData(true);

            if (m_Cam.GetHistoEqual())
            {
                m_bUseExif = false;
                m_bExifGps = false;
                m_bHistoEqual = true;
            }
            else
                m_bHistoEqual = false;

            m_Cam.GetRegCapturePathEx(m_tzSaveFilePath, m_tzSaveFileName);



            if (m_ModelType == MODEL_TYPE.MODEL_ORANGE || m_ModelType == MODEL_TYPE.MODEL_SMART 
                || m_ModelType == MODEL_TYPE.MODEL_ORANGE_PLUS || m_ModelType == MODEL_TYPE.MODEL_BLACK)
                this.Menu = MenuStill;
            else
                this.Menu = this.MenuStillSky;

            m_bHistoEqual = m_Cam.GetHistoEqual();

            LoadRegCamOption();

            m_Cam.GetRegCapturePathEx(m_tzSaveFilePath, m_tzSaveFileName);

            if (m_ModelType == MODEL_TYPE.MODEL_ORANGE || m_ModelType == MODEL_TYPE.MODEL_SMART || m_ModelType == MODEL_TYPE.MODEL_ORANGE_PLUS || m_ModelType == MODEL_TYPE.MODEL_BLACK)
            {
                int nZoom = m_Cam.GetZoom();

                switch (nZoom)
                {
                    case 0:
                        this.StillMenuItemZoom1.Checked = true;
                        break;
                    case 1:
                        this.StillMenuItemZoom2.Checked = true;
                        break;
                    case 2:
                        this.StillMenuItemZoom3.Checked = true;
                        break;
                    case 3:
                        this.StillMenuItemZoom4.Checked = true;
                        break;
                }
            }

            if (m_ModelType == MODEL_TYPE.MODEL_MM3)
                this.StillSkyMenuItemAF.Enabled = false;


            // For Timer
            ResultMsgFunc = new DelegateUpdateResultMsg(UpdateResultMsg);

            m_CameraTimerClass = new CameraTimer(this);

            m_TimerRecTimeCallback = m_CameraTimerClass.RecTimeTimer;
            m_TimerResultMsgCallback = m_CameraTimerClass.ResultMsgTimer;

            m_TimerRecTime = new System.Threading.Timer(m_TimerRecTimeCallback, 0, Timeout.Infinite, Timeout.Infinite);
            m_TimerResultMsg = new System.Threading.Timer(m_TimerResultMsgCallback, 0, Timeout.Infinite, Timeout.Infinite);
            //

            // Message Window
            m_CamMessage.AFStatusFunc += new AFStatusDelegate(ReceiveAfMsg);
            m_CamMessage.DeviceResumeFunc += new DeviceResumeDelegate(DeviceResume);
            m_CamMessage.GPSStatusFunc += new GPSStatusDelegate(OnGpsStatus);
        }


        private bool CameraOpen(bool bOpen)
        {
            if (bOpen)
            {
                if (!m_Cam.Open(this.Handle, CAMERA_MODE.STILL_MODE, VIDEO_TYPE.VIDEO_ASF))
                    return false;

                if (!m_bAutoInit)
                {
                    if (m_Cam.PreviewStop())
                        m_bPreviewOn = false;
                }
                else
                {
                    m_bPreviewOn = true;
                    if (m_Cam.PreviewStart())
                    {
                        m_bWakeUp = false;
                        m_bPreviewOn = true;
                    }

                }
                m_bCameraOpen = true;

                m_CamMessage.RegisterPowerResume(true);
            }
            else
            {
                if (m_Cam.PreviewStop())
                    m_bPreviewOn = false;

                m_Cam.Close();                
                m_bCameraOpen = false;
                
                m_CamMessage.RegisterPowerResume(false);
            }
            return true;
        }

        private void CaptureTimer_Tick(object sender, EventArgs e)
        {
            CameraCapture();
            m_CaptureTimer.Dispose();
        }

        private bool CameraCapture()
        {
            if (m_bStillCapturing == true)
                return false;

            char[] strOutFile = new char[260];
         
            m_bStillCapturing = true;

            m_Cam.CaptureEx(m_SaveType, m_bAutoInit, strOutFile);

            string NameBuf = new string(strOutFile);

            if (m_bUseExif)
            {
                int cnt = 0;
                for (int i = 0; i < NameBuf.Length; i++)
                    if (NameBuf[i] == '\0')
                    {
                        cnt = i;
                        break;
                    }
                NameBuf = NameBuf.Substring(0, cnt);

                bool bJpg = NameBuf.EndsWith(".jpg") || NameBuf.EndsWith(".JPG");

                if (bJpg)
                {
                    Cam.ExifInfo info = new Cam.ExifInfo();

                    char delimiter = '\\';
                    string[] tmp = NameBuf.Split(delimiter);
                    info.TitleName = tmp[tmp.Length - 1];

                    info.Make = "M3 Mobile Co.Ltd";
                    info.Model = "M3SKY";
                    m_Cam.InsertExifInformation(NameBuf, info);

                }
            }

            try
            {
                if (m_bEnableViewer)
                    System.Diagnostics.Process.Start("\\Flash Disk\\Camera\\Viewer.exe", NameBuf);
            }
            catch (Exception ex)
            {
                // Viewer error
            }

            m_bStillCapturing = false;

            return true;
        }

        private void button_Preview_Click(object sender, EventArgs e)
        {
            if (m_bPreviewOn)
            {
                if (m_Cam.PreviewStop())
                    m_bPreviewOn = false;
            }
            else
            {
                if (m_Cam.PreviewStart())
                    m_bPreviewOn = true;
            }
        }

        private void button_AutoFocus_Click(object sender, EventArgs e)
        {
            if (!m_bAutoFocusing)
            {
                m_Cam.AutoFocus();
            }
        }

        private void menuItem_Close_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void CameraClose()
        {
            if (m_bPreviewOn)
            {
                if (m_Cam.PreviewStop())
                    m_bPreviewOn = false;
            }

            if (m_bCameraOpen)
                m_Cam.Close();

            RegisterCameraKey(false);

            PostMessage(HWND_BROADCAST, WM_CONVERT, 0, 0);

            SaveRegCamOption();
            m_CamMessage.RegisterPowerResume(false);

            this.Close();

        }

        public void DeviceResume()
        {
            MessageBox.Show("DeviceResume");
            m_bWakeUp = true;
            //             if (m_bCameraOpen == true)
            m_Cam.PreviewStop();
            CameraOpen(false);
            m_bCameraOpen = false;




            m_Cam.Close();
        }

        public void ReceiveAfMsg(AF_STATUS nStatus)
        {
            switch (nStatus)
            {
                case AF_STATUS.AF_STATUS_READY:
                    label_Result_Message.Text = "";
                    break;
                case AF_STATUS.AF_STATUS_START:
                    label_Result_Message.Text = "Auto Focusing..";
                    break;
                case AF_STATUS.AF_STATUS_FINISH:
                    label_Result_Message.Text = "Auto Focusing..OK";
                    break;
            }
        }

        private void OnGpsStatus(bool bOn)
        {
            if (bOn)
            {
                MessageBox.Show("GPS ON");
            }
            else
            {
                MessageBox.Show("GPS OFF");
            }
        }

        public void UpdateResultMsg(String strMsg)
        {
            label_Result_Message.Text = strMsg;
            m_TimerResultMsg.Change(Timeout.Infinite, Timeout.Infinite);
        }

        private void StillMenuItemImage_Click(object sender, EventArgs e)
        {
            if (m_bPreviewOn)
                m_Cam.PreviewStop();

            Form_ImageOption ImageForm = new Form_ImageOption(m_Cam);

            ImageForm.m_AFMode = m_AFMode;
            ImageForm.m_bHistoEqual = m_bHistoEqual;
            ImageForm.m_bDateTime = m_bDateTime;

            ImageForm.m_nWBValue = (int)m_Cam.GetWhiteBalance();

            switch (m_ModelType)
            {
                case MODEL_TYPE.MODEL_MM3:
                case MODEL_TYPE.MODEL_SKY:
                case MODEL_TYPE.MODEL_BLACK:
                    ImageForm.m_nBrightnessValue = m_Cam.GetBrightness();
                    break;

                case MODEL_TYPE.MODEL_ORANGE:
                case MODEL_TYPE.MODEL_SMART:
                case MODEL_TYPE.MODEL_ORANGE_PLUS:
                    ImageForm.m_nBrightnessValue = m_Cam.GetBrightness();
                    ImageForm.m_nContrastValue = m_Cam.GetContrast();
                    ImageForm.m_nSharpnessValue = m_Cam.GetSharpness();
                    break;
            }

            CameraOpen(false);
           
            ImageForm.ShowDialog();

            if (ImageForm.m_bOK == true)
            {
                CameraOpen(true);

                switch (m_ModelType)
                {
                    case MODEL_TYPE.MODEL_MM3:
                    case MODEL_TYPE.MODEL_SKY:
                    case MODEL_TYPE.MODEL_BLACK:
                        m_Cam.SetBrightness(ImageForm.m_nBrightnessValue);
                        break;

                    case MODEL_TYPE.MODEL_ORANGE:
                    case MODEL_TYPE.MODEL_SMART:
                    case MODEL_TYPE.MODEL_ORANGE_PLUS:
                        m_Cam.SetBrightness(ImageForm.m_nBrightnessValue);
                        m_Cam.SetContrast(ImageForm.m_nContrastValue);
                        m_Cam.SetSharpness(ImageForm.m_nSharpnessValue);
                        break;
                }
               
                m_bDateTime = ImageForm.m_bDateTime;
                // Image Option
                m_bUseExif = ImageForm.m_bUseEXIF;
                m_AFMode = ImageForm.m_AFMode;
                m_bHistoEqual = ImageForm.m_bHistoEqual;
                m_Cam.SetAfMode(m_AFMode);
                m_Cam.SetWhiteBalance((WHITE_BALANCE)ImageForm.m_nWBValue);

                CameraOpen(false);
                m_Cam.SetInsertDateTimeEnable(m_bDateTime);
                CameraOpen(true);
            }
            else
            {
                m_Cam.SetInsertDateTimeEnable(m_bDateTime);
                CameraOpen(true);
            }
        }

        private void StillMenuItemSave_Click(object sender, EventArgs e)
        {
            Form_SaveOption SaveForm = new Form_SaveOption(m_Cam);

            SaveForm.m_strSaveFileName = m_tzSaveFileName.ToString();
            SaveForm.m_strSaveFilePath = m_tzSaveFilePath.ToString();

            SaveForm.m_bAutoInit = m_bAutoInit;

            SaveForm.m_bEnableViewer = m_bEnableViewer;
            SaveForm.m_UseEXIF = m_bUseExif;
            SaveForm.m_bDateTime = m_bDateTime;
            SaveForm.m_SaveType = (Form_SaveOption.SAVE_TYPE)m_SaveType;

            SaveForm.ShowDialog();

            if (SaveForm.m_bOK == true)
            {
                m_tzSaveFileName = new StringBuilder(SaveForm.m_strSaveFileName);
                m_tzSaveFilePath = new StringBuilder(SaveForm.m_strSaveFilePath);

                m_bAutoInit = SaveForm.m_bAutoInit;
                m_bUseExif = SaveForm.m_UseEXIF;
                m_bDateTime = SaveForm.m_bDateTime;

                m_SaveType = (SAVE_TYPE)SaveForm.m_SaveType;
                m_bEnableViewer = SaveForm.m_bEnableViewer;

                m_Cam.SetInsertDateTimeEnable(m_bDateTime);
                m_Cam.SetRegCapturePath(m_tzSaveFilePath, m_tzSaveFileName);
            }
        }

        private void RegisterCameraKey(bool bOn)
        {
            RegistryKey reg = null;
            String tzKeyPath = null;
            int nRegValue = 0;

            if (m_ModelType == MODEL_TYPE.MODEL_MM3)
                tzKeyPath = "ControlPanel\\Keypad\\SideKey";
            else if (m_ModelType == MODEL_TYPE.MODEL_ORANGE || m_ModelType == MODEL_TYPE.MODEL_SKY)
            {
                reg = Registry.LocalMachine.CreateSubKey("ControlPanel\\keypad");
                try
                {
                    nRegValue = (int)reg.GetValue("KeypadType");
                }
                catch (System.Exception ex)
                {
                    nRegValue = 0;
                }

                reg.Close();

                switch (nRegValue)
                {
                    case 0:
                        tzKeyPath = "ControlPanel\\Keypad\\Numeric";
                        break;
                    case 1:
                        tzKeyPath = "ControlPanel\\Keypad\\Qwerty";
                        break;
                    case -1:
                        tzKeyPath = "ControlPanel\\Keypad\\SideKey";
                        break;
                }
            }
            else
                tzKeyPath = "ControlPanel\\Keypad\\SideKey";

            RegistryKey subReg = Registry.LocalMachine.CreateSubKey(tzKeyPath);

            if (bRegister)
            {
                m_dwBackupCameraKey = (int)subReg.GetValue("RightUpKey");
                m_dwBackupScannerKey = (int)subReg.GetValue("RightDownKey");

                subReg.SetValue("RightUpKey", 2);
                subReg.SetValue("RightDownKey", 3);
            }
            else
            {
                subReg.SetValue("RightUpKey", m_dwBackupCameraKey);
                subReg.SetValue("RightDownKey", m_dwBackupScannerKey);
            }

            subReg.Close();
        }

        private void SaveRegCamOption()
        {
            RegistryKey reg = Registry.CurrentUser.CreateSubKey("Software\\Microsoft\\Pictures\\Camera\\USER");

            reg.SetValue("AutoPreview", m_bAutoInit ? 1 : 0);
            reg.SetValue("ViewAfterCapturing", m_bEnableViewer ? 1 : 0);
        
            reg.Close();
        }

        private void LoadRegCamOption()
        {
            RegistryKey reg = Registry.CurrentUser.CreateSubKey(@"Software\\Microsoft\\Pictures\\Camera\\USER");

            if (reg != null)
            {
                object tmp = null;

                tmp = reg.GetValue("AutoPreview");
                if (tmp == null)
                    m_bAutoInit = true;
                else
                    m_bAutoInit = ((int)tmp == 0 ? false : true);

                tmp = reg.GetValue("ViewAfterCapturing");
                if (tmp == null)
                    m_bEnableViewer = true;
                else
                    m_bEnableViewer = ((int)tmp == 0 ? false : true);
                

            }


            reg.Close();
        }

        private void StillMenuItemClose_Click(object sender, EventArgs e)
        {
            CameraClose();
        }


        private void StillMenuItemCapture_Click(object sender, EventArgs e)
        {
            CameraCapture();
        }

        private void StillMenuItemFlash_Click(object sender, EventArgs e)
        {
            bool flashOn = m_Cam.GetFlashState();

            m_Cam.AlwaysFlash(!flashOn);

            if (m_ModelType == MODEL_TYPE.MODEL_ORANGE || m_ModelType == MODEL_TYPE.MODEL_SMART || m_ModelType == MODEL_TYPE.MODEL_ORANGE_PLUS || m_ModelType == MODEL_TYPE.MODEL_BLACK)
                this.StillMenuItemFlash.Checked = !flashOn;
            else
                this.StillSkyMenuItemFlash.Checked = !flashOn;
            
            m_bFlashOn = !flashOn;
        }

        private void StillMenuItemAF_Click(object sender, EventArgs e)
        {
            if (!m_bAutoFocusing)
            {
                m_Cam.AutoFocus();
            }
        }

        private void StillMenuItemZoom1_Click(object sender, EventArgs e)
        {
            m_Cam.Zoom(0);

            this.StillMenuItemZoom1.Checked = true;
            this.StillMenuItemZoom2.Checked = false;
            this.StillMenuItemZoom3.Checked = false;
            this.StillMenuItemZoom4.Checked = false;
        }

        private void StillMenuItemZoom2_Click(object sender, EventArgs e)
        {
            m_Cam.Zoom(1);

            this.StillMenuItemZoom1.Checked = false;
            this.StillMenuItemZoom2.Checked = true;
            this.StillMenuItemZoom3.Checked = false;
            this.StillMenuItemZoom4.Checked = false;
        }

        private void StillMenuItemZoom3_Click(object sender, EventArgs e)
        {
            m_Cam.Zoom(2);

            this.StillMenuItemZoom1.Checked = false;
            this.StillMenuItemZoom2.Checked = false;
            this.StillMenuItemZoom3.Checked = true;
            this.StillMenuItemZoom4.Checked = false;

        }

        private void StillMenuItemZoom4_Click(object sender, EventArgs e)
        {
            m_Cam.Zoom(3);

            this.StillMenuItemZoom1.Checked = false;
            this.StillMenuItemZoom2.Checked = false;
            this.StillMenuItemZoom3.Checked = false;
            this.StillMenuItemZoom4.Checked = true;
        }

        private void Form_Cam_Click(object sender, EventArgs e)
        {
            if (!m_bCameraOpen)
            {
                CameraOpen(true);
                m_bWakeUp = false;
                m_bCameraOpen = true;
            }

            if (!m_bPreviewOn)
                m_Cam.PreviewStart();

            m_bPreviewOn = true;
        }

        private void Form_Cam_KeyDown(object sender, KeyEventArgs e)
        {
            /*
              if (e.KeyCode == System.Windows.Forms.Keys.F13 || e.KeyCode == System.Windows.Forms.Keys.Return)
                         {                
                             m_bPressedCaptureKey = true;
                         }*/

        }

        private void Form_Cam_KeyUp(object sender, KeyEventArgs e)
        {

            if (e.KeyCode == System.Windows.Forms.Keys.F13 || e.KeyCode == System.Windows.Forms.Keys.Return)
            {
                if (m_bPreviewOn)
                {
                    CameraCapture();
                    /*
                    if (m_bStillCapturing == false)
                                        {
                                            m_CaptureTimer.Tick += new System.EventHandler(this.CaptureTimer_Tick);
                                            m_CaptureTimer.Interval = 1;
                                            m_CaptureTimer.Enabled = true;
                                        }
                                        else
                                        {
                                            CameraCapture();
                                        }*/

                }
            }
        }

        private void Form_Cam_Closed(object sender, EventArgs e)
        {
            CameraClose();
        }


    }


    public class CameraTimer
    {
        Form_Cam m_Cam;

        public CameraTimer(Form_Cam cam)
        {
            m_Cam = cam;
        }

        public void RecTimeTimer(object obj)
        {
            m_Cam.Invoke(m_Cam.RecTimeFunc);
        }

        public void ResultMsgTimer(object obj)
        {
            String strMsg = "";
            m_Cam.Invoke(m_Cam.ResultMsgFunc, new object[] { strMsg });
        }
    }
}