#pragma once
#define CAM_API __declspec(dllexport)

#define WM_STATUS_AF	WM_USER + 916
#define WM_CONVERT	WM_USER + 232
#define WM_GPS_ON	WM_USER + 1020

typedef enum {
	MODEL_SKY,
	MODEL_MM3,
	MODEL_ORANGE,
	MODEL_SMART,
	MODEL_ORANGE_PLUS,
	MODEL_BLACK,
	MODEL_UNKONWN = 99
} MODEL_TYPE;

typedef enum {
	SCANNER_OPTICON,
	SCANNER_SYMBOL,
	SCANNER_INTERMEC,
	SCANNER_HHP
} SCANNER_TYPE;

typedef enum {
	STILL_MODE,
	VIDEO_MODE, 
	CLOSE_MODE
} CAMERA_MODE;

typedef enum {
	VIDEO_ASF,
	VIDEO_WMV 
} VIDEO_TYPE;

typedef enum {
	AF_MANUAL,
	AF_ALWAYS,
	AF_AUTO
}AF_MODE;

typedef enum{
	AF_STATUS_READY,
	AF_STATUS_START,
	AF_STATUS_FINISH
} AF_STATUS;

typedef enum{
	WB_Auto,
	WB_Sunny,
	WB_Cloudy,
	WB_Fluorescent,
	WB_Incandescent
}WHITE_BALANCE;

typedef enum {
	SAVE_DATE = 0,
	SAVE_CUSTOM = 1
}SAVE_TYPE;

typedef struct _ExifInfo
{
	TCHAR TitleName[21];
	TCHAR Make[21];
	TCHAR Model[21];
}ExifInfo;

typedef void (CALLBACK *MANAGED_SAMPLEPROCESSEDPROC)(BYTE* pdata, int height, int width, int bitcount, int stride, GUID type);

EXTERN_C CAM_API MODEL_TYPE CAM_GetModelType();
EXTERN_C CAM_API SCANNER_TYPE CAM_GetScannerType();
EXTERN_C CAM_API BOOL CAM_AlwaysFlash(BOOL bOn);
EXTERN_C CAM_API BOOL CAM_GetFlashState();
EXTERN_C CAM_API BOOL CAM_CaptureFlash(BOOL bOn);

EXTERN_C CAM_API BOOL CAM_Open(HWND hWnd, CAMERA_MODE cameramode, VIDEO_TYPE videotype);
EXTERN_C CAM_API BOOL CAM_Close();
EXTERN_C CAM_API BOOL CAM_GetVersion(TCHAR* tzDllVersion, TCHAR* tzDllRelease);

EXTERN_C CAM_API BOOL CAM_SetPreviewWindow(long left,  long top, long width, long height);
EXTERN_C CAM_API BOOL CAM_PreviewStart();
EXTERN_C CAM_API BOOL CAM_PreviewStop();

EXTERN_C CAM_API BOOL CAM_CaptureEx(SAVE_TYPE nSaveType, BOOL bAutoInit, TCHAR* tzOutFileName);
EXTERN_C CAM_API BOOL CAM_Capture(const TCHAR* tzInFileName, TCHAR* tzOutFileName, BOOL bAutoInit);

EXTERN_C CAM_API BOOL CAM_EnableShutterSound(BOOL bEnable);

EXTERN_C CAM_API BOOL CAM_GetRegCapturePath(TCHAR* tzFullName);
EXTERN_C CAM_API BOOL CAM_GetRegCapturePathEx(TCHAR* tzPath, TCHAR* tzName);
EXTERN_C CAM_API BOOL CAM_SetRegCapturePath(TCHAR* tzPath, TCHAR* tzName);

EXTERN_C CAM_API BOOL CAM_VideoStart();
EXTERN_C CAM_API BOOL CAM_VideoStop(const TCHAR* tzInFileName, TCHAR* tzOutFileName);
EXTERN_C CAM_API BOOL CAM_VideoStopEx(SAVE_TYPE nSaveType, TCHAR* tzOutFileName);

EXTERN_C CAM_API BOOL CAM_AutoFocus();

EXTERN_C CAM_API AF_MODE CAM_SetAfMode(AF_MODE mode);
EXTERN_C CAM_API AF_MODE CAM_GetAfMode();

EXTERN_C CAM_API BOOL CAM_Zoom(int index);
EXTERN_C CAM_API int CAM_GetZoom();

EXTERN_C CAM_API BOOL CAM_SetResolution(int nResolution);
EXTERN_C CAM_API int CAM_GetResolution();
EXTERN_C CAM_API BOOL CAM_SetQuality(int nQuality);
EXTERN_C CAM_API int CAM_GetQuality();
EXTERN_C CAM_API BOOL CAM_SetBrightness(int nBrightness); 
EXTERN_C CAM_API int CAM_GetBrightness();
EXTERN_C CAM_API BOOL CAM_SetWhiteBalance(WHITE_BALANCE nWhiteBalance);
EXTERN_C CAM_API WHITE_BALANCE CAM_GetWhiteBalance();
EXTERN_C CAM_API BOOL CAM_SetContrast(int nContrast);
EXTERN_C CAM_API int CAM_GetContrast();
EXTERN_C CAM_API BOOL CAM_SetSharpness(int nSharpness);
EXTERN_C CAM_API int CAM_GetSharpness();

EXTERN_C CAM_API void CAM_SetHistoEqual(BOOL Enable);
EXTERN_C CAM_API BOOL CAM_GetHistoEqual();

EXTERN_C CAM_API BOOL CAM_RegisterPreview(MANAGED_SAMPLEPROCESSEDPROC fpPreview);
EXTERN_C CAM_API void CAM_RegisterMsgWnd(HWND hWnd);

EXTERN_C CAM_API BOOL CAM_InsertExifInformation(TCHAR* FileName, ExifInfo info);
EXTERN_C CAM_API BOOL CAM_UseGPSExifData(BOOL bUse);

EXTERN_C CAM_API BOOL CAM_GetRegExifEnable();
EXTERN_C CAM_API BOOL CAM_GetRegExifGpsEnable();

EXTERN_C CAM_API BOOL CAM_GetRegInsertDateTimeEnable();
EXTERN_C CAM_API BOOL CAM_SetInsertDateTimeEnable(int bEnable);