// Reg.cpp: implementation of the CReg class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Reg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CReg::CReg()
{
}

CReg::~CReg()
{

}


BOOL CReg::GetRegStr(HKEY hKeyRoot, WCHAR *wszRegPath, WCHAR *wsaValue, TCHAR *wsGetData)
{
	HKEY hKey;
	int nRet;
//	DWORD dwDisp;
	DWORD size = 0;
	
	memset(wsGetData, 0, 50);

	nRet = RegOpenKeyEx(hKeyRoot, wszRegPath, 0, KEY_QUERY_VALUE, &hKey);
	if(nRet != ERROR_SUCCESS)
	{
		return NULL;
	}


	size = RegQueryValueEx (hKey, wsaValue, NULL, NULL, (LPBYTE)wsGetData, NULL);
	if(size == 0)
	{
		RegCloseKey(hKey);
		return NULL;
	}
	
	nRet = RegQueryValueEx (hKey, wsaValue, NULL, NULL, (LPBYTE)wsGetData, &size);
	if(nRet != ERROR_SUCCESS)
	{
		RegCloseKey(hKey);
		return NULL;
	}

	if(hKey) RegCloseKey(hKey);

	
	return 0;	
}

BOOL CReg::SetRegStr(HKEY hKeyRoot, WCHAR *wszRegPath, WCHAR *wszValue, WCHAR *wszData)
{
	HKEY hKey;
	int nRet;
	DWORD dwDisp;

	nRet = RegCreateKeyEx(hKeyRoot, wszRegPath, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hKey, &dwDisp);
	if(nRet != ERROR_SUCCESS)
	{
		return -1;
	}

	nRet = RegSetValueEx(hKey, wszValue, 0, REG_SZ, (LPBYTE)wszData, (wcslen(wszData)*sizeof(TCHAR) )+1 );
	if(nRet != ERROR_SUCCESS)
	{
		return -1;
	}
	RegCloseKey(hKey);
	return TRUE;
}

DWORD CReg::GetRegValue(HKEY hKeyRoot, WCHAR *wszRegPath, WCHAR *wszValue)
{
	HKEY key;
	DWORD dwDisp;
	DWORD Size;
	if(RegCreateKeyEx(hKeyRoot, wszRegPath, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_READ, NULL, &key, &dwDisp) != ERROR_SUCCESS)
	{
		return -1;
	}
	Size = sizeof(LONG);
	if(RegQueryValueEx(key, wszValue, 0, NULL, (LPBYTE)&m_nRegValue, &Size) != ERROR_SUCCESS)
	{
		return -1;
	}

	RegCloseKey(key);
	return m_nRegValue;
}

BOOL CReg::SetRegValue(HKEY hKeyRoot, WCHAR *wszRegPath, WCHAR * wszValue, DWORD wszData)
{
	HKEY hKey;
	int nRet;
	DWORD dwDisp;

	nRet = RegCreateKeyEx(hKeyRoot, wszRegPath, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hKey, &dwDisp);
	if(nRet != ERROR_SUCCESS)
	{
		MessageBox(NULL, L"Reg Create Error", L"Registry", MB_OK);
		return -1;
	}

	nRet = RegSetValueEx(hKey, wszValue, 0, REG_DWORD, (LPBYTE)&wszData, sizeof(DWORD));
	if(nRet != ERROR_SUCCESS)
	{
		return -1;
	}
	RegCloseKey(hKey);
	return m_nRegValue;
}

