// OptionSavePage.cpp : implementation file
//

#include "stdafx.h"
#include "CamTest.h"
#include "OptionSaveDlg.h"
#include "aygshell.h"
// COptionSaveDlg dialog

IMPLEMENT_DYNAMIC(COptionSaveDlg, CDialog)

COptionSaveDlg::COptionSaveDlg(CWnd* pParent)
	: CDialog(COptionSaveDlg::IDD, pParent)
	, m_bUseGps(FALSE)
{
	memset(m_tzSaveFilePath, 0x00, sizeof(TCHAR) * MAX_PATH);
	wsprintf(m_tzSaveFilePath, L"");
	memset(m_tzSaveFileName, 0x00, sizeof(TCHAR) * MAX_PATH);
	wsprintf(m_tzSaveFileName, L"");

	m_SaveType = SAVE_DATE;
	m_bAutoInit = TRUE;

	m_bEnableViewer = TRUE;
	m_bHistoEqual=FALSE;
}

COptionSaveDlg::~COptionSaveDlg()
{
}

void COptionSaveDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_QUALITY, m_ctlQuality);
	DDX_Control(pDX, IDC_COMBO_SAVE_MODE, m_ctlSaveMode);
	DDX_Control(pDX, IDC_CHECK_AUTO_PREVIEW, m_ctlAutoPreview);
	DDX_Control(pDX, IDC_CHECK_VIEWER, m_ctlEnableViewer);
	DDX_Control(pDX, IDC_CHECK_EXIF, m_ctlEnableExif);
	DDX_Check(pDX, IDC_CHECK_EXIF_GPS, m_bUseGps);
	DDX_Control(pDX, IDC_CHECK_EXIF_GPS, m_ctlUseGPS);
	DDX_Control(pDX, IDC_CHECK_DATETIME, m_ctlDateTime);
}


BEGIN_MESSAGE_MAP(COptionSaveDlg, CDialog)
	ON_COMMAND(ID_MENU_CANCEL, &COptionSaveDlg::OnMenuCancel)
	ON_COMMAND(ID_MENU_OK, &COptionSaveDlg::OnMenuOk)
	ON_CBN_SELCHANGE(IDC_COMBO_SAVE_MODE, &COptionSaveDlg::OnCbnSelchangeComboSaveMode)
	ON_BN_CLICKED(IDC_CHECK_EXIF, &COptionSaveDlg::OnBnClickedCheckExif)
	ON_BN_CLICKED(IDC_CHECK_DATETIME, &COptionSaveDlg::OnBnClickedCheckDatetime)
END_MESSAGE_MAP()



// COptionSaveDlg message handlers

BOOL COptionSaveDlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	// Menu
	SHMENUBARINFO mbi;

	HINSTANCE hInst = AfxGetInstanceHandle();

	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize = sizeof(SHMENUBARINFO);
	mbi.hwndParent = m_hWnd;
	mbi.nToolBarId = IDR_MENU_OKCANCEL;
	mbi.hInstRes = hInst;
	mbi.dwFlags = SHCMBF_HMENU;

	SHCreateMenuBar(&mbi);
	//

	InitControl();


	// Version
	TCHAR tzDllVersion[MAX_PATH] = {0x00};
	TCHAR tzDllRelease[MAX_PATH] = {0x00};

	TCHAR tzDllVer[MAX_PATH] = {0x00};
	TCHAR tzAppVersion[MAX_PATH] = {0x00};

	memset(tzDllVersion, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzDllRelease, 0x00, sizeof(TCHAR) * MAX_PATH);

	memset(tzDllVer, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzAppVersion, 0x00, sizeof(TCHAR) * MAX_PATH);

	CAM_GetVersion(tzDllVersion, tzDllRelease);

	wsprintf(tzAppVersion, L"APP: %s(%s)", APP_VERSION, APP_RELEASE);
	wsprintf(tzDllVer, L"DLL: %s(%s)", tzDllVersion, tzDllRelease);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APP_VERSION), tzAppVersion);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_DLL_VERSION), tzDllVer);

	return 0;
}

void COptionSaveDlg::InitControl()
{

	// Get Viewer
	TCHAR	szThisProgram[MAX_PATH] = {0, }; // Camera Program
	CString szViewr;

	GetModuleFileName(NULL, szThisProgram, sizeof(TCHAR)*MAX_PATH);
	szViewr.Format(_T("%s"), szThisProgram);
	int nIndex = szViewr.ReverseFind('\\');
	szViewr.Format(_T("%s\\Viewer.exe"), szViewr.Left(nIndex));

	if(GetFileAttributes(szViewr) == INVALID_SET_FILE_POINTER)
	{
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_CHECK_VIEWER), FALSE);
	}
	else
	{
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_CHECK_VIEWER), TRUE);

		if(m_bEnableViewer == TRUE)
		{
			m_ctlEnableViewer.SetCheck(BST_CHECKED);
		}
		else
		{
			m_ctlEnableViewer.SetCheck(BST_UNCHECKED);
		}
	}

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_SAVE_PATH), m_tzSaveFilePath);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_SAVE_FILENAME), m_tzSaveFileName);

	m_ctlQuality.InsertString(0, L"Low quality");
	m_ctlQuality.InsertString(1, L"Normal quality");
	m_ctlQuality.InsertString(2, L"High quality");
	m_ctlQuality.SetCurSel(CAM_GetQuality());

	m_ctlSaveMode.InsertString(0, L"Date Mode");
	m_ctlSaveMode.InsertString(1, L"Custom Mode");
	m_ctlSaveMode.SetCurSel((int)m_SaveType);
	

	if(m_bAutoInit)
		m_ctlAutoPreview.SetCheck(BST_CHECKED);
	else
		m_ctlAutoPreview.SetCheck(BST_UNCHECKED);

	if(m_bHistoEqual)
	{
		m_bUseExif=FALSE;
		m_ctlEnableExif.SetCheck(BST_UNCHECKED);
		m_ctlUseGPS.SetCheck(BST_UNCHECKED);
	}
	else
	{
		if(m_bUseExif)
			m_ctlEnableExif.SetCheck(BST_CHECKED);
		else
			m_ctlEnableExif.SetCheck(BST_UNCHECKED);


		if(m_bUseGps)
			m_ctlUseGPS.SetCheck(BST_CHECKED);
		else
			m_ctlUseGPS.SetCheck(BST_UNCHECKED);

	}
	
	OnBnClickedCheckExif();
	OnCbnSelchangeComboSaveMode();

	::EnableWindow(::GetDlgItem(m_hWnd, IDC_STATIC_VIDEO_TYPE), FALSE);

	m_ctlDateTime.EnableWindow(TRUE);
	if(m_bDateTime)
		m_ctlDateTime.SetCheck(BST_CHECKED);
	else
		m_ctlDateTime.SetCheck(BST_UNCHECKED);
	
}



void COptionSaveDlg::OnCbnSelchangeComboSaveMode()
{
	if(m_ctlSaveMode.GetCurSel() == 1)
	{
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_EDIT_SAVE_FILENAME), TRUE);
	}
	else
	{
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_EDIT_SAVE_FILENAME), FALSE);
	}

}
void COptionSaveDlg::OnOK()
{
	UpdateData();

	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_SAVE_PATH), m_tzSaveFilePath, MAX_PATH);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_SAVE_FILENAME), m_tzSaveFileName, MAX_PATH);

	m_SaveType = (SAVE_TYPE)m_ctlSaveMode.GetCurSel();

	if(m_SaveType==SAVE_CUSTOM)
	{
		if(_tcscmp(m_tzSaveFileName, _T(""))==0)
		{
			::MessageBox(0, _T("Input Save Filename!!"), _T("Camera"), MB_TOPMOST);
			return;
		}
	}

	if(_tcscmp(m_tzSaveFileName, _T(""))!=0)
	{
		if(_tcsstr(m_tzSaveFileName, L".j") == NULL && _tcsstr(m_tzSaveFileName, L".b") == NULL && _tcsstr(m_tzSaveFileName, L".J") == NULL && _tcsstr(m_tzSaveFileName, L".B") == NULL)
		{
			if(m_bHistoEqual)
				_tcscat(m_tzSaveFileName, _T(".bmp"));
			else
				_tcscat(m_tzSaveFileName, _T(".jpg"));
		}
	}

	CAM_SetQuality(m_ctlQuality.GetCurSel());

	m_SaveType = (SAVE_TYPE)m_ctlSaveMode.GetCurSel();
	
	m_bAutoInit = m_ctlAutoPreview.GetCheck();
	m_bEnableViewer = m_ctlEnableViewer.GetCheck();
	m_bUseExif = m_ctlEnableExif.GetCheck();
	m_bUseGps = m_ctlUseGPS.GetCheck();

	m_bDateTime=m_ctlDateTime.GetCheck();
	
	EndDialog(IDOK);
		
}

void COptionSaveDlg::OnMenuCancel()
{
	EndDialog(IDCANCEL);
}

void COptionSaveDlg::OnMenuOk()
{
	OnOK();
}


void COptionSaveDlg::OnBnClickedCheckExif()
{	
	if(m_ctlEnableExif.GetCheck())
	{
		if(!m_bHistoEqual)
		{
			m_bUseExif = TRUE;
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_CHECK_EXIF_GPS), TRUE);
		}

		else
		{
			m_ctlEnableExif.SetCheck(0);
			m_ctlUseGPS.SetCheck(0);
			m_bUseExif=FALSE;
			AfxMessageBox(_T("Not Available EXIF On NightMode!!"));
		}
		
	}
	else
	{
		m_bUseExif = FALSE;
		m_ctlUseGPS.SetCheck(0);
		m_ctlUseGPS.EnableWindow(FALSE);
	}
}

void COptionSaveDlg::OnBnClickedCheckDatetime()
{
	if(m_ctlDateTime.GetCheck())
	{		
		MODEL_TYPE model = CAM_GetModelType();

		if((model==MODEL_MM3 || model==MODEL_ORANGE || model==MODEL_SKY || model==MODEL_BLACK) && CAM_GetResolution()==0)
		{
			::MessageBox(0, _T("QCIF Not Supported Insert DateTime"), _T("Camera"), MB_TOPMOST);
			m_ctlDateTime.SetCheck(0);
			return;
		}

		if(model==MODEL_ORANGE_PLUS)
		{
			int tmp=CAM_GetResolution();
			if(tmp==5 || tmp==6)
			{
				::MessageBox(0, _T("Insert Date Time is not supported in WUXGA & QXGA resolution of ORNAGE PLUS"), _T("Camera"), MB_TOPMOST);
				m_ctlDateTime.SetCheck(0);
				return;
			}
		}
		m_bDateTime=TRUE;
		
	}
	else
		m_bDateTime = FALSE;
}
