// OptionImagePage.cpp : implementation file
//

#include "stdafx.h"
#include "CamTest.h"
#include "OptionImageDlg.h"

#include "aygshell.h"

#pragma warning (disable:4018)
// COptionImageDlg dialog

IMPLEMENT_DYNAMIC(COptionImageDlg, CDialog)

COptionImageDlg::COptionImageDlg(CWnd* pParent, BOOL m_useEXIF)
	: CDialog(COptionImageDlg::IDD, pParent)
{
	m_AFMode = AF_MANUAL;
	this->m_useEXIF=m_useEXIF;
	m_bHistoEqual=FALSE;
}

COptionImageDlg::~COptionImageDlg()
{
	
}

void COptionImageDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_RESOLUTION, m_ctlResolution);
	DDX_Control(pDX, IDC_COMBO_WHITE_BALANCE, m_ctlWhiteBalance);
	DDX_Control(pDX, IDC_COMBO_BRIGHT, m_ctlBrightness);
	DDX_Control(pDX, IDC_COMBO_CONTRAST, m_ctlContrast);
	DDX_Control(pDX, IDC_COMBO_SHARPNESS, m_ctlSharpness);
	DDX_Control(pDX, IDC_COMBO_SMART_SET, m_ctlSmartSetting);
	DDX_Control(pDX, IDC_COMBO_AF, m_ctlAfType);
	DDX_Control(pDX, IDC_CHECK_HISTOEQUAL, m_ctlNightMode);
}

BEGIN_MESSAGE_MAP(COptionImageDlg, CDialog)
	ON_COMMAND(ID_MENU_CANCEL, &COptionImageDlg::OnMenuCancel)
	ON_COMMAND(ID_MENU_OK, &COptionImageDlg::OnMenuOk)
	ON_CBN_SELCHANGE(IDC_COMBO_SMART_SET, &COptionImageDlg::OnCbnSelchangeComboSmartSet)
	ON_BN_CLICKED(IDC_CHECK_HISTOEQUAL, &COptionImageDlg::OnBnClickedCheckHistoequal)
END_MESSAGE_MAP()


// COptionImageDlg message handlers

BOOL COptionImageDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Menu
	SHMENUBARINFO mbi;

	HINSTANCE hInst = AfxGetInstanceHandle();

	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize = sizeof(SHMENUBARINFO);
	mbi.hwndParent = m_hWnd;
	mbi.nToolBarId = IDR_MENU_OKCANCEL;
	mbi.hInstRes = hInst;
	mbi.dwFlags = SHCMBF_HMENU;

	SHCreateMenuBar(&mbi);
	//

	
	InitControl();

	return 0;
}

void COptionImageDlg::InitControl()
{
	MODEL_TYPE model = CAM_GetModelType();
	int nValue;

	InitResolutionUI();
	nValue = CAM_GetResolution();
	m_ctlResolution.SetCurSel(nValue);

	m_ctlWhiteBalance.InsertString(WB_Auto, L"Auto");
	m_ctlWhiteBalance.InsertString(WB_Sunny, L"Sunny");
	m_ctlWhiteBalance.InsertString(WB_Cloudy, L"Cloudy");
	m_ctlWhiteBalance.InsertString(WB_Fluorescent, L"Fluorescent");
	m_ctlWhiteBalance.InsertString(WB_Incandescent, L"Incandescent");
	m_ctlWhiteBalance.SetCurSel(m_nWBValue);
	
	switch(model)
	{
	case MODEL_MM3:
		{
			m_ctlBrightness.InsertString(0, L"+3");
			m_ctlBrightness.InsertString(1, L"+2");
			m_ctlBrightness.InsertString(2, L"+1");
			m_ctlBrightness.InsertString(3, L"0");
			m_ctlBrightness.InsertString(4, L"-1");
			m_ctlBrightness.InsertString(5, L"-2");
			m_ctlBrightness.InsertString(6, L"-3");
			nValue = (m_nBrightnessValue - 3) * -1;
			m_ctlBrightness.SetCurSel(nValue);

			m_ctlContrast.InsertString(0, L"Not Supported");
			m_ctlContrast.SetCurSel(0);
			m_ctlSharpness.InsertString(0, L"Not Supported");
			m_ctlSharpness.SetCurSel(0);
			m_ctlSmartSetting.InsertString(0, L"Not Supported");
			m_ctlSmartSetting.SetCurSel(0);


			m_ctlContrast.EnableWindow(FALSE);
			m_ctlSharpness.EnableWindow(FALSE);
			m_ctlSmartSetting.EnableWindow(FALSE);


			m_ctlAfType.InsertString(0,	L"Fixed Focus");
			m_ctlAfType.SetCurSel(0);

			m_ctlAfType.EnableWindow(FALSE);

		}
		break;
	case MODEL_SKY:
		{
			m_ctlBrightness.InsertString(0, L"+3");
			m_ctlBrightness.InsertString(1, L"+2");
			m_ctlBrightness.InsertString(2, L"+1");
			m_ctlBrightness.InsertString(3, L"0");
			m_ctlBrightness.InsertString(4, L"-1");
			m_ctlBrightness.InsertString(5, L"-2");
			m_ctlBrightness.InsertString(6, L"-3");
			nValue = (m_nBrightnessValue - 3) * -1;
			m_ctlBrightness.SetCurSel(nValue);

			m_ctlContrast.InsertString(0, L"Not Supported");
			m_ctlContrast.SetCurSel(0);
			m_ctlSharpness.InsertString(0, L"Not Supported");
			m_ctlSharpness.SetCurSel(0);
			m_ctlSmartSetting.InsertString(0, L"Not Supported");
			m_ctlSmartSetting.SetCurSel(0);


			m_ctlContrast.EnableWindow(FALSE);
			m_ctlSharpness.EnableWindow(FALSE);
			m_ctlSmartSetting.EnableWindow(FALSE);

			m_ctlAfType.InsertString(AF_MANUAL,	L"Manual AF");
			m_ctlAfType.InsertString(AF_ALWAYS,	L"Always AF");
			m_ctlAfType.InsertString(AF_AUTO,	L"Auto AF");
			m_ctlAfType.SetCurSel(m_AFMode);
		
		}
		break;
	case MODEL_ORANGE:
		{
			m_ctlBrightness.InsertString(0, L"+5");
			m_ctlBrightness.InsertString(1, L"+4");
			m_ctlBrightness.InsertString(2, L"+3");
			m_ctlBrightness.InsertString(3, L"+2");
			m_ctlBrightness.InsertString(4, L"+1");
			m_ctlBrightness.InsertString(5, L"0");
			m_ctlBrightness.InsertString(6, L"-1");
			m_ctlBrightness.InsertString(7, L"-2");
			m_ctlBrightness.InsertString(8, L"-3");
			m_ctlBrightness.InsertString(9, L"-4");
			m_ctlBrightness.InsertString(10, L"-5");
			nValue = (m_nBrightnessValue - 5) * -1;
			m_ctlBrightness.SetCurSel(nValue);

			m_ctlContrast.InsertString(0, L"+4");
			m_ctlContrast.InsertString(1, L"+3");
			m_ctlContrast.InsertString(2, L"+2");
			m_ctlContrast.InsertString(3, L"+1");
			m_ctlContrast.InsertString(4, L"0");
			m_ctlContrast.InsertString(5, L"-1");
			m_ctlContrast.InsertString(6, L"-2");
			m_ctlContrast.InsertString(7, L"-3");
			m_ctlContrast.InsertString(8, L"-4");
			nValue = 4-m_nContrastValue;
			m_ctlContrast.SetCurSel(nValue);

			m_ctlSharpness.InsertString(0, L"0");
			m_ctlSharpness.InsertString(1, L"1");
			m_ctlSharpness.InsertString(2, L"2");
			m_ctlSharpness.InsertString(3, L"3");
			m_ctlSharpness.InsertString(4, L"4");
			m_ctlSharpness.InsertString(5, L"5");
			m_ctlSharpness.InsertString(6, L"6");
			m_ctlSharpness.InsertString(7, L"7");
			m_ctlSharpness.InsertString(8, L"8");
			nValue = m_nSharpnessValue;
			m_ctlSharpness.SetCurSel(nValue);

			m_ctlSmartSetting.InsertString(SMART_SET_NOTSET, L"Not set");
			m_ctlSmartSetting.InsertString(SMART_SET_ROOM, L"Room");
			m_ctlSmartSetting.InsertString(SMART_SET_OUTSIDE_DAY, L"Outside in the day");
			m_ctlSmartSetting.InsertString(SMART_SET_OUTSIDE_NIGHT, L"Outside in the night");
			m_ctlSmartSetting.SetCurSel(SMART_SET_NOTSET);	

			m_ctlAfType.InsertString(AF_MANUAL,	L"Manual AF");
			m_ctlAfType.InsertString(AF_ALWAYS,	L"Always AF");
			m_ctlAfType.InsertString(AF_AUTO,	L"Auto AF");
			m_ctlAfType.SetCurSel(m_AFMode);
		}
		break;

	case MODEL_ORANGE_PLUS:
	case MODEL_SMART:
		{
			m_ctlBrightness.InsertString(0, L"+5");
			m_ctlBrightness.InsertString(1, L"+4");
			m_ctlBrightness.InsertString(2, L"+3");
			m_ctlBrightness.InsertString(3, L"+2");
			m_ctlBrightness.InsertString(4, L"+1");
			m_ctlBrightness.InsertString(5, L"0");
			m_ctlBrightness.InsertString(6, L"-1");
			m_ctlBrightness.InsertString(7, L"-2");
			m_ctlBrightness.InsertString(8, L"-3");
			m_ctlBrightness.InsertString(9, L"-4");
			m_ctlBrightness.InsertString(10, L"-5");
			nValue = 10 - m_nBrightnessValue;
			m_ctlBrightness.SetCurSel(nValue);

			m_ctlContrast.InsertString(0, L"+4");
			m_ctlContrast.InsertString(1, L"+3");
			m_ctlContrast.InsertString(2, L"+2");
			m_ctlContrast.InsertString(3, L"+1");
			m_ctlContrast.InsertString(4, L"0");
			m_ctlContrast.InsertString(5, L"-1");
			m_ctlContrast.InsertString(6, L"-2");
			m_ctlContrast.InsertString(7, L"-3");
			m_ctlContrast.InsertString(8, L"-4");
			nValue = (8 - m_nContrastValue);
			m_ctlContrast.SetCurSel(nValue);

			m_ctlSharpness.InsertString(0, L"0");
			m_ctlSharpness.InsertString(1, L"1");
			m_ctlSharpness.InsertString(2, L"2");
			m_ctlSharpness.InsertString(3, L"3");
			m_ctlSharpness.InsertString(4, L"4");
			m_ctlSharpness.InsertString(5, L"5");
			m_ctlSharpness.InsertString(6, L"6");
			m_ctlSharpness.InsertString(7, L"7");
			m_ctlSharpness.InsertString(8, L"8");
			nValue = m_nSharpnessValue;
			m_ctlSharpness.SetCurSel(nValue);

			m_ctlSmartSetting.InsertString(0, L"Not Supported");
			m_ctlSmartSetting.SetCurSel(0);
			m_ctlSmartSetting.EnableWindow(FALSE);

			m_ctlAfType.InsertString(AF_MANUAL,	L"Manual AF");
			m_ctlAfType.InsertString(AF_ALWAYS,	L"Always AF");
			m_ctlAfType.InsertString(AF_AUTO,	L"Auto AF");
			m_ctlAfType.SetCurSel(m_AFMode);
		}
		break;

	case MODEL_BLACK:
		{
			RECT rt;

			m_ctlBrightness.InsertString(0, L"+4");
			m_ctlBrightness.InsertString(1, L"+3");
			m_ctlBrightness.InsertString(2, L"+2");
			m_ctlBrightness.InsertString(3, L"+1");
			m_ctlBrightness.InsertString(4, L"0");
			m_ctlBrightness.InsertString(5, L"-1");
			m_ctlBrightness.InsertString(6, L"-2");
			m_ctlBrightness.InsertString(7, L"-3");
			m_ctlBrightness.InsertString(8, L"-4");
			nValue = (m_nBrightnessValue - 4) * -1;
			m_ctlBrightness.SetCurSel(nValue);

			m_ctlContrast.InsertString(0, L"Not Supported");
			
			m_ctlContrast.SetCurSel(0);
			m_ctlContrast.GetWindowRect(&rt);		//	츦 δ.
			GetParent()->ScreenToClient(&rt);
			m_ctlContrast.MoveWindow(rt.left, rt.top, 230, rt.bottom- rt.top);

			m_ctlSharpness.InsertString(0, L"Not Supported");
			m_ctlSharpness.SetCurSel(0);
			m_ctlSharpness.GetWindowRect(&rt);
			GetParent()->ScreenToClient(&rt);
			m_ctlSharpness.MoveWindow(rt.left, rt.top, 230, rt.bottom- rt.top);	

			m_ctlSmartSetting.InsertString(0, L"Not Supported");
			m_ctlSmartSetting.SetCurSel(0);


			m_ctlContrast.EnableWindow(FALSE);
			m_ctlSharpness.EnableWindow(FALSE);
			m_ctlSmartSetting.EnableWindow(FALSE);

			m_ctlAfType.InsertString(AF_MANUAL,	L"Manual AF");
			m_ctlAfType.InsertString(AF_ALWAYS,	L"Always AF");
			m_ctlAfType.InsertString(AF_AUTO,	L"Auto AF");
			m_ctlAfType.SetCurSel(m_AFMode);

			// NOT Support Black [12/18/2013 JJ]
			m_ctlNightMode.EnableWindow(FALSE);
		}
		break;
	}

		m_ctlNightMode.SetCheck(m_bHistoEqual);

		CAM_Close();
}

void COptionImageDlg::OnOK()
{
	MODEL_TYPE model = CAM_GetModelType();
	int nValue;

	nValue = m_ctlResolution.GetCurSel();
	CAM_SetResolution(nValue);

	if(model==MODEL_ORANGE_PLUS && (nValue==6 || nValue==5) )		
		m_bDateTime=FALSE;

	if((model==MODEL_MM3 || model==MODEL_ORANGE || model==MODEL_SKY || model == MODEL_BLACK) && nValue==0 && m_bDateTime)
		m_bDateTime=FALSE;


	if(m_ctlNightMode.GetCheck() == BST_CHECKED)
	{
		CAM_SetHistoEqual(TRUE);
		m_bHistoEqual=TRUE;
	}
	else
	{
		CAM_SetHistoEqual(FALSE);
		m_bHistoEqual=FALSE;
	}

	m_nWBValue = m_ctlWhiteBalance.GetCurSel();
	
	switch(model)
	{
	case MODEL_MM3:
		m_nBrightnessValue = (m_ctlBrightness.GetCurSel() - 3) * -1;
		break;

	case MODEL_SKY:
		m_nBrightnessValue = (m_ctlBrightness.GetCurSel() - 3) * -1;
		m_AFMode = (AF_MODE)m_ctlAfType.GetCurSel();
		break;

	case MODEL_ORANGE:		
		m_nContrastValue = (m_ctlContrast.GetCurSel() - 4) * -1;		
		m_nSharpnessValue = m_ctlSharpness.GetCurSel();		
		m_nBrightnessValue = (m_ctlBrightness.GetCurSel() - 5) * -1;			
		m_AFMode = (AF_MODE)m_ctlAfType.GetCurSel();		
		break;

	case MODEL_ORANGE_PLUS:		
	case MODEL_SMART:
		m_nSharpnessValue = (m_ctlSharpness.GetCurSel());
		m_nContrastValue = (8 - m_ctlContrast.GetCurSel());
		m_nBrightnessValue = (10-m_ctlBrightness.GetCurSel());
		m_AFMode = (AF_MODE)m_ctlAfType.GetCurSel();		
		break;

	case MODEL_BLACK:		
		m_nBrightnessValue = (m_ctlBrightness.GetCurSel() - 4) * -1;			
		m_AFMode = (AF_MODE)m_ctlAfType.GetCurSel();		
		break;
	}

	EndDialog(IDOK);
}

void COptionImageDlg::OnMenuCancel()
{
	EndDialog(IDCANCEL);
}

void COptionImageDlg::OnMenuOk()
{
	OnOK();
}


void COptionImageDlg::InitResolutionUI()
{
	HKEY	hMainKey;
	DWORD	dwIndex, dwNameLen;
	TCHAR	pName[MAX_PATH];

	//	The key HKEY_LOCAL_MACHINE\Software\Microsoft\Pictures\Camera\OEM\PictureResolution\ defines the total number of resolution settings available on a device.
	if(ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, TEXT("Software\\Microsoft\\Pictures\\Camera\\OEM\\PictureResolution"), 0, 0, &hMainKey))
	{
		dwIndex		= 0;
		dwNameLen	= MAX_PATH;


		PDWORD		*pData; 
		DWORD		dwItemCount;
		DWORD		dwItemCountLen = 4;

		//		This value represents the number of available resolutions.
		if(ERROR_SUCCESS == RegQueryValueEx(hMainKey, TEXT("OptionNum"), NULL, NULL, (LPBYTE)&dwItemCount, &dwItemCountLen))
		{
			pData = new PDWORD[dwItemCount];

			if(NULL != pData)
			{
				int index;

				//	ʱȭ
				for(index = 0; index < dwItemCount; index++)
				{
					pData[index] = NULL;
				}

				//	resolution item о  
				while (ERROR_SUCCESS == RegEnumKeyEx(hMainKey, dwIndex++, pName, &dwNameLen, NULL, NULL, NULL, NULL))
				{
					HKEY	hSubKey;
					DWORD	pResolutionData[2];			//	index 0: width, 1: height			
					TCHAR	pSubKeyPath[MAX_PATH];
					DWORD	dwDataSize;


					wsprintf(pSubKeyPath, L"%s\\%s", TEXT("Software\\Microsoft\\Pictures\\Camera\\OEM\\PictureResolution"), pName);

					if(ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, pSubKeyPath, 0, 0, &hSubKey))
					{			
						dwDataSize = 4;	
						//	resolution item Width о
						if(ERROR_SUCCESS == RegQueryValueEx(hSubKey, TEXT("Width"), NULL, NULL, (LPBYTE)&pResolutionData[0], &dwDataSize))
						{
							int num = _wtoi(pName) -1;
							pData[num] = new DWORD[2];
							if(NULL != pData[num])
							{
								pData[num][0] = pResolutionData[0];

								dwDataSize = 4;
								//	resolution item Height о
								if(ERROR_SUCCESS == RegQueryValueEx(hSubKey, TEXT("Height"), NULL, NULL, (LPBYTE)&pResolutionData[1], &dwDataSize))
								{
									pData[num][1] = pResolutionData[1];
								}
							}

						}
						RegCloseKey(hSubKey);
					}		
					dwNameLen	= MAX_PATH;
				}

				//	resolution "WidthxHeight" · ǥ 
				for(index = 0; index < dwItemCount; index++)
				{
					if(NULL != pData[index])
					{
						TCHAR strResolution[10];
						wsprintf(strResolution, L"%dx%d", pData[index][0], pData[index][1]);
						m_ctlResolution.InsertString(index, strResolution);
						delete pData[index];
					}
				}
				delete pData;
			}
		}

		RegCloseKey(hMainKey);		
	}
}
void COptionImageDlg::OnCbnSelchangeComboSmartSet()
{
	MODEL_TYPE model = CAM_GetModelType();

	int nSetIndex = m_ctlSmartSetting.GetCurSel();

	if(model==MODEL_ORANGE)
	{
		HKEY hKey;
		DWORD Size = sizeof(DWORD);
		// DWORD value;
		if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, L"Drivers\\BuiltIn\\Camera\\sensor", 0, NULL, &hKey) != ERROR_SUCCESS)
		{
			return;
		}

		DWORD size = 260;
		int nRet;
		TCHAR tzSensorName[260] = {0x00,};
		nRet = RegQueryValueEx (hKey, L"sensor", NULL, NULL, NULL, &size);
		nRet = RegQueryValueEx (hKey, L"sensor", NULL, NULL, (LPBYTE)tzSensorName, &size);

		RegCloseKey(hKey);

		if(_tcscmp(tzSensorName, _T("s5k4cagx"))==0)	// tapio module
		{
			switch(nSetIndex)
			{
			case SMART_SET_NOTSET:				//	Brightness : 0, Sharpness : 0, Contrast : 0
				m_ctlBrightness.SetCurSel(5);
				m_ctlSharpness.SetCurSel(0);
				m_ctlContrast.SetCurSel(4);
				break;

			case SMART_SET_ROOM:				//	Brightness : 0, Sharpness : +3, Contrast : 0
				m_ctlBrightness.SetCurSel(5);
				m_ctlSharpness.SetCurSel(3);
				m_ctlContrast.SetCurSel(4);
				break;
			case SMART_SET_OUTSIDE_DAY:			//	Brightness : -1, Sharpness : +3, Contrast : 0
				m_ctlBrightness.SetCurSel(6);
				m_ctlSharpness.SetCurSel(3);
				m_ctlContrast.SetCurSel(4);
				break;

			case SMART_SET_OUTSIDE_NIGHT:		//	Brightness : +4, Sharpness : +3, Contrast : 0
				m_ctlBrightness.SetCurSel(1);
				m_ctlSharpness.SetCurSel(3);
				m_ctlContrast.SetCurSel(4);
				break;
			}
		}

		else
		{
			switch(nSetIndex)
			{
			case SMART_SET_NOTSET:				//	Brightness : 0, Sharpness : 0, Contrast : 0
				m_ctlBrightness.SetCurSel(5);
				m_ctlSharpness.SetCurSel(0);
				m_ctlContrast.SetCurSel(4);
				break;

			case SMART_SET_ROOM:				//	Brightness : -4, Sharpness : +8, Contrast : 0
				m_ctlBrightness.SetCurSel(9);
				m_ctlSharpness.SetCurSel(8);
				m_ctlContrast.SetCurSel(4);
				break;
			case SMART_SET_OUTSIDE_DAY:			//	Brightness : 0, Sharpness : +8, Contrast : 0
				m_ctlBrightness.SetCurSel(5);
				m_ctlSharpness.SetCurSel(8);
				m_ctlContrast.SetCurSel(4);
				break;

			case SMART_SET_OUTSIDE_NIGHT:		//	Brightness : +1, Sharpness : +2, Contrast : 0
				m_ctlBrightness.SetCurSel(4);
				m_ctlSharpness.SetCurSel(2);
				m_ctlContrast.SetCurSel(4);
				break;
			}
		}
	}
}

void COptionImageDlg::OnBnClickedCheckHistoequal()
{
	if(m_useEXIF)
	{
		if(m_ctlNightMode.GetCheck())
		{
			AfxMessageBox(_T("Not Available in use EXIF."));
			m_ctlNightMode.SetCheck(0);
		}
			
	}
	
}

