// CamTestDlg.h : header file
//

#pragma once

#include "CAM.h"
#include "afxwin.h"

#include "Msgqueue.h"
#include <Pm.h>
// Power Status 
#define QUEUE_ENTRIES   3
#define MAX_NAMELEN     200
#define QUEUE_SIZE      (QUEUE_ENTRIES * (sizeof(POWER_BROADCAST) + MAX_NAMELEN))

// CCamTestDlg dialog
class CCamTestDlg : public CDialog
{
// Construction
public:
	CCamTestDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_CAMTEST_DIALOG };


	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void OnOK();
// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);

#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	afx_msg void OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/);
#endif
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnMenuClose();	
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnMenuStill();
	afx_msg void OnMenuFlash();
	afx_msg void OnMenuAF();
	afx_msg void OnMenuImage();
	afx_msg void OnMenuSave();
	afx_msg void OnMenuZoom1();
	afx_msg void OnMenuZoom2();
	afx_msg void OnMenuZoom3();
	afx_msg void OnMenuZoom4();
	afx_msg void OnMenuCapture();

	afx_msg void OnUpdateZoom1(CCmdUI *pCmdUI);
	afx_msg void OnUpdateZoom2(CCmdUI *pCmdUI);
	afx_msg void OnUpdateZoom3(CCmdUI *pCmdUI);
	afx_msg void OnUpdateZoom4(CCmdUI *pCmdUI);

	afx_msg void OnUpdateMenuImage(CCmdUI *pCmdUI);
	afx_msg void OnUpdateMenuSave(CCmdUI *pCmdUI);

	afx_msg void OnUpdateMenuTRIGGERAF(CCmdUI *pCmdUI);
	
	afx_msg void OnUpdateMenuCapture(CCmdUI *pCmdUI);
	
	BOOL InsertExifInform(TCHAR * tzFileName);
	long OnRecvAfMsg(WPARAM wParam, LPARAM lParam);
	long OnGpsStatus(WPARAM wParam, LPARAM lParam);
	
	CComboBox m_ctlZoom;

	HWND m_hMenu;

	// Status
	int m_nTime;
	BOOL m_bHistoEqual;

	// Flag
	BOOL m_bPreviewOn;
	BOOL m_bFlashOn;
	BOOL m_bAutoFocusing;
	BOOL m_bStillCapturing;
	BOOL m_bCameraOpen;
	BOOL m_bPressedCaptureKey;
	BOOL m_bDateTime;

	// Setting
	MODEL_TYPE m_ModelType;
	
	AF_MODE m_AFMode;
	SCANNER_TYPE m_ScannerType;

	TCHAR m_tzSaveFilePath[MAX_PATH];
	TCHAR m_tzSaveFileName[MAX_PATH];
	BOOL m_bAutoInit;
	BOOL m_bEnableViewer;
	BOOL m_bUseExif;
	BOOL m_bExifGps;

	BOOL m_bRunScanEmul;
	int m_nZoomCheck;
	//

private:
	// Power Manager

	BOOL SaveRegCamOption();
	BOOL LoadRegCamOption();

	BOOL RegisterPowerNotify();
	BOOL UnregisterPowerNotify();
	static DWORD PowerStatusThreadFunc(LPVOID pParam);

	BOOL UseStillShotViewer(TCHAR* tzFileName);
	BOOL RegisterCameraKey(BOOL bRegister);

	DWORD m_dwBackupCameraKey;
	DWORD m_dwBackupScannerKey;

	DWORD m_dwScannerType;

	static HANDLE m_hPowerStatusThread;
	static HANDLE m_hPMMQ;
	static HANDLE m_hPMNoti;
	static MSGQUEUEOPTIONS m_mqOptions;

	
	int m_nCaptureCnt;

public:
	void CameraOpen(BOOL bOpen);
	void Capture();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
		
	void ExecuteCapture(void);


	afx_msg void OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu);
	afx_msg void OnUpdateMenuFlash(CCmdUI *pCmdUI);
	afx_msg void OnUpdateMenuVideo(CCmdUI *pCmdUI);

	afx_msg void OnUpdateMenuStart(CCmdUI *pCmdUI);
};
