/********************************************************************
created		:	2011/10/11
file base	:   CamTest.exe
file ext    :   cpp
author      :   Kevin
purpose     :   WM Camera C++ Demo Program
Report      :   2012. 01. 13 [01/13/2012 khj1528] v1.0.0 - Release Version        
2012. 02. 20 [02/20/2012 khj1528] v1.1.0 -  M3 SMART Combined       
// v.1.2.0    [8/7/2013 JJ]
// v.1.3.0	BLACK ߰ [11/27/2013 JJ]
//			Black Night   (BLACK ī޶ ü ɾ Կ    ֱ  DEMO ش  disable ó ص    QA ޽) [12/18/2013 JJ]
*********************************************************************/

#include "stdafx.h"
#include "CamTest.h"
#include "CamTestDlg.h"

#include "OptionImageDlg.h"
#include "OptionSaveDlg.h"

#include "aygshell.h"

#include "Reg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// Timer Constant
#define TIMER_STATUS_MSG			811


// Timer Interval
#define TIMER_STATUS_MSG_INTERVAL	3000b 

//
#define WM_TIMER_CAPTURE	0x1111111


HANDLE CCamTestDlg::m_hPowerStatusThread = NULL;
HANDLE CCamTestDlg::m_hPMMQ = NULL;
HANDLE CCamTestDlg::m_hPMNoti = NULL;

MSGQUEUEOPTIONS CCamTestDlg::m_mqOptions;


BOOL g_bWakeUp=FALSE;
SAVE_TYPE g_SaveType;
HWND g_hWnd=NULL;
HINSTANCE gInst=NULL;

// CCamTestDlg dialog

CCamTestDlg::CCamTestDlg(CWnd* pParent /*=NULL*/)
: CDialog(CCamTestDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_ModelType = MODEL_UNKONWN;
	m_ScannerType = SCANNER_INTERMEC;

	m_bPreviewOn = FALSE;
	m_bFlashOn = FALSE;
	m_bAutoFocusing = FALSE;
	m_bStillCapturing = FALSE;
	m_bCameraOpen = FALSE;

	m_bRunScanEmul = FALSE;

	memset(m_tzSaveFilePath, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(m_tzSaveFileName, 0x00, sizeof(TCHAR) * MAX_PATH);
	
	m_bAutoInit = TRUE;
	m_bEnableViewer = TRUE;
	m_bUseExif=FALSE;
	m_bExifGps = FALSE;

	m_AFMode = AF_MANUAL;

	m_dwBackupCameraKey = 0;
	m_dwBackupScannerKey = 0;

	m_nTime = 0;

	g_SaveType = SAVE_DATE;
	g_bWakeUp=FALSE;
	m_bPressedCaptureKey = FALSE;
	m_hMenu=NULL;
	m_bHistoEqual=FALSE;
	m_nZoomCheck=0;
	m_bDateTime=FALSE;
	m_nCaptureCnt=0;
}

void CCamTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CCamTestDlg, CDialog)
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	ON_WM_SIZE()
#endif
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_CLOSE, &CCamTestDlg::OnMenuClose)
	ON_COMMAND(ID_CLOSE_STILL_SKY, &CCamTestDlg::OnMenuClose)

	ON_COMMAND(ID_MENU_CAPTURE, &CCamTestDlg::OnMenuCapture)
	ON_COMMAND(ID_MENU_CAPTURE_STILL_SKY, &CCamTestDlg::OnMenuCapture)
	ON_UPDATE_COMMAND_UI(ID_MENU_CAPTURE, &CCamTestDlg::OnUpdateMenuCapture)
	ON_UPDATE_COMMAND_UI(ID_MENU_CAPTURE_STILL_SKY, &CCamTestDlg::OnUpdateMenuCapture)

	ON_COMMAND(ID_MENU_FLASH, &CCamTestDlg::OnMenuFlash)
	ON_COMMAND(ID_MENU_FLASH_STILL_SKY, &CCamTestDlg::OnMenuFlash)
	ON_UPDATE_COMMAND_UI(ID_MENU_FLASH, &CCamTestDlg::OnUpdateMenuFlash)
	ON_UPDATE_COMMAND_UI(ID_MENU_FLASH_STILL_SKY, &CCamTestDlg::OnUpdateMenuFlash)

	ON_COMMAND(ID_MENU_TRIGGERAF, &CCamTestDlg::OnMenuAF)
	ON_COMMAND(ID_MENU_TRIGGERAF_STILL_SKY, &CCamTestDlg::OnMenuAF)
	ON_UPDATE_COMMAND_UI(ID_MENU_TRIGGERAF, &CCamTestDlg::OnUpdateMenuTRIGGERAF)
	ON_UPDATE_COMMAND_UI(ID_MENU_TRIGGERAF_STILL_SKY, &CCamTestDlg::OnUpdateMenuTRIGGERAF)


	ON_COMMAND(ID_OPTION_IMAGE, &CCamTestDlg::OnMenuImage)
	ON_COMMAND(ID_OPTION_IMAGE_STILL_SKY, &CCamTestDlg::OnMenuImage)
	ON_UPDATE_COMMAND_UI(ID_OPTION_IMAGE, &CCamTestDlg::OnUpdateMenuImage)
	ON_UPDATE_COMMAND_UI(ID_OPTION_IMAGE_STILL_SKY, &CCamTestDlg::OnUpdateMenuImage)

	ON_COMMAND(ID_OPTION_SAVE, &CCamTestDlg::OnMenuSave)
	ON_COMMAND(ID_OPTION_SAVE_STILL_SKY, &CCamTestDlg::OnMenuSave)
	ON_UPDATE_COMMAND_UI(ID_OPTION_SAVE, &CCamTestDlg::OnUpdateMenuSave)
	ON_UPDATE_COMMAND_UI(ID_OPTION_SAVE_STILL_SKY, &CCamTestDlg::OnUpdateMenuSave)

	ON_COMMAND(ID_ZOOM1, &CCamTestDlg::OnMenuZoom1)
	ON_COMMAND(ID_ZOOM2, &CCamTestDlg::OnMenuZoom2)
	ON_COMMAND(ID_ZOOM3, &CCamTestDlg::OnMenuZoom3)
	ON_COMMAND(ID_ZOOM4, &CCamTestDlg::OnMenuZoom4)
	ON_UPDATE_COMMAND_UI(ID_ZOOM1, &CCamTestDlg::OnUpdateZoom1)
	ON_UPDATE_COMMAND_UI(ID_ZOOM2, &CCamTestDlg::OnUpdateZoom2)
	ON_UPDATE_COMMAND_UI(ID_ZOOM3, &CCamTestDlg::OnUpdateZoom3)
	ON_UPDATE_COMMAND_UI(ID_ZOOM4, &CCamTestDlg::OnUpdateZoom4)

	ON_MESSAGE(WM_STATUS_AF, OnRecvAfMsg)
	ON_MESSAGE(WM_GPS_ON, OnGpsStatus)
	ON_WM_TIMER()
	ON_WM_SETFOCUS()
	ON_WM_LBUTTONDOWN()

	ON_WM_INITMENUPOPUP()

END_MESSAGE_MAP()


// CCamTestDlg message handlers

BOOL CCamTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	// SetIcon(m_hIcon, FALSE);		// Set small icon

	m_ModelType = CAM_GetModelType();
	m_ScannerType = CAM_GetScannerType();

	// Menu
	SHMENUBARINFO mbi;

	HINSTANCE hInst = AfxGetInstanceHandle();
	gInst=hInst;
	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize = sizeof(SHMENUBARINFO);
	mbi.hwndParent = m_hWnd;
	g_hWnd=m_hWnd;
	if(m_ModelType==MODEL_SMART || m_ModelType==MODEL_ORANGE || m_ModelType==MODEL_ORANGE_PLUS || m_ModelType==MODEL_BLACK)
		mbi.nToolBarId = IDR_MENU_STILL;
	else
		mbi.nToolBarId = IDR_MENU_STILL_SKY;
	mbi.hInstRes = hInst;
	mbi.dwFlags = SHCMBF_HMENU;

	SHCreateMenuBar(&mbi);

	m_hMenu=mbi.hwndMB;

	m_bDateTime=CAM_GetRegInsertDateTimeEnable();
	CAM_SetInsertDateTimeEnable(m_bDateTime);

	m_bAutoInit=TRUE;

	LoadRegCamOption();
	
	CAM_EnableShutterSound(TRUE);

	CameraOpen(TRUE);
	

	if(m_ModelType==MODEL_SMART || m_ModelType==MODEL_ORANGE || m_ModelType==MODEL_ORANGE_PLUS || m_ModelType==MODEL_BLACK)
	{
		switch(CAM_GetZoom())
		{
		case 0:
			OnMenuZoom1();
			break;
		case 1:
			OnMenuZoom2();
			break;
		case 2:
			OnMenuZoom3();
			break;
		case 3:
			OnMenuZoom4();
			break;
		}
	}

	RegisterPowerNotify();
	RegisterCameraKey(TRUE);

	// Load Setting
	m_AFMode = CAM_GetAfMode();

	CAM_SetAfMode(m_AFMode);

	m_bUseExif = CAM_GetRegExifEnable();
	m_bExifGps = CAM_GetRegExifGpsEnable();

	if(m_bExifGps)
		CAM_UseGPSExifData(TRUE);
	if(CAM_GetHistoEqual())
	{
		m_bUseExif = FALSE;
		m_bExifGps = FALSE;
		m_bHistoEqual=TRUE;
	}
	else
		m_bHistoEqual=FALSE;

	CAM_GetRegCapturePathEx(m_tzSaveFilePath, m_tzSaveFileName);	

	this->SetForegroundWindow();

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
void CCamTestDlg::OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/)
{
	if (AfxIsDRAEnabled())
	{
		DRA::RelayoutDialog(
			AfxGetResourceHandle(), 
			this->m_hWnd, 
			DRA::GetDisplayMode() != DRA::Portrait ? 
			MAKEINTRESOURCE(IDD_CAMTEST_DIALOG_WIDE) : 
		MAKEINTRESOURCE(IDD_CAMTEST_DIALOG));
	}
}
#endif

void CCamTestDlg::OnTimer(UINT_PTR nIDEvent)
{

	switch(nIDEvent)
	{

	case WM_TIMER_CAPTURE:
		{
			KillTimer(WM_TIMER_CAPTURE);
			ExecuteCapture();
		}
		break;
	case TIMER_STATUS_MSG:
		{
			::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"");

			KillTimer(TIMER_STATUS_MSG);
		}
		break;
	}

	CDialog::OnTimer(nIDEvent);
}


void CCamTestDlg::CameraOpen(BOOL bOpen)
{
	if(bOpen)
	{
		if(!CAM_Open(m_hWnd, STILL_MODE, (VIDEO_TYPE)NULL))
		{
			::MessageBox(this->m_hWnd, _T("Camera Open Fail!!"), _T("Camera"), MB_TOPMOST);
			m_bCameraOpen=FALSE;
			OnOK();
			return;
		}	
		
		if(!m_bAutoInit)
		{
			if(CAM_PreviewStop()) 
				m_bPreviewOn = FALSE;
		}

		else
		{
			m_bPreviewOn = TRUE;

			if(CAM_PreviewStart()) 
			{					
				g_bWakeUp=FALSE;
				m_bPreviewOn = TRUE;

				if(m_ModelType==MODEL_SMART || m_ModelType==MODEL_ORANGE_PLUS)
					CAM_CaptureFlash(m_bFlashOn);

			}
		}

		m_bCameraOpen = TRUE;

		{
			SHMENUBARINFO mbi;
			HINSTANCE hInst = AfxGetInstanceHandle();

			memset(&mbi, 0, sizeof(SHMENUBARINFO));
			mbi.cbSize = sizeof(SHMENUBARINFO);
			mbi.hwndParent = m_hWnd;
			g_hWnd=m_hWnd;
			if(m_ModelType==MODEL_SMART || m_ModelType==MODEL_ORANGE || m_ModelType==MODEL_ORANGE_PLUS  || m_ModelType==MODEL_BLACK)
				mbi.nToolBarId = IDR_MENU_STILL;
			else
				mbi.nToolBarId = IDR_MENU_STILL_SKY;
			mbi.hInstRes = hInst;
			mbi.dwFlags = SHCMBF_HMENU;

			SHCreateMenuBar(&mbi);

			m_hMenu=mbi.hwndMB;
		}
	}
	else
	{
		m_bCameraOpen = FALSE;
		if(CAM_PreviewStop()) 
			m_bPreviewOn = FALSE;

		
		CAM_Close();
		
	}
}


BOOL CCamTestDlg::SaveRegCamOption()
{

	CReg reg;

	reg.SetRegValue(HKEY_CURRENT_USER, L"Software\\Microsoft\\Pictures\\Camera\\USER", L"AutoPreview", m_bAutoInit);
	reg.SetRegValue(HKEY_CURRENT_USER, L"Software\\Microsoft\\Pictures\\Camera\\USER", L"ViewAfterCapturing", m_bEnableViewer);

	return TRUE;
}

BOOL CCamTestDlg::LoadRegCamOption()
{
	CReg reg;
	m_bAutoInit = reg.GetRegValue(HKEY_CURRENT_USER, L"Software\\Microsoft\\Pictures\\Camera\\USER", L"AutoPreview");
	
	int ntmp=reg.GetRegValue(HKEY_CURRENT_USER, L"Software\\Microsoft\\Pictures\\Camera\\USER", L"ViewAfterCapturing");

	// clean boot  default false ϱ 
	if(ntmp==1)
		m_bEnableViewer=TRUE;
	else
		m_bEnableViewer=FALSE;
	
	RETAILMSG(RT_MSG, (_T("m_bEnableViewer Value ----> %d	%d\r\n"), ntmp, m_bEnableViewer));
	
	if(m_bAutoInit == -1)		
		m_bAutoInit = TRUE;	

	return TRUE;
}

BOOL CCamTestDlg::RegisterCameraKey(BOOL bRegister)
{
	DWORD nRegValue;

	CReg reg;

	TCHAR tzKeyPath[MAX_PATH] = {0x00};
	TCHAR tzScannerKeyName[MAX_PATH] = {0x00};
	TCHAR tzCameraKeyName[MAX_PATH] = {0x00};
	memset(tzKeyPath, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzScannerKeyName, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzCameraKeyName, 0x00, sizeof(TCHAR) * MAX_PATH);


	wsprintf(tzScannerKeyName, L"RightDownKey");
	wsprintf(tzCameraKeyName, L"RightUpKey");

	switch(m_ModelType)
	{
	case MODEL_MM3:
		wsprintf(tzKeyPath, L"ControlPanel\\Keypad\\SideKey");
		break;
	case MODEL_ORANGE:
	case MODEL_SKY:
		{
			nRegValue  = reg.GetRegValue(HKEY_LOCAL_MACHINE, L"ControlPanel\\keypad", L"KeypadType");

			switch(nRegValue)
			{
			case 0:
				wsprintf(tzKeyPath, L"ControlPanel\\Keypad\\Numeric");
				break;
			case 1:
				wsprintf(tzKeyPath, L"ControlPanel\\Keypad\\Qwerty");
				break;
			case -1:
				wsprintf(tzKeyPath, L"ControlPanel\\Keypad\\SideKey");
				break;
			}
		}
		break;
	case MODEL_BLACK:
		wsprintf(tzScannerKeyName, L"SideScanKey");
		wsprintf(tzCameraKeyName, L"CameraKey");
	case MODEL_ORANGE_PLUS:
	case MODEL_SMART:
		wsprintf(tzKeyPath, L"ControlPanel\\Keypad\\MultiFunc");
		break;
	default:
		wsprintf(tzKeyPath, L"ControlPanel\\Keypad\\SideKey");
		break;
	}


	RETAILMSG(RT_MSG, (L"%d : %s", bRegister?1:0, tzKeyPath));

	if(bRegister)
	{
		m_dwBackupCameraKey = reg.GetRegValue(HKEY_LOCAL_MACHINE, tzKeyPath, tzCameraKeyName);
		m_dwBackupScannerKey = reg.GetRegValue(HKEY_LOCAL_MACHINE, tzKeyPath, tzScannerKeyName);

		reg.SetRegValue(HKEY_LOCAL_MACHINE, tzKeyPath, tzCameraKeyName, 2);
		reg.SetRegValue(HKEY_LOCAL_MACHINE, tzKeyPath, tzScannerKeyName, 3);

	}
	else
	{
		reg.SetRegValue(HKEY_LOCAL_MACHINE, tzKeyPath, tzCameraKeyName, m_dwBackupCameraKey);
		reg.SetRegValue(HKEY_LOCAL_MACHINE, tzKeyPath, tzScannerKeyName, m_dwBackupScannerKey);
	}

	return TRUE;
}

BOOL CCamTestDlg::UseStillShotViewer(TCHAR* tzFileName)
{
	// Get Viewer
	Sleep(50);
	TCHAR	szThisProgram[MAX_PATH] = {0, }; // Camera Program
	CString szViewr;

	GetModuleFileName(NULL, szThisProgram, sizeof(TCHAR)*MAX_PATH);
	szViewr.Format(_T("%s"), szThisProgram);
	int nIndex = szViewr.ReverseFind('\\');
	szViewr.Format(_T("%s\\Viewer.exe"), szViewr.Left(nIndex));


	if(!CreateProcessW(szViewr, tzFileName, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL))
		return FALSE;
	else
		return TRUE;
}


BOOL CCamTestDlg::InsertExifInform(TCHAR * tzFileName)
{
	ExifInfo info={0,};
	TCHAR OutFileBuf[260]={0,};
	_tcscpy(OutFileBuf, tzFileName);

	TCHAR* ImageName;
	ImageName=_tcstok(OutFileBuf, _T("\\"));
	while (ImageName!=NULL)
	{
		if(_tcsstr(ImageName, _T(".jpg"))!=NULL || _tcsstr(ImageName, _T(".JPG"))!=NULL)
			break;
		ImageName=_tcstok(NULL, _T("\\"));
	}

	_tcscpy(info.TitleName, ImageName);
	_tcscpy(info.Make, _T("M3 Mobile Co.Ltd"));

	switch(m_ModelType)
	{
	case MODEL_MM3:
		_tcscpy(info.Model, _T("MM3"));
		break;
	case MODEL_SMART:
		_tcscpy(info.Model, _T("M3 SMART"));
		break;
	case MODEL_ORANGE_PLUS:
		_tcscpy(info.Model, _T("M3 ORANGE PLUS"));
		break;
	case MODEL_SKY:
		_tcscpy(info.Model, _T("M3 SKY"));
		break;
	case MODEL_ORANGE:
		_tcscpy(info.Model, _T("M3 ORANGE"));
		break;
	case MODEL_BLACK:
		_tcscpy(info.Model, _T("M3 BLACK"));
		break;
	case MODEL_UNKONWN:
		_tcscpy(info.Model, _T("M3"));
		break;
	}

	if(CAM_InsertExifInformation(tzFileName, info))
	{
		RETAILMSG(RT_MSG, (_T("CamTest - Insert EXIF Success!!\n")));
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

long CCamTestDlg::OnGpsStatus(WPARAM wParam, LPARAM lParam)
{
	if(wParam == TRUE)
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"STATUS: GPS ON");
		SetTimer(TIMER_STATUS_MSG, 3000, NULL);

	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"STATUS: GPS OUT");
		SetTimer(TIMER_STATUS_MSG, 3000, NULL);
	}
	return 0;
}	


long CCamTestDlg::OnRecvAfMsg(WPARAM wParam, LPARAM lParam)
{

	if(wParam == AF_STATUS_START)
	{
		if(m_AFMode!=AF_ALWAYS)
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"Auto Focusing..");
		m_bAutoFocusing = TRUE;
	}
	else if(wParam == AF_STATUS_FINISH)
	{
		if(m_AFMode!=AF_ALWAYS)
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"Auto Focusing..OK");
		m_bAutoFocusing = FALSE;
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"");
	}

	return 0;
}

void CCamTestDlg::OnOK()
{
	if(m_bPreviewOn)
	{
		if(CAM_PreviewStop()) 
			m_bPreviewOn = FALSE;		
	}	


	UnregisterPowerNotify();
	if(m_bCameraOpen)
		CAM_Close();	

	RegisterCameraKey(FALSE);

	::PostMessage(HWND_BROADCAST, WM_CONVERT, NULL, NULL);	

	SaveRegCamOption();

	CDialog::OnOK();
}

void CCamTestDlg::OnMenuClose()
{
	OnOK();
}

BOOL CCamTestDlg::PreTranslateMessage(MSG* pMsg)
{
	HKEY hKey;
   	DWORD dwType,dwValue,cbData;
	
	if( ((pMsg->message==WM_SYSKEYUP) || (pMsg->message == WM_KEYUP)) && ((pMsg->wParam == VK_F13) || (pMsg->wParam == VK_RETURN)))
	{
		if(g_bWakeUp==TRUE || m_bCameraOpen==FALSE)
			return TRUE;
		if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, _T("Drivers\\Builtin\\CameraDriver"), 0, KEY_READ, &hKey) == ERROR_SUCCESS)
		{
			RegQueryValueEx(hKey, _T("CameraSDKWakeUpFlag"), NULL, &dwType, (LPBYTE)&dwValue, (LPDWORD)&cbData);
			if(dwValue)
			{	
				return TRUE;
			}
			RegCloseKey(hKey);
		}

		if(m_bPreviewOn)
		{
			if(m_bPressedCaptureKey)
			{		
				m_bPressedCaptureKey = FALSE;

				if(m_bStillCapturing == FALSE)
				{
					SetTimer(WM_TIMER_CAPTURE, 1, NULL);
				}
			}
		}
		return TRUE;
	}
	else if(((pMsg->message == WM_SYSKEYDOWN) || (pMsg->message == WM_KEYDOWN)) && (((pMsg->wParam == VK_F13) || (pMsg->wParam == VK_RETURN))))
	{
		m_bPressedCaptureKey = TRUE;
		return TRUE;
	}

	// Convert 2D Scanner 
	if((pMsg->message == WM_KEYUP) && (pMsg->wParam == VK_F14) && (m_ScannerType == SCANNER_HHP))
	{	
		
		BeginWaitCursor();
		m_bRunScanEmul = TRUE;

		UnregisterPowerNotify();
		Sleep(300);

		CAM_Close();

		Sleep(1500);

		RegisterCameraKey(FALSE);

		::PostMessage(HWND_BROADCAST, WM_CONVERT, NULL, NULL);			

		EndWaitCursor();

		CDialog::OnCancel();
	}
	return CDialog::PreTranslateMessage(pMsg);
}

BOOL CCamTestDlg::RegisterPowerNotify()
{
	DWORD dwThreadID;
	TCHAR tzMsg[1024]= {0x00};

	m_mqOptions.dwSize			= sizeof (MSGQUEUEOPTIONS);
	m_mqOptions.dwFlags			= MSGQUEUE_ALLOW_BROKEN;
	m_mqOptions.dwMaxMessages		= 10;							// ޽ť  ִ ޽ 
	m_mqOptions.cbMaxMessage		= QUEUE_SIZE;					// ޽ ϳ ִ 
	m_mqOptions.bReadAccess		= TRUE;

	m_hPMMQ = CreateMsgQueue (NULL, &m_mqOptions);				// ޽ ť 
	if (m_hPMMQ == NULL) {
		return FALSE;
	}


	if(NULL == m_hPowerStatusThread)
	{
		m_hPowerStatusThread = CreateThread(0, 0, PowerStatusThreadFunc, (LPVOID)this, 0, &dwThreadID);

		if (m_hPowerStatusThread == NULL) {		
			return FALSE;
		}
	}	
	//SetThreadPriority (pCamCtrl->m_hPowerStatusThread, THREAD_PRIORITY_NORMAL);

	m_hPMNoti = RequestPowerNotifications (m_hPMMQ, PBT_RESUME/*POWER_NOTIFY_ALL*/);
	if (m_hPMNoti == NULL) {
		return FALSE;
	}

	return TRUE;
}


BOOL CCamTestDlg::UnregisterPowerNotify()
{
	if(m_hPMMQ)
	{
		CloseMsgQueue(m_hPMMQ);
		m_hPMMQ = NULL;
	}

	if(m_hPMNoti)
	{
		StopPowerNotifications(m_hPMNoti);
		m_hPMNoti = NULL;
	}

	return TRUE;
}

DWORD CCamTestDlg::PowerStatusThreadFunc(LPVOID  pParam)
{
	DWORD					lm_dwErrCode, lm_dwPri = 250, lm_dwCount = 0;

	UCHAR					lm_ucBuf[QUEUE_SIZE];
	DWORD					lm_dwReadSize = 0, lm_dwFlags;
	BOOL					lm_bResult;
	HKEY hKey;
    DWORD dwLevel;

	CCamTestDlg *dlg = (CCamTestDlg*)pParam;

	if ( !CeSetThreadPriority(GetCurrentThread(), lm_dwPri)) {
		goto _Exit;
	}

	if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, _T("Drivers\\Builtin\\CameraDriver"), 0, KEY_READ, &hKey) == ERROR_SUCCESS)
	{
			dwLevel=0;
			RegSetValueEx(hKey, TEXT("CameraSDKWakeUpFlag"), NULL, REG_DWORD, (LPBYTE)&dwLevel, sizeof(dwLevel));	
			RegCloseKey(hKey);
	}
	while (TRUE) {
		memset (&lm_ucBuf, 0, QUEUE_SIZE);

		lm_bResult = ReadMsgQueue (m_hPMMQ, &lm_ucBuf, sizeof (POWER_BROADCAST), &lm_dwReadSize, INFINITE, &lm_dwFlags);

		if (lm_bResult) {	
			RETAILMSG(RT_MSG, (TEXT("noti, msg:%d, flag:%x, tickcount %x\r\n"), 
				((PPOWER_BROADCAST)&lm_ucBuf)->Message,
				((PPOWER_BROADCAST)&lm_ucBuf)->Flags, 
				GetTickCount()));
			if (lm_dwReadSize >= sizeof(POWER_BROADCAST)) {
				PPOWER_BROADCAST	pB = (PPOWER_BROADCAST)&lm_ucBuf;

				if (pB->Message == PBT_RESUME) 	// wake up 
				{	
					if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, _T("Drivers\\Builtin\\CameraDriver"), 0, KEY_READ, &hKey) == ERROR_SUCCESS)
					{
							dwLevel=0;
							RegSetValueEx(hKey, TEXT("CameraSDKWakeUpFlag"), NULL, REG_DWORD, (LPBYTE)&dwLevel, sizeof(dwLevel));	
							RegCloseKey(hKey);
					}

					g_bWakeUp=TRUE;
					if(dlg->m_bCameraOpen)
					{
						dlg->m_bCameraOpen=FALSE;
						dlg->CameraOpen(FALSE);
					}

				

					Sleep(200);

					g_bWakeUp=FALSE;
				}
				else 
				{
					if(pB->Message == PBT_TRANSITION)
					{
						if(pB->Flags == POWER_STATE_SUSPEND)  
						{	
							if(dlg->m_ModelType == MODEL_SMART || dlg->m_ModelType == MODEL_ORANGE_PLUS || dlg->m_ModelType == MODEL_BLACK)
							{
								dlg->m_bCameraOpen=FALSE;
								dlg->CameraOpen(FALSE);
							}
						}
					}
				}
			}
		}
		else {
			lm_dwErrCode = GetLastError ();
			if(lm_dwErrCode == ERROR_TIMEOUT) 
				continue;

			goto _Exit;
		}

	}

_Exit:
	StopPowerNotifications (m_hPMNoti);
	CloseMsgQueue (m_hPMMQ);

	RETAILMSG(RT_MSG,(L"CPowerManager - Exit PowerMonitor\r\n"));

	return 0;
}

void CCamTestDlg::OnSetFocus(CWnd* pOldWnd)
{
	CDialog::OnSetFocus(pOldWnd);

}

void CCamTestDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	if(g_bWakeUp==TRUE)
		return;

	g_bWakeUp=FALSE;
	m_bPreviewOn = TRUE;

	if(!m_bCameraOpen)
		CameraOpen(TRUE);

	CAM_PreviewStart();
	m_bPreviewOn=TRUE;
	m_bStillCapturing=FALSE;
	m_bCameraOpen=TRUE;

	CDialog::OnLButtonDown(nFlags, point);
}


void CCamTestDlg::ExecuteCapture(void)
{
	m_bStillCapturing=TRUE;

	if(++m_nCaptureCnt>=999)
	{
		::MessageBox(0, _T("Caution: Out of memory, please re-start camera program."), _T("Memory"), MB_TOPMOST);
		m_bStillCapturing = FALSE;

		OnOK();	
		return;
	}

	TCHAR tzOutFile[MAX_PATH] = {0x00};

	if(!CAM_CaptureEx(g_SaveType, TRUE, tzOutFile))
	{
		m_bStillCapturing = FALSE;
		
		OnOK();		
		return;
	}

	


	if(m_bUseExif)
	{
		if(!m_bHistoEqual)
			InsertExifInform(tzOutFile);			
	}

	RETAILMSG(RT_MSG, (_T("ExcuteCapture ------> %d\r\n"), m_bEnableViewer));
	if(m_bEnableViewer)
	{
		if(!UseStillShotViewer(tzOutFile))
		{
			m_bEnableViewer = FALSE;
		}
	}

	if(!m_bAutoInit)
	{
		if(CAM_PreviewStop()) 
			m_bPreviewOn = FALSE;
	}
	m_bStillCapturing = FALSE;


	MSG msg;	
	int count = 0;

	while(count++ < 500)
	{			
		if(::PeekMessage(&msg, NULL, WM_KEYDOWN, WM_SYSKEYUP, PM_REMOVE))
		{
			if(((msg.message == WM_KEYDOWN) || (msg.message == WM_SYSKEYDOWN) ||(msg.message == WM_KEYUP) || (msg.message == WM_SYSKEYUP))
				&& ((msg.wParam == VK_F13) || (msg.wParam == VK_RETURN) || (msg.wParam == VK_F23)))		
			{

				continue;
			}
			else
			{
				::PostMessage(m_hWnd, msg.message, msg.wParam, msg.lParam);
			}
		}
		else
		{
			break;
		}
	}
}

void CCamTestDlg::OnMenuFlash()
{
	
	if(m_bFlashOn == FALSE)
	{
		CAM_AlwaysFlash(TRUE);
		// CAM_CaptureFlash(TRUE);
		m_bFlashOn = TRUE;
	}
	else
	{
		CAM_AlwaysFlash(FALSE);
		// CAM_CaptureFlash(FALSE);
		m_bFlashOn = FALSE;
	}
}

void CCamTestDlg::OnUpdateMenuFlash(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(m_bFlashOn)
		pCmdUI->SetText(_T("Flash Off"));
	else
		pCmdUI->SetText(_T("Flash On"));

	pCmdUI->Enable(TRUE);
}

void CCamTestDlg::OnMenuAF()
{
	if(m_ModelType==MODEL_MM3)
		return;
	if(!m_bAutoFocusing)
	{
		CAM_AutoFocus(); 
	}
}

void CCamTestDlg::OnUpdateMenuTRIGGERAF(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(m_ModelType==MODEL_MM3)
	{
		pCmdUI->Enable(FALSE);	
	}
	else
	{
		pCmdUI->Enable(TRUE);
	}	
	UpdateData(FALSE);
}

void CCamTestDlg::OnMenuImage()
{
	if(g_bWakeUp)
	{
		::MessageBox(this->m_hWnd, _T("Please, Touch Screen Preview!!"), _T("Camera"), MB_OK);
		return;
	}

	if(m_bPreviewOn == TRUE)
	{
		if(CAM_PreviewStop()) 
			m_bPreviewOn = FALSE;
		Sleep(50);
	}

	COptionImageDlg* OptionImage=new COptionImageDlg(NULL, m_bUseExif);

	// Image Option
	OptionImage->m_AFMode = m_AFMode;
	OptionImage->m_bHistoEqual=m_bHistoEqual;
	OptionImage->m_bDateTime=m_bDateTime;


	OptionImage->m_nWBValue=(int)CAM_GetWhiteBalance();

	switch(m_ModelType)
	{
	case MODEL_MM3:
	case MODEL_SKY:
	case MODEL_BLACK:
		OptionImage->m_nBrightnessValue = CAM_GetBrightness();
		break;
	case MODEL_ORANGE_PLUS:
	case MODEL_ORANGE:
	case MODEL_SMART:
		OptionImage->m_nBrightnessValue=CAM_GetBrightness();
		OptionImage->m_nContrastValue=CAM_GetContrast();
		OptionImage->m_nSharpnessValue=CAM_GetSharpness();
		break;
	}

	CameraOpen(FALSE);

	if(OptionImage->DoModal() == IDOK)
	{	
	
		CameraOpen(TRUE);

		switch(m_ModelType)
		{
		case MODEL_MM3:
		case MODEL_SKY:
		case MODEL_BLACK:
			CAM_SetBrightness(OptionImage->m_nBrightnessValue);
			break;
		case MODEL_ORANGE_PLUS:
		case MODEL_ORANGE:
		case MODEL_SMART:
			CAM_SetBrightness(OptionImage->m_nBrightnessValue);
			CAM_SetContrast(OptionImage->m_nContrastValue);
			CAM_SetSharpness(OptionImage->m_nSharpnessValue);
			break;
		}

		m_bDateTime=OptionImage->m_bDateTime;
		RETAILMSG(RT_MSG, (_T("bDateTime : %d\n"), m_bDateTime));
// 		RETAILMSG(RT_MSG, (L"%d : %s", bRegister?1:0, tzKeyPath));

		// Image Option
		m_bUseExif=OptionImage->m_useEXIF;
		m_AFMode = OptionImage->m_AFMode;
		m_bHistoEqual=OptionImage->m_bHistoEqual;
		CAM_SetAfMode(m_AFMode);
		CAM_SetWhiteBalance((WHITE_BALANCE)OptionImage->m_nWBValue);

		CameraOpen(FALSE);
		CAM_SetInsertDateTimeEnable(m_bDateTime);
		CameraOpen(TRUE);
	}
	else
	{
		CAM_SetInsertDateTimeEnable(m_bDateTime);
		CameraOpen(TRUE);
	}

	delete OptionImage;
}

void CCamTestDlg::OnUpdateMenuImage(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}

}

void CCamTestDlg::OnMenuSave()
{
	if(g_bWakeUp)
	{
		::MessageBox(this->m_hWnd, _T("Please, Touch Screen Preview!!"), _T("Camera"), MB_OK);
		return;
	}

	else
	{
		COptionSaveDlg OptionSave;

		CameraOpen(FALSE);
		// Save option
		CAM_GetRegCapturePathEx(m_tzSaveFilePath, m_tzSaveFileName);
		wcscpy(OptionSave.m_tzSaveFilePath, m_tzSaveFilePath);
		wcscpy(OptionSave.m_tzSaveFileName, m_tzSaveFileName);

		OptionSave.m_bAutoInit = m_bAutoInit;
		OptionSave.m_bEnableViewer = m_bEnableViewer;
		OptionSave.m_bUseExif=m_bUseExif;
		OptionSave.m_bUseGps = m_bExifGps;
		OptionSave.m_SaveType = g_SaveType;		
		OptionSave.m_bDateTime=m_bDateTime;
		OptionSave.m_bHistoEqual=m_bHistoEqual;
		

		RETAILMSG(RT_MSG, (_T("bDateTime : %d\n"), OptionSave.m_bDateTime));
		if(OptionSave.DoModal() == IDOK)
		{	
			// Save option
			wcscpy(m_tzSaveFilePath, OptionSave.m_tzSaveFilePath);
			wcscpy(m_tzSaveFileName, OptionSave.m_tzSaveFileName);
			CAM_SetRegCapturePath(m_tzSaveFilePath, m_tzSaveFileName);

			m_bAutoInit = OptionSave.m_bAutoInit;
			m_bEnableViewer = OptionSave.m_bEnableViewer;
			m_bUseExif=OptionSave.m_bUseExif;
			m_bExifGps = OptionSave.m_bUseGps;
			g_SaveType = OptionSave.m_SaveType;
			m_bHistoEqual=OptionSave.m_bHistoEqual;
			m_bDateTime=OptionSave.m_bDateTime;		

			//CameraOpen(FALSE);
			CAM_SetInsertDateTimeEnable(m_bDateTime);
			CAM_UseGPSExifData(m_bExifGps);
			
		}
		g_bWakeUp=FALSE;

		CameraOpen(TRUE);	
	}
}

void CCamTestDlg::OnUpdateMenuSave(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}
}

void CCamTestDlg::OnUpdateZoom1(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(m_ModelType!=MODEL_SMART && m_ModelType!=MODEL_ORANGE && m_ModelType!=MODEL_ORANGE_PLUS && m_ModelType != MODEL_BLACK)
		return;
	if(m_nZoomCheck == 0)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);

	pCmdUI->Enable(TRUE);
}

void CCamTestDlg::OnUpdateZoom2(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(m_ModelType!=MODEL_SMART && m_ModelType!=MODEL_ORANGE && m_ModelType!=MODEL_ORANGE_PLUS && m_ModelType != MODEL_BLACK)
		return;
	if(m_ModelType==MODEL_SMART || m_ModelType==MODEL_ORANGE_PLUS)
		pCmdUI->SetText(_T("2.0x"));
	if(m_nZoomCheck == 1)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);

	pCmdUI->Enable(TRUE);
}

void CCamTestDlg::OnUpdateZoom3(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(m_ModelType!=MODEL_SMART && m_ModelType!=MODEL_ORANGE && m_ModelType!=MODEL_ORANGE_PLUS && m_ModelType != MODEL_BLACK)
		return;
	if(m_ModelType==MODEL_SMART || m_ModelType==MODEL_ORANGE_PLUS)
		pCmdUI->SetText(_T("3.0x"));
	if(m_nZoomCheck == 2)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);

	pCmdUI->Enable(TRUE);
}

void CCamTestDlg::OnUpdateZoom4(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}

	if(m_ModelType!=MODEL_SMART && m_ModelType!=MODEL_ORANGE && m_ModelType!=MODEL_ORANGE_PLUS && m_ModelType != MODEL_BLACK)
		return;
	if(m_ModelType==MODEL_SMART || m_ModelType==MODEL_ORANGE_PLUS)
		pCmdUI->SetText(_T("4.0x"));
	if(m_nZoomCheck == 3)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);

	pCmdUI->Enable(TRUE);
}

void CCamTestDlg::OnMenuZoom1()
{
	if(m_ModelType!=MODEL_SMART && m_ModelType!=MODEL_ORANGE && m_ModelType!=MODEL_ORANGE_PLUS && m_ModelType != MODEL_BLACK)
		return;
	m_nZoomCheck=0;
	CAM_Zoom(0);
}

void CCamTestDlg::OnMenuZoom2()
{
	if(m_ModelType!=MODEL_SMART && m_ModelType!=MODEL_ORANGE && m_ModelType!=MODEL_ORANGE_PLUS && m_ModelType != MODEL_BLACK)
		return;
	m_nZoomCheck=1;
	CAM_Zoom(1);
}

void CCamTestDlg::OnMenuZoom3()
{
	if(m_ModelType!=MODEL_SMART && m_ModelType!=MODEL_ORANGE && m_ModelType!=MODEL_ORANGE_PLUS && m_ModelType != MODEL_BLACK)
		return;
	m_nZoomCheck=2;
	CAM_Zoom(2);
}

void CCamTestDlg::OnMenuZoom4()
{
	if(m_ModelType!=MODEL_SMART && m_ModelType!=MODEL_ORANGE && m_ModelType!=MODEL_ORANGE_PLUS && m_ModelType != MODEL_BLACK)
		return;
	m_nZoomCheck=3;
	CAM_Zoom(3);
}


void CCamTestDlg::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu)
{
	ASSERT(pPopupMenu != NULL);

	int nResolution;
	CCmdUI state;
	state.m_pMenu = pPopupMenu;
	ASSERT(state.m_pOther == NULL);
	ASSERT(state.m_pParentMenu == NULL);

	

	//	BLACK Resolution     ִ ZOOM  ٸǷ  resolution  Ŀ 
	//	
	if(m_ModelType == MODEL_BLACK)
	{
		nResolution = CAM_GetResolution();			
	}

	// Determine if menu is popup in top-level menu and set m_pOther to
	// it if so (m_pParentMenu == NULL indicates that it is secondary popup).
	HMENU hParentMenu;
	if (AfxGetThreadState()->m_hTrackingMenu == pPopupMenu->m_hMenu)
		state.m_pParentMenu = pPopupMenu;    // Parent == child for tracking popup.
	else if ((hParentMenu = ::GetMenu(m_hWnd)) != NULL)
	{
		CWnd* pParent = this;
		// Child windows don't have menus--need to go to the top!
		if (pParent != NULL &&
			(hParentMenu = ::GetMenu(pParent->m_hWnd)) != NULL)
		{
			int nIndexMax = ::GetMenuItemCount(hParentMenu);
			for (int nIndex = 0; nIndex < nIndexMax; nIndex++)
			{
				if (::GetSubMenu(hParentMenu, nIndex) == pPopupMenu->m_hMenu)
				{
					// When popup is found, m_pParentMenu is containing menu.
					state.m_pParentMenu = CMenu::FromHandle(hParentMenu);
					break;
				}
			}
		}
	}

	state.m_nIndexMax = pPopupMenu->GetMenuItemCount();
	for (state.m_nIndex = 0; state.m_nIndex < state.m_nIndexMax;
		state.m_nIndex++)
	{
		state.m_nID = pPopupMenu->GetMenuItemID(state.m_nIndex);
		if (state.m_nID == 0)
			continue; // Menu separator or invalid cmd - ignore it.

		ASSERT(state.m_pOther == NULL);
		ASSERT(state.m_pMenu != NULL);
		if (state.m_nID == (UINT)-1)
		{
			// Possibly a popup menu, route to first item of that popup.
			state.m_pSubMenu = pPopupMenu->GetSubMenu(state.m_nIndex);
			if (state.m_pSubMenu == NULL ||
				(state.m_nID = state.m_pSubMenu->GetMenuItemID(0)) == 0 ||
				state.m_nID == (UINT)-1)
			{
				continue;       // First item of popup can't be routed to.
			}
			state.DoUpdate(this, TRUE);   // Popups are never auto disabled.
		}
		else
		{
			// Normal menu item.
			// Auto enable/disable if frame window has m_bAutoMenuEnable
			// set and command is _not_ a system command.
			state.m_pSubMenu = NULL;
			state.DoUpdate(this, FALSE);
		}

		// Adjust for menu deletions and additions.
		UINT nCount = pPopupMenu->GetMenuItemCount();
		if (nCount < state.m_nIndexMax)
		{
			state.m_nIndex -= (state.m_nIndexMax - nCount);
			while (state.m_nIndex < nCount &&
				pPopupMenu->GetMenuItemID(state.m_nIndex) == state.m_nID)
			{
				state.m_nIndex++;
			}
		}
		if(m_ModelType == MODEL_BLACK)
		{				
			switch(nResolution)
			{
			case 5:	//	2560x1920	hide 1.5, 2.0, 2.5
				if(state.m_nID == ID_ZOOM2)
					state.Enable(FALSE);	
			case 4:	//	2048x1536	hide 2.0, 2.5
				if(state.m_nID == ID_ZOOM3)
					state.Enable(FALSE);
			case 3:	//	1600x1200	hide 2.5
				if(state.m_nID == ID_ZOOM4)
					state.Enable(FALSE);
				break;
			}
		}
		state.m_nIndexMax = nCount;
	}
}

void CCamTestDlg::OnMenuCapture()
{
	if(m_bPreviewOn)
	{
		if(m_bStillCapturing == FALSE)
			SetTimer(WM_TIMER_CAPTURE, 1, NULL);
	}
}

void CCamTestDlg::OnUpdateMenuCapture(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}
}

void CCamTestDlg::OnUpdateMenuStart(CCmdUI *pCmdUI)
{
	if(!m_bCameraOpen)
	{
		pCmdUI->Enable(FALSE);
		return;
	}

}
