﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;
using CamNet;

namespace CamNetTest
{
    public partial class Form_Cam_VGA : Form
    {
        #region API
        const uint SIPF_OFF = 0x0;
        const uint SIPF_ON = 0x1;

        [System.Runtime.InteropServices.DllImport("coredll.dll")]
        private extern static void SipShowIM(uint dwFlag);
        #endregion

        Cam m_Cam;
        CameraMessage m_CamMessage = new CameraMessage();

        CameraButtonCaption m_Caption;
        int m_nCurrentEffect = 0;
        int m_nCurrentResolution = 0;
        int m_nCurrentFormat = 1;
        int m_nCurrentZoom = 0;
        int m_nCurrentSave = 0;
        int m_nEvValue = 2;
        
        bool m_bOpen = false;
        bool m_bPreviewing = false;
        bool m_bFlash = false;
        bool m_bEnableAAF = false;
        bool m_bEXIF = true;
        bool m_bGPS = false;

        String m_strSavePath = "";
        Cam.CAMERA_OPTION m_CamOption;

        MODEL_TYPE m_Model = MODEL_TYPE.MODEL_UNKNOWN;


        String m_strViewerPath = "";

        public Form_Cam_VGA()
        { 
            InitializeComponent();
        }

        private void ButtonEnable(bool bOpen, bool bClose, bool bStart, bool bEnd, bool bCapture, bool bFlash, bool bAF, bool bZoom, bool bOption)
        {
            button_Open.Enabled = bOpen;
            button_Close.Enabled = bClose;
            button_Start.Enabled = bStart;
            button_End.Enabled = bEnd;
            button_Capture.Enabled = bCapture;
            button_Flash.Enabled = bFlash;

            if (m_Model == MODEL_TYPE.MODEL_BLACK_CE || m_Model == MODEL_TYPE.MODEL_UL10 || m_Model == MODEL_TYPE.MODEL_ORANGE_CE_VGA)
                button_AF.Enabled = bAF;
            else
                button_AF.Enabled = false;

            button_Zoom.Enabled = bZoom;            
            button_Option.Enabled = bOption;
        }

        private void Form_Cam_Load(object sender, EventArgs e)
        {
            m_Cam = new Cam();
            m_CamOption = new Cam.CAMERA_OPTION();


            pictureBox_Preview.Size = new Size(475, 360);
            pictureBox_Preview.Location = new Point(0, 120);

            OptionVisible(false);
                                   
            OpenCam();

            m_Caption = new CameraButtonCaption(m_Model);
            StringBuilder strPath = new StringBuilder(260);

            m_Cam.GetCameraOption(out m_CamOption, strPath);
            m_strSavePath = strPath.ToString();
                     
            
            UpdateVersion();

            // Message Window
            m_CamMessage.AFStatusFunc += new AFStatusDelegate(ReceiveAfMsg);
            m_CamMessage.CaptureNotifyFunc += new CaptureNotifyDelegate(OnCaptureStatus);
            m_CamMessage.GPSStatusFunc += new GPSStatusDelegate(OnGpsStatus);
            
            m_strViewerPath = "Flash Disk\\Camera\\Viewer.exe";

            System.Threading.Thread.Sleep(500);
            m_Cam.PreviewStart();
            m_bPreviewing = true;
            ButtonEnable(false, true, false, true, true, true, true, true, true);

           
        }

        public void OptionVisible(bool bVisible)
        {
            button_Option_OK.Visible = bVisible;
            panel_Option.Visible = bVisible;
        }

        private void button_Open_Click(object sender, EventArgs e)
        {
            OpenCam();

            ButtonEnable(false, true, true, false, false, true, false, false, true);   
         
        }
        private void OpenCam()
        {
            m_Model = m_Cam.Open(this.Handle, pictureBox_Preview.Handle);

            if (m_Model == MODEL_TYPE.MODEL_UNKNOWN)
            {
                MessageBox.Show("Camera can not open");
                return;
            }

            m_bOpen = true;
        }

        private void CloseCam()
        {
            if (m_bPreviewing)
            {
                m_Cam.PreviewStop();
                pictureBox_Preview.Invalidate();
                m_bPreviewing = false;
            }

            if (m_bOpen)
            {
                m_Cam.Close();

                m_bOpen = false;
            }
        }

        private bool UpdateVersion()
        {
            StringBuilder strDll = new StringBuilder();
            StringBuilder strRelease = new StringBuilder();
            StringBuilder strPixels = new StringBuilder();
            String strVersions = "";

            if(m_Cam.GetVersion(strDll, strRelease, strPixels))
            {
                strVersions = "Dll: " + strDll.ToString() + "\tRelease: " + strRelease.ToString() + "\nPixels: " + strPixels.ToString();
                label_Option_Version.Text = strVersions;
                return true;
            }
            else
            {
                strVersions = "Failed getting versions";
                label_Option_Version.Text = strVersions;
                return false;
            }
        }

        private void button_Close_Click(object sender, EventArgs e)
        {
            CloseCam();

            ButtonEnable(true, false, false, false, false, false, false, false, false);

        }

        private void button_Start_Click(object sender, EventArgs e)
        {
            if(m_bPreviewing == false)
            {
                m_Cam.PreviewStart();
                m_bPreviewing = true;

                ButtonEnable(false, true, false, true, true, true, true, true, true);
                pictureBox_Preview.Invalidate();

            }
        }
        
        private void button_End_Click(object sender, EventArgs e)
        {
            if (m_bPreviewing == true)
            {
                m_Cam.PreviewStop();
                m_bPreviewing = false;

                ButtonEnable(false, true, true, false, false, true, true, false, true);
                pictureBox_Preview.Invalidate();
            }
        }

        private void button_Capture_Click(object sender, EventArgs e)
        {
            m_Cam.Capture(m_strSavePath);                        
        }

        private void button_Flash_Click(object sender, EventArgs e)
        {
            if(m_bFlash == false)
            {
                m_Cam.FlashOn();
                m_bFlash = true;

                button_Flash.Text = "Fls On";
            }
            else
            {
                m_Cam.FlashOff();
                m_bFlash = false;

                button_Flash.Text = "Fls Off";
            }
        }

        private void button_AF_Click(object sender, EventArgs e)
        {
            switch(m_Model)
            {
                case MODEL_TYPE.MODEL_ORANGE_CE_VGA:
                case MODEL_TYPE.MODEL_UL10:
                case MODEL_TYPE.MODEL_BLACK_CE:
                    m_Cam.AutoFocus();
                    break;
                default:
                    break;
            }

        }

        private void InitZoomOnBlack()
        {
            switch (m_CamOption.nResolution)
            {
                case 0:	//	1280x1024
                case 1:	//	640x480
                case 2:	//	320x240
                    ButtonEnable(false, false, false, true, true, true, true, true, true);
                    break;
                case 4:	//	1600x1200
                    if (m_nCurrentZoom > 2)
                        m_nCurrentZoom = 0;

                    ButtonEnable(false, false, false, true, true, true, true, true, true);
                    break;
                case 5:	//	2048x1536
                    if (m_nCurrentZoom > 1)
                        m_nCurrentZoom = 0;

                    ButtonEnable(false, false, false, true, true, true, true, true, true);
                    break;
                case 6:	//	2560x1920
                    m_nCurrentZoom = 0;
                    ButtonEnable(false, false, false, true, true, true, true, false, true);
                    break;
            }

            if (m_nCurrentZoom == 0)
            {
                m_Cam.Zoom(m_nCurrentZoom);

                String strCaption = m_Caption.Zoom[m_Caption.m_nZoom[m_nCurrentZoom]];
                button_Zoom.Text = strCaption;
            }
        }

        private void button_Zoom_Click(object sender, EventArgs e)
        {
            int nStepMax = 4;

            switch (m_CamOption.nResolution)
            {
                case 4: // 1600X1200
                    nStepMax = 3;
                    break;
                case 5:	//	2048x1536
                    nStepMax = 2;
                    break;
                case 6:	//	2560x1920
                    nStepMax = 1;
                    break;
            }

            String strCaption = "";

            if(++m_nCurrentZoom >= nStepMax)
            {
                m_nCurrentZoom = 0;
            }

            if (!m_Cam.Zoom(m_nCurrentZoom))
                return;

            strCaption = m_Caption.Zoom[m_Caption.m_nZoom[m_nCurrentZoom]];

            button_Zoom.Text = strCaption;
        }

        private void button_Option_Click(object sender, EventArgs e)
        {
            m_Cam.PreviewStop();
            m_bPreviewing = false;
            ButtonEnable(false, true, true, false, false, true, true, false, true);
            pictureBox_Preview.Invalidate();

            StringBuilder strPath = new StringBuilder(260);
            m_Cam.GetCameraOption(out m_CamOption, strPath);

            String strCaption;
                      
            // Effect
            if (m_Model == MODEL_TYPE.MODEL_BLACK_CE)
            {
                strCaption = "WB: " + m_Caption.Effect[m_CamOption.nImgbalance];
            }
            else
            {
                strCaption = "Effect: " + m_Caption.Effect[m_CamOption.nImgEffect];
            }
            button_Effect.Text = strCaption;

            // resolution
            int nCurrentResolution = 0;
            int nTotalRes = m_Caption.m_nResolution.Length;
            for (int i = 0; i < nTotalRes; i++)
            {
                if(m_Caption.m_nResolution[i] == m_CamOption.nResolution)
                {
                    nCurrentResolution = i;
                    break;
                }
            }
            strCaption = m_Caption.Resolution[m_Caption.m_nResolution[nCurrentResolution]];
            button_Resolution.Text = strCaption;

            // Format
            strCaption = "Format: " + m_Caption.Format[m_CamOption.nSaveFormat];
            button_Format.Text = strCaption;

            // Prefix
            strCaption = "Save: " + m_Caption.SaveType[m_CamOption.nNamePrefix];
            button_Save_Mode.Text = strCaption;

            // Save Path
            m_strSavePath = strPath.ToString();
            textBox_Save_Path.Text = m_strSavePath;

            // 
            if (m_Model == MODEL_TYPE.MODEL_BLACK_CE)
            {
                m_nCurrentEffect = m_CamOption.nImgbalance;
            }
            else
            {
                m_nCurrentEffect = m_CamOption.nImgEffect;
            }

            m_nCurrentResolution = nCurrentResolution;
            m_nCurrentFormat = m_CamOption.nSaveFormat;
            m_nCurrentSave = m_CamOption.nNamePrefix;
            m_nEvValue = m_Cam.GetBrightness();

            trackBar_Exposure.Value = m_nEvValue;

            if(m_nCurrentSave == 0)
            {
                textBox_Save_Path.Enabled = false;
            }



            OptionVisible(true);
        }

        private void button_Effect_Click(object sender, EventArgs e)
        {
            String strCaption;
            if (m_Caption.Effect[m_Caption.m_nEffect[m_nCurrentEffect++]] == "Incandescent")
            {
                m_nCurrentEffect = 0;
                strCaption = "WB: " + m_Caption.Effect[m_Caption.m_nEffect[m_nCurrentEffect]];
            }
            else
            {
                strCaption = "Effect: " + m_Caption.Effect[m_Caption.m_nEffect[m_nCurrentEffect]];
            }

            button_Effect.Text = strCaption;
        }

        private void button_Resolution_Click(object sender, EventArgs e)
        {
            String strCaption = "";

            if (m_Caption.Resolution[m_Caption.m_nResolution[m_nCurrentResolution++]] == "2560X1920")
            {
                m_nCurrentResolution = 0;
                strCaption = m_Caption.Resolution[m_Caption.m_nResolution[m_nCurrentResolution]];
            }
            else
            {
                strCaption = m_Caption.Resolution[m_Caption.m_nResolution[m_nCurrentResolution]];
            }
            
            button_Resolution.Text = strCaption;
        }

        private void button_Format_Click(object sender, EventArgs e)
        {
            String strCaption;

            if (m_nCurrentFormat == Cam.OPTION_IMAGE_FILENAME_PREF_DATE)
            {
                m_nCurrentFormat = Cam.OPTION_IMAGE_FILENAME_PREF_SERIAL;
            }
            else
            {
                m_nCurrentFormat = Cam.OPTION_IMAGE_FILENAME_PREF_DATE;
            }

            strCaption = "Format: " + m_Caption.Format[m_nCurrentFormat];
            button_Format.Text = strCaption;
        }

        private void button_Save_Mode_Click(object sender, EventArgs e)
        {
            String strCaption;
            if(m_nCurrentSave == Cam.OPTION_SAVE_FORMAT_BMP)
            {
                m_nCurrentSave = Cam.OPTION_SAVE_FORMAT_JPG;
                textBox_Save_Path.Enabled = true;
            }
            else
            {
                m_nCurrentSave = Cam.OPTION_SAVE_FORMAT_BMP;
                textBox_Save_Path.Enabled = false;
            }
            strCaption = "Save: " + m_Caption.SaveType[m_nCurrentSave];
            button_Save_Mode.Text = strCaption;            
        }

        private void button_Option_OK_Click(object sender, EventArgs e)
        {
            m_nEvValue = trackBar_Exposure.Value;

            if (m_Model == MODEL_TYPE.MODEL_BLACK_CE)
            {
                m_CamOption.nImgbalance = m_Caption.m_nEffect[m_nCurrentEffect];

            }
            else
            {
                m_CamOption.nImgEffect = m_Caption.m_nEffect[m_nCurrentEffect];
            }


            m_CamOption.nResolution = m_Caption.m_nResolution[m_nCurrentResolution];
            m_CamOption.nSaveFormat = m_nCurrentFormat;
            m_CamOption.nNamePrefix = m_nCurrentSave;    

            m_strSavePath = textBox_Save_Path.Text;

            m_Cam.SetCameraOption(ref m_CamOption, m_strSavePath);

            m_Cam.Brightness(m_nEvValue);
            
            OptionVisible(false);
            
            m_Cam.PreviewStart();
            m_bPreviewing = true;
            pictureBox_Preview.Invalidate();

            ButtonEnable(false, true, false, true, true, true, true, true, true);
        }

        private void textBox_Save_Path_GotFocus(object sender, EventArgs e)
        {
            SipShowIM(SIPF_ON);
        }

        private void Form_Cam_Closed(object sender, EventArgs e)
        {
            CloseCam();
            this.Close();
        }

        private void button_Cam_Close_Click(object sender, EventArgs e)
        {
            CloseCam();


            this.Close();
        }

        private void button_EXIF_Click(object sender, EventArgs e)
        {
            if(m_bEXIF)
            {
                m_bEXIF = false;
                button_EXIF.Text = "EXIF: Off";
                m_bGPS = false;
                button_GPS.Text = "GPS: Off";
                button_GPS.Enabled=false;
            }

            else
            {
                m_bEXIF = true;
                button_EXIF.Text = "EXIF: On";
                button_GPS.Enabled = true;
            }
        }

        private void button_GPS_Click(object sender, EventArgs e)
        {
            if(m_bGPS)
            {
                m_bGPS = false;
                button_GPS.Text = "GPS: Off";
            }
            else
            {
                m_bGPS = true;
                button_GPS.Text = "GPS: On";
            }
        }


        public void ReceiveAfMsg(AF_STATUS nStatus)
        {
            switch (nStatus)
            {
                case AF_STATUS.AF_STATUS_IDLE:
                    break;
                case AF_STATUS.AF_STATUS_START:
                    break;
                case AF_STATUS.AF_STATUS_FINISH:
                    break;
            }
        }

        private void OnGpsStatus(bool bOn)
        {
            if (bOn)
            {
                // On
            }
        }

        private void OnCaptureStatus(CAP_STATUS status)
        {
            switch(status)
            {
                case CAP_STATUS.CAP_STATUS_START:
                    break;
                case CAP_STATUS.CAP_STATUS_IMG_TRANSFORM:
                    break;
                case CAP_STATUS.CAP_STATUS_IMG_SCALE_UP:
                    break;
                case CAP_STATUS.CAP_STATUS_IMG_SAVE:
                    break;
                case CAP_STATUS.CAP_STATUS_END:
                    {
                        String strCapturePath;
                        m_Cam.GetLastSaveFilePath(out strCapturePath);

                        if (m_bEXIF)
                        {
                            if (m_nCurrentFormat == Cam.OPTION_SAVE_FORMAT_JPG)
                            {
                                int cnt = 0;
                                for (int i = 0; i < strCapturePath.Length; i++)
                                {
                                    if (strCapturePath[i] == '\0')
                                    {
                                        cnt = i;
                                        break;
                                    }
                                }

                                strCapturePath = strCapturePath.Substring(0, cnt);

                                Cam.ExifInfo info = new Cam.ExifInfo();

                                char delimiter = '\\';
                                string FilePath = strCapturePath.ToString();
                                string[] tmp = strCapturePath.ToString().Split(delimiter);
                                info.TitleName = tmp[tmp.Length - 1];

                                info.Make = "M3 Mobile Co.Ltd";


                                switch (m_Model)
                                {
                                    case MODEL_TYPE.MODEL_BLACK_CE:
                                        info.Model = "M3 BLACK";
                                        break;
                                    case MODEL_TYPE.MODEL_UL10:
                                        info.Model = "UL10";
                                        break;
                                    default:
                                        info.Model = "M3";
                                        break;
                                }
                                m_Cam.InsertExifInformation(FilePath, info);
                            }

                        }

                        Process.Start(m_strViewerPath, strCapturePath);


                    }
                    break;
                case CAP_STATUS.CAP_STATUS_ALL_PROCESS_END:
                    break;
            }
        }


    }
}