﻿using System;
using System.Collections.Generic;
using System.Text;
using CamNet;

using System.Windows.Forms;
namespace CamNetTest
{
    class CameraButtonCaption
    {
        public String[] Effect = { 
            "Normal", "Sepia", "B&W", "Negative", "UV Red", "UV Blue", "UV Green", "Aqua" };
        public String[] Resolution = {
            "1280X1024","640X480","320X240","Empty","1600X1200","2048X1536", "2560X1920"};
        public String[] Format = {
            "BMP" ,"JPG"
        };
        public String[] SaveType = {
            "Date", "Custom"
        };
        public String[] Zoom = { 
            "1 X", "1.5 X", "2 X", "2.5 X", "3 X", "3.5 X", "4 X", "4.5 X"
        };

        public int[] m_nZoom;
        public int[] m_nEffect;
        public int[] m_nResolution;

        public CameraButtonCaption(MODEL_TYPE model)
        {
		    switch (model)
		    {
		    case MODEL_TYPE.MODEL_T:
                m_nZoom = new int[] { 0, 1, 2, 3 };
				m_nEffect = new int[] {0, 1, 2, 3, 4, 5, 6};
				m_nResolution = new int[] {2, 1, 0, 4, 5};
                break;
            case MODEL_TYPE.MODEL_UL10:
            case MODEL_TYPE.MODEL_UL10_QVGA:
            case MODEL_TYPE.MODEL_SMART:
            case MODEL_TYPE.MODEL_ORANGE_CE:
            case MODEL_TYPE.MODEL_ORANGE_CE_VGA:
                m_nZoom = new int[] { 0, 2, 4, 6 };
                m_nEffect = new int[] { 0, 1, 2, 3, 4};
                m_nResolution = new int[] { 2, 1, 0, 4, 5 };
                Effect[4] = "Aqua";
                break;
            case MODEL_TYPE.MODEL_GREEN:
                m_nZoom = new int[] { 0, 1, 2, 3 };
                m_nEffect = new int[] { 0, 1, 2, 3, 4, 5, 6 };
                m_nResolution = new int[] { 2, 1, 0, 4, 5 };
                break;
            case MODEL_TYPE.MODEL_GREEN_13M:
                m_nZoom = new int[] { 0 };
                m_nEffect = new int[] { 0, 1, 2, 3, 4, 5, 6 };
                m_nResolution = new int[] { 2, 1, 0 };
                break;
            case MODEL_TYPE.MODEL_POS:
                m_nZoom = new int[] { 0, 1, 2, 3 };
                m_nEffect = new int[] { 0, 1, 2, 3, 4, 5, 6 };
                m_nResolution = new int[] { 2, 1, 0, 4, 5 };
                break;
            case MODEL_TYPE.MODEL_BLACK_CE:
            case MODEL_TYPE.MODEL_BLACK_QVGA:
                m_nZoom = new int[] { 0, 1, 2, 3 };
                m_nEffect = new int[] { 0, 1, 2, 3, 4, 5, 6 };
                m_nResolution = new int[] { 2, 1, 0, 4, 5, 6 };

                Effect[0] = "Auto";
                Effect[1] = "Sunny";
                Effect[2] = "Cloudy";
                Effect[3] = "Fluorescent";
                Effect[4] = "Incandescent";

                Resolution[6] = "2560X1920";
                break;
		    default:
                break;
		    }

        }
    }
}