#define CAM_EXPORTS __declspec(dllexport)

//Image Effect
#define OPTION_IMAGE_NOMAL_EFFECT			0
#define OPTION_IMAGE_SEPIA_EFFECT			1
#define OPTION_IMAGE_BLACKWHITE_EFFECT		2
#define OPTION_IMAGE_NEGATIVE_EFFECT		3
#define	OPTION_IMAGE_UVRED_EFFECT			4
#define OPTION_IMAGE_UVBLUE_EFFECT			5
#define OPTION_IMAGE_UVGREEN_EFFECT			6
#define	OPTION_IMAGE_SMART_AQUA_EFFECT		4

//Resolution 
#define OPTION_RESOLUTION_2560X1920		6
#define OPTION_RESOLUTION_2048X1536		5
#define OPTION_RESOLUTION_1600X1200		4
#define OPTION_RESOLUTION_1280X1024		0
#define OPTION_RESOLUTION_640X480		1
#define OPTION_RESOLUTION_320X240		2

//Save Format
#define OPTION_SAVE_FORMAT_BMP			0
#define OPTION_SAVE_FORMAT_JPG			1

//Image File Name Prefix
#define OPTION_IMAGE_FILENAME_PREF_DATE		0
#define OPTION_IMAGE_FILENAME_PREF_SERIAL	1

// AF Status Messege
#define WM_STATUS_AF		(WM_USER + 0x1002)

// GPS Status Messasge
#define WM_GPS_ON			(WM_USER + 0x1003)

// Convert 2D Imager
#define WM_CONVERT			(WM_USER + 232)

// Capture Status Message
#define WM_SHOW_CAP_STATUS	(WM_USER + 5)

enum AF_STATUS
{
	AF_STATUS_IDLE = -1,
	AF_STATUS_START = 1,
	AF_STATUS_FINISH = 0
};


enum MODEL_TYPE
{
	MODEL_GREEN_13M,
	MODEL_GREEN,
	MODEL_T,
	MODEL_POS,
	MODEL_SMART,
	MODEL_ORANGE_CE,
	MODEL_UL10,
	MODEL_BLACK,
	MODEL_UL10_QVGA,
	MODEL_BLACK_QVGA,
	MODEL_ORANGE_CE_VGA,
	MODEL_UNKNOWN
};

enum SCANNER_TYPE{
	SCANNER_OPTICON,
	SCANNER_SYMBOL,
	SCANNER_INTERMEC,
	SCANNER_HHP,
	SCANNER_ERR = -1
} ;

enum CAP_STATUS
{
	CAP_STATUS_START = 0x1,
	CAP_STATUS_IMG_TRANSFORM = 0x2,
	CAP_STATUS_IMG_SCALE_UP = 0x4,
	CAP_STATUS_IMG_SAVE = 0x8,
	CAP_STATUS_END = 0x10,
	CAP_STATUS_ALL_PROCESS_END = 0x16,
	CAP_STATUS_COPY_DATA = 0x20,
	CAP_STATUS_TIME_OUT = 0xFF
};

typedef struct
{
	int		nResolution;		// Resolution
	int		nSaveFormat;		// SaveFormat
	int		nJpegQuality;		// Jpeg Quality
	int		nNamePrefix;		// Image File Name Prefix
	int		nImgEffect;			// Image Effect
	int		nImgbalance;		// Image Balance
	int		nImgRotatesave;		// Image Rotate
	int		nImgRotateview;		// Image Rotate
} CAMERA_OPTION, *LPCAMERA_OPTION;

typedef struct _ExifInfo
{
	TCHAR TitleName[21];
	TCHAR Make[21];
	TCHAR Model[21];
}ExifInfo;

EXTERN_C CAM_EXPORTS MODEL_TYPE CAM_GetDeviceInfo();
EXTERN_C CAM_EXPORTS MODEL_TYPE CAM_Open(HWND hMainWnd, HWND hPreviewWnd);
EXTERN_C CAM_EXPORTS BOOL CAM_Close();

EXTERN_C CAM_EXPORTS BOOL CAM_Capture(LPCTSTR strFilePath);
EXTERN_C CAM_EXPORTS BOOL CAM_PreviewStart();
EXTERN_C CAM_EXPORTS BOOL CAM_PreviewStop();
EXTERN_C CAM_EXPORTS BOOL CAM_FlashOn();
EXTERN_C CAM_EXPORTS BOOL CAM_FlashOff();
EXTERN_C CAM_EXPORTS BOOL CAM_Zoom(int nZoom);
EXTERN_C CAM_EXPORTS BOOL CAM_Brightness(int nBrightness);
EXTERN_C CAM_EXPORTS int  CAM_GetBrightness();

EXTERN_C CAM_EXPORTS BOOL CAM_SetCameraOption(LPCAMERA_OPTION option, LPTSTR strSaveFolder);
EXTERN_C CAM_EXPORTS BOOL CAM_GetCameraOption(LPCAMERA_OPTION option, LPTSTR strSaveFolder);;

EXTERN_C CAM_EXPORTS BOOL CAM_GetLastSaveFilePath(LPTSTR strOutFilePath);

EXTERN_C CAM_EXPORTS DWORD CAM_GetBufferSize();
EXTERN_C CAM_EXPORTS void CAM_RawData(byte* data);

EXTERN_C CAM_EXPORTS BOOL CAM_AutoFocus();
EXTERN_C CAM_EXPORTS BOOL CAM_EnableAutoAF(BOOL bEnable);

EXTERN_C CAM_EXPORTS BOOL CAM_EnableShutterSound(BOOL bEnable);
EXTERN_C CAM_EXPORTS BOOL CAM_GetVersion(TCHAR* tzDllVersion, TCHAR* tzReleaseDate, TCHAR* tzPixels);

EXTERN_C CAM_EXPORTS BOOL CAM_InsertExifInformation(TCHAR* FileName, ExifInfo info);
EXTERN_C CAM_EXPORTS BOOL CAM_UseGPSExifData(BOOL bUse);

EXTERN_C CAM_EXPORTS void CAM_RegisterMsgWnd(HWND hWnd);
EXTERN_C CAM_EXPORTS SCANNER_TYPE CAM_GetScannerType();