// Camera_UL10_VGA.cpp : implementation file
//

#include "stdafx.h"
#include "CamTest.h"
#include "Camera_UL10_VGA.h"
#include "Sipapi.h"
#include <pkfuncs.h>

#define WM_TIMER_STATUS_GPS		(WM_USER + 1000)
#define WM_SHOW_CAP_STATUS			(WM_USER + 5)
// CCamera_UL10_VGA dialog

IMPLEMENT_DYNAMIC(CCamera_UL10_VGA, CDialog)

CCamera_UL10_VGA::CCamera_UL10_VGA(CWnd* pParent /*=NULL*/)
	: CDialog(CCamera_UL10_VGA::IDD, pParent)
{
	m_nCurrentEffect = 0;
	m_nCurrentResolution = 0;
	m_nCurrentFormat = 0;
	m_nCurrentZoom = 0;
	m_nCurrentSave = 0;

	m_nEvValue = 2;

	m_bOpen = FALSE;
	m_bPreviewing = FALSE;

	m_bEnableAutoAF = FALSE;
	m_bCapturing = FALSE;
	m_bCaptureKeyPressed = FALSE;


	m_bRunScanEmul = FALSE;
	m_dwRightDowndBackupKey = 0;


	memset(m_tzCaptionEffect, 0x00, sizeof(m_tzCaptionEffect));
	memset(m_tzCaptionResolution, 0x00, sizeof(m_tzCaptionResolution));
	memset(m_tzCaptionSave, 0x00, sizeof(m_tzCaptionSave));
	memset(m_tzCaptionFormat, 0x00, sizeof(m_tzCaptionFormat));
	memset(m_tzCaptionZoom, 0x00, sizeof(m_tzCaptionZoom));

	wsprintf(m_tzCaptionEffect[0], L"Auto");
	wsprintf(m_tzCaptionEffect[1], L"Sunny");
	wsprintf(m_tzCaptionEffect[2], L"Cloudy");
	wsprintf(m_tzCaptionEffect[3], L"Fluorescent");
	wsprintf(m_tzCaptionEffect[4], L"Incandescent");
	memset(m_nEffectStep, 0x00, sizeof(m_nEffectStep));

	wsprintf(m_tzCaptionResolution[0], L"1280X1024");
	wsprintf(m_tzCaptionResolution[1], L"640X480");
	wsprintf(m_tzCaptionResolution[2], L"320X240");
	wsprintf(m_tzCaptionResolution[3], L"Empty");
	wsprintf(m_tzCaptionResolution[4], L"1600X1200");
	wsprintf(m_tzCaptionResolution[5], L"2048X1536");
	memset(m_nResolutionStep, 0x00, sizeof(m_nResolutionStep));

	wsprintf(m_tzCaptionFormat[0], L"BMP");
	wsprintf(m_tzCaptionFormat[1], L"JPG");
	
	wsprintf(m_tzCaptionSave[0], L"Date");
	wsprintf(m_tzCaptionSave[1], L"Custom");

	wsprintf(m_tzCaptionZoom[0], L"1 X ZOOM");
	wsprintf(m_tzCaptionZoom[1], L"1.5 X ZOOM");
	wsprintf(m_tzCaptionZoom[2], L"2 X ZOOM");
	wsprintf(m_tzCaptionZoom[3], L"2.5 X ZOOM");
	wsprintf(m_tzCaptionZoom[4], L"3 X ZOOM");
	wsprintf(m_tzCaptionZoom[5], L"3.5 X ZOOM");
	wsprintf(m_tzCaptionZoom[6], L"4 X ZOOM");
	wsprintf(m_tzCaptionZoom[7], L"4.5 X ZOOM");
	memset(m_nZoomStep, 0x00, sizeof(m_nZoomStep));

	memset(m_tzSavePath, 0x00, sizeof(TCHAR) * 256);
	memset(&m_CamOption, 0x00, sizeof(CAMERA_OPTION));

	m_ScannerType = SCANNER_ERR;

}

CCamera_UL10_VGA::~CCamera_UL10_VGA()
{
}

void CCamera_UL10_VGA::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_PREVIEW, m_ctrPreview);
	DDX_Control(pDX, IDC_SLIDER_EV, m_SliderEV);
}


BEGIN_MESSAGE_MAP(CCamera_UL10_VGA, CDialog)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_CAPTURE, &CCamera_UL10_VGA::OnBnClickedButtonCapture)
	ON_BN_CLICKED(IDC_BUTTON_OPEN, &CCamera_UL10_VGA::OnBnClickedButtonOpen)
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &CCamera_UL10_VGA::OnBnClickedButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_START, &CCamera_UL10_VGA::OnBnClickedButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_END, &CCamera_UL10_VGA::OnBnClickedButtonEnd)
	ON_BN_CLICKED(IDOK, &CCamera_UL10_VGA::OnBnClickedButtonCapture)
	ON_BN_CLICKED(IDC_BUTTON_FLASH, &CCamera_UL10_VGA::OnBnClickedButtonFlash)
	ON_BN_CLICKED(IDC_BUTTON_AF, &CCamera_UL10_VGA::OnBnClickedButtonAf)
	ON_BN_CLICKED(IDC_BUTTON_EXIT, &CCamera_UL10_VGA::OnBnClickedButtonExit)
	ON_BN_CLICKED(IDC_BUTTON_OPTION, &CCamera_UL10_VGA::OnBnClickedButtonOption)
	ON_BN_CLICKED(IDC_BUTTON_OPTION_EXIT, &CCamera_UL10_VGA::OnBnClickedButtonOptionExit)
	ON_BN_CLICKED(IDC_BUTTON_OPTION_CANCEL, &CCamera_UL10_VGA::OnBnClickedButtonOptionCancel)
	ON_BN_CLICKED(IDC_BUTTON_ZOOM, &CCamera_UL10_VGA::OnBnClickedButtonZoom)
	ON_BN_CLICKED(IDC_BUTTON_EFFECT, &CCamera_UL10_VGA::OnBnClickedButtonEffect)
	ON_BN_CLICKED(IDC_BUTTON_RESOLUTION, &CCamera_UL10_VGA::OnBnClickedButtonResolution)
	ON_BN_CLICKED(IDC_BUTTON_FORMAT, &CCamera_UL10_VGA::OnBnClickedButtonFormat)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_NAME, &CCamera_UL10_VGA::OnBnClickedButtonSaveName)
	ON_BN_CLICKED(IDC_BUTTON_AAF, &CCamera_UL10_VGA::OnBnClickedButtonAaf)
	ON_EN_SETFOCUS(IDC_EDIT_PATH, &CCamera_UL10_VGA::OnEnSetfocusEditPath)
	ON_MESSAGE(WM_STATUS_AF, OnAFStatus)
	ON_MESSAGE(WM_GPS_ON, OnGPSStatus)
	ON_MESSAGE(WM_SHOW_CAP_STATUS, OnShowCaptureStatus)
	ON_BN_CLICKED(IDC_BUTTON_EXIF, &CCamera_UL10_VGA::OnBnClickedButtonExif)
	ON_BN_CLICKED(IDC_BUTTON_GPS, &CCamera_UL10_VGA::OnBnClickedButtonGps)
END_MESSAGE_MAP()

/*
// CVUL10_CamTestDlg message handlers

void CVUL10_CamTestDlg::OnBnClickedButtonCapture()
{
	// TODO: Add your control notification handler code here


}

BOOL CVUL10_CamTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CVUL10_CamTestDlg::PreTranslateMessage(MSG* pMsg)
{
	// TODO: Add your specialized code here and/or call the base class

	return CDialog::PreTranslateMessage(pMsg);
}

void CVUL10_CamTestDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: Add your message handler code here
}

void CVUL10_CamTestDlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default

	CDialog::OnTimer(nIDEvent);
}
*/


void CCamera_UL10_VGA::SaveLoadCameraSetting(BOOL bSave)
{
	if(bSave)
	{
		HKEY hKey;
		int nRet;
		DWORD dwDisp;

		nRet = RegCreateKeyEx(HKEY_CURRENT_USER, L"Software\\M3Mobile\\Camera", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hKey, &dwDisp);
		if(nRet != ERROR_SUCCESS)
		{
			// error
		}

		nRet = RegSetValueEx(hKey, L"ExifEnable", 0, REG_DWORD, (LPBYTE)&m_onEXIF, sizeof(DWORD));
		if(nRet != ERROR_SUCCESS)
		{
			// error
		}
		nRet = RegSetValueEx(hKey, L"ExifGps", 0, REG_DWORD, (LPBYTE)&m_onGPS, sizeof(DWORD));
		if(nRet != ERROR_SUCCESS)
		{
			// error
		}
		nRet = RegSetValueEx(hKey, L"EnableAF", 0, REG_DWORD, (LPBYTE)&m_bEnableAutoAF, sizeof(DWORD));
		if(nRet != ERROR_SUCCESS)
		{
			// error
		}
		RegCloseKey(hKey);		
	}
	else
	{
		HKEY key;
		DWORD dwDisp;
		DWORD Size;
		if(RegCreateKeyEx(HKEY_CURRENT_USER, L"Software\\M3Mobile\\Camera", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_READ, NULL, &key, &dwDisp) != ERROR_SUCCESS)
		{
			// error
		}

		Size = sizeof(LONG);
		if(RegQueryValueEx(key, L"ExifEnable", 0, NULL, (LPBYTE)&m_onEXIF, &Size) != ERROR_SUCCESS)
		{
			m_onEXIF = TRUE;
		}
		Size = sizeof(LONG);
		if(RegQueryValueEx(key, L"ExifGps", 0, NULL, (LPBYTE)&m_onGPS, &Size) != ERROR_SUCCESS)
		{
			m_onGPS = FALSE;
		}
		Size = sizeof(LONG);
		if(RegQueryValueEx(key, L"EnableAF", 0, NULL, (LPBYTE)&m_bEnableAutoAF, &Size) != ERROR_SUCCESS)
		{
			m_onGPS = FALSE;
		}
			
		RegCloseKey(key);
	}
}

#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
void CCamera_UL10_VGA::OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/)
{
	if (AfxIsDRAEnabled())
	{
		DRA::RelayoutDialog(
			AfxGetResourceHandle(), 
			this->m_hWnd, 
			DRA::GetDisplayMode() != DRA::Portrait ? 
			MAKEINTRESOURCE(IDD_CAMTEST_DIALOG_WIDE) : 
			MAKEINTRESOURCE(IDD_CAMTEST_DIALOG));
	}
}
#endif


BOOL CCamera_UL10_VGA::MemoryCheck()
{
	CString str;	
	CString strDirectoryName;
	//	INT		nIdx;
	float TotalBytes, fTotal, FreeBytes, fAvail, fUsed;

	ULARGE_INTEGER uliUserFree, uliTotal, uliRealFree;

	if(wcsstr(m_tzSavePath, L"Flash Disk") != NULL )
	{
		strDirectoryName="Flash Disk\\";                                  // ˰ϴ ũ̸
	}
	else 
	{
		//	SD ī带 ־ 츦 ߰  [2009/1/30 11:55:24 JU]
		//	 SD  ðų ̹ 510p  
		if(wcsstr(m_tzSavePath, L"Flash Disk") != NULL)	
		{
			strDirectoryName = "Storage Card\\";
		}
		else
		{
			strDirectoryName="\\";                                  // ˰ϴ ũ̸
		}
	}


	if(GetDiskFreeSpaceEx(strDirectoryName, &uliUserFree, &uliTotal, &uliRealFree))
	{
		TotalBytes =uliTotal.LowPart+(double)uliTotal.HighPart*(double)4294967296;
		fTotal = (float)(TotalBytes/1024/1024); // Convert (GB)     
		FreeBytes = uliRealFree.LowPart+(double)uliRealFree.HighPart*(double)4294967296;
		fAvail = (float)(FreeBytes/1024/1024); // Convert (GB)
		fUsed = fTotal - fAvail;
		str.Format(L"D:\\ Total %.1fMB, Free %fMB, Used %fMB", fTotal, fAvail, fUsed);


		if(fAvail<10)
		{
			// ::MessageBox(this->m_hWnd,L"Not enough memory for save picture.",L"Notice",0);
			return FALSE;
		}

	}

	return TRUE;
}

LRESULT CCamera_UL10_VGA::OnShowCaptureStatus(WPARAM wParam, LPARAM lParam)
{
	RETAILMSG(RT_MSG, (TEXT("  wParam:x%x, lParam:x%x\r\n"), wParam, lParam));

	switch (wParam) {
		case CAP_STATUS_START:
			EnableButton(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE);
			break;
		case CAP_STATUS_IMG_TRANSFORM:
			RETAILMSG(RT_MSG, (TEXT("OnShowCaptureStatus CAP_STATUS_IMG_TRANSFORM\r\n")));

		case CAP_STATUS_IMG_SCALE_UP:
			RETAILMSG(RT_MSG, (TEXT("OnShowCaptureStatus CAP_STATUS_IMG_SCALE_UP\r\n")));
			break;
		case CAP_STATUS_IMG_SAVE:
			RETAILMSG(RT_MSG, (TEXT("OnShowCaptureStatus CAP_STATUS_IMG_SAVE\r\n")));
			break;
		case CAP_STATUS_END:
			{
				m_bCapturing	= FALSE;



				TCHAR tzFileName[MAX_PATH];
				memset(tzFileName, 0x00, sizeof(TCHAR) * MAX_PATH);
				CAM_GetLastSaveFilePath(tzFileName);
				RETAILMSG(RT_MSG, (TEXT("OnShowCaptureStatus CAP_STATUS_END Result - [%s]\r\n"), tzFileName));

				if(_tcsstr(tzFileName, _T(".jpg"))!=NULL)
					if(m_onEXIF)
						InsertExifInform();		

				// Get FileName
				TCHAR	szThisProgram[MAX_PATH] = {0, }; // Camera Program
				CString szViewr;

				GetModuleFileName(NULL, szThisProgram, sizeof(TCHAR)*MAX_PATH);
				szViewr.Format(_T("%s"), szThisProgram);
				int nIndex = szViewr.ReverseFind('\\');
				szViewr.Format(_T("%s\\Viewer.exe"), szViewr.Left(nIndex));
				wsprintf(szThisProgram, L"%s", szViewr);

				// RETAILMSG(RT_MSG, (L"CCamera_Black_Dlg::OnShowCaptureStatus - CAP_STATUS_END1\r\n"));
				// ̸  ö  Viewer  ʴ´. [9/9/2013 JJ]
				if(wcslen(tzFileName) > 1)
				{
					CreateProcessW(szThisProgram, tzFileName, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				}

				// RETAILMSG(RT_MSG, (L"CCamera_Black_Dlg::OnShowCaptureStatus - CAP_STATUS_END2\r\n"));
				// ::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), TRUE);
				// RETAILMSG(RT_MSG, (L"CCamera_Black_Dlg::OnShowCaptureStatus - CAP_STATUS_END3\r\n"));

				EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);
			}

			break;
		default:
			m_bCapturing	= FALSE;
			EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);			
			break;
	}

	RETAILMSG(RT_MSG, (L"CCamera_Black_Dlg::OnShowCaptureStatus - Exit\r\n"));

	return 0L;
}


LRESULT CCamera_UL10_VGA::OnGPSStatus(WPARAM wParam, LPARAM lParam)
{
	if(wParam == TRUE)
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AFING), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_OUT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_ON), SW_SHOW);

		SetTimer(WM_TIMER_STATUS_GPS, 5000, NULL);

	}
	else
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AFING), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_OUT), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_ON), SW_HIDE);


		SetTimer(WM_TIMER_STATUS_GPS, 5000, NULL);
	}

	return 0;
}

LRESULT CCamera_UL10_VGA::OnAFStatus(WPARAM wParam, LPARAM lParam)
{
	if(wParam == AF_STATUS_START)
	{
		RETAILMSG(RT_MSG, (L"CCamera_Black_Dlg::OnAFStatus AF_STATUS_START\r\n"));
		m_bCapturing = TRUE;
	}
	else if(wParam == AF_STATUS_FINISH)
	{
		RETAILMSG(RT_MSG, (L"CCamera_Black_Dlg::OnAFStatus AF_STATUS_FINISH\r\n"));
		m_bCapturing = FALSE;
	}
	else
	{
		m_bCapturing = FALSE;
	}

	return 0;
}
void CCamera_UL10_VGA::InitControlValue(MODEL_TYPE model, BOOL bInit)
{
	if(bInit)
	{

		memset(m_tzCaptionEffect, 0x00, sizeof(m_tzCaptionEffect));

		wsprintf(m_tzCaptionEffect[0], L"Auto");
		wsprintf(m_tzCaptionEffect[1], L"Sunny");
		wsprintf(m_tzCaptionEffect[2], L"Cloudy");
		wsprintf(m_tzCaptionEffect[3], L"Fluorescent");
		wsprintf(m_tzCaptionEffect[4], L"Incandescent");

//		wsprintf(m_tzCaptionResolution[6], L"2560X1920");

		int nZoom[4] = {0, 1, 2, 3};
		int nEffect[7] = {0, 1, 2, 3, 4, 5, 6};
		int nResolution[6] = {2, 1, 0, 4, 5, 6};
		memcpy(m_nZoomStep, nZoom , sizeof(nZoom));
		memcpy(m_nEffectStep, nEffect, sizeof(nEffect));
		memcpy(m_nResolutionStep, nResolution, sizeof(nResolution));


		m_ctrPreview.MoveWindow(0, 120, 475, 360);
//		m_ctrPreview.MoveWindow(0, 0, 480, 640);
	}
	else
	{
		memset(m_nZoomStep, 0 , sizeof(m_nZoomStep));
		memset(m_nEffectStep, 0, sizeof(m_nEffectStep));
		memset(m_nResolutionStep, 0, sizeof(m_nResolutionStep));

	}
}

void CCamera_UL10_VGA::OnBnClickedButtonOpen()
{

	m_Model = CAM_Open(m_hWnd, m_ctrPreview.m_hWnd) ;

	if(m_Model == MODEL_UNKNOWN)
	{
		::MessageBox(m_hWnd, L"Open error", L"Open", NULL);
		return;
	}

	m_bOpen = TRUE;

	EnableButton(FALSE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE);

	InitControlValue(m_Model, TRUE);
	
	UpdateVersion();

	CAM_GetCameraOption(&m_CamOption, m_tzSavePath);
	CAM_GetBrightness();
}

BOOL CCamera_UL10_VGA::UpdateVersion()
{
	TCHAR tzDll[MAX_PATH], tzRelease[MAX_PATH], tzPixels[MAX_PATH], tzVersions[MAX_PATH];

	memset(tzDll, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzRelease, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzPixels, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzVersions, 0x00, sizeof(TCHAR) * MAX_PATH);
	
	if(CAM_GetVersion(tzDll, tzRelease, tzPixels))
	{
		wsprintf(tzVersions, L"DLL:%s(%s)\r\nAPP:%s(%s)\r\nPixels: %s", tzDll, tzRelease, APP_VER, APP_RELEASE, tzPixels);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_VERSION), tzVersions);
	}
	else
	{
		wsprintf(tzVersions, L"Failed getting versions");
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_VERSION), tzVersions);

		return FALSE;
	}
         
	return TRUE;
}

void CCamera_UL10_VGA::OnBnClickedButtonClose()
{
	if(m_bPreviewing)
	{
		CAM_PreviewStop();
		m_ctrPreview.Invalidate();
		m_bPreviewing = FALSE;
	}

	if(!CAM_Close())
	{
		::MessageBox(m_hWnd, L"Close error", L"Open", NULL);
	}
	else
	{
		m_bOpen = FALSE;


		InitControlValue(m_Model, FALSE);

		EnableButton(TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE);
	}

}

void CCamera_UL10_VGA::OnBnClickedButtonStart()
{
	if(m_bPreviewing == FALSE)
	{
		m_ctrPreview.MoveWindow(0, 120, 475, 360);
		CAM_PreviewStart();

		m_bPreviewing = TRUE;

		EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);

		InitZoomOnBlack();
		
		::SetFocus(::GetDlgItem(m_hWnd, IDC_BUTTON_END));
	}
}

void CCamera_UL10_VGA::InitZoomOnBlack()
{	
	switch(m_CamOption.nResolution)
	{
	case 0:	//	1280x1024
	case 1:	//	640x480
	case 2:	//	320x240
		EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);
		break;
	case 4:	//	1600x1200
		if(m_nCurrentZoom > 2)
			m_nCurrentZoom = 0;

		EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);
		break;
	case 5:	//	2048x1536
		if(m_nCurrentZoom > 1)
			m_nCurrentZoom = 0;

		EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);
		break;
	case 6:	//	2560x1920
		m_nCurrentZoom = 0;
		EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE);
		break;
	}

	if(0 == m_nCurrentZoom)
	{
		TCHAR tzCaption[16];
		CAM_Zoom(m_nCurrentZoom);
		wsprintf(tzCaption, L"%s", m_tzCaptionZoom[m_nZoomStep[m_nCurrentZoom]]);

		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_ZOOM), tzCaption);
	}
}


void CCamera_UL10_VGA::OnBnClickedButtonEnd()
{
	if(m_bPreviewing == TRUE)
	{
		CAM_PreviewStop();
		m_ctrPreview.MoveWindow(0, 10, 10, 10);
		m_bPreviewing = FALSE;

		m_ctrPreview.Invalidate();

		EnableButton(FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE);
	}
}

void CCamera_UL10_VGA::OnBnClickedButtonCapture()
{
	if(!m_bOpen)
		return;
	
	if(!m_bPreviewing)
		return;

	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), FALSE);

	if(MemoryCheck() == FALSE)
	{
		::MessageBox(this->m_hWnd,L"Not enough memory for save picture.",L"Notice",0);		
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), TRUE);
		return;
	}

	if(!m_bCapturing)
	{
		m_bCapturing = TRUE;

		if(!CAM_Capture(m_tzSavePath))
		{
			MessageBox(L"Failed Capturing. Please try again.", L"Capture", NULL);			
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), TRUE);
			m_bCapturing = FALSE;
			return;
		}
	}

	// Key  
	MSG msg;	
	int count = 0;

	while(count++ < 500)
	{			
		if(::PeekMessage(&msg, NULL, WM_KEYDOWN, WM_SYSKEYUP, PM_REMOVE))
		{
			if(((msg.message == WM_KEYDOWN) || (msg.message == WM_SYSKEYDOWN) ||(msg.message == WM_KEYUP) || (msg.message == WM_SYSKEYUP))
				&& ((msg.wParam == VK_RETURN) || (msg.wParam == VK_F23)))		//	KeyValue (VK_F23 AcitionKey)
			{
				continue;
			}
			else
			{
				::PostMessage(m_hWnd, msg.message, msg.wParam, msg.lParam);
			}
		}
		else
		{
			break;
		}
	}
}

BOOL CCamera_UL10_VGA::InsertExifInform()
{
	ExifInfo info={0,};
	TCHAR OutFileBuf[260]={0,};
	TCHAR tzFileName[260]={0,};

	if(!CAM_GetLastSaveFilePath(tzFileName))
		return FALSE;

	_tcscpy(OutFileBuf, tzFileName);

	TCHAR* ImageName;
	ImageName=_tcstok(OutFileBuf, _T("\\"));
	while (ImageName!=NULL)
	{
		if(_tcsstr(ImageName, _T(".jpg"))!=NULL || _tcsstr(ImageName, _T(".JPG"))!=NULL)
			break;
		ImageName=_tcstok(NULL, _T("\\"));
	}

	_tcscpy(info.TitleName, ImageName);
	_tcscpy(info.Make, _T("M3 Mobile Co.Ltd"));
	_tcscpy(info.Model, _T("M3 UL10"));



	if(CAM_InsertExifInformation(tzFileName, info))
	{
		RETAILMSG(RT_MSG, (_T("CamTest - Insert EXIF Success!!\n")));
		return TRUE;		
	}
	else
	{
		RETAILMSG(RT_MSG, (_T("CamTest - Insert EXIF Fail\n")));
		return FALSE;
	}
	
}

void CCamera_UL10_VGA::OnBnClickedButtonFlash()
{
	if(m_bFlash == FALSE)
	{
		CAM_FlashOn();
		m_bFlash = TRUE;
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_FLASH), L"FLASH ON");
	}
	else
	{
		CAM_FlashOff();
		m_bFlash = FALSE;
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_FLASH), L"FLASH OFF");
	}
}

void CCamera_UL10_VGA::OnBnClickedButtonAf()
{
	if(!m_bOpen)
		return;

	if(!m_bPreviewing)
		return;

	CAM_AutoFocus();
}

void CCamera_UL10_VGA::OnBnClickedButtonExit()
{

	CDialog::OnOK();
	
	
}
void CCamera_UL10_VGA::OnDestroy()
{
	CDialog::OnDestroy();

	if(m_bOpen)
	{
		if(m_bPreviewing == TRUE)
		{
			CAM_PreviewStop();
			m_ctrPreview.Invalidate();
			m_bPreviewing = FALSE;
		}

		if(m_bFlash == TRUE)
		{
			CAM_FlashOff();

		}

		Sleep(500);

		CAM_Close();
		m_bOpen = FALSE;

		::PostMessage(HWND_BROADCAST, WM_CONVERT, NULL, NULL);	
		SaveLoadCameraSetting(TRUE);

	}	

	EndDialog(IDYES);


}

void CCamera_UL10_VGA::OnBnClickedButtonOption()
{

	OnBnClickedButtonEnd();

	CAM_GetCameraOption(&m_CamOption, m_tzSavePath);

	if(m_onEXIF)
	{
		if(m_onGPS)
			::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), _T("GPS: ON"));
		else
			::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), _T("GPS: OFF"));

		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), L"EXIF: TRUE");
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), TRUE);
	}	
	else
	{
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), FALSE);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), _T("GPS: OFF"));
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), L"EXIF: FALSE");
	}

		
	TCHAR  tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	wsprintf(tzCaption, L"WB: %s", m_tzCaptionEffect[m_CamOption.nImgbalance]);


	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EFFECT), tzCaption);

	int nCurrentRes = 0, nTotalRes = 5;
	nTotalRes = sizeof(m_nResolutionStep) / sizeof(m_nResolutionStep[0]);

	for(int i = 0; i< nTotalRes; i++)
	{	
		if(m_nResolutionStep[i] == m_CamOption.nResolution)
		{
			nCurrentRes = i;
			break;
		}
	}

	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[nCurrentRes]]);
	RETAILMSG(RT_MSG, (L"Resolution - [%d] [%s]\n", m_nCurrentResolution, m_tzCaptionResolution[m_nResolutionStep[nCurrentRes]])); 
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_RESOLUTION), tzCaption);

	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	wsprintf(tzCaption, L"Format: %s", m_tzCaptionFormat[m_CamOption.nSaveFormat]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_FORMAT), tzCaption);

	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	wsprintf(tzCaption, L"Save: %s", m_tzCaptionSave[m_CamOption.nNamePrefix]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVE_NAME), tzCaption);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_PATH), m_tzSavePath);

	if(m_Model == MODEL_BLACK)
	{
		m_nCurrentEffect = m_CamOption.nImgbalance;
	}
	else
	{
		m_nCurrentEffect = m_CamOption.nImgEffect;
	}
	

	m_nCurrentResolution = nCurrentRes;
	RETAILMSG(RT_MSG, (L"Resolution - [%d] [%s]\n", m_nCurrentResolution, m_tzCaptionResolution[nCurrentRes]));
	m_nCurrentFormat = m_CamOption.nSaveFormat;
	m_nCurrentSave = m_CamOption.nNamePrefix;

	m_SliderEV.EnableWindow(TRUE);
	m_nEvValue = CAM_GetBrightness();
	m_SliderEV.SetPos(m_nEvValue);

	EnableOption(TRUE);
}

BOOL CCamera_UL10_VGA::EnableOption(BOOL bOn)
{
	
	if(bOn == TRUE)
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_EFFECT), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_EDIT_PATH), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVE_NAME), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_FORMAT), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GRP_OPTION), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_CUSTOM_PATH), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_RESOLUTION), SW_SHOW);	
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION_EXIT), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION_CANCEL), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_EV), SW_SHOW);	
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_SLIDER_EV), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_VERSION), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), SW_SHOW);	
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), SW_SHOW);	
	}
	else
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_EFFECT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_EDIT_PATH), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVE_NAME), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_FORMAT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GRP_OPTION), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_CUSTOM_PATH), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_RESOLUTION), SW_HIDE);	
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION_EXIT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION_CANCEL), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_EV), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_SLIDER_EV), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_VERSION), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), SW_HIDE);
	}
	return TRUE;
}

void CCamera_UL10_VGA::OnBnClickedButtonOptionCancel()
{
	EnableOption(FALSE);
	OnBnClickedButtonStart();
}

void CCamera_UL10_VGA::OnBnClickedButtonOptionExit()
{
	TCHAR tzFileName[MAX_PATH] = {0x00};
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_PATH), tzFileName, MAX_PATH);

	if(wcsstr(tzFileName, L".j") != NULL || wcsstr(tzFileName, L".J") != NULL)
	{
		if(m_nCurrentFormat == 0) // BMP
		{
			MessageBox(L"Input correct file name",L"Camera Option", NULL);
			return;
		}
		else if(m_nCurrentSave == 0) //Date
		{
			MessageBox(L"Input correct Folder path",L"Camera Option", NULL);
			return;
		}
	}
	else if(wcsstr(tzFileName, L".b") != NULL || wcsstr(tzFileName, L".B") != NULL)
	{
		if(m_nCurrentFormat == 1) // JPG
		{
			MessageBox(L"Input correct file name",L"Camera Option", NULL);
			return;
		}
		else if(m_nCurrentSave == 0) //Date
		{
			MessageBox(L"Input correct Folder path",L"Camera Option", NULL);
			return;
		}
	}

	wcscpy(m_tzSavePath, tzFileName);

	m_nEvValue = m_SliderEV.GetPos();

	m_CamOption.nImgbalance = m_nEffectStep[m_nCurrentEffect];
	m_CamOption.nResolution = m_nResolutionStep[m_nCurrentResolution];
	m_CamOption.nSaveFormat = m_nCurrentFormat;
	m_CamOption.nNamePrefix = m_nCurrentSave;
	
	CAM_SetCameraOption(&m_CamOption, m_tzSavePath);

	CAM_Brightness(m_nEvValue);

	EnableOption(FALSE);


	OnBnClickedButtonStart();
}

void CCamera_UL10_VGA::OnBnClickedButtonZoom()
{
	int nStepMax = 4;

	switch(m_CamOption.nResolution)
	{
	case 4:	//	1600x1200
		nStepMax = 3;
		break;
	case 5:	//	2048x1536
		nStepMax = 2;
		break;
	case 6:	//	2560x1920
		nStepMax = 1;
		break;
	}	

	TCHAR tzCaption[256] = {0x00};

	if(++m_nCurrentZoom >= nStepMax)
		m_nCurrentZoom = 0;

	if(!CAM_Zoom(m_nCurrentZoom))
		return ;

	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	wsprintf(tzCaption, L"%s", m_tzCaptionZoom[m_nZoomStep[m_nCurrentZoom]]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_ZOOM), tzCaption);
}

void CCamera_UL10_VGA::OnBnClickedButtonEffect()
{
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	
	if(wcscmp(m_tzCaptionEffect[m_nEffectStep[m_nCurrentEffect++]], L"Incandescent") == 0)
	{
		m_nCurrentEffect = 0;
		wsprintf(tzCaption, L"WB: %s", m_tzCaptionEffect[m_nEffectStep[m_nCurrentEffect]]);
	}
	else
	{
		wsprintf(tzCaption, L"WB: %s", m_tzCaptionEffect[m_nEffectStep[m_nCurrentEffect]]);
	}
	
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EFFECT), tzCaption);
}

void CCamera_UL10_VGA::OnBnClickedButtonResolution()
{

	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	//	wsprintf(m_tzCaptionResolution[5], L"2048X1536");

	if(wcscmp(m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution++]], L"2048X1536") == 0)
	{
		m_nCurrentResolution = 0;
		wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]);
	}
	else
	{
		wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]);
	}

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_RESOLUTION), tzCaption);
}

void CCamera_UL10_VGA::OnBnClickedButtonFormat()
{
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	m_nCurrentFormat?(m_nCurrentFormat = 0):(m_nCurrentFormat =1);
	wsprintf(tzCaption, L"Format: %s", m_tzCaptionFormat[m_nCurrentFormat]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_FORMAT), tzCaption);
}

void CCamera_UL10_VGA::OnBnClickedButtonSaveName()
{
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	if(m_nCurrentSave == 1)
	{
		m_nCurrentSave = 0;
	}
	else
	{
		m_nCurrentSave =1;

	}

	wsprintf(tzCaption, L"Save: %s", m_tzCaptionSave[m_nCurrentSave]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVE_NAME), tzCaption);
}

void CCamera_UL10_VGA::OnBnClickedButtonAaf()
{
	if(m_bEnableAutoAF == FALSE)
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_AAF), L"AAF");
		
		m_bEnableAutoAF = TRUE;
		CAM_EnableAutoAF(TRUE);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_AAF), L"MAF");

		m_bEnableAutoAF = FALSE;
		CAM_EnableAutoAF(FALSE);
	}
}

void CCamera_UL10_VGA::EnableButton(BOOL bOpen, BOOL bStart, BOOL bEnd, BOOL bClose, BOOL bCapture, BOOL bFlash, BOOL bAF, BOOL bZoom, BOOL bOption)
{
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPEN), bOpen);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_START), bStart);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_END), bEnd);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CLOSE), bClose);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), bCapture);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_FLASH), bOption);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AF), bAF);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_ZOOM), bZoom);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION), bOption);
}

void CCamera_UL10_VGA::OnEnSetfocusEditPath()
{
	SipShowIM(SIPF_ON);
}

BOOL CCamera_UL10_VGA::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN|| pMsg->message == WM_SYSKEYDOWN)
	{
		switch(pMsg->wParam)
		{
		case VK_F23:
		case VK_RETURN:
			if(m_bCaptureKeyPressed == FALSE)	m_bCaptureKeyPressed = TRUE;
			return TRUE;
			break;

		case VK_LEFT:
		case VK_RIGHT:
		case VK_UP:
		case VK_DOWN:
			OnBnClickedButtonAf();
			break;
		}
	}

	if(pMsg->message == WM_KEYUP|| pMsg->message == WM_SYSKEYUP)
	{
		switch(pMsg->wParam)
		{
		case VK_RETURN:
		case VK_F23:
			if(m_bCaptureKeyPressed == TRUE)
			{
				m_bCaptureKeyPressed = FALSE;
				OnBnClickedButtonCapture();
			}
			break;
		}
	}

	// Convert 2D Scanner
	if((pMsg->message == WM_KEYUP) && (pMsg->wParam == VK_F22) && (m_ScannerType == SCANNER_HHP))
	{	
		BeginWaitCursor();
		m_bRunScanEmul = TRUE;

		Sleep(300);

		CAM_Close();
		Sleep(1000);

		::PostMessage(HWND_BROADCAST, WM_CONVERT, NULL, NULL);			

		EndWaitCursor();

		CDialog::OnCancel();
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CCamera_UL10_VGA::OnBnClickedButtonExif()
{
	// TODO: Add your control notification handler code here
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	if(m_onEXIF)
	{
		m_onEXIF=FALSE;
		wsprintf(tzCaption, L"EXIF: FALSE");
		if(m_onGPS)
		{
			m_onGPS=FALSE;
			CAM_UseGPSExifData(m_onGPS);
		}
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), _T("GPS: OFF"));
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), FALSE);
	}
	else
	{
		m_onEXIF=TRUE;
		wsprintf(tzCaption, L"EXIF: TRUE");
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), TRUE);
	}

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), tzCaption);
}

void CCamera_UL10_VGA::OnBnClickedButtonGps()
{
	// TODO: Add your control notification handler code here
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	if(m_onGPS)
	{
		m_onGPS=FALSE;
		wsprintf(tzCaption, L"GPS: Off");
		CAM_UseGPSExifData(FALSE);
	}
	else
	{
		m_onGPS=TRUE;
		wsprintf(tzCaption, L"GPS: On");
		if(!CAM_UseGPSExifData(TRUE))
		{
			AfxMessageBox(_T("The terminal either do not have GPS or you are in area, where GPS connection is not possible."));

			m_onGPS=FALSE;
			wsprintf(tzCaption, L"GPS: Off");
			CAM_UseGPSExifData(FALSE);
		}
	}

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), tzCaption);
}

void CCamera_UL10_VGA::OnTimer(UINT_PTR nIDEvent)
{
	switch(nIDEvent)
	{
	case WM_TIMER_STATUS_GPS:
		KillTimer(WM_TIMER_STATUS_GPS);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_OUT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_ON), SW_HIDE);

		break;
	}

	CDialog::OnTimer(nIDEvent);
}


BOOL CCamera_UL10_VGA::OnInitDialog()
{
	CDialog::OnInitDialog();
	// TODO:  Add extra initialization here

	RECT rctTask;
	HWND hTask = ::FindWindow(L"HHTaskBar", NULL);
	::GetClientRect(hTask, &rctTask);

//	SetWindowPos(&CWnd::wndTopMost, -1, -1, 483, 640 - rctTask.bottom, SWP_NOZORDER);

	SetWindowPos(&CWnd::wndTopMost, -1, -1, 486, 646, SWP_SHOWWINDOW);

	m_bFlash = FALSE;
	m_Model = MODEL_UNKNOWN;

	m_SliderEV.SetRange(0, 5);
	m_SliderEV.SetTicFreq(1);

	m_ctrPreview.MoveWindow(0, 120, 480, 360);


	OnBnClickedButtonOpen();

	m_ScannerType = CAM_GetScannerType();

	SaveLoadCameraSetting(FALSE);
	
	// Green ϰ POS   GPS ư Ⱥ̰ 
	if(m_onGPS)
		CAM_UseGPSExifData(TRUE);

	Sleep(500);
	OnBnClickedButtonStart();

	// Key  
	MSG msg;	
	int count = 0;

	while(count++ < 500)
	{			
		if(::PeekMessage(&msg, NULL, WM_KEYDOWN, WM_SYSKEYUP, PM_REMOVE))
		{
			if(((msg.message == WM_KEYDOWN) || (msg.message == WM_SYSKEYDOWN) ||(msg.message == WM_KEYUP) || (msg.message == WM_SYSKEYUP))
				&& ((msg.wParam == VK_RETURN) || (msg.wParam == VK_F23)))		//	KeyValue (VK_F23 AcitionKey)
			{
				continue;
			}
			else
			{
				::PostMessage(m_hWnd, msg.message, msg.wParam, msg.lParam);
			}
		}
		else
		{
			break;
		}
	}


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
