#pragma once


// CCamera_BLACK_VGA dialog

class CCamera_BLACK_VGA : public CDialog
{
	DECLARE_DYNAMIC(CCamera_BLACK_VGA)

public:
	CCamera_BLACK_VGA(CWnd* pParent = NULL);   // standard constructor
	virtual ~CCamera_BLACK_VGA();

// Dialog Data
	enum { IDD = IDD_CAMTEST_BLACK_VGA };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()

public:
	BOOL m_bOpen;
	BOOL m_bPreviewing;
	CSliderCtrl m_SliderEV;
	CStatic m_ctrPreview;
	BOOL m_bFlash;
	MODEL_TYPE m_Model;
	BOOL m_bEnableAutoAF;
	BOOL m_bRunScanEmul;
	SCANNER_TYPE m_ScannerType;
	DWORD m_dwRightDowndBackupKey;

	BOOL m_bCapturing;
	BOOL m_bCaptureKeyPressed;
	
	
	int m_nEffectStep[7];
	TCHAR m_tzCaptionEffect[9][64];
	int m_nCurrentEffect;

	int m_nResolutionStep[6];
	TCHAR m_tzCaptionResolution[7][64];
	int m_nCurrentResolution;

	TCHAR m_tzCaptionFormat[3][64];
	int m_nCurrentFormat;

	TCHAR m_tzCaptionSave[3][64];
	int m_nCurrentSave;

	int m_nZoomStep[4];
	TCHAR m_tzCaptionZoom[9][64];
	int m_nCurrentZoom;

	CAMERA_OPTION m_CamOption;

	int m_nEvValue;

	TCHAR m_tzSavePath[256];
	void InitControlValue(MODEL_TYPE model, BOOL bInit);
	BOOL EnableOption(BOOL bOn);
	BOOL UpdateVersion();
	void EnableButton(BOOL bOpen, BOOL bStart, BOOL bEnd, BOOL bClose, BOOL bCapture, BOOL bFlash, BOOL bAF, BOOL bZoom, BOOL bOption);
	
	void InitZoomOnBlack();

	virtual BOOL OnInitDialog();

	void SaveLoadCameraSetting(BOOL bSave);
	BOOL MemoryCheck();

	LRESULT OnGPSStatus(WPARAM wParam, LPARAM lParam);
	LRESULT OnAFStatus(WPARAM wParam, LPARAM lParam);
	LRESULT OnShowCaptureStatus(WPARAM wParam, LPARAM lParam);


	static UINT ThreadAutoFocus(LPVOID pParam);
	int GetFileCount(TCHAR* tzFolder);
	
	afx_msg void OnBnClickedButtonOpen();
	afx_msg void OnBnClickedButtonClose();
	afx_msg void OnBnClickedButtonStart();
	afx_msg void OnBnClickedButtonEnd();
	afx_msg void OnBnClickedButtonCapture();
	afx_msg void OnBnClickedButtonFlash();
	afx_msg void OnBnClickedButtonAf();
	afx_msg void OnBnClickedButtonExit();
	afx_msg void OnBnClickedButtonOption();
	afx_msg void OnBnClickedButtonOptionExit();
	afx_msg void OnBnClickedButtonZoom();
	afx_msg void OnBnClickedButtonEffect();
	afx_msg void OnBnClickedButtonResolution();
	afx_msg void OnBnClickedButtonFormat();
	afx_msg void OnBnClickedButtonSaveName();
	afx_msg void OnBnClickedButtonAaf();
	afx_msg void OnEnSetfocusEditPath();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnBnClickedCheckExif();
	afx_msg void OnBnClickedButtonExif();
	afx_msg void OnBnClickedButtonGps();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnDestroy();
	BOOL m_onEXIF;
	BOOL m_onGPS;
	BOOL InsertExifInform();
	afx_msg void OnBnClickedButtonOptionCancel();
	
};
