
#include "stdafx.h"
#include "CamTest.h"
#include "CamTestDlg.h"

#include "Sipapi.h"

#include "pkfuncs.h"


#define WM_TIMER_STATUS_GPS		(WM_USER + 1000)

#define WM_SHOW_CAP_STATUS			(WM_USER + 5)

//extern CStatic g_ctrPreview;
//extern HWND g_hWnd;     

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CCamTestDlg dialog

CCamTestDlg::CCamTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCamTestDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_nCurrentEffect = 0;
	m_nCurrentResolution = 0;
	m_nCurrentFormat = 0;
	m_nCurrentZoom = 0;
	m_nCurrentSave = 0;

	m_nEvValue = 2;

	m_bOpen = FALSE;
	m_bPreviewing = FALSE;

	m_bEnableAutoAF = FALSE;
	m_bCapturing = FALSE;
	m_bCaptureKeyPressed = FALSE;


	m_bRunScanEmul = FALSE;
	m_dwRightDowndBackupKey = 0;

	memset(m_tzCaptionEffect, 0x00, sizeof(m_tzCaptionEffect));
	memset(m_tzCaptionResolution, 0x00, sizeof(m_tzCaptionResolution));
	memset(m_tzCaptionSave, 0x00, sizeof(m_tzCaptionSave));
	memset(m_tzCaptionFormat, 0x00, sizeof(m_tzCaptionFormat));
	memset(m_tzCaptionZoom, 0x00, sizeof(m_tzCaptionZoom));

	wsprintf(m_tzCaptionEffect[0], L"Normal");
	wsprintf(m_tzCaptionEffect[1], L"Sepia");
	wsprintf(m_tzCaptionEffect[2], L"B&W");
	wsprintf(m_tzCaptionEffect[3], L"Negative");
	wsprintf(m_tzCaptionEffect[4], L"UV Red");	// Exclude Smart
	wsprintf(m_tzCaptionEffect[5], L"UV Blue"); // Exclude Smart
	wsprintf(m_tzCaptionEffect[6], L"UV Green"); // Exclude Smart
	memset(m_nEffectStep, 0x00, sizeof(m_nEffectStep));

	wsprintf(m_tzCaptionResolution[0], L"1280X1024");
	wsprintf(m_tzCaptionResolution[1], L"640X480");
	wsprintf(m_tzCaptionResolution[2], L"320X240");
	wsprintf(m_tzCaptionResolution[3], L"Empty");
	wsprintf(m_tzCaptionResolution[4], L"1600X1200");
	wsprintf(m_tzCaptionResolution[5], L"2048X1536");
	memset(m_nResolutionStep, 0x00, sizeof(m_nResolutionStep));

	wsprintf(m_tzCaptionFormat[0], L"BMP");
	wsprintf(m_tzCaptionFormat[1], L"JPG");
	
	wsprintf(m_tzCaptionSave[0], L"Date");
	wsprintf(m_tzCaptionSave[1], L"Custom");

	wsprintf(m_tzCaptionZoom[0], L"1 X");
	wsprintf(m_tzCaptionZoom[1], L"1.5 X");
	wsprintf(m_tzCaptionZoom[2], L"2 X");
	wsprintf(m_tzCaptionZoom[3], L"2.5 X");
	wsprintf(m_tzCaptionZoom[4], L"3 X");
	wsprintf(m_tzCaptionZoom[5], L"3.5 X");
	wsprintf(m_tzCaptionZoom[6], L"4 X");
	wsprintf(m_tzCaptionZoom[7], L"4.5 X");
	memset(m_nZoomStep, 0x00, sizeof(m_nZoomStep));

	memset(m_tzSavePath, 0x00, sizeof(TCHAR) * 256);
	memset(&m_CamOption, 0x00, sizeof(CAMERA_OPTION));

	m_ScannerType = SCANNER_ERR;
}

void CCamTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_PREVIEW, m_ctrPreview);
	DDX_Control(pDX, IDC_SLIDER_EV, m_SliderEV);
}

BEGIN_MESSAGE_MAP(CCamTestDlg, CDialog)
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	ON_WM_SIZE()
#endif
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_OPEN, &CCamTestDlg::OnBnClickedButtonOpen)
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &CCamTestDlg::OnBnClickedButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_START, &CCamTestDlg::OnBnClickedButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_END, &CCamTestDlg::OnBnClickedButtonEnd)
	ON_BN_CLICKED(IDC_BUTTON_CAPTURE, &CCamTestDlg::OnBnClickedButtonCapture)
	ON_BN_CLICKED(IDOK, &CCamTestDlg::OnBnClickedButtonCapture)
	ON_BN_CLICKED(IDC_BUTTON_FLASH, &CCamTestDlg::OnBnClickedButtonFlash)
	ON_BN_CLICKED(IDC_BUTTON_AF, &CCamTestDlg::OnBnClickedButtonAf)
	ON_BN_CLICKED(IDC_BUTTON_EXIT, &CCamTestDlg::OnBnClickedButtonExit)
	ON_BN_CLICKED(IDC_BUTTON_OPTION, &CCamTestDlg::OnBnClickedButtonOption)
	ON_BN_CLICKED(IDC_BUTTON_OPTION_EXIT, &CCamTestDlg::OnBnClickedButtonOptionExit)
	ON_BN_CLICKED(IDC_BUTTON_ZOOM, &CCamTestDlg::OnBnClickedButtonZoom)
	ON_BN_CLICKED(IDC_BUTTON_EFFECT, &CCamTestDlg::OnBnClickedButtonEffect)
	ON_BN_CLICKED(IDC_BUTTON_RESOLUTION, &CCamTestDlg::OnBnClickedButtonResolution)
	ON_BN_CLICKED(IDC_BUTTON_FORMAT, &CCamTestDlg::OnBnClickedButtonFormat)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_NAME, &CCamTestDlg::OnBnClickedButtonSaveName)
	ON_BN_CLICKED(IDC_BUTTON_AAF, &CCamTestDlg::OnBnClickedButtonAaf)
	ON_EN_SETFOCUS(IDC_EDIT_PATH, &CCamTestDlg::OnEnSetfocusEditPath)
	ON_MESSAGE(WM_STATUS_AF, OnAFStatus)
	ON_MESSAGE(WM_GPS_ON, OnGPSStatus)
	ON_MESSAGE(WM_SHOW_CAP_STATUS, OnShowCaptureStatus)
	ON_BN_CLICKED(IDC_BUTTON_EXIF, &CCamTestDlg::OnBnClickedButtonExif)
	ON_BN_CLICKED(IDC_BUTTON_GPS, &CCamTestDlg::OnBnClickedButtonGps)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_OPTION_CANCEL, &CCamTestDlg::OnBnClickedButtonOptionCancel)
END_MESSAGE_MAP()


BOOL CCamTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog3w
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	SetWindowPos(&CWnd::wndTopMost, -1, -1, 243, 323, SWP_NOMOVE);


	m_ctrPreview.MoveWindow(0, 0, 240, 320);
	m_bFlash = FALSE;
	m_Model = MODEL_UNKNOWN;

	m_SliderEV.SetRange(0, 5);
	m_SliderEV.SetTicFreq(1);

	OnBnClickedButtonOpen();


	m_ScannerType = CAM_GetScannerType();

	SaveLoadCameraSetting(FALSE);
	
	// Green ϰ POS   GPS ư Ⱥ̰ 
	if(m_onGPS)
		CAM_UseGPSExifData(TRUE);

	Sleep(500);
	OnBnClickedButtonStart();

	// Key  
	MSG msg;
	int count = 0;

	while(count++ < 500)
	{			
		if(::PeekMessage(&msg, NULL, WM_KEYDOWN, WM_SYSKEYUP, PM_REMOVE))
		{
			if(((msg.message == WM_KEYDOWN) || (msg.message == WM_SYSKEYDOWN) ||(msg.message == WM_KEYUP) || (msg.message == WM_SYSKEYUP))
				&& ((msg.wParam == VK_RETURN) || (msg.wParam == VK_F23)))		//	KeyValue (VK_F23 AcitionKey)
			{
				continue;
			}
			else
			{
				::PostMessage(m_hWnd, msg.message, msg.wParam, msg.lParam);
			}
		}
		else
		{
			break;
		}
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CCamTestDlg::SaveLoadCameraSetting(BOOL bSave)
{
	if(bSave)
	{
		HKEY hKey;
		int nRet;
		DWORD dwDisp;

		nRet = RegCreateKeyEx(HKEY_CURRENT_USER, L"Software\\M3Mobile\\Camera", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hKey, &dwDisp);
		if(nRet != ERROR_SUCCESS)
		{
			// error
		}

		nRet = RegSetValueEx(hKey, L"ExifEnable", 0, REG_DWORD, (LPBYTE)&m_onEXIF, sizeof(DWORD));
		if(nRet != ERROR_SUCCESS)
		{
			// error
		}
		nRet = RegSetValueEx(hKey, L"ExifGps", 0, REG_DWORD, (LPBYTE)&m_onGPS, sizeof(DWORD));
		if(nRet != ERROR_SUCCESS)
		{
			// error
		}
		nRet = RegSetValueEx(hKey, L"EnableAF", 0, REG_DWORD, (LPBYTE)&m_bEnableAutoAF, sizeof(DWORD));
		if(nRet != ERROR_SUCCESS)
		{
			// error
		}
		RegCloseKey(hKey);
	}
	else
	{
		HKEY key;
		DWORD dwDisp;
		DWORD Size;
		if(RegCreateKeyEx(HKEY_CURRENT_USER, L"Software\\M3Mobile\\Camera", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_READ, NULL, &key, &dwDisp) != ERROR_SUCCESS)
		{
			// error
		}

		Size = sizeof(LONG);
		if(RegQueryValueEx(key, L"ExifEnable", 0, NULL, (LPBYTE)&m_onEXIF, &Size) != ERROR_SUCCESS)
		{
			m_onEXIF = TRUE;
		}
		Size = sizeof(LONG);
		if(RegQueryValueEx(key, L"ExifGps", 0, NULL, (LPBYTE)&m_onGPS, &Size) != ERROR_SUCCESS)
		{
			m_onGPS = FALSE;
		}
		Size = sizeof(LONG);
		if(RegQueryValueEx(key, L"EnableAF", 0, NULL, (LPBYTE)&m_bEnableAutoAF, &Size) != ERROR_SUCCESS)
		{
			m_onGPS = FALSE;
		}
			
		RegCloseKey(key);
	}
}

#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
void CCamTestDlg::OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/)
{
	if (AfxIsDRAEnabled())
	{
		DRA::RelayoutDialog(
			AfxGetResourceHandle(), 
			this->m_hWnd, 
			DRA::GetDisplayMode() != DRA::Portrait ? 
			MAKEINTRESOURCE(IDD_CAMTEST_DIALOG_WIDE) : 
			MAKEINTRESOURCE(IDD_CAMTEST_DIALOG));
	}
}
#endif

void CCamTestDlg::InitAFControl(BOOL bEnable)
{
	if(m_Model == MODEL_T || m_Model == MODEL_SMART || m_Model == MODEL_ORANGE_CE  || m_Model == MODEL_UL10_QVGA)
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G1), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G2), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G3), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G4), SW_HIDE);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AFING), SW_HIDE);

		int bState;
		if(bEnable == TRUE)
		{
			bState = SW_SHOW;
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AF), TRUE);
		}
		else
		{
			bState = SW_HIDE;
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AF), FALSE);

		} 

		if(m_Model == MODEL_T)
		{
			::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AAF), bState);

			// T Enable AF
			if(m_bEnableAutoAF == TRUE)
			{
				::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_AAF), L"AAF");

				CAM_EnableAutoAF(TRUE);
			}
			else
			{
				::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_AAF), L"MAF");

				CAM_EnableAutoAF(FALSE);
			}
		}
		else if(m_Model == MODEL_SMART || m_Model == MODEL_ORANGE_CE || m_Model == MODEL_UL10_QVGA)
		{
			::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AAF), SW_HIDE);
		}

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R1), bState);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R2), bState);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R3), bState);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R4), bState);


		POINT p1 = {110, 130};
		POINT p2 = {111, 130};
		POINT p3 = {130, 131};
		POINT p4 = {110, 150};		

		::MoveWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G1),p1.x, p1.y, 1, 20, FALSE);
		::MoveWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R1),p1.x, p1.y, 1, 20, FALSE);

		::MoveWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G2),p2.x, p2.y, 20, 1, FALSE);
		::MoveWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R2),p2.x, p2.y, 20, 1, FALSE);

		::MoveWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G3),p3.x, p3.y, 1, 20, FALSE);
		::MoveWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R3),p3.x, p3.y, 1, 20, FALSE);

		::MoveWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G4),p4.x, p4.y, 20, 1, FALSE);
		::MoveWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R4),p4.x, p4.y, 20, 1, FALSE);


	}
	else
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AAF), SW_HIDE);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G1), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G2), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G3), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G4), SW_HIDE);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R1), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R2), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R3), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R4), SW_HIDE);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AFING), SW_HIDE);
	}
}

void CCamTestDlg::UpdateAfRectangle(AF_STATUS status)
{
	if(status== AF_STATUS_START)
	{

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G1), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G2), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G3), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G4), SW_HIDE);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R1), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R2), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R3), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R4), SW_SHOW);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AFING), SW_SHOW);
				

	}
	else if (status == AF_STATUS_FINISH)
	{

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G1), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G2), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G3), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G4), SW_SHOW);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R1), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R2), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R3), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R4), SW_HIDE);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AFING), SW_HIDE);
		
		
	}
	else if(status == AF_STATUS_IDLE)
	{

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G1), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G2), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G3), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_G4), SW_HIDE);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R1), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R2), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R3), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AF_R4), SW_SHOW);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AFING), SW_HIDE);
	}

}

BOOL CCamTestDlg::MemoryCheck()
{
	CString str;	
	CString strDirectoryName;
	//	INT		nIdx;
	float TotalBytes, fTotal, FreeBytes, fAvail, fUsed;

	ULARGE_INTEGER uliUserFree, uliTotal, uliRealFree;

	if(wcsstr(m_tzSavePath, L"Flash Disk") != NULL )
	{
		strDirectoryName="Flash Disk\\";                                  // ˰ϴ ũ̸
	}
	else 
	{
		//	SD ī带 ־ 츦 ߰  [2009/1/30 11:55:24 JU]
		//	 SD  ðų ̹ 510p  
		if(wcsstr(m_tzSavePath, L"Flash Disk") != NULL)	
		{
			strDirectoryName = "Storage Card\\";
		}
		else
		{
			strDirectoryName="\\";                                  // ˰ϴ ũ̸
		}
	}


	if(GetDiskFreeSpaceEx(strDirectoryName, &uliUserFree, &uliTotal, &uliRealFree))
	{
		TotalBytes =uliTotal.LowPart+(double)uliTotal.HighPart*(double)4294967296;
		fTotal = (float)(TotalBytes/1024/1024); // Convert (GB)     
		FreeBytes = uliRealFree.LowPart+(double)uliRealFree.HighPart*(double)4294967296;
		fAvail = (float)(FreeBytes/1024/1024); // Convert (GB)
		fUsed = fTotal - fAvail;
		str.Format(L"D:\\ Total %.1fMB, Free %fMB, Used %fMB", fTotal, fAvail, fUsed);


		if(fAvail<10)
		{
			// ::MessageBox(this->m_hWnd,L"Not enough memory for save picture.",L"Notice",0);
			return FALSE;
		}

	}

	return TRUE;
}

int CCamTestDlg::GetFileCount(TCHAR* tzFolder)
{
	int nCount =0;

	HANDLE hFind = NULL;
	WIN32_FIND_DATA FindData = {0x00};


	TCHAR tzSearchName[MAX_PATH] = {0x00};
	memset(tzSearchName, 0x00, sizeof(TCHAR) * MAX_PATH);
	wsprintf(tzSearchName, L"%s\\*.*", tzFolder);

	hFind = FindFirstFile(tzSearchName, &FindData);

	if(hFind != INVALID_HANDLE_VALUE)
	{
		while(FindNextFile(hFind, &FindData))
			nCount++;
		
	}

	FindClose(hFind);

	return nCount;
}

LRESULT CCamTestDlg::OnShowCaptureStatus(WPARAM wParam, LPARAM lParam)
{
	RETAILMSG(RT_MSG, (TEXT("  wParam:x%x, lParam:x%x\r\n"), wParam, lParam));

	switch (wParam) {
		case CAP_STATUS_START:
			EnableButton(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE);
			break;
		case CAP_STATUS_IMG_TRANSFORM:
			RETAILMSG(RT_MSG, (TEXT("OnShowCaptureStatus CAP_STATUS_IMG_TRANSFORM\r\n")));

		case CAP_STATUS_IMG_SCALE_UP:
			RETAILMSG(RT_MSG, (TEXT("OnShowCaptureStatus CAP_STATUS_IMG_SCALE_UP\r\n")));
			break;
		case CAP_STATUS_IMG_SAVE:
			RETAILMSG(RT_MSG, (TEXT("OnShowCaptureStatus CAP_STATUS_IMG_SAVE\r\n")));
			break;
		case CAP_STATUS_END:
			{
				m_bCapturing	= FALSE;
// 				if(m_Model == MODEL_GREEN_13M)
// 				{
// 					EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);
// 				}
// 				else
// 				{
// 					EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);
// 				}
				EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);


				TCHAR tzFileName[MAX_PATH];
				memset(tzFileName, 0x00, sizeof(TCHAR) * MAX_PATH);
				CAM_GetLastSaveFilePath(tzFileName);
				RETAILMSG(RT_MSG, (TEXT("OnShowCaptureStatus CAP_STATUS_END Result - [%s]\r\n"), tzFileName));

				if(_tcsstr(tzFileName, _T(".jpg"))!=NULL)
					if(m_onEXIF)
						InsertExifInform();		

				// Get FileName
				TCHAR	szThisProgram[MAX_PATH] = {0, }; // Camera Program
				CString szViewr;
				CString strCurrentFolder, strPictureFolder;

				GetModuleFileName(NULL, szThisProgram, sizeof(TCHAR)*MAX_PATH);
				strCurrentFolder.Format(_T("%s"), szThisProgram);
				int nIndex = strCurrentFolder.ReverseFind('\\');
				strCurrentFolder = strCurrentFolder.Left(nIndex);
				szViewr.Format(strCurrentFolder + L"\\Viewer.exe");
				wsprintf(szThisProgram, L"%s", szViewr);

				// ̸  ö  Viewer  ʴ´. [9/9/2013 JJ]
				if(wcslen(tzFileName) > 1)
				{
					CreateProcessW(szThisProgram, tzFileName, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				}

				::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), TRUE);

				strPictureFolder.Format(_T("%s"), tzFileName);
				nIndex = strPictureFolder.ReverseFind('\\');
				strPictureFolder = strPictureFolder.Left(nIndex);
				int nFileCount = GetFileCount(strPictureFolder.GetBuffer());

				RETAILMSG(RT_MSG, (L"CCamTestDlg::OnShowCaptureStatus - FileCount [%d]\r\n", nFileCount));
				if(nFileCount > 1189)
				{
					MessageBox(L"Can not Capture the scene. Too many pictures are existing in the same folder.", NULL, NULL);
				}
			}

			break;
		default:
			m_bCapturing	= FALSE;
			EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);			
			// MessageBox(L"Failed Capturing. Please try again.", L"Capture", NULL);		
			break;
	}

	RETAILMSG(RT_MSG, (L"CCamTestDlg::OnShowCaptureStatus - Exit\r\n"));

	return 0L;
}


LRESULT CCamTestDlg::OnGPSStatus(WPARAM wParam, LPARAM lParam)
{
	if(wParam == TRUE)
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AFING), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_OUT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_ON), SW_SHOW);

		SetTimer(WM_TIMER_STATUS_GPS, 5000, NULL);

	}
	else
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_AFING), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_OUT), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_ON), SW_HIDE);


		SetTimer(WM_TIMER_STATUS_GPS, 5000, NULL);
	}

	return 0;
}

LRESULT CCamTestDlg::OnAFStatus(WPARAM wParam, LPARAM lParam)
{
	if(wParam == AF_STATUS_START)
	{
		RETAILMSG(RT_MSG, (L"CCamTestDlg::OnAFStatus AF_STATUS_START\r\n"));
		m_bCapturing = TRUE;
	}
	else if(wParam == AF_STATUS_FINISH)
	{
		RETAILMSG(RT_MSG, (L"CCamTestDlg::OnAFStatus AF_STATUS_FINISH\r\n"));
		m_bCapturing = FALSE;
	}
	else
	{
		m_bCapturing = FALSE;
	}

	UpdateAfRectangle((AF_STATUS)wParam);

	return 0;
}
void CCamTestDlg::InitControlValue(MODEL_TYPE model, BOOL bInit)
{
	if(bInit)
	{
		switch (model)
		{
		case MODEL_T:
			{
				int nZoom[4] = {0, 1, 2, 3};
				int nEffect[7] = {0, 1, 2, 3, 4, 5, 6};
				int nResolution[5] = {2, 1, 0, 4, 5};
				memcpy(m_nZoomStep, nZoom , sizeof(nZoom));
				memcpy(m_nEffectStep, nEffect, sizeof(nEffect));
				memcpy(m_nResolutionStep, nResolution, sizeof(nResolution));

// 				::EnableWindow(::GetDlgItem(m_hWnd, IDC_STATIC_EV), FALSE);
// 				::EnableWindow(::GetDlgItem(m_hWnd, IDC_SLIDER_EV), FALSE);
			}
			break;
		case MODEL_UL10_QVGA:
		case MODEL_ORANGE_CE:
			m_ctrPreview.MoveWindow(0, 60, 240, 180);
		case MODEL_SMART:
			{
				int nZoom[4] = {0, 2, 4, 6};
				int nEffect[5] = {0, 1, 2, 3, 4};
				int nResolution[5] = {2, 1, 0, 4, 5};
				
				wsprintf(m_tzCaptionResolution[0], L"1280X960"); // UL10, ORC, SMAR  1280X960 ̴.
				wsprintf(m_tzCaptionEffect[4], L"Aqua");	// Exclude Smart
				memcpy(m_nZoomStep, nZoom , sizeof(nZoom));
				memcpy(m_nEffectStep, nEffect, sizeof(nEffect));
				memcpy(m_nResolutionStep, nResolution, sizeof(nResolution));
			}
			break;
		case MODEL_GREEN:
			{
				int nZoom[4] = {0, 1, 2, 3};
				int nEffect[7] = {0, 1, 2, 3, 4, 5, 6};
				int nResolution[5] = {2, 1, 0, 4, 5};
				memcpy(m_nZoomStep, nZoom , sizeof(nZoom));
				memcpy(m_nEffectStep, nEffect, sizeof(nEffect));
				memcpy(m_nResolutionStep, nResolution, sizeof(nResolution));

				::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AF), SW_HIDE);
				::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), SW_HIDE);
				::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), FALSE);
				m_onGPS=FALSE;
			}
			break;
		case MODEL_GREEN_13M:
			{
				m_ctrPreview.MoveWindow(0, 60, 240, 180);

				int nZoom[1] = {0};
				int nEffect[7] = {0, 1, 2, 3, 4, 5, 6};
				int nResolution[5] = {2, 1, 0};
				memcpy(m_nZoomStep, nZoom , sizeof(nZoom));
				memcpy(m_nEffectStep, nEffect, sizeof(nEffect));
				memcpy(m_nResolutionStep, nResolution, sizeof(nResolution));

				::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AF), SW_HIDE);
				::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), SW_HIDE);
				::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_ZOOM), SW_HIDE);
				::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), FALSE);
				::EnableWindow(::GetDlgItem(m_hWnd, IDC_STATIC_EV), FALSE);
				::EnableWindow(::GetDlgItem(m_hWnd, IDC_SLIDER_EV), FALSE);
				m_onGPS=FALSE;
			}
			break;
		case MODEL_POS:
			{
				int nZoom[4] = {0, 1, 2, 3};
				int nEffect[7] = {0, 1, 2, 3, 4, 5, 6};
				int nResolution[5] = {2, 1, 0, 4, 5};
				memcpy(m_nZoomStep, nZoom , sizeof(nZoom));
				memcpy(m_nEffectStep, nEffect, sizeof(nEffect));
				memcpy(m_nResolutionStep, nResolution, sizeof(nResolution));

				::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AF), SW_HIDE);
				::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), SW_HIDE);
				::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), FALSE);
				m_onGPS=FALSE;
			}
			break;
		case MODEL_BLACK:
			{
				memset(m_tzCaptionEffect, 0x00, sizeof(m_tzCaptionEffect));

				wsprintf(m_tzCaptionEffect[0], L"Auto");
				wsprintf(m_tzCaptionEffect[1], L"Sunny");
				wsprintf(m_tzCaptionEffect[2], L"Cloudy");
				wsprintf(m_tzCaptionEffect[3], L"Fluorescent");
				wsprintf(m_tzCaptionEffect[4], L"Incandescent");
				
				wsprintf(m_tzCaptionResolution[6], L"2560X1920");

				int nZoom[4] = {0, 1, 2, 3};
				int nEffect[7] = {0, 1, 2, 3, 4, 5, 6};
				int nResolution[6] = {2, 1, 0, 4, 5, 6};
				memcpy(m_nZoomStep, nZoom , sizeof(nZoom));
				memcpy(m_nEffectStep, nEffect, sizeof(nEffect));
				memcpy(m_nResolutionStep, nResolution, sizeof(nResolution));
				m_ctrPreview.MoveWindow(0, 60, 240, 180);
			}
			break;
		default:
			::MessageBox(m_hWnd, L"Unsupported platform", NULL, NULL);
			break;
		}
	}
	else
	{
		memset(m_nZoomStep, 0 , sizeof(m_nZoomStep));
		memset(m_nEffectStep, 0, sizeof(m_nEffectStep));
		memset(m_nResolutionStep, 0, sizeof(m_nResolutionStep));

	}
}

void CCamTestDlg::OnBnClickedButtonOpen()
{
	m_Model = CAM_Open(m_hWnd, m_ctrPreview.m_hWnd) ;

//	m_Model = g_Model;
//		//CAM_Open(
//	m_hWnd = g_hWnd;
//	m_ctrPreview.m_hWnd  = g_ctrPreview.m_hWnd;



	if(m_Model == MODEL_UNKNOWN)
	{
		::MessageBox(m_hWnd, L"Open error", L"Open", NULL);
		return;
	}

	m_bOpen = TRUE;

	EnableButton(FALSE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE);

	InitControlValue(m_Model, TRUE);
	
	UpdateVersion();

	CAM_GetCameraOption(&m_CamOption, m_tzSavePath);
	CAM_GetBrightness();
}

BOOL CCamTestDlg::UpdateVersion()
{
	TCHAR tzDll[MAX_PATH], tzRelease[MAX_PATH], tzPixels[MAX_PATH], tzVersions[MAX_PATH];

	memset(tzDll, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzRelease, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzPixels, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzVersions, 0x00, sizeof(TCHAR) * MAX_PATH);
	
	if(CAM_GetVersion(tzDll, tzRelease, tzPixels))
	{
		wsprintf(tzVersions, L"DLL:%s(%s)\r\nAPP:%s(%s)\r\nPixels: %s", tzDll, tzRelease, APP_VER, APP_RELEASE, tzPixels);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_VERSION), tzVersions);
	}
	else
	{
		wsprintf(tzVersions, L"Failed getting versions");
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_VERSION), tzVersions);

		return FALSE;
	}
         
	return TRUE;
}

void CCamTestDlg::OnBnClickedButtonClose()
{
	if(m_bPreviewing)
	{
		CAM_PreviewStop();
		m_ctrPreview.Invalidate();
		m_bPreviewing = FALSE;
	}

	if(!CAM_Close())
	{
		::MessageBox(m_hWnd, L"Close error", L"Open", NULL);
	}
	else
	{
		m_bOpen = FALSE;


		InitControlValue(m_Model, FALSE);

		EnableButton(TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE);
	}

}

void CCamTestDlg::OnBnClickedButtonStart()
{
	if(m_bPreviewing == FALSE)
	{
//		m_ctrPreview.MoveWindow(0, 0, 240, 320);
		m_ctrPreview.MoveWindow(0, 60, 240, 180);
		CAM_PreviewStart();

		m_bPreviewing = TRUE;

		EnableButton(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE);
		
		InitAFControl(TRUE);

		::SetFocus(::GetDlgItem(m_hWnd, IDC_BUTTON_END));
	}
}

void CCamTestDlg::OnBnClickedButtonEnd()
{
	if(m_bPreviewing == TRUE)
	{
		CAM_PreviewStop();
		m_ctrPreview.MoveWindow(0, 5, 5, 5);

		m_bPreviewing = FALSE;

		m_ctrPreview.Invalidate();

		EnableButton(FALSE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE);

		InitAFControl(FALSE);
	}
}



void CCamTestDlg::OnBnClickedButtonCapture()
{
	if(!m_bOpen)
		return;
	
	if(!m_bPreviewing)
		return;

	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), FALSE);

	if(MemoryCheck() == FALSE)
	{
		::MessageBox(this->m_hWnd,L"Not enough memory for save picture.",L"Notice",0);		
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), TRUE);
		return;
	}

	if(!m_bCapturing)
	{
		m_bCapturing = TRUE;
		if(!CAM_Capture(m_tzSavePath))
		{
			MessageBox(L"Failed Capturing. Please try again.", L"Capture", NULL);
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), TRUE);
			m_bCapturing = FALSE;
			return;
		}
	}

	// Key  
	MSG msg;	
	int count = 0;

	while(count++ < 500)
	{			
		if(::PeekMessage(&msg, NULL, WM_KEYDOWN, WM_SYSKEYUP, PM_REMOVE))
		{
			if(((msg.message == WM_KEYDOWN) || (msg.message == WM_SYSKEYDOWN) ||(msg.message == WM_KEYUP) || (msg.message == WM_SYSKEYUP))
				&& ((msg.wParam == VK_RETURN) || (msg.wParam == VK_F23)))		//	KeyValue (VK_F23 AcitionKey)
			{
				continue;
			}
			else
			{
				::PostMessage(m_hWnd, msg.message, msg.wParam, msg.lParam);
			}
		}
		else
		{
			break;
		}
	}
}

BOOL CCamTestDlg::InsertExifInform()
{
	ExifInfo info={0,};
	TCHAR OutFileBuf[260]={0,};
	TCHAR tzFileName[260]={0,};

	if(!CAM_GetLastSaveFilePath(tzFileName))
		return FALSE;

	_tcscpy(OutFileBuf, tzFileName);

	TCHAR* ImageName;
	ImageName=_tcstok(OutFileBuf, _T("\\"));
	while (ImageName!=NULL)
	{
		if(_tcsstr(ImageName, _T(".jpg"))!=NULL || _tcsstr(ImageName, _T(".JPG"))!=NULL)
			break;
		ImageName=_tcstok(NULL, _T("\\"));
	}

	_tcscpy(info.TitleName, ImageName);
	_tcscpy(info.Make, _T("M3 Mobile Co.Ltd"));

	
	switch(m_Model)
	{
		case MODEL_ORANGE_CE:
			_tcscpy(info.Model, _T("M3 ORANGE PLUS"));
			break;
		case MODEL_UL10_QVGA:
			_tcscpy(info.Model, _T("M3 UL10"));
			break;
		case MODEL_SMART:
			_tcscpy(info.Model, _T("M3 SMART"));
			break;
		case MODEL_POS:
			_tcscpy(info.Model, _T("M3 POS"));
			break;
		case MODEL_GREEN:
		case MODEL_GREEN_13M:
			_tcscpy(info.Model, _T("M3 GREEN"));
			break;
		case MODEL_T:
			_tcscpy(info.Model, _T("M3 T"));
			break;

	}
	

	if(CAM_InsertExifInformation(tzFileName, info))
	{
		RETAILMSG(RT_MSG, (_T("CamTest - Insert EXIF Success!!\n")));
		return TRUE;		
	}
	else
	{
		RETAILMSG(RT_MSG, (_T("CamTest - Insert EXIF Fail\n")));
		return FALSE;
	}
	
}

void CCamTestDlg::OnBnClickedButtonFlash()
{
	if(m_bFlash == FALSE)
	{
		CAM_FlashOn();
		m_bFlash = TRUE;
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_FLASH), L"Fls On");
	}
	else
	{
		CAM_FlashOff();
		m_bFlash = FALSE;
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_FLASH), L"Fls Off");
	}
}

void CCamTestDlg::OnBnClickedButtonAf()
{
	if(!m_bOpen)
		return;

	if(!m_bPreviewing)
		return;

	switch(m_Model)
	{
	case MODEL_T:
	case MODEL_SMART:
	case MODEL_ORANGE_CE:
	case MODEL_UL10_QVGA:
	case MODEL_BLACK:
		{
			CAM_AutoFocus();
		}
		break;
	case MODEL_GREEN:
	case MODEL_GREEN_13M:
	case MODEL_POS:
		break;
	default:
		::MessageBox(m_hWnd, L"Unsupported platform", NULL, NULL);
		break;
	}
}

void CCamTestDlg::OnBnClickedButtonExit()
{


	CDialog::OnOK();
	
	
}
void CCamTestDlg::OnDestroy()
{
	CDialog::OnDestroy();

	
	if(m_bOpen)
	{
		if(m_bPreviewing == TRUE)
		{
			CAM_PreviewStop();
			m_ctrPreview.Invalidate();
			m_bPreviewing = FALSE;
		}

		if(m_bFlash == TRUE)
		{
			CAM_FlashOff();

		}

		Sleep(500);

		CAM_Close();
		m_bOpen = FALSE;

		::PostMessage(HWND_BROADCAST, WM_CONVERT, NULL, NULL);	
		SaveLoadCameraSetting(TRUE);

		if(m_Model == MODEL_SMART || m_Model == MODEL_ORANGE_CE || m_Model == MODEL_UL10_QVGA)	
		{
			Sleep(700);
		}
	}	

	EndDialog(IDYES);
}

void CCamTestDlg::OnBnClickedButtonOption()
{
	OnBnClickedButtonEnd();


	CAM_GetCameraOption(&m_CamOption, m_tzSavePath);

	if(m_onEXIF)
	{
		if(m_onGPS)
			::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), _T("GPS: ON"));
		else
			::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), _T("GPS: OFF"));

		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), L"EXIF: TRUE");
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), TRUE);
	}	
	else
	{
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), FALSE);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), _T("GPS: OFF"));
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), L"EXIF: FALSE");
	}

		
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	wsprintf(tzCaption, L"Effect: %s", m_tzCaptionEffect[m_CamOption.nImgEffect]);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EFFECT), tzCaption);

	int nCurrentRes = 0;
	for(int i = 0; i< 5; i++)
	{	
		if(m_nResolutionStep[i] == m_CamOption.nResolution)
		{
			nCurrentRes = i;
			break;
		}
	}

	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[nCurrentRes]]);
	RETAILMSG(RT_MSG, (L"Resolution - [%d] [%s]\n", m_nCurrentResolution, m_tzCaptionResolution[m_nResolutionStep[nCurrentRes]])); 
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_RESOLUTION), tzCaption);

	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	wsprintf(tzCaption, L"Format: %s", m_tzCaptionFormat[m_CamOption.nSaveFormat]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_FORMAT), tzCaption);

	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	wsprintf(tzCaption, L"Save: %s", m_tzCaptionSave[m_CamOption.nNamePrefix]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVE_NAME), tzCaption);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_PATH), m_tzSavePath);

	m_nCurrentEffect = m_CamOption.nImgEffect;
	

	m_nCurrentResolution = nCurrentRes;
	RETAILMSG(RT_MSG, (L"Resolution - [%d] [%s]\n", m_nCurrentResolution, m_tzCaptionResolution[nCurrentRes]));
	m_nCurrentFormat = m_CamOption.nSaveFormat;
	m_nCurrentSave = m_CamOption.nNamePrefix;

	if(m_Model == MODEL_GREEN_13M)
	{
		m_SliderEV.EnableWindow(FALSE);
	}
	else
	{
		m_SliderEV.EnableWindow(TRUE);
		m_nEvValue = CAM_GetBrightness();
		m_SliderEV.SetPos(m_nEvValue);
	}

	EnableOption(TRUE);
}

BOOL CCamTestDlg::EnableOption(BOOL bOn)
{
	
	if(bOn == TRUE)
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_EFFECT), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_EDIT_PATH), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVE_NAME), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_FORMAT), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GRP_OPTION), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_CUSTOM_PATH), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_RESOLUTION), SW_SHOW);	
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION_EXIT), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION_CANCEL), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_EV), SW_SHOW);	
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_SLIDER_EV), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_VERSION), SW_SHOW);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), SW_SHOW);	
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), SW_SHOW);	

		if(m_Model == MODEL_GREEN_13M)
		{
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_START), FALSE);
		}
	}
	else
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_EFFECT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_EDIT_PATH), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVE_NAME), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_FORMAT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GRP_OPTION), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_CUSTOM_PATH), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_RESOLUTION), SW_HIDE);	
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION_EXIT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION_CANCEL), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_EV), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_SLIDER_EV), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_VERSION), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), SW_HIDE);

		if(m_Model == MODEL_GREEN_13M)
		{
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_START), TRUE);
		}
	}
	return TRUE;
}

void CCamTestDlg::OnBnClickedButtonOptionCancel()
{
	EnableOption(FALSE);
	OnBnClickedButtonStart();
}


void CCamTestDlg::OnBnClickedButtonOptionExit()
{
	TCHAR tzFileName[MAX_PATH] = {0x00};
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_PATH), tzFileName, MAX_PATH);

	if(wcsstr(tzFileName, L".j") != NULL || wcsstr(tzFileName, L".J") != NULL)
	{
		if(m_nCurrentFormat == 0) // BMP
		{
			MessageBox(L"Input correct file name",L"Camera Option", NULL);
			return;
		}
		else if(m_nCurrentSave == 0) //Date
		{
			MessageBox(L"Input correct Folder path",L"Camera Option", NULL);
			return;
		}
	}
	else if(wcsstr(tzFileName, L".b") != NULL || wcsstr(tzFileName, L".B") != NULL)
	{
		if(m_nCurrentFormat == 1) // JPG
		{
			MessageBox(L"Input correct file name",L"Camera Option", NULL);
			return;
		}
		else if(m_nCurrentSave == 0) //Date
		{
			MessageBox(L"Input correct Folder path",L"Camera Option", NULL);
			return;
		}
	}

	wcscpy(m_tzSavePath, tzFileName);

	m_nEvValue = m_SliderEV.GetPos();

	m_CamOption.nImgEffect = m_nEffectStep[m_nCurrentEffect];
	m_CamOption.nResolution = m_nResolutionStep[m_nCurrentResolution];
	m_CamOption.nSaveFormat = m_nCurrentFormat;
	m_CamOption.nNamePrefix = m_nCurrentSave;
	
	CAM_SetCameraOption(&m_CamOption, m_tzSavePath);

	CAM_Brightness(m_nEvValue);

	EnableOption(FALSE);



	OnBnClickedButtonStart();

}

void CCamTestDlg::OnBnClickedButtonZoom()
{
	int nStepMax = 4;
	TCHAR tzCaption[256] = {0x00};

	if(++m_nCurrentZoom >= nStepMax)
		m_nCurrentZoom = 0;

	if(!CAM_Zoom(m_nCurrentZoom))
		return ;

	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	wsprintf(tzCaption, L"%s", m_tzCaptionZoom[m_nZoomStep[m_nCurrentZoom]]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_ZOOM), tzCaption);
}

void CCamTestDlg::OnBnClickedButtonEffect()
{
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	if(m_Model == MODEL_SMART || m_Model == MODEL_ORANGE_CE || m_Model == MODEL_UL10_QVGA)
	{
		if(wcscmp(m_tzCaptionEffect[m_nEffectStep[m_nCurrentEffect++]], L"Aqua") == 0)
		{
			m_nCurrentEffect = 0;
			wsprintf(tzCaption, L"Effect: %s", m_tzCaptionEffect[m_nEffectStep[m_nCurrentEffect]]);
		}
		else
		{
			wsprintf(tzCaption, L"Effect: %s", m_tzCaptionEffect[m_nEffectStep[m_nCurrentEffect]]);
		}
	}
	else
	{

		if(wcscmp(m_tzCaptionEffect[m_nEffectStep[m_nCurrentEffect++]], L"UV Green") == 0)
		{
			m_nCurrentEffect = 0;
			wsprintf(tzCaption, L"Effect: %s", m_tzCaptionEffect[m_nEffectStep[m_nCurrentEffect]]);
		}
		else
		{
			wsprintf(tzCaption, L"Effect: %s", m_tzCaptionEffect[m_nEffectStep[m_nCurrentEffect]]);
		}

		if(m_Model == MODEL_GREEN_13M)
		{
			m_SliderEV.EnableWindow(FALSE);
		}
	}

	
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EFFECT), tzCaption);
}

void CCamTestDlg::OnBnClickedButtonResolution()
{

	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	switch(m_Model)
	{
	case MODEL_T:
	case MODEL_ORANGE_CE:
	case MODEL_UL10:
	case MODEL_SMART:
		{

			if(wcscmp(m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution++]], L"2048X1536") == 0)
			{
				m_nCurrentResolution = 0;
				wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]);
			}
			else
			{
				wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]);
			}
		}
		break;
	case MODEL_GREEN:
	case MODEL_POS:
		{
			RETAILMSG(RT_MSG, (L"Resolution - [%d] [%s]\n", m_nCurrentResolution, m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]));
			if(wcscmp(m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution++]], L"1600X1200") == 0)
			{
				m_nCurrentResolution = 0;
				wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]);
			}
			else
			{
				wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]);
			}
		}
		break;
	case MODEL_GREEN_13M:
		{
			RETAILMSG(RT_MSG, (L"Resolution - [%d] [%s]\n", m_nCurrentResolution, m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]));
			if(wcscmp(m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution++]], L"1280X1024") == 0)
			{
				m_nCurrentResolution = 0;
				wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]);
			}
			else
			{
				wsprintf(tzCaption, L"%s", m_tzCaptionResolution[m_nResolutionStep[m_nCurrentResolution]]);
			}
		}
		break;
	default:
		break;
	}
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_RESOLUTION), tzCaption);
}

void CCamTestDlg::OnBnClickedButtonFormat()
{
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	m_nCurrentFormat?(m_nCurrentFormat = 0):(m_nCurrentFormat =1);
	wsprintf(tzCaption, L"Format: %s", m_tzCaptionFormat[m_nCurrentFormat]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_FORMAT), tzCaption);
}

void CCamTestDlg::OnBnClickedButtonSaveName()
{
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);
	if(m_nCurrentSave == 1)
	{
		m_nCurrentSave = 0;
	}
	else
	{
		m_nCurrentSave =1;

	}

	wsprintf(tzCaption, L"Save: %s", m_tzCaptionSave[m_nCurrentSave]);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVE_NAME), tzCaption);
}

void CCamTestDlg::OnBnClickedButtonAaf()
{
	if(m_bEnableAutoAF == FALSE)
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_AAF), L"AAF");
		
		m_bEnableAutoAF = TRUE;
		CAM_EnableAutoAF(TRUE);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_AAF), L"MAF");

		m_bEnableAutoAF = FALSE;
		CAM_EnableAutoAF(FALSE);
	}
}

void CCamTestDlg::EnableButton(BOOL bOpen, BOOL bStart, BOOL bEnd, BOOL bClose, BOOL bCapture, BOOL bFlash, BOOL bAF, BOOL bZoom, BOOL bOption)
{
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPEN), bOpen);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_START), bStart);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_END), bEnd);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CLOSE), bClose);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_CAPTURE), bCapture);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_FLASH), bOption);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_AF), bAF);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_ZOOM), bZoom);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_OPTION), bOption);
}

void CCamTestDlg::OnEnSetfocusEditPath()
{
	SipShowIM(SIPF_ON);
}

BOOL CCamTestDlg::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN|| pMsg->message == WM_SYSKEYDOWN)
	{
		switch(pMsg->wParam)
		{
		case VK_F23:
		case VK_RETURN:
			if(m_bCaptureKeyPressed == FALSE)	m_bCaptureKeyPressed = TRUE;
			return TRUE;
			break;

		case VK_LEFT:
		case VK_RIGHT:
		case VK_UP:
		case VK_DOWN:
			OnBnClickedButtonAf();
			break;
		}
	}

	if(pMsg->message == WM_KEYUP|| pMsg->message == WM_SYSKEYUP)
	{
		switch(pMsg->wParam)
		{
		case VK_RETURN:
		case VK_F23:
			if(m_bCaptureKeyPressed == TRUE)
			{
				m_bCaptureKeyPressed = FALSE;
				OnBnClickedButtonCapture();
			}
			break;
		}
	}

	// Convert 2D Scanner
	if((pMsg->message == WM_KEYUP) && (pMsg->wParam == VK_F22) && (m_ScannerType == SCANNER_HHP))
	{	
		BeginWaitCursor();
		m_bRunScanEmul = TRUE;

		Sleep(300);

		CAM_Close();
		Sleep(1000);

		::PostMessage(HWND_BROADCAST, WM_CONVERT, NULL, NULL);			

		EndWaitCursor();

		CDialog::OnCancel();
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CCamTestDlg::OnBnClickedButtonExif()
{
	// TODO: Add your control notification handler code here
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	if(m_onEXIF)
	{
		m_onEXIF=FALSE;
		wsprintf(tzCaption, L"EXIF: FALSE");
		if(m_onGPS)
		{
			m_onGPS=FALSE;
			CAM_UseGPSExifData(m_onGPS);
		}
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), _T("GPS: OFF"));
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), FALSE);
	}
	else
	{
		m_onEXIF=TRUE;
		wsprintf(tzCaption, L"EXIF: TRUE");
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), TRUE);
	}

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_EXIF), tzCaption);
}

void CCamTestDlg::OnBnClickedButtonGps()
{
	// TODO: Add your control notification handler code here
	TCHAR tzCaption[256] = {0x00};
	memset(tzCaption, 0x00, sizeof(TCHAR) * 256);

	if(m_onGPS)
	{
		m_onGPS=FALSE;
		wsprintf(tzCaption, L"GPS: Off");
		CAM_UseGPSExifData(FALSE);
	}
	else
	{
		m_onGPS=TRUE;
		wsprintf(tzCaption, L"GPS: On");
		if(!CAM_UseGPSExifData(TRUE))
		{
			AfxMessageBox(_T("The terminal either do not have GPS or you are in area, where GPS connection is not possible."));

			m_onGPS=FALSE;
			wsprintf(tzCaption, L"GPS: Off");
			CAM_UseGPSExifData(FALSE);
		}
	}

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_GPS), tzCaption);
}

void CCamTestDlg::OnTimer(UINT_PTR nIDEvent)
{
	switch(nIDEvent)
	{
	case WM_TIMER_STATUS_GPS:
		KillTimer(WM_TIMER_STATUS_GPS);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_OUT), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_STATIC_GPS_ON), SW_HIDE);

		break;
	}

	CDialog::OnTimer(nIDEvent);
}
