

#include "stdafx.h"
#include "CamTest.h"
#include "CamTestDlg.h"
#include "Camera_OX10C_VGA.h"
#include "Camera_BLACK_VGA.h"
#include "Camera_BLACK_QVGA.h"
#include "Camera_UL10_VGA.h"
#include "Camera_UL10_QVGA.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//	CStatic g_ctrPreview;
//	HWND g_hWnd;     

// CCamTestApp

BEGIN_MESSAGE_MAP(CCamTestApp, CWinApp)
END_MESSAGE_MAP()

extern MODEL_TYPE g_Model;

// CCamTestApp construction
CCamTestApp::CCamTestApp()
	: CWinApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}


// The one and only CCamTestApp object
CCamTestApp theApp;

HANDLE g_hMutex;
// CCamTestApp initialization

BOOL CCamTestApp::InitInstance()
{

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	// of your final executable, you should remove from the following
	// the specific initialization routines you do not need
	// Change the registry key under which our settings are stored
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));


	// avoid duple running
	g_hMutex = NULL;
	g_hMutex = ::CreateMutex(NULL, TRUE, _T("M3_CAMERA"));

	if(GetLastError() == ERROR_ALREADY_EXISTS)
	{
		// ::MessageBox(NULL,_T("Camera is already running!"),_T("ERROR"),MB_OK|MB_ICONWARNING);	

		return FALSE;
	}
	//

	// ̹   Ǿ?
	HANDLE hImagerMutex = ::CreateMutex(NULL, TRUE, _T("M3Imager"));
	if(GetLastError() == ERROR_ALREADY_EXISTS)
	{
		::MessageBox(NULL,_T("ImagerEmul is already running!"),_T("ERROR"),MB_OK|MB_ICONWARNING);	

		return FALSE;
	}
	CloseHandle(hImagerMutex);
	//

	//HWND hWnd = FindWindow(NULL,_T("ImagerEmul"));
	//
	//if(hWnd)
	//{
	//	MessageBox(NULL, _T("ERROR : ImagerEmul is already running!"), _T("ERROR"), MB_OK|MB_ICONWARNING);
	//	return FALSE;			
	//}	
	//

////////////////////////////////////////////////////////////////////////////////////////////////////////
///	m_Model = CAM_Open(m_hWnd, m_ctrPreview.m_hWnd) ;
// extern CStatic g_ctrPreview;
// extern HWND g_hWnd;     
// extern MODEL_TYPE g_Model;
////////////////////////////////////////////////////////////////////////////////////////////////////////

	g_Model = CAM_GetDeviceInfo() ;

	switch(g_Model)
	{
	case MODEL_ORANGE_CE_VGA:
		{
			Camera_OX10C_VGA dlg;
			m_pMainWnd = &dlg;
			INT_PTR nResponse = dlg.DoModal();
			if (nResponse == IDOK)
			{
				// TODO: Place code here to handle when the dialog is
				//  dismissed with OK
			}
		}

		break;
	case MODEL_UL10_QVGA:
		{
			CCamera_UL10_QVGA dlg;
			m_pMainWnd = &dlg;
			INT_PTR nResponse = dlg.DoModal();
			if (nResponse == IDOK)
			{
				// TODO: Place code here to handle when the dialog is
				//  dismissed with OK
			}
		}
		break;	
	case MODEL_UL10:
		{
			CCamera_UL10_VGA dlg;
			m_pMainWnd = &dlg;
			INT_PTR nResponse = dlg.DoModal();
			if (nResponse == IDOK)
			{
				// TODO: Place code here to handle when the dialog is
				//  dismissed with OK
			}
		}
		break;
	case MODEL_BLACK:
		{	
			CCamera_BLACK_VGA dlg;
			m_pMainWnd = &dlg;
			INT_PTR nResponse = dlg.DoModal();
			if (nResponse == IDOK)
			{
				// TODO: Place code here to handle when the dialog is
				//  dismissed with OK
			}
		}
		break;
	case MODEL_BLACK_QVGA:
		{	
			CCamera_BLACK_QVGA dlg;
			m_pMainWnd = &dlg;
			INT_PTR nResponse = dlg.DoModal();
			if (nResponse == IDOK)
			{
				// TODO: Place code here to handle when the dialog is
				//  dismissed with OK
			}
		}
		break;
	default:
		{

			CCamTestDlg dlg;
			m_pMainWnd = &dlg;
			INT_PTR nResponse = dlg.DoModal();
			if (nResponse == IDOK)
			{
				// TODO: Place code here to handle when the dialog is
				//  dismissed with OK
			}
		}
		break;
	}


	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}
