﻿//////////////////////////////////////////////////////////////////////////
// v.1.0.0 First Release 안하영
// v.1.0.1 SPP 만 사용할 수 있도록 수정 [8/27/2013 JJ]
//////////////////////////////////////////////////////////////////////////
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.WindowsCE.Forms;
using System.Runtime.InteropServices;
using BluetoothNet;
using BluetoothTestNet;

using System.Collections;

using HLOCAL = System.IntPtr;
using HANDLE = System.IntPtr;
using BT_Connection_ID = System.UInt32;
using HRESULT = System.Int32;
using LPVOID = System.Array;
using BT_Device_Find = System.IntPtr;
using BT_Service_Find = System.IntPtr;
using BT_Connection_Find = System.IntPtr;


namespace BluetoothTestNet
{
    public partial class BluetoothTestNet : Form
    {
        BlueToothNet Bluetooth;

        public List<BluetoothNet.BlueToothNet.BT_Device_Info_t> m_DeviceItem = new List<BluetoothNet.BlueToothNet.BT_Device_Info_t>();
        public List<BluetoothNet.BlueToothNet.BT_Connection_Info_t> m_ConnectionItem = new List<BluetoothNet.BlueToothNet.BT_Connection_Info_t>();

        public BluetoothNet.BlueToothNet.BT_Connection_Info_Ex_t m_ConnectionInfo = new BluetoothNet.BlueToothNet.BT_Connection_Info_Ex_t();
        public BluetoothNet.BlueToothNet.BT_Find_Local_Device_From_BTE_t m_LocalInfo;

        public enum ListType { DeviceFind = 1, ServiceFind, ConnectionFind }

        public ListType m_ListType;
        public HRESULT hResult;

        public uint serviceUUID = 16;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] incomingPIN;
        public uint incomingPINLen = 0;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] outgoingPIN;
        public uint outgoingPINLen = 0;

        const uint GENERIC_READ = 0x80000000;
        const uint GENERIC_WRITE = 0x40000000;
        const uint OPEN_EXISTING = 3;
        const uint FILE_ATTRIBUTE_NORMAL = 0x00000080;

        //Open
        private bool g_bBluetoothOpen = false;

        //All of Delete Devices
        private bool g_bAllDelDevice = false;

        //List Click Type
        private bool g_bListDevice = false;
        private bool g_bListService = false;
        private bool g_bListConnection = false;

        [DllImport("Coredll.dll", SetLastError = true)]
        static extern IntPtr CreateFile(
            string FileName,         //file name
            uint DesiredAccess,      //access mode
            uint ShareMode,          //share mode 
            uint SecurityAttributes, //security attributes
            uint CreationDisposition,//how to create 
            uint FlagsAndAttributes, // file attributes
            int hTemplateFile        //handle to template file
            );

        public BluetoothTestNet()
        {
            InitializeComponent();

            Bluetooth = new BlueToothNet();

            listView_Info.Columns.Add("Name", 100, HorizontalAlignment.Left);
            listView_Info.Columns.Add("MAC Address", 125, HorizontalAlignment.Left);
            listView_Info.Columns.Add("Class Of Device", 125, HorizontalAlignment.Left);

            button_Open.Enabled = true;
            button_Device_Find.Enabled = false;
            button_Service_Find.Enabled = false;
            button_Create_Connection.Enabled = false;
            button_Conn_Find.Enabled = false;
            button_Connect.Enabled = false;
            button_Disconnect.Enabled = false;
            button_Delete_Connection.Enabled = false;
            button_Close.Enabled = false;
            button_All_Of_Delete_Device.Enabled = false;
            button_Local_Info.Enabled = false;
        }

        private void SetButtonStatusOpen()
        {
            button_Open.Enabled = false;
            button_Device_Find.Enabled = true;
            button_Service_Find.Enabled = false;
            button_Create_Connection.Enabled = false;
            button_Conn_Find.Enabled = true;
            button_Connect.Enabled = false;
            button_Disconnect.Enabled = false;
            button_Delete_Connection.Enabled = false;
            button_Close.Enabled = true;
            button_All_Of_Delete_Device.Enabled = true;
            button_Local_Info.Enabled = true;
        }

        private void button_Open_Click(object sender, EventArgs e)
        {
            if (Bluetooth.Open())
            {
                listView_Info.Items.Clear();

                label_State_View.Text = "Open Success";

                g_bBluetoothOpen = true;
                SetButtonStatusOpen();
            }
            else
            {
                label_State_View.Text = "Open Fail";
            }
        }

        private void button_Close_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true)
            {
                listView_Info.Items.Clear();
                m_DeviceItem.Clear();

                Cursor.Current = Cursors.Default;
                Bluetooth.Close();

                label_State_View.Text = "Close Success";

                button_Open.Enabled = true;
                button_Device_Find.Enabled = false;
                button_Service_Find.Enabled = false;
                button_Create_Connection.Enabled = false;
                button_Conn_Find.Enabled = false;
                button_Connect.Enabled = false;
                button_Disconnect.Enabled = false;
                button_Delete_Connection.Enabled = false;
                button_Close.Enabled = false;
                button_All_Of_Delete_Device.Enabled = false;
                button_Local_Info.Enabled = false;
            }
            g_bBluetoothOpen = false;
        }

        private int GetByteLength(byte[] btByteArray)
        {
            int nLength = 0;

            for(int i = 0;i < btByteArray.Length; i++)
            {
                if (btByteArray[i] == 0x00)
                {
                    nLength = i;
                    break;
                }
            }

            return nLength;
        }

        private void button_Device_Find_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true)
            {
                m_ListType = ListType.DeviceFind;

                listView_Info.Items.Clear();
                m_DeviceItem.Clear();

                BT_Device_Find DeviceFind = new BT_Device_Find();
                BlueToothNet.BT_Device_Info_t DeviceInfo = new BlueToothNet.BT_Device_Info_t();
                BlueToothNet.BT_Device_Query_Ex_t DeviceQuery = new BlueToothNet.BT_Device_Query_Ex_t();
                BlueToothNet.BT_Device_Info_t DeviceInfo_temp;

                String strName;
                String strAddr;

                m_ConnectionInfo.Size = (ushort)(Marshal.SizeOf(typeof(BlueToothNet.BT_Connection_Info_Ex_t)));
                m_ConnectionInfo.ProfileType = BlueToothNet.BT_Profile_Type.BT_PROFILE_SPP;

                DeviceQuery.Size = (ushort)(Marshal.SizeOf(typeof(BlueToothNet.BT_Device_Query_Ex_t)));
                DeviceQuery.DeviceAttributes = (UInt16)BlueToothNet.BT_DEVICE_ALL;
                DeviceQuery.DeviceType = (m_ConnectionInfo.ProfileType == BlueToothNet.BT_Profile_Type.BT_PROFILE_SPP ? BlueToothNet.BT_DeviceType_t.bdAll : BlueToothNet.BT_DeviceType_t.bdHID);

                DeviceQuery.InquiryTimeout = 10;

                Cursor.Current = Cursors.WaitCursor;

                hResult = Bluetooth.FindFirstDeviceEx(ref DeviceFind, ref DeviceInfo, ref DeviceQuery);

                if (BlueToothNet.BT_ERROR_SUCCESS == hResult)
                {
                    do
                    {
                        DeviceInfo_temp = DeviceInfo;
                        m_DeviceItem.Insert(0, DeviceInfo_temp);
                        hResult = Bluetooth.FindNextDevice(DeviceFind, ref DeviceInfo);
                    } while (BlueToothNet.BT_ERROR_SUCCESS == hResult);
                }
                Bluetooth.FindDeviceClose(DeviceFind);

                int ImportDevicecount = m_DeviceItem.Count;
                int i = 0;

                for (i = ImportDevicecount - 1; i >= 0; i--)
                {
                    DeviceInfo = m_DeviceItem[i];

                    strName = String.Format("{0:G}", Encoding.Default.GetString(DeviceInfo.Name, 0, GetByteLength(DeviceInfo.Name)));

                    strAddr = String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}",
                    DeviceInfo.BD_ADDR.BD_ADDR5,
                    DeviceInfo.BD_ADDR.BD_ADDR4,
                    DeviceInfo.BD_ADDR.BD_ADDR3,
                    DeviceInfo.BD_ADDR.BD_ADDR2,
                    DeviceInfo.BD_ADDR.BD_ADDR1,
                    DeviceInfo.BD_ADDR.BD_ADDR0);

                    ListViewItem list_View = new ListViewItem(strName);
                    list_View.SubItems.Add(strAddr);
                    listView_Info.Items.Insert(0, list_View);
                }
                label_State_View.Text = "Device Found";

                g_bAllDelDevice = false;

                button_Open.Enabled = false;
                button_Device_Find.Enabled = true;
                button_Service_Find.Enabled = true;
                button_Create_Connection.Enabled = false;
                button_Conn_Find.Enabled = true;
                button_Connect.Enabled = false;
                button_Disconnect.Enabled = false;
                button_Delete_Connection.Enabled = false;
                button_Close.Enabled = true;
                button_All_Of_Delete_Device.Enabled = true;
                button_Local_Info.Enabled = true;

                Cursor.Current = Cursors.Default;
            }
        }

        private void button_Service_Find_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true && g_bAllDelDevice == false && g_bListDevice == true)
            {
                m_ListType = ListType.ServiceFind;

                listView_Info.Items.Clear();

                BT_Service_Find ServiceFind = new BT_Service_Find();
                BlueToothNet.BT_Service_Info_Ex_t ServiceInfo = new BlueToothNet.BT_Service_Info_Ex_t();
                BlueToothNet.BT_Service_Query_t ServiceQuery = new BlueToothNet.BT_Service_Query_t();
                BlueToothNet.SDP_UUID_Entry_t Service = new BlueToothNet.SDP_UUID_Entry_t();

                String strName;

                ServiceInfo.Size = (ushort)(Marshal.SizeOf(typeof(BlueToothNet.BT_Service_Info_Ex_t)));

                ServiceQuery.BD_ADDR = m_ConnectionInfo.BD_ADDR;
                ServiceQuery.NumberServiceUUID = 1;

                Service.SDP_Data_Element_Type = BlueToothNet.SDP_Data_Element_Type_t.deUUID_16;

                switch (m_ConnectionInfo.ProfileType)
                {
                    case BlueToothNet.BT_Profile_Type.BT_PROFILE_SPP:
                        if (128 == serviceUUID)
                        {
                            Service.SDP_Data_Element_Type = BlueToothNet.SDP_Data_Element_Type_t.deUUID_128;

                            Bluetooth.ASSIGN_UUID_128(ref (Service.value.UUID_128),
                                0x85, 0x60, 0xCA, 0x18,
                                0x62, 0x3F,
                                0x4A, 0x77,
                                0x9F, 0x5E, 0x3C, 0x52, 0x66, 0x68, 0x05, 0x1A);
                        }
                        else
                        {
                            Bluetooth.ASSIGN_UUID_16(ref (Service.value.UUID_16), 0x11, 0x01);
                        }
                        break;

                    case BlueToothNet.BT_Profile_Type.BT_PROFILE_HID_HOST:
                    case BlueToothNet.BT_Profile_Type.BT_PROFILE_HID_DEVICE:
                        Bluetooth.ASSIGN_UUID_16(ref (Service.value.UUID_16), 0x11, 0x24);
                        break;
                }
                Cursor.Current = Cursors.WaitCursor;

                ServiceQuery.Service = Marshal.AllocCoTaskMem(Marshal.SizeOf(Service));
                Marshal.StructureToPtr(Service, ServiceQuery.Service, false);

                hResult = Bluetooth.FindFirstServiceEx(ref ServiceFind, ref ServiceInfo, ref ServiceQuery);

                if (BlueToothNet.BT_ERROR_SUCCESS == hResult)
                {
                    do
                    {
                        m_ConnectionInfo.ProfileType = ServiceInfo.ProfileType;
                        m_ConnectionInfo.MajorVersion = ServiceInfo.MajorVersion;
                        m_ConnectionInfo.MinorVersion = ServiceInfo.MinorVersion;

                        switch (m_ConnectionInfo.ProfileType)
                        {
                            case BlueToothNet.BT_Profile_Type.BT_PROFILE_SPP:
                                m_ConnectionInfo._profileinformation.RemoteSerialPortProfileInfo.RFCOMMServerPort = ServiceInfo._profileinformation.RemoteSerialPortProfileInfo.RFCOMMServerPort;
                                m_ConnectionInfo._profileinformation.RemoteSerialPortProfileInfo.UseActiveSync = ServiceInfo._profileinformation.RemoteSerialPortProfileInfo.UseActiveSync;

                                strName = String.Format("{0:G}", Encoding.Default.GetString(ServiceInfo.ServiceName, 0, GetByteLength(ServiceInfo.ServiceName)));

                                ListViewItem list_View = new ListViewItem(strName);
                                listView_Info.Items.Insert(0, list_View);

                                break;
//                             case BlueToothNet.BT_Profile_Type.BT_PROFILE_UNKNOWN:
//                                 m_ConnectionInfo._profileinformation.RemoteSerialPortProfileInfo.RFCOMMServerPort = ServiceInfo._profileinformation.RemoteSerialPortProfileInfo.RFCOMMServerPort;
//                                 m_ConnectionInfo._profileinformation.RemoteSerialPortProfileInfo.UseActiveSync = ServiceInfo._profileinformation.RemoteSerialPortProfileInfo.UseActiveSync;
//                                 break;
// 
// 
//                             case BlueToothNet.BT_Profile_Type.BT_PROFILE_HID_HOST:
//                             case BlueToothNet.BT_Profile_Type.BT_PROFILE_HID_DEVICE:
//                                 m_ConnectionInfo._profileinformation.RemoteHIDProfileInfo.DeviceAutomaticReconnect = ServiceInfo._profileinformation.RemoteHIDProfileInfo.DeviceAutomaticReconnect;
//                                 m_ConnectionInfo._profileinformation.RemoteHIDProfileInfo.DeviceNormallyConnectable = ServiceInfo._profileinformation.RemoteHIDProfileInfo.DeviceNormallyConnectable;
//                                 m_ConnectionInfo._profileinformation.RemoteHIDProfileInfo.DeviceSubclass = ServiceInfo._profileinformation.RemoteHIDProfileInfo.DeviceSubclass;
//                                 m_ConnectionInfo._profileinformation.RemoteHIDProfileInfo.L2CAPControlChannel = ServiceInfo._profileinformation.RemoteHIDProfileInfo.L2CAPControlChannel;
//                                 m_ConnectionInfo._profileinformation.RemoteHIDProfileInfo.L2CAPInterruptChannel = ServiceInfo._profileinformation.RemoteHIDProfileInfo.L2CAPInterruptChannel;
//                                 m_ConnectionInfo._profileinformation.RemoteHIDProfileInfo.VirtualCableSupported = ServiceInfo._profileinformation.RemoteHIDProfileInfo.VirtualCableSupported;
//                                 break;
                        }


                        hResult = Bluetooth.FindNextServiceEx(ServiceFind, ref ServiceInfo);

                    } while (BlueToothNet.BT_ERROR_SUCCESS == hResult);

                    if (BlueToothNet.BT_ERROR_NO_MORE != hResult)
                    {
                        label_State_View.Text = "Failed to find next service";
                    }

                    Bluetooth.FindServiceClose(ServiceFind);
                    Cursor.Current = Cursors.Default;
                }

                if (listView_Info.Items.Count > 0)
                {
                    label_State_View.Text = "Service Found";

                    button_Create_Connection.Enabled = true;
                }
                else
                {

                    label_State_View.Text = "Only Support SPP Profile.";

                    button_Create_Connection.Enabled = true;

                    ListViewItem list_View = new ListViewItem("Did not find the SPP Profile.");
                    listView_Info.Items.Insert(0, list_View);

                    button_Create_Connection.Enabled = false;
                }

                button_Open.Enabled = false;
                button_Device_Find.Enabled = true;
                button_Conn_Find.Enabled = true;
                button_Connect.Enabled = false;
                button_Disconnect.Enabled = false;
                button_Delete_Connection.Enabled = false;
                button_Close.Enabled = true;
                button_All_Of_Delete_Device.Enabled = false;
                button_Local_Info.Enabled = true;
            }
            else if (g_bAllDelDevice == true)
            {
                label_State_View.Text = "Please,Click the 'Device Find' button.";
            }
            else if (g_bListDevice == false)
            {
                label_State_View.Text = "Please, Make a list of selection.";
            }
            Cursor.Current = Cursors.Default;
        }

        private void button_Create_Connection_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true && g_bListService == true)
            {
                listView_Info.Items.Clear();

                m_ConnectionInfo.ConnectionAttributes = BlueToothNet.BT_CONNECTION_REMEMBERED | BlueToothNet.BT_CONNECTION_ACTIVE;
                m_ConnectionInfo.LocalCOMPort = 9;
                m_ConnectionInfo.ProfileType = BlueToothNet.BT_Profile_Type.BT_PROFILE_SPP;

                hResult = Bluetooth.CreateConnectionEx(ref m_ConnectionInfo);

                if (BlueToothNet.BT_ERROR_SUCCESS == hResult)
                {
                    label_State_View.Text = "Success";

                    ListViewItem list_View = new ListViewItem("Connection was created");
                    listView_Info.Items.Insert(0, list_View);

                    button_Open.Enabled = false;
                    button_Device_Find.Enabled = true;
                    button_Service_Find.Enabled = true;
                    button_Create_Connection.Enabled = false;
                    button_Conn_Find.Enabled = true;
                    button_Connect.Enabled = false;
                    button_Disconnect.Enabled = false;
                    button_Delete_Connection.Enabled = false;
                    button_Close.Enabled = true;
                    button_All_Of_Delete_Device.Enabled = false;
                    button_Local_Info.Enabled = true;
                }
                else
                {
                    label_State_View.Text = "Create Connection Error";
                    SetButtonStatusOpen();
                    return;
                }

            }
            else if (g_bListService == false)
            {
                label_State_View.Text = "Please, Make a list of selection.";
                SetButtonStatusOpen();
                return;
            }
        }

        private void button_Delete_Connection_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true)
            {
                listView_Info.Items.Clear();

                hResult = Bluetooth.DeleteConnection(m_ConnectionInfo.ConnectionID);

                if (BlueToothNet.BT_ERROR_SUCCESS == hResult)
                {
                    label_State_View.Text = "Delete Connection";
                }
                else
                {
                    label_State_View.Text = "Delete Connection Error";
                }

                button_Open.Enabled = false;
                button_Device_Find.Enabled = true;
                button_Service_Find.Enabled = false;
                button_Create_Connection.Enabled = false;
                button_Conn_Find.Enabled = true;
                button_Connect.Enabled = false;
                button_Disconnect.Enabled = false;
                button_Delete_Connection.Enabled = false;
                button_Close.Enabled = true;
                button_All_Of_Delete_Device.Enabled = true;
                button_Local_Info.Enabled = true;
            }
        }

        private void button_Conn_Find_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true)
            {
                m_ListType = ListType.ConnectionFind;

                listView_Info.Items.Clear();
                m_ConnectionItem.Clear();

                String strID;
                String strAddr;

                BT_Connection_Find ConnectFind = new BT_Connection_Find();
                BlueToothNet.BT_Connection_Info_t ConnectionInfo = new BlueToothNet.BT_Connection_Info_t();
                BlueToothNet.BT_Connection_Query_t ConnectQuery = new BlueToothNet.BT_Connection_Query_t();

                ConnectQuery.ConnectionAttributes = BlueToothNet.BT_CONNECTION_REMEMBERED;

                Cursor.Current = Cursors.WaitCursor;

                hResult = Bluetooth.FindFirstConnection(ref ConnectFind, ref ConnectionInfo, ref ConnectQuery);

                if (BlueToothNet.BT_ERROR_SUCCESS == hResult)
                {
                    Cursor.Current = Cursors.Default;
                    do
                    {
                        BlueToothNet.BT_Connection_Info_t ConnectInfo_temp;
                        ConnectInfo_temp = ConnectionInfo;
                        m_ConnectionItem.Insert(0, ConnectInfo_temp);

                        hResult = Bluetooth.FindNextConnection(ConnectFind, ref ConnectionInfo);
                    } while (BlueToothNet.BT_ERROR_SUCCESS == hResult);
                    if (BlueToothNet.BT_ERROR_NO_MORE != hResult)
                    {
                        Cursor.Current = Cursors.Default;
                        label_State_View.Text = "Failed to find next connection.";
                    }
                    Bluetooth.FindConnectionClose(ConnectFind);
                }
                else
                {
                    Cursor.Current = Cursors.Default;
                    label_State_View.Text = " No connections were found.";

                    return;
                }

                int ImportDeviceCount = m_ConnectionItem.Count;
                int i = 0;

                for (i = m_ConnectionItem.Count - 1; i >= 0; i--)
                {
                    ConnectionInfo = m_ConnectionItem[i];

                    strID = String.Format("{0:}", ConnectionInfo.ConnectionID);

                    strAddr = String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}",
                    ConnectionInfo.BD_ADDR.BD_ADDR5,
                    ConnectionInfo.BD_ADDR.BD_ADDR4,
                    ConnectionInfo.BD_ADDR.BD_ADDR3,
                    ConnectionInfo.BD_ADDR.BD_ADDR2,
                    ConnectionInfo.BD_ADDR.BD_ADDR1,
                    ConnectionInfo.BD_ADDR.BD_ADDR0);

                    ListViewItem list_View = new ListViewItem(strID);
                    list_View.SubItems.Add(strAddr);
                    listView_Info.Items.Insert(0, list_View);
                }
                label_State_View.Text = "Connection Found";

                button_Open.Enabled = false;
                button_Device_Find.Enabled = true;
                button_Service_Find.Enabled = false;
                button_Create_Connection.Enabled = false;
                button_Conn_Find.Enabled = false;
                button_Connect.Enabled = true;
                button_Disconnect.Enabled = false;
                button_Delete_Connection.Enabled = true;
                button_Close.Enabled = true;
                button_All_Of_Delete_Device.Enabled = false;
                button_Local_Info.Enabled = true;
            }
        }

        private void button_Connect_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true && g_bListConnection == true)
            {
                listView_Info.Items.Clear();

                hResult = Bluetooth.Connect(m_ConnectionInfo.ConnectionID);

                //CreateFile("COM9:", GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);

                if (BlueToothNet.BT_ERROR_SUCCESS == hResult)
                {
                    label_State_View.Text = "Connected";
                    button_Open.Enabled = false;
                    button_Device_Find.Enabled = false;
                    button_Service_Find.Enabled = false;
                    button_Create_Connection.Enabled = false;
                    button_Conn_Find.Enabled = false;
                    button_Connect.Enabled = false;
                    button_Disconnect.Enabled = true;
                    button_Delete_Connection.Enabled = false;
                    button_Close.Enabled = true;
                    button_All_Of_Delete_Device.Enabled = false;
                    button_Local_Info.Enabled = true;
                }
                else if (BlueToothNet.BT_ERROR_INVALID_PARAMETER == hResult)
                {
                    label_State_View.Text = "Error Invalid parameter";
                    SetButtonStatusOpen();
                    return;
                }
                else
                {
                    label_State_View.Text = "Connect Error";
                    SetButtonStatusOpen();
                    return;
                }

            }
            else if (g_bListConnection == false)
            {
                label_State_View.Text = "Please, Make a list of selection.";
                SetButtonStatusOpen();
                return;
            }
        }

        private void button_Disconnect_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true)
            {
                listView_Info.Items.Clear();

                hResult = Bluetooth.Disconnect(m_ConnectionInfo.ConnectionID);

                if (BlueToothNet.BT_ERROR_SUCCESS == hResult)
                {
                    label_State_View.Text = "Disconnected";
                }
                else if (BlueToothNet.BT_ERROR_INVALID_PARAMETER == hResult)
                {
                    label_State_View.Text = "Error Invalid parameter";
                }
                else
                {
                    label_State_View.Text = "Disconnect Error";
                }

                button_Open.Enabled = false;
                button_Device_Find.Enabled = true;
                button_Service_Find.Enabled = false;
                button_Create_Connection.Enabled = false;
                button_Conn_Find.Enabled = true;
                button_Connect.Enabled = false;
                button_Disconnect.Enabled = false;
                button_Delete_Connection.Enabled = false;
                button_Close.Enabled = true;
                button_All_Of_Delete_Device.Enabled = false;
                button_Local_Info.Enabled = true;
            }
        }

        private void button_Local_Info_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true)
            {
                listView_Info.Items.Clear();

                UInt32 ClassOfDevice;

                String strName;
                String strAddr;
                String strClass;

                hResult = Bluetooth.FindLocalDevice(ref m_LocalInfo);

                if (BlueToothNet.BT_ERROR_SUCCESS == hResult)
                {
                    ClassOfDevice = (((UInt32)m_LocalInfo.DeviceInfo.ClassOfDevice.Class_of_Device0) << 16) |
                                      (((UInt32)m_LocalInfo.DeviceInfo.ClassOfDevice.Class_of_Device1) << 8) |
                                      ((UInt32)m_LocalInfo.DeviceInfo.ClassOfDevice.Class_of_Device2);
                    strName = String.Format("{0:G}", Encoding.Default.GetString(m_LocalInfo.DeviceInfo.Name, 0, GetByteLength(m_LocalInfo.DeviceInfo.Name)));

                    strAddr = String.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}",
                        m_LocalInfo.DeviceInfo.BD_ADDR.BD_ADDR5,
                        m_LocalInfo.DeviceInfo.BD_ADDR.BD_ADDR4,
                        m_LocalInfo.DeviceInfo.BD_ADDR.BD_ADDR3,
                        m_LocalInfo.DeviceInfo.BD_ADDR.BD_ADDR2,
                        m_LocalInfo.DeviceInfo.BD_ADDR.BD_ADDR1,
                        m_LocalInfo.DeviceInfo.BD_ADDR.BD_ADDR0);

                    strClass = String.Format("{0:G} (0x{1:X2}{2:X2}{3:X2})",
                        ClassOfDevice,
                        m_LocalInfo.DeviceInfo.ClassOfDevice.Class_of_Device0,
                        m_LocalInfo.DeviceInfo.ClassOfDevice.Class_of_Device1,
                        m_LocalInfo.DeviceInfo.ClassOfDevice.Class_of_Device2);

                    ListViewItem list_View = new ListViewItem(strName);
                    list_View.SubItems.Add(strAddr);
                    list_View.SubItems.Add(strClass);
                    listView_Info.Items.Insert(0, list_View);
                }
                label_State_View.Text = "Local Information";

                button_Open.Enabled = false;
                button_Device_Find.Enabled = true;
                button_Service_Find.Enabled = false;
                button_Create_Connection.Enabled = false;
                button_Conn_Find.Enabled = true;
                button_Connect.Enabled = false;
                button_Disconnect.Enabled = false;
                button_Delete_Connection.Enabled = false;
                button_Close.Enabled = true;
                button_All_Of_Delete_Device.Enabled = true;
                button_Local_Info.Enabled = true;
            }
        }

        private void button_All_Of_Delete_Device_Click(object sender, EventArgs e)
        {
            if (g_bBluetoothOpen == true)
            {
                listView_Info.Items.Clear();

                hResult = Bluetooth.PerformAction(BlueToothNet.BT_ACTION_DELETE_ALL_DEVICES, 0, 0, 0, 0);

                if (BlueToothNet.BT_ERROR_SUCCESS == hResult)
                {
                    label_State_View.Text = "All Of Delete Devices Success";

                    button_Open.Enabled = false;
                    button_Device_Find.Enabled = true;
                    button_Service_Find.Enabled = false;
                    button_Create_Connection.Enabled = false;
                    button_Conn_Find.Enabled = false;
                    button_Connect.Enabled = false;
                    button_Disconnect.Enabled = false;
                    button_Delete_Connection.Enabled = false;
                    button_Close.Enabled = true;
                    button_All_Of_Delete_Device.Enabled = false;
                    button_Local_Info.Enabled = true;

                    g_bAllDelDevice = true;
                }
                else
                {
                    String strMsg;
                    strMsg = String.Format("BTPerformAction - {0:}", hResult);
                    MessageBox.Show(strMsg);
                }
            }
        }

        private void listView_Info_SelectedIndexChanged(object sender, EventArgs e)
        {
            listView_Info.Refresh();

            BlueToothNet.BT_Device_Info_t DeviceInfo;
            BlueToothNet.BT_Connection_Info_t ConnectionInfo;
            BlueToothNet.BT_Profile_Type Profiletype;

            if (listView_Info.SelectedIndices.Count < 1) return;

            int nSelectNum = listView_Info.SelectedIndices[0];

            if (m_ListType == ListType.DeviceFind)
            {
                if (nSelectNum > 0 || nSelectNum == 0)
                {
                    DeviceInfo = m_DeviceItem[nSelectNum];
                    m_ConnectionInfo.BD_ADDR = DeviceInfo.BD_ADDR;
                    Profiletype = m_ConnectionInfo.ProfileType;

                    g_bListDevice = true;
                }
            }
            else if (m_ListType == ListType.ServiceFind)
            {
                if (nSelectNum > 0 || nSelectNum == 0)
                {
                    g_bListService = true;
                }
            }
            else if (m_ListType == ListType.ConnectionFind)
            {
                if (nSelectNum > 0 || nSelectNum == 0)
                {
                    ConnectionInfo = m_ConnectionItem[nSelectNum];
                    m_ConnectionInfo.BD_ADDR = ConnectionInfo.BD_ADDR;
                    m_ConnectionInfo.ConnectionID = ConnectionInfo.ConnectionID;

                    g_bListConnection = true;
                }
            }
            return;
        }

        private void button_Version_Click(object sender, EventArgs e)
        {
            StringBuilder strVersion = new StringBuilder(128);

            if (g_bBluetoothOpen == true)
            {
                if (Bluetooth.GetVersionInfo(strVersion))
                {
                    String strVersionMsg = String.Format("[ BLUETOOTH NET ]\n - {0} \n \n- EXE : 1.0.1", strVersion);
                    MessageBox.Show(strVersionMsg, "Version");
                }
                else
                {
                    MessageBox.Show("Fail");
                }
            }
        }

        private void BTN_CLOSE_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}