// BluetoothTestDlg.h : header file
//

#pragma once

#include "BLUETOOTH.h"
#include "afxwin.h"

// CBluetoothTestDlg dialog
class CBluetoothTestDlg : public CDialog
{
public:

	CList<BTP_Device_Info_t, BTP_Device_Info_t&>			m_Deviceitem;
	CList<BTP_Connection_Info_t, BTP_Connection_Info_t&>	m_Connectitem;
	int	  m_listtype;
	BTP_Connection_Info_Ex_t  m_connectionInfo;

// Construction
public:
	CBluetoothTestDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_BLUETOOTHTEST_DIALOG };


	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	afx_msg void OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/);
#endif
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedBtnOpen();
	afx_msg void OnBnClickedBtnDeviceFind();
	afx_msg void OnBnClickedBtnServiceFind();
	afx_msg void OnBnClickedBtnCreateConnection();
	afx_msg void OnBnClickedBtnConnectionFind();
	afx_msg void OnBnClickedBtnConnect();
	afx_msg void OnBnClickedBtnDisconnect();
	afx_msg void OnBnClickedBtnDeleteConnection();
	afx_msg void OnBnClickedBtnClose();
	afx_msg void OnBnClickedBtnAllOfDeleteDevice();
	afx_msg void OnNMClickList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedBtnLocalInfo();
	

	void SetButtonStatusOpen();
	CListCtrl m_List;
	CStatic m_State;
	
	CButton m_Open;
	CButton m_DeviceFind;
	CButton m_ServiceFind;
	CButton m_CreateConn;
	CButton m_ConnFind;
	CButton m_Connect;
	CButton m_Disconnect;
	CButton m_DeleteConn;
	CButton m_Close;
	CButton m_AllDelDevice;
	CButton m_LocalInfo;

	afx_msg void OnBnClickedBtnVersion();
	CButton m_Version;
};
