//////////////////////////////////////////////////////////////////////////
// v.1.0.0 First Release Ͽ
// v.1.0.1 SPP    ֵ  [8/27/2013 JJ]
//////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "BluetoothTest.h"
#include "BluetoothTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define VERSION_INFO L"1.0.1"
/******************************************************************************/
/**  Function Prototypes.                                                    **/
/******************************************************************************/
static HINSTANCE hModule;
static HRESULT hResult;
static unsigned int serviceUUID   = 16;

static char        outgoingPIN[16]  = "";
static unsigned int outgoingPINLen   = 0;
static char        incomingPIN[16]  = "";
static unsigned int incomingPINLen   = 0;

#define DeviceFind 1
#define ServiceFind 2
#define ConnectionFind 3

//Open
BOOL g_bBluetoothOpen = FALSE;

//All of Delete Devices
BOOL g_bAllDelDevice = FALSE;

//List Click Type
BOOL g_bListDevice = FALSE;
BOOL g_bListService = FALSE;
BOOL g_bListConnection = FALSE;

// CBluetoothTestDlg dialog

CBluetoothTestDlg::CBluetoothTestDlg(CWnd* pParent /*=NULL*/)
: CDialog(CBluetoothTestDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBluetoothTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST, m_List);
	DDX_Control(pDX, IDC_STA_STATE_VIEW, m_State);
	DDX_Control(pDX, IDC_BTN_OPEN, m_Open);
	DDX_Control(pDX, IDC_BTN_DEVICE_FIND, m_DeviceFind);
	DDX_Control(pDX, IDC_BTN_SERVICE_FIND, m_ServiceFind);
	DDX_Control(pDX, IDC_BTN_CREATE_CONNECTION, m_CreateConn);
	DDX_Control(pDX, IDC_BTN_CONNECTION_FIND, m_ConnFind);
	DDX_Control(pDX, IDC_BTN_CONNECT, m_Connect);
	DDX_Control(pDX, IDC_BTN_DISCONNECT, m_Disconnect);
	DDX_Control(pDX, IDC_BTN_DELETE_CONNECTION, m_DeleteConn);
	DDX_Control(pDX, IDC_BTN_CLOSE, m_Close);
	DDX_Control(pDX, IDC_BTN_ALL_OF_DELETE_DEVICE, m_AllDelDevice);
	DDX_Control(pDX, IDC_BTN_LOCAL_INFO, m_LocalInfo);
	DDX_Control(pDX, IDC_BTN_VERSION, m_Version);
}

BEGIN_MESSAGE_MAP(CBluetoothTestDlg, CDialog)
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	ON_WM_SIZE()
#endif
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_OPEN, &CBluetoothTestDlg::OnBnClickedBtnOpen)
	ON_BN_CLICKED(IDC_BTN_CLOSE, &CBluetoothTestDlg::OnBnClickedBtnClose)
	ON_BN_CLICKED(IDC_BTN_DEVICE_FIND, &CBluetoothTestDlg::OnBnClickedBtnDeviceFind)
	ON_BN_CLICKED(IDC_BTN_SERVICE_FIND, &CBluetoothTestDlg::OnBnClickedBtnServiceFind)
	ON_BN_CLICKED(IDC_BTN_CONNECTION_FIND, &CBluetoothTestDlg::OnBnClickedBtnConnectionFind)
	ON_BN_CLICKED(IDC_BTN_CREATE_CONNECTION, &CBluetoothTestDlg::OnBnClickedBtnCreateConnection)
	ON_BN_CLICKED(IDC_BTN_DELETE_CONNECTION, &CBluetoothTestDlg::OnBnClickedBtnDeleteConnection)
	ON_BN_CLICKED(IDC_BTN_CONNECT, &CBluetoothTestDlg::OnBnClickedBtnConnect)
	ON_BN_CLICKED(IDC_BTN_DISCONNECT, &CBluetoothTestDlg::OnBnClickedBtnDisconnect)
	ON_BN_CLICKED(IDC_BTN_LOCAL_INFO, &CBluetoothTestDlg::OnBnClickedBtnLocalInfo)
	ON_BN_CLICKED(IDC_BTN_ALL_OF_DELETE_DEVICE, &CBluetoothTestDlg::OnBnClickedBtnAllOfDeleteDevice)
	ON_NOTIFY(NM_CLICK, IDC_LIST, &CBluetoothTestDlg::OnNMClickList)

	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BTN_VERSION, &CBluetoothTestDlg::OnBnClickedBtnVersion)
END_MESSAGE_MAP()


// CBluetoothTestDlg message handlers

BOOL CBluetoothTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	static CFont fFont;
	LOGFONT LogFont;

	//Static Font
	GetDlgItem(IDC_STA_STATE)->GetFont()->GetLogFont(&LogFont);
	LogFont.lfWeight = 700;
	fFont.CreateFontIndirect(&LogFont);
	GetDlgItem(IDC_STA_STATE)->SetFont(&fFont);

	ListView_SetExtendedListViewStyle(m_List.GetSafeHwnd(),LVS_EX_FULLROWSELECT);

	m_List.InsertColumn(0, L"Name", LVCFMT_LEFT, 100);
	m_List.InsertColumn(1, L"MAC Address", LVCFMT_LEFT, 125);
	m_List.InsertColumn(2, L"Class Of Device", LVCFMT_LEFT, 125);

	m_Open.EnableWindow(TRUE);
	m_DeviceFind.EnableWindow(FALSE);
	m_ServiceFind.EnableWindow(FALSE);
	m_CreateConn.EnableWindow(FALSE);
	m_ConnFind.EnableWindow(FALSE);
	m_Connect.EnableWindow(FALSE);
	m_Disconnect.EnableWindow(FALSE);
	m_DeleteConn.EnableWindow(FALSE);
	m_Close.EnableWindow(FALSE);
	m_AllDelDevice.EnableWindow(FALSE);
	m_LocalInfo.EnableWindow(FALSE);
	m_Version.EnableWindow(FALSE);

	UpdateData(FALSE);

//	MoveWindow(-1,-1, 242, 362);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
void CBluetoothTestDlg::OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/)
{
	if (AfxIsDRAEnabled())
	{
		DRA::RelayoutDialog(
			AfxGetResourceHandle(), 
			this->m_hWnd, 
			DRA::GetDisplayMode() != DRA::Portrait ? 
			MAKEINTRESOURCE(IDD_BLUETOOTHTEST_DIALOG_WIDE) : 
		MAKEINTRESOURCE(IDD_BLUETOOTHTEST_DIALOG));
	}
}
#endif

void CBluetoothTestDlg::SetButtonStatusOpen()
{

	m_Open.EnableWindow(FALSE);
	m_DeviceFind.EnableWindow(TRUE);
	m_ServiceFind.EnableWindow(FALSE);
	m_CreateConn.EnableWindow(FALSE);
	m_ConnFind.EnableWindow(TRUE);
	m_Connect.EnableWindow(FALSE);
	m_Disconnect.EnableWindow(FALSE);
	m_DeleteConn.EnableWindow(FALSE);
	m_Close.EnableWindow(TRUE);
	m_AllDelDevice.EnableWindow(TRUE);
	m_LocalInfo.EnableWindow(TRUE);
	m_Version.EnableWindow(TRUE);
}

void CBluetoothTestDlg::OnBnClickedBtnOpen()
{
	TCHAR* result = NULL;

	if(BLUETOOTH_Open())
	{
		m_List.DeleteAllItems();

		m_State.SetWindowText(L"Open Success");

		g_bBluetoothOpen = TRUE;
		
		SetButtonStatusOpen();
	}
	else 
		m_State.SetWindowText(L"Open Fail");
}


void CBluetoothTestDlg::OnBnClickedBtnClose()
{
	if(g_bBluetoothOpen == TRUE)
	{
		m_List.DeleteAllItems();
		m_Deviceitem.RemoveAll();

		EndWaitCursor();

		BLUETOOTH_Close();

		m_State.SetWindowText(L"Close Success");

		m_Open.EnableWindow(TRUE);
		m_DeviceFind.EnableWindow(FALSE);
		m_ServiceFind.EnableWindow(FALSE);
		m_CreateConn.EnableWindow(FALSE);
		m_ConnFind.EnableWindow(FALSE);
		m_Connect.EnableWindow(FALSE);
		m_Disconnect.EnableWindow(FALSE);
		m_DeleteConn.EnableWindow(FALSE);
		m_Close.EnableWindow(FALSE);
		m_AllDelDevice.EnableWindow(FALSE);
		m_LocalInfo.EnableWindow(FALSE);
		m_Version.EnableWindow(FALSE);

	}
	g_bBluetoothOpen = FALSE;
}

void CBluetoothTestDlg::OnBnClickedBtnDeviceFind()
{
	if(g_bBluetoothOpen == TRUE)
	{
		m_listtype = DeviceFind;

		m_List.DeleteAllItems();
		
		m_Deviceitem.RemoveAll();

		memset(&m_connectionInfo, 0, sizeof(m_connectionInfo));
		m_connectionInfo.Size = sizeof(BTP_Connection_Info_Ex_t);
		m_connectionInfo.ProfileType = BTP_PROFILE_SPP;

		CString strAddr;
		CString strName;

		BTP_Device_Find    deviceFind;
		BTP_Device_Info_t  deviceInfo;
		BTP_Device_Query_Ex_t deviceQuery;


		memset(&deviceQuery, 0, sizeof(deviceQuery));
		deviceQuery.Size = sizeof(BTP_Device_Query_Ex_t);

		deviceQuery.DeviceAttributes = BTP_DEVICE_ALL;
		deviceQuery.DeviceType = (m_connectionInfo.ProfileType == BTP_PROFILE_SPP ? bdAll : bdHID);

		deviceQuery.InquiryTimeout = 10;

		BeginWaitCursor();

		hResult = BLUETOOTH_FindFirstDeviceEx(&deviceFind, &deviceInfo, &deviceQuery);

		if (BTP_ERROR_SUCCESS == hResult)
		{
			EndWaitCursor();
			do
			{
				BTP_Device_Info_t  deviceInfo_temp;
				memcpy(&deviceInfo_temp,&deviceInfo,sizeof(BTP_Device_Info_t));

				m_Deviceitem.AddTail(deviceInfo_temp);

				hResult = BLUETOOTH_FindNextDevice(deviceFind, &deviceInfo);
			} while (BTP_ERROR_SUCCESS == hResult);      
		}
		BLUETOOTH_FindDeviceClose(deviceFind);

		int lmportdevicecount = m_Deviceitem.GetCount();
		int i = 0;

		for(i = lmportdevicecount-1;i>=0;i--)
		{
			deviceInfo =	m_Deviceitem.GetAt(m_Deviceitem.FindIndex(i));

			strName.Format(L"%s", CString(deviceInfo.Name));
			m_List.InsertItem(0,strName,0);

			strAddr.Format(L"%02X:%02X:%02X:%02X:%02X:%02X",
				deviceInfo.BD_ADDR.BD_ADDR5,
				deviceInfo.BD_ADDR.BD_ADDR4,
				deviceInfo.BD_ADDR.BD_ADDR3,
				deviceInfo.BD_ADDR.BD_ADDR2,
				deviceInfo.BD_ADDR.BD_ADDR1,
				deviceInfo.BD_ADDR.BD_ADDR0);

			m_List.SetItem(0,1,LVIF_TEXT,strAddr,NULL,NULL, NULL,NULL);
		}
		m_State.SetWindowText(L"Device Found");

		g_bAllDelDevice = FALSE;

		m_Open.EnableWindow(FALSE);
		m_DeviceFind.EnableWindow(TRUE);
		m_ServiceFind.EnableWindow(TRUE);
		m_CreateConn.EnableWindow(FALSE);
		m_ConnFind.EnableWindow(TRUE);
		m_Connect.EnableWindow(FALSE);
		m_Disconnect.EnableWindow(FALSE);
		m_DeleteConn.EnableWindow(FALSE);
		m_Close.EnableWindow(TRUE);
		m_AllDelDevice.EnableWindow(TRUE);
		m_LocalInfo.EnableWindow(TRUE);
		m_Version.EnableWindow(TRUE);
	}
}


void CBluetoothTestDlg::OnBnClickedBtnServiceFind()
{	
	if(g_bBluetoothOpen == TRUE && g_bAllDelDevice == FALSE && g_bListDevice == TRUE)
	{
		m_listtype = ServiceFind;

		m_List.DeleteAllItems();

		BTP_Service_Find        serviceFind;
		BTP_Service_Info_Ex_t   serviceInfo;
		BTP_Service_Query_t     serviceQuery;
		SDP_UUID_Entry_t        service[1];

		CString			strname;

		serviceInfo.Size = sizeof(BTP_Service_Info_Ex_t);

		memset(&serviceQuery, 0, sizeof(serviceQuery));

		serviceQuery.BD_ADDR = m_connectionInfo.BD_ADDR;
		serviceQuery.NumberServiceUUID = 1;
		serviceQuery.Service = service;
		service[0].SDP_Data_Element_Type = deUUID_16;


		switch(m_connectionInfo.ProfileType)
		{
		case BTP_PROFILE_SPP:
			if (128 == serviceUUID)
			{
				service[0].SDP_Data_Element_Type = deUUID_128;

				ASSIGN_UUID_128((service[0].UUID_Value.UUID_128),
					0x85, 0x60, 0xCA, 0x18,  // 0x8560CA18
					0x62, 0x3F,              // 0x623f
					0x4A, 0x77,              // 0x4a77
					0x9F, 0x5E, 0x3C, 0x52, 0x66, 0x68, 0x05, 0x1A); // 0x9f, 0x5e, 0x3c, 0x52, 0x66, 0x68, 0x05, 0x1a
			}
			else
			{
				ASSIGN_UUID_16((service[0].UUID_Value.UUID_16), 0x11, 0x01)
			}
			break;

		case BTP_PROFILE_HID_HOST:
		case BTP_PROFILE_HID_DEVICE:
			ASSIGN_UUID_16((service[0].UUID_Value.UUID_16), 0x11, 0x24)
				break;
		}

		BeginWaitCursor();

		hResult = BLUETOOTH_FindFirstServiceEx(&serviceFind, &serviceInfo, &serviceQuery);

		if (BTP_ERROR_SUCCESS == hResult)
		{
			do
			{
				m_connectionInfo.ProfileType  = serviceInfo.ProfileType;
				m_connectionInfo.MajorVersion = serviceInfo.MajorVersion;
				m_connectionInfo.MinorVersion = serviceInfo.MinorVersion;

				switch(m_connectionInfo.ProfileType)
				{
				case BTP_PROFILE_SPP:
					m_connectionInfo.ProfileInformation.RemoteSerialPortProfileInfo.RFCOMMServerPort  = serviceInfo.ProfileInformation.RemoteSerialPortProfileInfo.RFCOMMServerPort;
					m_connectionInfo.ProfileInformation.RemoteSerialPortProfileInfo.UseActiveSync     = serviceInfo.ProfileInformation.RemoteSerialPortProfileInfo.UseActiveSync;

					strname = serviceInfo.ServiceName;
					m_List.InsertItem(0, strname, 0);
					break;
// 				case BTP_PROFILE_UNKNOWN: 
// 					m_connectionInfo.ProfileInformation.RemoteSerialPortProfileInfo.RFCOMMServerPort  = serviceInfo.ProfileInformation.RemoteSerialPortProfileInfo.RFCOMMServerPort;
// 					m_connectionInfo.ProfileInformation.RemoteSerialPortProfileInfo.UseActiveSync     = serviceInfo.ProfileInformation.RemoteSerialPortProfileInfo.UseActiveSync;				
// 					break; 
// 
// 				case BTP_PROFILE_HID_HOST:
// 				case BTP_PROFILE_HID_DEVICE:
// 					m_connectionInfo.ProfileInformation.RemoteHIDProfileInfo.DeviceAutomaticReconnect = serviceInfo.ProfileInformation.RemoteHIDProfileInfo.DeviceAutomaticReconnect;
// 					m_connectionInfo.ProfileInformation.RemoteHIDProfileInfo.DeviceNormallyConnectable= serviceInfo.ProfileInformation.RemoteHIDProfileInfo.DeviceNormallyConnectable;
// 					m_connectionInfo.ProfileInformation.RemoteHIDProfileInfo.DeviceSubclass           = serviceInfo.ProfileInformation.RemoteHIDProfileInfo.DeviceSubclass;
// 					m_connectionInfo.ProfileInformation.RemoteHIDProfileInfo.L2CAPControlChannel      = serviceInfo.ProfileInformation.RemoteHIDProfileInfo.L2CAPControlChannel;
// 					m_connectionInfo.ProfileInformation.RemoteHIDProfileInfo.L2CAPInterruptChannel    = serviceInfo.ProfileInformation.RemoteHIDProfileInfo.L2CAPInterruptChannel;
// 					m_connectionInfo.ProfileInformation.RemoteHIDProfileInfo.VirtualCableSupported    = serviceInfo.ProfileInformation.RemoteHIDProfileInfo.VirtualCableSupported;
// 					break;
				}	

// 				strname = serviceInfo.ServiceName;
// 
// 				m_List.InsertItem(0, strname, 0);
				hResult = BLUETOOTH_FindNextServiceEx(serviceFind, &serviceInfo);

			} while (BTP_ERROR_SUCCESS == hResult);

			if (BTP_ERROR_NO_MORE != hResult)
				m_State.SetWindowText(L"Failed to Find Next Service");

			BLUETOOTH_FindServiceClose(serviceFind);
		}
		if(m_List.GetItemCount() > 0)
		{
			m_State.SetWindowText(L"Services found");
			m_CreateConn.EnableWindow(TRUE);
		}
		else
		{
			m_State.SetWindowText(L"Only Support SPP Profile.");

			m_List.InsertItem(0, L"Did not find the SPP Profile.");
			m_CreateConn.EnableWindow(FALSE);
		}

		EndWaitCursor();

		m_Open.EnableWindow(FALSE);
		m_DeviceFind.EnableWindow(TRUE);		
		m_ServiceFind.EnableWindow(TRUE);
		m_ConnFind.EnableWindow(TRUE);
		m_Connect.EnableWindow(FALSE);
		m_Disconnect.EnableWindow(FALSE);
		m_DeleteConn.EnableWindow(FALSE);
		m_Close.EnableWindow(TRUE);
		m_AllDelDevice.EnableWindow(FALSE);
		m_LocalInfo.EnableWindow(TRUE);
		m_Version.EnableWindow(TRUE);

	}
	else if(g_bAllDelDevice == TRUE)
	{
		m_State.SetWindowText(L"Please, Click the 'Device Find' button.");
		EndWaitCursor();
		return;
	}
	else if(g_bListDevice == FALSE)
	{
		m_State.SetWindowText(L"Please, Make a list of selection.");
		EndWaitCursor();
		return;
	}
}

void CBluetoothTestDlg::OnBnClickedBtnCreateConnection()
{
	if(g_bBluetoothOpen == TRUE && g_bListService == TRUE)
	{
		m_List.DeleteAllItems();

		m_connectionInfo.ConnectionAttributes = BTP_CONNECTION_REMEMBERED | BTP_CONNECTION_ACTIVE;
		m_connectionInfo.LocalCOMPort = 9;
		m_connectionInfo.ProfileType = BTP_PROFILE_SPP; 

		hResult = BLUETOOTH_CreateConnectionEx(&m_connectionInfo);

		if (BTP_ERROR_SUCCESS == hResult)
		{
			m_State.SetWindowText(L"Created connection");
			m_List.InsertItem(0, L"Created connection");

			m_Open.EnableWindow(FALSE);
			m_DeviceFind.EnableWindow(TRUE);
			m_ServiceFind.EnableWindow(TRUE);
			m_CreateConn.EnableWindow(FALSE);
			m_ConnFind.EnableWindow(TRUE);
			m_Connect.EnableWindow(FALSE);
			m_Disconnect.EnableWindow(FALSE);
			m_DeleteConn.EnableWindow(FALSE);
			m_Close.EnableWindow(TRUE);
			m_AllDelDevice.EnableWindow(FALSE);
			m_LocalInfo.EnableWindow(TRUE);
			m_Version.EnableWindow(TRUE);
		}
		else
		{
			m_State.SetWindowText(L"Create Connection Error");
			SetButtonStatusOpen();
			return;
		}

	}
	else if(g_bListService == FALSE)
	{
		m_State.SetWindowText(L"Please, Make a list of selection.");
		return;
	}
}

void CBluetoothTestDlg::OnBnClickedBtnDeleteConnection()
{
	if(g_bBluetoothOpen == TRUE)
	{
		m_List.DeleteAllItems();

		hResult = BLUETOOTH_DeleteConnection(m_connectionInfo.ConnectionID);

		if (BTP_ERROR_SUCCESS == hResult)
		{
			m_State.SetWindowText(L"Deleted Connection");

			m_Open.EnableWindow(FALSE);
			m_DeviceFind.EnableWindow(TRUE);
			m_ServiceFind.EnableWindow(FALSE);
			m_CreateConn.EnableWindow(FALSE);
			m_ConnFind.EnableWindow(TRUE);
			m_Connect.EnableWindow(FALSE);
			m_Disconnect.EnableWindow(FALSE);
			m_DeleteConn.EnableWindow(FALSE);
			m_Close.EnableWindow(TRUE);
			m_AllDelDevice.EnableWindow(TRUE);
			m_LocalInfo.EnableWindow(TRUE);
			m_Version.EnableWindow(TRUE);
		}
		else
		{
			m_State.SetWindowText(L"Delete Connection Error");
			SetButtonStatusOpen();
		}


	}
}

void CBluetoothTestDlg::OnBnClickedBtnConnectionFind()
{
	if(g_bBluetoothOpen == TRUE)
	{
		m_listtype = ConnectionFind;

		m_List.DeleteAllItems();
		m_Connectitem.RemoveAll();

		CString strID;
		CString strAddr;

		BTP_Connection_Find    connectFind;
		BTP_Connection_Info_t  connectionInfo;
		BTP_Connection_Query_t connectQuery;
		BTP_Connection_Info_t  connectInfo_temp;

		memset(&connectQuery, 0, sizeof(connectQuery));

		connectQuery.ConnectionAttributes = BTP_CONNECTION_REMEMBERED;

		BeginWaitCursor();

		hResult = BLUETOOTH_FindFirstConnection(&connectFind, &connectionInfo, &connectQuery);
		
		if (BTP_ERROR_SUCCESS == hResult)
		{
			EndWaitCursor();
			do
			{
				memcpy(&connectInfo_temp,&connectionInfo,sizeof(BTP_Connection_Info_t));		   
				m_Connectitem.AddTail(connectInfo_temp);

				hResult = BLUETOOTH_FindNextConnection(connectFind, &connectionInfo);
			} while (BTP_ERROR_SUCCESS == hResult); 
			
			if(BTP_ERROR_NO_MORE != hResult)
			{
				m_State.SetWindowText(L"Failed to find next connection.");
			}  
			BLUETOOTH_FindConnectionClose(connectFind);   
		}
		else
		{
			EndWaitCursor();
			m_State.SetWindowText(L"Connections can not find.");
			SetButtonStatusOpen();
			return;
		}
		
		int ImportDeviceCount = m_Connectitem.GetCount();
		int i = 0;

		for(i = ImportDeviceCount-1;i>=0;i--)
		{
			connectionInfo = m_Connectitem.GetAt(m_Connectitem.FindIndex(i));

			strID.Format(L"%d", connectionInfo.ConnectionID);
			m_List.InsertItem(0, strID, 0);

			strAddr.Format(L"%02X:%02X:%02X:%02X:%02X:%02X",
				connectionInfo.BD_ADDR.BD_ADDR5,
				connectionInfo.BD_ADDR.BD_ADDR4,
				connectionInfo.BD_ADDR.BD_ADDR3,
				connectionInfo.BD_ADDR.BD_ADDR2,
				connectionInfo.BD_ADDR.BD_ADDR1,
				connectionInfo.BD_ADDR.BD_ADDR0);
			m_List.SetItem(0, 1, LVIF_TEXT, strAddr, NULL, NULL, NULL, NULL);
		}
		m_State.SetWindowText(L"Connection Found");	

		m_Open.EnableWindow(FALSE);
		m_DeviceFind.EnableWindow(TRUE);
		m_ServiceFind.EnableWindow(FALSE);
		m_CreateConn.EnableWindow(FALSE);
		m_ConnFind.EnableWindow(FALSE);
		m_Connect.EnableWindow(TRUE);
		m_Disconnect.EnableWindow(FALSE);
		m_DeleteConn.EnableWindow(TRUE);
		m_Close.EnableWindow(TRUE);
		m_AllDelDevice.EnableWindow(TRUE);
		m_LocalInfo.EnableWindow(TRUE);	
		m_Version.EnableWindow(TRUE);
	}
}

void CBluetoothTestDlg::OnBnClickedBtnConnect()
{
	if(g_bBluetoothOpen == TRUE && g_bListConnection == TRUE)
	{
		m_List.DeleteAllItems();

		hResult = BLUETOOTH_Connect(m_connectionInfo.ConnectionID);

		//CreateFile((LPCWSTR)"COM9:", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

		if(BTP_ERROR_SUCCESS == hResult) 
		{
			m_State.SetWindowText(L"Connected");

			m_Open.EnableWindow(FALSE);
			m_DeviceFind.EnableWindow(FALSE);
			m_ServiceFind.EnableWindow(FALSE);
			m_CreateConn.EnableWindow(FALSE);
			m_ConnFind.EnableWindow(FALSE);
			m_Connect.EnableWindow(FALSE);
			m_Disconnect.EnableWindow(TRUE);
			m_DeleteConn.EnableWindow(FALSE);
			m_Close.EnableWindow(TRUE);
			m_AllDelDevice.EnableWindow(FALSE);
			m_LocalInfo.EnableWindow(TRUE);	
			m_Version.EnableWindow(TRUE);
		}
		else if(BTP_ERROR_INVALID_PARAMETER == hResult)
		{
			m_State.SetWindowText(L"Error Invalid parameter");
			SetButtonStatusOpen();
			return;
		}
		else
		{
			m_State.SetWindowText(L"Connect Error");
			SetButtonStatusOpen();
			return;
		}

	}
	else if(g_bListConnection == FALSE)
	{
		m_State.SetWindowText(L"Please, Make a list of selection.");
		SetButtonStatusOpen();
		return;
	}
}

void CBluetoothTestDlg::OnBnClickedBtnDisconnect()
{
	if(g_bBluetoothOpen == TRUE)
	{
		m_List.DeleteAllItems();

		hResult = BLUETOOTH_Disconnect(m_connectionInfo.ConnectionID);

		if(BTP_ERROR_SUCCESS == hResult) 
		{
			m_State.SetWindowText(L"Disconnected");
		}
		else if(BTP_ERROR_INVALID_PARAMETER == hResult)
		{
			m_State.SetWindowText(L"Error Invalid parameter");
		}
		else
		{
			m_State.SetWindowText(L"Disconnect Error");
		}

		m_Open.EnableWindow(FALSE);
		m_DeviceFind.EnableWindow(TRUE);
		m_ServiceFind.EnableWindow(FALSE);
		m_CreateConn.EnableWindow(FALSE);
		m_ConnFind.EnableWindow(TRUE);
		m_Connect.EnableWindow(FALSE);
		m_Disconnect.EnableWindow(FALSE);
		m_DeleteConn.EnableWindow(FALSE);
		m_Close.EnableWindow(TRUE);
		m_AllDelDevice.EnableWindow(FALSE);
		m_LocalInfo.EnableWindow(TRUE);
		m_Version.EnableWindow(TRUE);
	}
}

void CBluetoothTestDlg::OnBnClickedBtnLocalInfo()
{
	if(g_bBluetoothOpen == TRUE)
	{
		m_List.DeleteAllItems();

		DWORD classOfDevice;

		CString strName;
		CString strAddr;
		CString strClass;

		BTP_Find_Local_Device_From_BTE_t device;
		hResult = BLUETOOTH_FindLocalDevice(&device);

		if (BTP_ERROR_SUCCESS == hResult)
		{
			classOfDevice = (((unsigned int)device.DeviceInfo.ClassOfDevice.Class_of_Device0) << 16) | 
				(((unsigned int)device.DeviceInfo.ClassOfDevice.Class_of_Device1) << 8) |
				((unsigned int)device.DeviceInfo.ClassOfDevice.Class_of_Device2);

			strName.Format(L"%s",(CString)(device.DeviceInfo.Name));
			m_List.InsertItem(0, strName, 0);

			strAddr.Format(L"%02X:%02X:%02X:%02X:%02X:%02X",	
				device.DeviceInfo.BD_ADDR.BD_ADDR5,
				device.DeviceInfo.BD_ADDR.BD_ADDR4,
				device.DeviceInfo.BD_ADDR.BD_ADDR3,
				device.DeviceInfo.BD_ADDR.BD_ADDR2,
				device.DeviceInfo.BD_ADDR.BD_ADDR1,
				device.DeviceInfo.BD_ADDR.BD_ADDR0);
			m_List.SetItem(0,1,LVIF_TEXT,strAddr,NULL,NULL, NULL,NULL);

			strClass.Format(L"%u (0x%02X%02X%02X)",
				classOfDevice,
				device.DeviceInfo.ClassOfDevice.Class_of_Device0,
				device.DeviceInfo.ClassOfDevice.Class_of_Device1,
				device.DeviceInfo.ClassOfDevice.Class_of_Device2);
			m_List.SetItem(0,2,LVIF_TEXT,strClass,NULL,NULL, NULL,NULL);
		}
		m_State.SetWindowText(L"Local Information");

		m_Open.EnableWindow(FALSE);
		m_DeviceFind.EnableWindow(TRUE);
		m_ServiceFind.EnableWindow(FALSE);
		m_CreateConn.EnableWindow(FALSE);
		m_ConnFind.EnableWindow(TRUE);
		m_Connect.EnableWindow(FALSE);
		m_Disconnect.EnableWindow(FALSE);
		m_DeleteConn.EnableWindow(FALSE);
		m_Close.EnableWindow(TRUE);
		m_AllDelDevice.EnableWindow(TRUE);
		m_LocalInfo.EnableWindow(TRUE);
		m_Version.EnableWindow(TRUE);
	}
}

void CBluetoothTestDlg::OnBnClickedBtnAllOfDeleteDevice()
{
	if(g_bBluetoothOpen == TRUE)
	{
		m_List.DeleteAllItems();
		
		hResult = BLUETOOTH_PerformAction(BTP_ACTION_DELETE_ALL_DEVICES, 0, 0, NULL, NULL);

		if(BTP_ERROR_SUCCESS == hResult)
		{
			m_State.SetWindowText(L"All Of Delete Devices Success");

			m_Open.EnableWindow(FALSE);
			m_DeviceFind.EnableWindow(TRUE);
			m_ServiceFind.EnableWindow(FALSE);
			m_CreateConn.EnableWindow(FALSE);
			m_ConnFind.EnableWindow(TRUE);
			m_Connect.EnableWindow(FALSE);
			m_Disconnect.EnableWindow(FALSE);
			m_DeleteConn.EnableWindow(FALSE);
			m_Close.EnableWindow(TRUE);
			m_AllDelDevice.EnableWindow(FALSE);
			m_LocalInfo.EnableWindow(TRUE);
			m_Version.EnableWindow(TRUE);

			g_bAllDelDevice = TRUE;
		}
		else
		{
			CString strMsg;
			strMsg.Format(L"BTPPerformAction - %d", hResult);
			AfxMessageBox(strMsg);
		}
	}
}

void CBluetoothTestDlg::OnNMClickList(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	ASSERT(pNMListView);

	int nSelectNum = pNMListView->iItem;

	BTP_Device_Info_t deviceInfo;
	BTP_Connection_Info_t connectioninfo;
	BTP_Profile_Type profiletype;


	if(m_listtype == DeviceFind)
	{
		if(nSelectNum > 0 || nSelectNum == 0)
		{
			deviceInfo = m_Deviceitem.GetAt(m_Deviceitem.FindIndex(nSelectNum));
			m_connectionInfo.BD_ADDR = deviceInfo.BD_ADDR;
			profiletype = m_connectionInfo.ProfileType;

			g_bListDevice = TRUE;
		}
	}
	else if(m_listtype == ServiceFind)
	{
		if(nSelectNum >0 || nSelectNum == 0)
		{
			g_bListService = TRUE;
		}
	}
	else if(m_listtype == ConnectionFind)
	{
		if(nSelectNum > 0 || nSelectNum == 0)
		{
			connectioninfo =	m_Connectitem.GetAt(m_Connectitem.FindIndex(nSelectNum));
			m_connectionInfo.BD_ADDR = connectioninfo.BD_ADDR;
			m_connectionInfo.ConnectionID = connectioninfo.ConnectionID;

			g_bListConnection = TRUE;
		}	
	}
	*pResult = 0;
}

void CBluetoothTestDlg::OnBnClickedBtnVersion()
{
	TCHAR *tzVersion = new TCHAR[128];

	if(g_bBluetoothOpen == TRUE)
	{
		if(BLUETOOTH_GetVersionInfo(tzVersion))
		{
			CString cstrMsg;
			cstrMsg.Format(L"[ BLUETOOTH ]\n - %s\n - EXE : %s",tzVersion, VERSION_INFO);
			MessageBox(cstrMsg, L"VERSION");
		}
		else
		{
			AfxMessageBox(L"Fail");
		}
	}
}
