﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using com.caen.RFIDLibrary;

namespace RFID_UHF_Net
{
    public partial class SetPower : Form
    {
        System.Globalization.CultureInfo m_UsCultureInfo = new System.Globalization.CultureInfo("en-US");
        public bool m_bGlob_circ;
        public int m_nPower;
        private CAENRFIDReader m_Reader;

        public SetPower(CAENRFIDReader a_Reader)
        {
            InitializeComponent();
            m_Reader = a_Reader;

        }

        private void SetPower_Load(object sender, EventArgs e)
        {
            radioButton_Polarit_Circular.Checked = m_bGlob_circ;
            radioButton_Polarit_Linear.Checked = !m_bGlob_circ;

            Power.Text = CalculatePower1().ToString();
        }

        private int CalculatePower1()
        {                        
            m_nPower = getPower();
            int power;
            double ant = 0, cl = 0;
            ant = Double.Parse(AntennaGain.Text, m_UsCultureInfo);

            if (radioButton_Polarit_Circular.Checked)
                m_bGlob_circ = true;
            else
                m_bGlob_circ = false;

            if (m_bGlob_circ) ant -= 3;

            cl = Double.Parse(CableLoss.Text, m_UsCultureInfo);

            power = m_nPower;

            power = (int)(((double)power) * ((double)Math.Pow(10, ((ant - cl - 2.114) / 10))));


            System.Diagnostics.Debug.WriteLine(String.Format("Power- [GetPower:{0}],[ResultPower:{1}]", m_nPower, power));

            return power;
        }

        
        private int CalculatePower2()
        {

            double ant = 0, cl = 0;
            int pw = 0;

            if (radioButton_Polarit_Circular.Checked)
                m_bGlob_circ = true;
            else
                m_bGlob_circ = false;

            ant = Double.Parse(AntennaGain.Text, m_UsCultureInfo);

            if (radioButton_Polarit_Circular.Checked)
                ant -= 3;

            cl = Double.Parse(CableLoss.Text, m_UsCultureInfo);

            pw = int.Parse(Power.Text, m_UsCultureInfo);

            pw = (int)(pw / Math.Pow(10, ((ant - cl - 2.114) / 10)));

            System.Diagnostics.Debug.WriteLine(String.Format("Power- [InputPower:{0}],[ResultPower:{1}]", pw, Power.Text));

            return pw;
        }
        private int getPower()
        {
            int result;
            try
            {
                result = m_Reader.GetPower();
            }
            catch
            {
                result = -1;
            }
            return result;
        }

        private Boolean setPower(int pw)
        {
            try
            {
                m_Reader.SetPower(pw);
                return true;
            }
            catch (CAENRFIDException err)
            {
                return false;
            }
        }

        private void menuItem_Set_Click(object sender, EventArgs e)
        {
            
            m_nPower = CalculatePower2();


            if (!setPower(m_nPower))
            {
                MessageBox.Show("Set Power Fail!");
            }

            Close();
        }

        private void menuItem_Cancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void radioButton_Polarit_CheckedChanged(object sender, EventArgs e)
        {
            Power.Text = CalculatePower1().ToString();
        }

        private void Power_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == Convert.ToChar(Keys.Enter))
            {
                m_nPower = CalculatePower2();

                if (!setPower(m_nPower))
                {
                    MessageBox.Show("Set Power Fail!");
                }

            }
        }

    }
}