﻿// v.1.0.1 RF Regulation CHINA 추가와 태그 구조체를 260 -> 1024 로 변경 [6/5/2012 JJ]
// [8/14/2012 JJ] v.1.0.2 KOREA 추가 했음. 하지만 에러가 나지만 기능상의 문제가 있는지는 확인 필요. 
// v.1.0.3 POWER 설정 부분 추가 [4/5/2013 JJ]

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using com.caen.RFIDLibrary;

namespace RFID_UHF_Net
{
    public enum MemoryBankType
    {
        Other = -1,
        Reserved = 0,
        EPC = 1,
        TID = 2,
        USER = 3
    };

    public partial class Form_Main : Form
    {
        public String m_strAppVersion = "1.0.3";
        public String m_strAppRelease = "2013-04-24";
        private CAENRFIDReader m_Reader;

        public bool m_bSoundEnable = true;
        public bool m_bTIDVisible = false;
        public bool m_bAccessWord = true;
        
        // Continuous Read
        public bool m_bTIDMode = false;
        public bool m_bOneRead = false;
        // 

        // memory Access
        MemoryBankType m_MemBank = MemoryBankType.EPC;
        int m_nStartAddr = 0;
        int m_nAccessLength = 12;
        //

        //Power
        public bool m_bGlob_circ = true;
        //

        private bool m_bConnect = false;

        public Form_Main()
        {
            InitializeComponent();
        }

        private void Form_Main_Load(object sender, EventArgs e)
        {
            m_Reader = new CAENRFIDReader();

            try
            {
                m_Reader.Connect(CAENRFIDPort.CAENRFID_RS232, "MOC1");

                System.Threading.Thread.Sleep(500);

                UpdateInformation();

                m_bConnect = true;
            }
            catch (CAENRFIDException err)
            {
                label_Information.Text = "Status: Connect Error\n" + err.Message;

                m_bConnect = false;
                return;
            }

        }

        private void UpdateInformation()
        {            
            CAENRFIDRFRegulations rf = m_Reader.GetRFRegulation();
            CAENRFIDProtocol protocol = m_Reader.GetProtocol();
            String strRfRegulation = "";
            String strProtocol = "";

            switch(rf)
            {
                case CAENRFIDRFRegulations.ETSI_302208:
                    strRfRegulation = "ETSI 302208";
                    break;
                case CAENRFIDRFRegulations.FCC_US:
                    strRfRegulation = "FCC US";
                    break;
                case CAENRFIDRFRegulations.CHINA:
                    strRfRegulation = "CHINA";
                    break;
                case CAENRFIDRFRegulations.KOREA:
                    strRfRegulation = "KOREA";
                    break;
                default:
                    break; 
            }

            switch(protocol)
            {
                case CAENRFIDProtocol.CAENRFID_EPC_C1G2:
                    strProtocol = "EPC Class1 Gen2";
                    break;
                default:
                    strProtocol = "No Protocol";
                    break;
            }



            String strInformation = "APP Version: " + m_strAppVersion + "\n" +
                                    "APP Release: " + m_strAppRelease + "\n" +
                                    "DLL Version: " + CAENRFIDReader.Version + "\n" +
                                    "Firmware: " + m_Reader.GetFirmwareRelease() + "\n" +
                                    "RF Regulation: " + strRfRegulation + "\n" +
                                    "Reader Protocol: " + strProtocol;

            label_Information.Text = strInformation;

            if(m_Reader.GetFirmwareRelease() == "1.2.1")
            {
                m_bTIDVisible = false;
            }
            else
            {
                m_bTIDVisible = true;
            }
        }

        private void button_Continue_Click(object sender, EventArgs e)
        {
            Form_Continue formContinue = new Form_Continue(m_Reader);
            formContinue.m_bSoundEnable = m_bSoundEnable;

            formContinue.m_bOneRead = m_bOneRead;
            formContinue.m_bTIDMode = m_bTIDMode;
            formContinue.m_bTIDVisible = m_bTIDVisible;

            formContinue.ShowDialog();
            m_bOneRead = formContinue.m_bOneRead;
            m_bTIDMode = formContinue.m_bTIDMode;
        }

        private void button_Memory_Click(object sender, EventArgs e)
        {
            Form_Read formRead = new Form_Read(m_Reader);
            formRead.m_bSoundEnable = m_bSoundEnable;
            formRead.m_bAccessWord = m_bAccessWord;

            formRead.m_MemBank = m_MemBank;
            formRead.m_nStartAddr = m_nStartAddr;
            formRead.m_nAccessLength = m_nAccessLength;
            
            formRead.ShowDialog();
            
            m_MemBank = formRead.m_MemBank;
            m_nStartAddr = formRead.m_nStartAddr;
            m_nAccessLength = formRead.m_nAccessLength;
            m_bAccessWord = formRead.m_bAccessWord;

        }

        private void button_Setting_Click(object sender, EventArgs e)
        {
            Form_Setting formSetting = new Form_Setting(m_Reader);
            formSetting.m_bSoundEnable = m_bSoundEnable;
            formSetting.m_bAccessWord = m_bAccessWord;

            formSetting.ShowDialog();

            m_bSoundEnable = formSetting.m_bSoundEnable;
            m_bAccessWord = formSetting.m_bAccessWord;

            UpdateInformation();
        }

        private void Form_Main_Closing(object sender, CancelEventArgs e)
        {
            if(m_bConnect == true)
            {
                if (m_Reader != null) m_Reader.Disconnect();
            }
        }

        private void button_Power_Click(object sender, EventArgs e)
        {
            SetPower formPower = new SetPower(m_Reader);
            formPower.m_bGlob_circ = m_bGlob_circ;

            formPower.ShowDialog();
            m_bGlob_circ = formPower.m_bGlob_circ;
        }
    }
}