// UHF_GunTestDlg.h : header file
//

#pragma once
#include "afxcmn.h"
#include "afxwin.h"

#include<map>

using namespace std;

// CUHF_GunTestDlg dialog
class CUHF_GunTestDlg : public CDialog
{
// Construction
public:
	CUHF_GunTestDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_UHF_GUNTEST_DIALOG };


protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void OnOK();
	virtual BOOL PreTranslateMessage(MSG* pMsg);

// Implementation
protected:
	static BOOL m_bSoundPlay;
	BOOL m_bOpen;
	BOOL m_bStartInventory;
	BOOL m_bTriggerUp;
	static UINT SoundThreadProcNew( LPVOID pParam  );
	static UINT SoundThreadProcRead( LPVOID pParam  );
	// static UINT ManagePowerThread( LPVOID pParam  );
	BOOL OpenRFID(BOOL bOpen);
	LRESULT ReceivedInventory(WPARAM wParam, LPARAM lParam);
	LRESULT ReceivedPower(WPARAM wParam, LPARAM lParam);
	void InsertListBox(LPCTSTR strTagData, int nIndex );	
	int FindAndInsertDataIntoMap(LPCTSTR strData);

	HICON m_hIcon;
	BOOL IsEnoughBattery();
	void SetBatteryProgress();	
	///2014.02.XX ߰...
	BOOL ExportResultToTXT();
	static UINT PlaySoundThread(LPVOID lpData );

	// Generated message map functions
	virtual BOOL OnInitDialog();
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	afx_msg void OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/);
#endif
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButtonStart();
	CListCtrl m_lstResult;
	CButton m_chkCRC;
	CString m_strTagCount;
	afx_msg void OnMenuAccess();
	afx_msg void OnMenuConfig2();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	CString m_strStatus;
	afx_msg void OnBnClickedButtonClear();
	void Inventory(BOOL bStart);
	void CheckBattery();
	
	CProgressCtrl m_ctrBattery;
	afx_msg void OnBnClickedButtonBattApply();
	float m_fCutOffValue;
	UINT m_nReadingDelay;
	CButton m_chkOnce;
	CString m_strScanEmulData;
	CButton m_chkMultiOnce;
	afx_msg void OnBnClickedButtonExport();
	HANDLE m_hReadSoundEvent;
	HANDLE m_hNewReadSoundEvent;
	HANDLE m_hExitEvent;
	HANDLE m_hSoundThread;
	BOOL m_bNeedSound;

private :
	map<string,int> m_hmTagData;

public:
	afx_msg void OnDestroy();
	CProgressCtrl m_prgCtrl;
};
