// UHF_GunTestDlg.cpp : implementation file
//				CE տ - ̾α  ߱ [9/17/2013 JJ]
//				UHF    [10/24/2013 JJ]
// v.1.0.0		͸ ¡ 5ܰ  [10/29/2013 JJ]
//				Antenna   ̾α ߰ [10/29/2013 JJ]
//				Powerüũ DLL  [11/13/2013 JJ]
//				Once Reading ߰ [11/14/2013 JJ]
//				Emul   ÿ Ʈ ڽ   [11/20/2013 JJ]
//				Firmware Version, Multi One Reading ߰ [12/3/2013 JJ]
// v.1.0.0.6	±     [2014-03-19 JJ]
// v.1.0.1		Ⱦ κ  [2014-04-24 JJ]


#include "stdafx.h"
#include "UHF_GunTest.h"
#include "UHF_GunTestDlg.h"
#include "UHFAccessDlg.h"
#include "UHFAntennaDlg.h"
#include <string>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define TIMER_BATTERY			(WM_USER + 0x1002)

BOOL CUHF_GunTestDlg::m_bSoundPlay = FALSE;

// CUHF_GunTestDlg dialog

CUHF_GunTestDlg::CUHF_GunTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUHF_GunTestDlg::IDD, pParent)
	, m_strTagCount(_T(""))
	, m_strStatus(_T(""))
	, m_fCutOffValue(3.4f)
	, m_nReadingDelay(0)
	, m_strScanEmulData(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_bSoundPlay = FALSE;
	m_bOpen = FALSE;
	m_bStartInventory = FALSE;
	m_bTriggerUp = TRUE;

	m_hReadSoundEvent = NULL;
	m_hNewReadSoundEvent = NULL;
	m_hExitEvent = NULL;
	m_hSoundThread = NULL;
	m_bNeedSound = TRUE;	
}

void CUHF_GunTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_RESULT, m_lstResult);
	DDX_Control(pDX, IDC_CHECK_CRC, m_chkCRC);
	DDX_Text(pDX, IDC_STATIC_TAG_COUNT, m_strTagCount);
	DDX_Control(pDX, IDC_PROGRESS_BATT, m_ctrBattery);
	DDX_Text(pDX, IDC_EDIT_CUT_OFF, m_fCutOffValue);
	DDX_Text(pDX, IDC_EDIT_DELAY, m_nReadingDelay);
	DDX_Control(pDX, IDC_CHECK_ONCE, m_chkOnce);
	DDX_Text(pDX, IDC_EDIT_EMUL, m_strScanEmulData);
	DDX_Control(pDX, IDC_CHECK_MULTI_ONCE, m_chkMultiOnce);
	DDX_Control(pDX, IDC_PROGRESS_EXPORT, m_prgCtrl);
}

BEGIN_MESSAGE_MAP(CUHF_GunTestDlg, CDialog)
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	ON_WM_SIZE()
#endif
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_MSG_INVENTORY, ReceivedInventory)
	ON_MESSAGE(WM_MSG_POWER, ReceivedPower)
	ON_BN_CLICKED(IDC_BUTTON_START, &CUHF_GunTestDlg::OnBnClickedButtonStart)
	ON_COMMAND(ID_MENU_ACCESS2, &CUHF_GunTestDlg::OnMenuAccess)
	ON_COMMAND(ID_MENU_CONFIG2, &CUHF_GunTestDlg::OnMenuConfig2)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, &CUHF_GunTestDlg::OnBnClickedButtonClear)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_BATT_APPLY, &CUHF_GunTestDlg::OnBnClickedButtonBattApply)
	ON_BN_CLICKED(IDC_BUTTON_EXPORT, &CUHF_GunTestDlg::OnBnClickedButtonExport)
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CUHF_GunTestDlg message handlers

BOOL CUHF_GunTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	SetWindowText(L"RFID_UHF");	

	m_bStartInventory = FALSE;

	CString strstatus;

	m_lstResult.SetExtendedStyle(LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT /*| LVS_EX_CHECKBOXES*/);
	m_lstResult.DeleteAllItems();

	CString coltext[2] = {_T("EPC"), _T("Cnt")};
	int nScreenWidth = GetSystemMetrics(SM_CXSCREEN);
	int colsize[2] = { int(nScreenWidth*0.7), int(nScreenWidth * 0.16)};
	LV_COLUMN lvc;

	for(int i=0;i<2;i++)
	{
		lvc.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH;
		lvc.fmt = LVCFMT_CENTER;
		lvc.iSubItem = i;
		lvc.pszText = (LPWSTR)(LPCTSTR)coltext[i];
		lvc.cx = colsize[i];
		m_lstResult.InsertColumn(i, &lvc);
	}

	if(!OpenRFID(TRUE))
	{
		strstatus.Format(_T("RFID Init Error"));
		MessageBox(strstatus);

		CDialog::OnCancel();
	}

	m_bOpen = TRUE;

	SetTimer(TIMER_BATTERY, 10 * 60 * 1000, NULL);


	// Menu
	SHMENUBARINFO mbi;

	HINSTANCE hInst = AfxGetInstanceHandle();

	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize = sizeof(SHMENUBARINFO);
	mbi.hwndParent = m_hWnd;
	mbi.nToolBarId = IDR_MENU_UHF;
	mbi.hInstRes = hInst;
	mbi.dwFlags = SHCMBF_HMENU;

	SHCreateMenuBar(&mbi);
		

	m_strTagCount.Format(L"TAG - 00");

	UpdateData(FALSE);

	SetDialogSize(m_hWnd);

	m_ctrBattery.SetRange(BATTERY_0, BATTERY_FULL);
	CheckBattery();

	if ( m_hReadSoundEvent == NULL )
	{
		m_hReadSoundEvent = ::CreateEvent( NULL, FALSE, FALSE, NULL );
		if ( m_hReadSoundEvent == INVALID_HANDLE_VALUE )
		{
			AfxMessageBox( _T("Read Sound Event Creation Failed.") );
			return FALSE;
		}
	}

	if ( m_hNewReadSoundEvent == NULL )
	{
		m_hNewReadSoundEvent = ::CreateEvent( NULL, FALSE, FALSE, NULL );
		if ( m_hNewReadSoundEvent == INVALID_HANDLE_VALUE )
		{
			AfxMessageBox( _T("Read Sound Event Creation Failed.") );
			return FALSE;
		}
	}

	if ( m_hExitEvent == NULL )
	{
		m_hExitEvent = ::CreateEvent( NULL, FALSE, FALSE, NULL );
		if ( m_hExitEvent == INVALID_HANDLE_VALUE )
		{
			AfxMessageBox( _T("Exit Event Creation Failed.") );
			return FALSE;
		}
	}

	if ( m_hSoundThread == NULL )
	{
		m_hSoundThread = ::CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)PlaySoundThread, this, 0, NULL );

		if ( m_hSoundThread == INVALID_HANDLE_VALUE )
		{
			AfxMessageBox( _T("Sound Thread Creation Failed.") );
			return FALSE;
		}
	}

	if ( !m_hmTagData.empty() )
		m_hmTagData.clear();

	CRect rect;

	GetClientRect( &rect );

	int nRightPos = rect.right;

	m_prgCtrl.GetWindowRect( &rect );

	ScreenToClient( &rect );

	m_prgCtrl.MoveWindow( rect.left, rect.top, nRightPos - rect.left, rect.bottom - rect.top );

	m_bNeedSound = TRUE;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
void CUHF_GunTestDlg::OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/)
{
	if (AfxIsDRAEnabled())
	{
		DRA::RelayoutDialog(
			AfxGetResourceHandle(), 
			this->m_hWnd, 
			DRA::GetDisplayMode() != DRA::Portrait ? 
			MAKEINTRESOURCE(IDD_UHF_GUNTEST_DIALOG_WIDE) : 
			MAKEINTRESOURCE(IDD_UHF_GUNTEST_DIALOG));
	}
}
#endif

void CUHF_GunTestDlg::SetBatteryProgress()
{
	/*
	LONG    left;
	LONG    top;
	LONG    right;
	LONG    bottom;
	*/

	RECT rBattery, rBatteryPos;
	CString msg;
	m_ctrBattery.GetClientRect(&rBattery);
	msg.Format(L"GetClientRect\r\nleft: %d \r\n top %d \r\n right: %d \r\n bottom: %d", rBattery.left, rBattery.top, rBattery.right, rBattery.bottom);
	// AfxMessageBox(msg);

	m_ctrBattery.GetWindowRect(&rBatteryPos);
	msg.Format(L"GetWindowRect\r\nleft: %d \r\n top %d \r\n right: %d \r\n bottom: %d", rBatteryPos.left, rBatteryPos.top, rBatteryPos.right, rBatteryPos.bottom);
	// AfxMessageBox(msg);

	TCHAR PType[64];
	SystemParametersInfo(SPI_GETPLATFORMTYPE , 64, PType, SPIF_SENDCHANGE)	;  //"PocketPC"
	if(wcscmp(PType,L"PocketPC") != 0)
	{
		// m_ctrBattery.MoveWindow(rBatteryPos.left, rBatteryPos.top - 20, rBattery.right -5, rBattery.bottom, TRUE);
		// m_ctrBattery.SetWindowPos(&CWnd::wndTop, rBatteryPos.left, rBatteryPos.top - 18, rBattery.right + 3, rBattery.bottom + 3, SWP_NOZORDER);
	}

	// m_ctrBattery.SetPos(2);
	
}

void CUHF_GunTestDlg::OnOK()
{

	KillTimer(TIMER_BATTERY);

	if(m_bOpen == TRUE)
	{
		OpenRFID(FALSE);
		m_bOpen = FALSE;
	}
		
	CDialog::OnOK();

}

BOOL CUHF_GunTestDlg::IsEnoughBattery()
{

	RFID_STATUS status;
	INT32U nPercent = 0;
	INT32U nADC = 0;
	float fVolt;
	// 0x2F8 - 3.4V
	// 0x2DE - 3.3V

	status = UHF_ReadBattery(&nADC, &fVolt);
	if(fVolt < m_fCutOffValue && status == RFID_STATUS_OK)
	{	
		return FALSE;				
	}
	else
	{
		return TRUE;
	}

}

void CUHF_GunTestDlg::Inventory(BOOL bStart)
{
	if(!m_bOpen)
		return;

	if(bStart)
	{
		if(!IsEnoughBattery())
		{
			MessageBox(L"It need more battery power.", L"CAUTION", NULL);

			OnOK();
		}
		

		UHF_Inventory(m_hWnd);
		m_bStartInventory = TRUE;
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_START), L"STOP");
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"Read Inventory");

	}
	else
	{
		UHF_InventoryStop();
		m_bStartInventory = FALSE;
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_START), L"START");
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"Stop Read");
	}
}

BOOL CUHF_GunTestDlg::OpenRFID(BOOL bOpen)
{
	if(bOpen)
	{

		RFID_STATUS status;
		CString strstatus;
		
		status = UHF_Init(m_hWnd);
		if(status != RFID_STATUS_OK)
		{
			strstatus.Format(_T("RFID Init Error-[%x]"),status);
			// MessageBox(strstatus);

			return FALSE;
		}
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"Open UHF");

	}
	else
	{
		RFID_STATUS status;
		CString strstatus;

		status = UHF_Close();
		if(status != RFID_STATUS_OK)
		{
			strstatus.Format(_T("%x"),status);
			// MessageBox(_T("RFID Close Error"), strstatus);

			return FALSE;
		}

		// MessageBox(L"Close");
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_STATUS), L"Close UHF");
	}

	return TRUE;
}


void CUHF_GunTestDlg::OnBnClickedButtonStart()
{
	Inventory(!m_bStartInventory);
}

///2014.02.12 string version

LRESULT CUHF_GunTestDlg::ReceivedInventory(WPARAM wParam, LPARAM lParam)
{
	if(m_bStartInventory == FALSE)
		return 0;

	int nTaglength = 0;
	unsigned char czTagData[128] = {0,};
	CString strTagData;	

	nTaglength = UHF_GetData(czTagData);

	Sleep(m_nReadingDelay);

	if(m_chkCRC.GetCheck())
	{
		for(int i=0;i<nTaglength;i++)
		{
			strTagData.AppendFormat(_T("%02X"), czTagData[i]);
		}
	}
	else
	{
		for(int i=0;i<nTaglength-2;i++)
		{
			strTagData.AppendFormat(_T("%02X"), czTagData[i]);
		}
	}

	int nIndex = FindAndInsertDataIntoMap(strTagData.GetBuffer(0));

	if(nIndex == -1 || m_chkMultiOnce.GetCheck() == BST_UNCHECKED)
	{
		InsertListBox(strTagData.GetBuffer(0), nIndex );
	}
	

	m_strTagCount.Format(L"TAG - %02d", m_lstResult.GetItemCount());

	UpdateData(FALSE);

	if(m_chkOnce.GetCheck() == BST_CHECKED)
	{
		Inventory(FALSE);
	}

	return LRESULT();
}

int CUHF_GunTestDlg::FindAndInsertDataIntoMap(LPCTSTR strData)
{

	string szData = CT2CA( strData);

	int nIndex = -1;

	if ( m_hmTagData.empty() )
	{
		m_hmTagData.insert(map<string,int>::value_type(szData, 0));
	}
	else
	{
		map<string,int>::iterator itFound = m_hmTagData.find(szData);

		if ( itFound != m_hmTagData.end() )
		{
			nIndex = itFound->second;						
		}
		else
		{
			m_hmTagData.insert( map<string, int>::value_type(szData, m_lstResult.GetItemCount() ));
			
		}
	}	

	return nIndex;
		
}

void CUHF_GunTestDlg::InsertListBox(LPCTSTR strTagData, int nIndex )
{
	LV_ITEM  lvi;	
	CString strExistedTagData;	
	int nTagCount = m_lstResult.GetItemCount();		

	lvi.mask = LVIF_TEXT;

	if (nIndex == -1)
	{
		lvi.iItem = nTagCount;
		lvi.iSubItem = 0;
		lvi.pszText = (LPWSTR)(LPCTSTR)strTagData;
		m_lstResult.InsertItem(&lvi);

		lvi.iSubItem = 1;
		strExistedTagData.Format(_T("%d"),1);
		lvi.pszText = (LPWSTR)(LPCTSTR)strExistedTagData;
		m_lstResult.SetItem(&lvi);

		SetEvent( m_hNewReadSoundEvent );

	}
	else
	{
		strExistedTagData = m_lstResult.GetItemText(nIndex, 1);
		int inc = _ttoi(strExistedTagData)+1;
		lvi.iItem = nIndex;
		lvi.iSubItem = 1;
		strExistedTagData.Format(_T("%d"),inc);
		lvi.pszText = (LPWSTR)(LPCTSTR)strExistedTagData;
		m_lstResult.SetItem(&lvi);

		SetEvent( m_hReadSoundEvent );

	}
}

UINT CUHF_GunTestDlg::SoundThreadProcNew( LPVOID pParam  )
{			
	HINSTANCE hInst = AfxGetInstanceHandle(); 

	PlaySound(MAKEINTRESOURCE(IDR_WAVE_NEW), hInst,SND_RESOURCE|SND_ASYNC);

	return 0;
}

UINT CUHF_GunTestDlg::SoundThreadProcRead( LPVOID pParam  )
{			
	HINSTANCE hInst = AfxGetInstanceHandle(); 

	PlaySound(MAKEINTRESOURCE(IDR_WAVE_READ), hInst,SND_RESOURCE|SND_ASYNC);

	return 0;
}
void CUHF_GunTestDlg::OnMenuAccess()
{
	if(!m_bOpen)
		return;

	CUHFAccessDlg dlg;
	dlg.DoModal();
}

void CUHF_GunTestDlg::OnMenuConfig2()
{
	CUHFAntennaDlg dlg;
	dlg.DoModal();
}

BOOL CUHF_GunTestDlg::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->wParam == VK_F14 || pMsg->wParam == VK_F22) // F14:WM / F22:CE
	{
		if(pMsg->message == WM_KEYDOWN) 
		{
			if(/*m_bStartInventory == FALSE &&*/ m_bTriggerUp == TRUE)
			{
				m_bTriggerUp = FALSE;

				Inventory(TRUE);
			}
		}
		else if(pMsg->message == WM_KEYUP)
		{

			if(/*m_bStartInventory == TRUE &&*/ m_bTriggerUp == FALSE)
			{
				m_bTriggerUp = TRUE;

				Inventory(FALSE);
			}
		}
	}

	if(pMsg->wParam == VK_RETURN)
	{
		UpdateData(TRUE);
		
		if(m_strScanEmulData.GetLength() > 0)
		{
			int nIndex = FindAndInsertDataIntoMap(m_strScanEmulData.GetBuffer(0));

			if(nIndex == -1 || m_chkMultiOnce.GetCheck() == BST_UNCHECKED)
			{
				InsertListBox(m_strScanEmulData.GetBuffer(0), nIndex );
			}

			m_strScanEmulData = "";
		}

		UpdateData(FALSE);

		return TRUE;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CUHF_GunTestDlg::OnTimer(UINT_PTR nIDEvent)
{
	switch(nIDEvent)
	{
	case TIMER_BATTERY:
		{
			CheckBattery();
		}
		break;

	}

	CDialog::OnTimer(nIDEvent);
}

LRESULT CUHF_GunTestDlg::ReceivedPower(WPARAM wParam, LPARAM lParam)
{
	BOOL* bPowerOn = (BOOL*)wParam;

// 	CString strMsg;
// 	strMsg.Format(L"Power: [%x][%x]", wParam, *bPowerOn);
// 	MessageBox(strMsg, NULL, NULL);

	BeginWaitCursor();
	if(*bPowerOn)
	{
		if(m_bOpen == FALSE)
		{
			if(OpenRFID(TRUE))
			{
				CheckBattery();

				m_bOpen = true;
			}
		}
		
	}
	else
	{
		if(m_bOpen == TRUE)
		{

			OpenRFID(FALSE);
			m_bOpen = FALSE;
		}

	}
	EndWaitCursor();


	return 0;	
}
void CUHF_GunTestDlg::CheckBattery()
{	

	if(!UHF_IsReady())
		return;

	if(m_bStartInventory)
		return;
	
	RFID_STATUS status;
	INT32U nADC = 0;
	float fVolt;
	BATTERY_STATUS battstatus;

	UHF_ReadBattery(&nADC, &fVolt);
	status = UHF_ReadBatteryStatus(&battstatus);

	m_strStatus.Format(_T("%.2f(%d)"),fVolt, battstatus);
	// MessageBox(m_strBattery, _T("Read Error!"));
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_BATTERY), m_strStatus);

	if (RFID_STATUS_OK != status)
	{
		CString strstatus;
		strstatus.Format(_T("Battery Error [0x%x]"),status);
		// MessageBox(strstatus, _T("Read Error!"));
	}
	else
	{
		m_strStatus.Format(_T("%.2f(%d)"),fVolt, battstatus);

		m_ctrBattery.SetPos(battstatus);

	}
}


void CUHF_GunTestDlg::OnBnClickedButtonClear()
{
	m_lstResult.DeleteAllItems();
	m_strTagCount.Format(L"TAG - 00");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_EMUL), L"");

	if ( !m_hmTagData.empty() )
	{
/*
		for ( map<unsigned char*,int, cmp_bytes>::iterator it = m_hmTagData.begin() ; it != m_hmTagData.end() ; ++it )
		{
			::HeapFree(::GetProcessHeap(), 0, it->first);
		}

*/		m_hmTagData.clear();
	}

	UpdateData(FALSE);
}
void CUHF_GunTestDlg::OnBnClickedButtonBattApply()
{
	UpdateData(TRUE);

	UpdateData(FALSE);
}

BOOL CUHF_GunTestDlg::ExportResultToTXT()
{
	int nTagCount = m_lstResult.GetItemCount();

	if ( nTagCount <= 0 )
		return FALSE;

	CString strTagData = _T("");
	
	SYSTEMTIME sysTime;
	memset( &sysTime, 0x00, sizeof(SYSTEMTIME) );

	::GetSystemTime( &sysTime );

	TCHAR szExportFullPath[MAX_PATH] = { 0, };
	TCHAR szExportFileName[32] = { 0, };
	int nFileCount = 1;
	_stprintf( szExportFileName, _T("%d-%02d-%02d_%02d%02d_%02d.txt"), sysTime.wYear, sysTime.wMonth, sysTime.wDay, sysTime.wHour, sysTime.wMinute, nFileCount);

	::GetModuleFileName( NULL, szExportFullPath, MAX_PATH );

	TCHAR *pDest = _tcsrchr( szExportFullPath, _T('\\') );

	if ( pDest == NULL )
		return FALSE;

	int nPos = pDest - szExportFullPath + 1;

	szExportFullPath[nPos] = '\0';

	_tcscat( szExportFullPath, szExportFileName );
	

	HANDLE hExportFile = ::CreateFile( szExportFullPath, GENERIC_WRITE, 0, NULL, CREATE_NEW, 0, NULL );
	

	if ( hExportFile == INVALID_HANDLE_VALUE )
	{
		BOOL bOk = TRUE;

		do
		{
			if ( ::GetLastError() == ERROR_FILE_EXISTS )
			{
				pDest = NULL;
				pDest = _tcsrchr( szExportFullPath, _T('\\') );

				if ( pDest == NULL )
					return FALSE;

				nPos = -1;
				nPos = pDest - szExportFullPath + 1;

				szExportFullPath[nPos] = '\0';

				nFileCount++;

				memset( szExportFileName, 0x00, sizeof(TCHAR) * 32 );

				_stprintf( szExportFileName, _T("%d-%02d-%02d_%02d%02d_%02d.txt"), sysTime.wYear, sysTime.wMonth, sysTime.wDay, sysTime.wHour, sysTime.wMinute, nFileCount);
				_tcscat( szExportFullPath, szExportFileName );

				hExportFile = ::CreateFile( szExportFullPath, GENERIC_WRITE, 0, NULL, CREATE_NEW, 0, NULL );				
			}
			else
			{
				bOk = FALSE;
				break;
			}

		} while ( hExportFile == INVALID_HANDLE_VALUE );

		if ( !bOk )
			return FALSE;		
	}

	if (0xFFFFFFFF == SetFilePointer(hExportFile, 0, NULL, FILE_END))
		return FALSE;	

	BYTE byUniCode[2] = { 0xff, 0xfe };

	DWORD dwSize = 0;

	::WriteFile( hExportFile, byUniCode, 2, &dwSize, NULL );

	m_prgCtrl.SetRange32(0, nTagCount );
	
	for ( int i = 0 ; i < nTagCount ; i++ )
	{
		strTagData = m_lstResult.GetItemText(i, 0);

		strTagData += _T("\r\n");

		::WriteFile( hExportFile, strTagData.GetBuffer(0), strTagData.GetLength() * 2, &dwSize, NULL );

		m_prgCtrl.SetPos(++i);

	}

	CloseHandle( hExportFile );

	hExportFile = NULL;

	return TRUE;
}

void CUHF_GunTestDlg::OnBnClickedButtonExport()	
{
	HCURSOR hCursor = SetCursor(LoadCursor(NULL,IDC_WAIT));;

	BOOL bResult = ExportResultToTXT();

	SetCursor( hCursor );

	if ( bResult )
		AfxMessageBox( _T("Success!!") );
	else
		AfxMessageBox( _T("Fail!!") );



	m_prgCtrl.SetPos(0);
}

UINT CUHF_GunTestDlg::PlaySoundThread(LPVOID lpData )
{
	CUHF_GunTestDlg* pDlg = (CUHF_GunTestDlg*)lpData;

	HANDLE hEvent[3];
	hEvent[0] = pDlg->m_hReadSoundEvent;
	hEvent[1] = pDlg->m_hNewReadSoundEvent;
	hEvent[2] = pDlg->m_hExitEvent;

	while ( pDlg->m_bNeedSound )
	{
		DWORD dwRet = ::WaitForMultipleObjects( 3, hEvent, FALSE, INFINITE );

		switch ( dwRet )
		{
		case WAIT_OBJECT_0 :
			{
				HINSTANCE hInst = AfxGetInstanceHandle(); 
				PlaySound(MAKEINTRESOURCE(IDR_WAVE_READ), hInst,SND_RESOURCE|SND_ASYNC);
			}
			break;

		case WAIT_OBJECT_0 + 1 :
			{
				HINSTANCE hInst = AfxGetInstanceHandle(); 
				PlaySound(MAKEINTRESOURCE(IDR_WAVE_NEW), hInst,SND_RESOURCE|SND_ASYNC);
			}
			break;

		case WAIT_OBJECT_0 + 2:
			pDlg->m_bNeedSound = FALSE;
			break;

		default :
			break;
		}
	}

	return 0;
}

void CUHF_GunTestDlg::OnDestroy()
{
	CDialog::OnDestroy();

	::SetEvent( m_hExitEvent );

	while ( m_bNeedSound )
	{
		Sleep(100);
	}

	::CloseHandle( m_hReadSoundEvent );
	m_hReadSoundEvent = NULL;

	::CloseHandle( m_hNewReadSoundEvent );
	m_hNewReadSoundEvent = NULL;

	::CloseHandle( m_hExitEvent );
	m_hExitEvent = NULL;

	::CloseHandle( m_hSoundThread );
	m_hSoundThread = NULL;


	if ( !m_hmTagData.empty() )
	{
/*
		for ( map<unsigned char*,int, cmp_bytes>::iterator it = m_hmTagData.begin() ; it != m_hmTagData.end() ; ++it )
		{
			::HeapFree(::GetProcessHeap(), 0, it->first);
		}
*/
		m_hmTagData.clear();
	}


}