// UHFAntennaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "UHF_GunTest.h"
#include "UHFAntennaDlg.h"


// CUHFAntennaDlg dialog

IMPLEMENT_DYNAMIC(CUHFAntennaDlg, CDialog)

CUHFAntennaDlg::CUHFAntennaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUHFAntennaDlg::IDD, pParent)
	, m_strPower(_T(""))
{

}

CUHFAntennaDlg::~CUHFAntennaDlg()
{

}

void CUHFAntennaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_FREQUENCY, m_lstRegion);
	DDX_Text(pDX, IDC_EDIT_POWER, m_strPower);
}


BEGIN_MESSAGE_MAP(CUHFAntennaDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_OK, &CUHFAntennaDlg::OnBnClickedButtonOk)
	ON_BN_CLICKED(IDC_BUTTON_CANCEL, &CUHFAntennaDlg::OnBnClickedButtonCancel)
END_MESSAGE_MAP()


// CUHFAntennaDlg message handlers
BOOL CUHFAntennaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_nRegionIndex[0] = RFID_REGION_KOREA_NEW;
	m_nRegionIndex[1] = RFID_REGION_USA;
	m_nRegionIndex[2] = RFID_REGION_EURO_NEW;
	m_nRegionIndex[3] = RFID_REGION_JAPAN;
	m_nRegionIndex[4] = RFID_REGION_CHINA;
	m_nRegionIndex[5] = RFID_REGION_AUSTRALIA;
	m_nRegionIndex[6] = RFID_REGION_BRAZIL;
	m_nRegionIndex[7] = RFID_REGION_MALAYSIA;
	m_nRegionIndex[8] = RFID_REGION_TAIWAN;

	m_lstRegion.InsertString(0, _T("KOREA_NEW"));
	m_lstRegion.InsertString(1, _T("USA"));
	m_lstRegion.InsertString(2, _T("EURO_NEW"));
	m_lstRegion.InsertString(3, _T("JAPAN"));
	m_lstRegion.InsertString(4, _T("CHINA"));
	m_lstRegion.InsertString(5, _T("AUSTRALIA"));
	m_lstRegion.InsertString(6, _T("BRAZIL"));
	m_lstRegion.InsertString(7, _T("MALAYSIA"));
	m_lstRegion.InsertString(8, _T("TAIWAN"));
	m_lstRegion.SetCurSel(0);

	int nRegionIndex = 0;
	RFID_STATUS status;
	INT32U data = 0;

	//unsigned int cnt = 1;
	//INT32U data = 0;
	//RFID_RADIO_HANDLE handle = NULL;
	//RFID_STATUS status;
	//status = UHF_MacReadOemData(handle, 0x00000086, &cnt, &data);	
	//if (RFID_STATUS_OK != status)
	//{
	//	MessageBox(_T("Read UHF_MacReadOemData Error!"));
	//}
	//else
	//{

	//	for(int i = 0; i< REGION_INDEX; i++)
	//	{
	//		if(m_nRegionIndex[i] == data)
	//		{
	//			nRegionIndex = i;
	//			break;
	//		}
	//	}

	//	m_lstRegion.SetCurSel(nRegionIndex);
	//}

	RFIDRegion region = UHF_GetRegionFrequency();

	for(int i = 0; i< REGION_INDEX; i++)
	{
		if(m_nRegionIndex[i] == region)
		{
			nRegionIndex = i;
			break;
		}
	}

	m_lstRegion.SetCurSel(nRegionIndex);

	status = UHF_GetPower(&data);
	if(status != RFID_STATUS_OK)
	{
		MessageBox(_T("UHF_GetPower Fail!"));
	}

	m_strPower.Format(_T("%d"),data);

	UpdateData(FALSE);

	SetDialogSize(m_hWnd);

	SetVersion();

	return 0;
}

void CUHFAntennaDlg::SetVersion()
{
	RFID_VERSION LibVer;
	RFID_VERSION MacVer; 
	TCHAR tzDllVersion[260] = {0x00};
	CString strstatus;
	UHF_Version(&LibVer, &MacVer, tzDllVersion);
	strstatus.Format(_T("Firmware: %u.%u.%u APP: %s"), MacVer.major, MacVer.minor, MacVer.maintenance, VER_APP);
	
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_VERSION), strstatus);
}

void CUHFAntennaDlg::OnOK()
{
	RFID_STATUS status;
	INT32U powerlevel;

	UpdateData(TRUE);

	powerlevel = _ttoi(m_strPower);
	if(powerlevel <= 0 || powerlevel > 300)
	{
		MessageBox(L"The value must be set from 0 to 300.", L"Out Of Range");
		return;
	}

	RFIDRegion region;
	int nRegion = m_lstRegion.GetCurSel();
	region = (RFIDRegion)m_nRegionIndex[nRegion];

	BeginWaitCursor();

	status = UHF_SetRegionFrequency(region);

	if(status != RFID_STATUS_OK)
	{
		MessageBox(_T("UHF_SetRegion Set Fail!"));
		EndWaitCursor();
		return ;
	}

	status = UHF_SetPower(powerlevel);
	EndWaitCursor();

	if(status != RFID_STATUS_OK)
		MessageBox(_T("Frequency Set Fail!"));
	else
		CDialog::OnOK();
}

void CUHFAntennaDlg::OnBnClickedButtonOk()
{
	OnOK();
}

void CUHFAntennaDlg::OnBnClickedButtonCancel()
{
	CDialog::OnCancel();
}
