// UHFAccessDlg.cpp : implementation file
//

#include "stdafx.h"
#include "UHF_GunTest.h"
#include "UHFAccessDlg.h"


// CUHFAccessDlg dialog

IMPLEMENT_DYNAMIC(CUHFAccessDlg, CDialog)

CUHFAccessDlg::CUHFAccessDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUHFAccessDlg::IDD, pParent)
	, m_strOffset(_T("2"))
	, m_strLength(_T("6"))
	, m_strRWPwd(_T("00000000"))
	, m_strReadData(_T(""))
	, m_strWriteData(_T(""))
	, m_strLockPwd(_T("00000000"))
	, m_strKillPwd(_T("00000000"))
{

}

CUHFAccessDlg::~CUHFAccessDlg()
{
}

void CUHFAccessDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BANK, m_cmbBank);
	DDX_Control(pDX, IDC_LOCKKILL, m_cmbKillPwd);
	DDX_Control(pDX, IDC_LOCKACC, m_cmbAccPwd);
	DDX_Control(pDX, IDC_LOCKEPC, m_cmbEPC);
	DDX_Control(pDX, IDC_LOCKTID, m_cmbTID);
	DDX_Control(pDX, IDC_LOCKUSER, m_cmbUser);
	DDX_Text(pDX, IDC_OFFSET, m_strOffset);
	DDX_Text(pDX, IDC_WCNT, m_strLength);
	DDX_Text(pDX, IDC_RWPWD, m_strRWPwd);
	DDX_Text(pDX, IDC_READDATA, m_strReadData);
	DDX_Text(pDX, IDC_WRITEDATA, m_strWriteData);
	DDX_Text(pDX, IDC_LOCKPWD, m_strLockPwd);
	DDX_Text(pDX, IDC_KILLPWD, m_strKillPwd);
}


BEGIN_MESSAGE_MAP(CUHFAccessDlg, CDialog)
	ON_MESSAGE(WM_MSG_ACCESS, ReceivedAccess)
	ON_BN_CLICKED(IDC_READCLEAR, &CUHFAccessDlg::OnBnClickedReadclear)
	ON_BN_CLICKED(IDC_READ, &CUHFAccessDlg::OnBnClickedRead)
	ON_BN_CLICKED(IDC_WRITE, &CUHFAccessDlg::OnBnClickedWrite)
	ON_BN_CLICKED(IDC_LOCK, &CUHFAccessDlg::OnBnClickedLock)
	ON_BN_CLICKED(IDC_Kill, &CUHFAccessDlg::OnBnClickedKill)
	ON_EN_CHANGE(IDC_RWPWD, &CUHFAccessDlg::OnEnChangeRwpwd)
	ON_EN_CHANGE(IDC_LOCKPWD, &CUHFAccessDlg::OnEnChangeLockpwd)
END_MESSAGE_MAP()


LRESULT CUHFAccessDlg::ReceivedAccess(WPARAM wParam, LPARAM lParam)
{
	int length = 0;
	unsigned char data[128] = {0,};
	RFIDErrorcode err;
	CString str;

	length = UHF_GetData(data);

	if(length == 0) 
	{
		err = UHF_GetError();

		switch(err)
		{
		case TAG_OTHERERROR:
			MessageBox(_T("Tag Other Error!"));
			break;
		case TAG_SUCCESS:
			MessageBox(_T("SUCCESS!"));
			break;
		case TAG_MEMORYOVERRUN:
			MessageBox(_T("Tag Memory Overrun!"));
			break;
		case TAG_MEMORYLOCKED:
			MessageBox(_T("Tag Memory Locked!"));
			break;
		case TAG_INSUFFICIENTPOWER:
			MessageBox(_T("Tag Insufficient Power!"));
			break;
		case TAG_NONSPECIFICERROR:
			MessageBox(_T("Tag Non Specific Error!"));
			break;
		case MAC_NOERROR:
			MessageBox(_T("Mac No Error!"));
			break;
		case MAC_HANDLEMISSMATCH:
			MessageBox(_T("Handle Missmatch Error!"));
			break;
		case MAC_CRCERROR:
			MessageBox(_T("CRC Error!"));
			break;
		case MAC_NOTAGREPLY:
			MessageBox(_T("No Tag Reply!"));
			break;
		case MAC_INVALIDPASSWD:
			MessageBox(_T("Invalid Password!"));
			break;
		case MAC_ZEROKILLPASSWD:
			MessageBox(_T("Tag Kill Password Zero Error!"));
			break;
		case MAC_TAGLOST:
			MessageBox(_T("Tag Lost!"));
			break;
		case MAC_COMMANDFORMATERROR:
			MessageBox(_T("Command Format Error!"));
			break;
		case MAC_READCOUNTINVALID:
			MessageBox(_T("Read Count Invaled Error!"));
			break;
		case MAC_OUTOFRETRIES:
			MessageBox(_T("Out of Retries Error!"));
			break;
		default:
			MessageBox(_T("Unknown Error!"));
			break;

		}
	}
	else
	{
		for(int i=0;i<length;i++)
		{
			str.AppendFormat(_T("%02X"), data[i]);
		}
		m_strReadData = str;
	}

	UpdateData(FALSE);

	return LRESULT();
}

// CUHFAccessDlg message handlers

BOOL CUHFAccessDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_cmbBank.InsertString(0, _T("RESERVED"));
	m_cmbBank.InsertString(1, _T("EPC"));
	m_cmbBank.InsertString(2, _T("TID"));
	m_cmbBank.InsertString(3, _T("USER"));
	m_cmbBank.SetCurSel(1);

	m_cmbKillPwd.InsertString(0, _T("ACCESSIBLE"));
	m_cmbKillPwd.InsertString(1, _T("ALWAYS_ACCESSIBLE"));
	m_cmbKillPwd.InsertString(2, _T("SECURED_ACCESSIBLE"));
	m_cmbKillPwd.InsertString(3, _T("ALWAYS_NOT_ACCESSIBLE"));
	m_cmbKillPwd.InsertString(4, _T("NO_CHANGE"));
	m_cmbKillPwd.SetCurSel(4);

	m_cmbAccPwd.InsertString(0, _T("ACCESSIBLE"));
	m_cmbAccPwd.InsertString(1, _T("ALWAYS_ACCESSIBLE"));
	m_cmbAccPwd.InsertString(2, _T("SECURED_ACCESSIBLE"));
	m_cmbAccPwd.InsertString(3, _T("ALWAYS_NOT_ACCESSIBLE"));
	m_cmbAccPwd.InsertString(4, _T("NO_CHANGE"));
	m_cmbAccPwd.SetCurSel(4);

	m_cmbEPC.InsertString(0, _T("ACCESSIBLE"));
	m_cmbEPC.InsertString(1, _T("ALWAYS_ACCESSIBLE"));
	m_cmbEPC.InsertString(2, _T("SECURED_ACCESSIBLE"));
	m_cmbEPC.InsertString(3, _T("ALWAYS_NOT_ACCESSIBLE"));
	m_cmbEPC.InsertString(4, _T("NO_CHANGE"));
	m_cmbEPC.SetCurSel(4);

	m_cmbTID.InsertString(0, _T("ACCESSIBLE"));
	m_cmbTID.InsertString(1, _T("ALWAYS_ACCESSIBLE"));
	m_cmbTID.InsertString(2, _T("SECURED_ACCESSIBLE"));
	m_cmbTID.InsertString(3, _T("ALWAYS_NOT_ACCESSIBLE"));
	m_cmbTID.InsertString(4, _T("NO_CHANGE"));
	m_cmbTID.SetCurSel(4);

	m_cmbUser.InsertString(0, _T("ACCESSIBLE"));
	m_cmbUser.InsertString(1, _T("ALWAYS_ACCESSIBLE"));
	m_cmbUser.InsertString(2, _T("SECURED_ACCESSIBLE"));
	m_cmbUser.InsertString(3, _T("ALWAYS_NOT_ACCESSIBLE"));
	m_cmbUser.InsertString(4, _T("NO_CHANGE"));
	m_cmbUser.SetCurSel(4);


	SetDialogSize(m_hWnd);

	return TRUE;
}

void CUHFAccessDlg::OnBnClickedReadclear()
{
	m_strReadData.Format(_T(""));
	m_strWriteData.Format(_T(""));

	UpdateData(FALSE);

}

void CUHFAccessDlg::OnBnClickedRead()
{
	RFID_STATUS status;
	RFIDReadCmd readcmd;
	INT32U accpwd = 0;

	UpdateData(TRUE);

	accpwd = wcstoul(m_strRWPwd, 0, 16);

	readcmd.hWnd = this->m_hWnd;
	readcmd.bank = (RFIDTagBank)m_cmbBank.GetCurSel();
	readcmd.wlength = (INT8U)_ttoi(m_strLength);
	readcmd.offset = (INT8U)_ttoi(m_strOffset);
	readcmd.accpwd = accpwd;

	status = UHF_Read(&readcmd);
	if (RFID_STATUS_OK != status)
	{
		MessageBox(_T("RFID Read Fail!"));
	}
}

void CUHFAccessDlg::OnBnClickedWrite()
{
	RFID_STATUS status;
	RFIDWriteCmd writecmd;
	WCHAR *str;
	char str1[32][8] = {0,};
	INT16U wdata[32] = {0,};
	INT8U wlength;
	INT8U offset;
	INT32U accpwd = 0;

	UpdateData(TRUE);

	wlength = (INT8U)_ttoi(m_strLength);
	offset = (INT8U)_ttoi(m_strOffset);
	accpwd = wcstoul(m_strRWPwd, 0, 16);

	str = (WCHAR*)((LPCWSTR)m_strWriteData);

	for(int i=0;i<wlength;i++)
	{
		sprintf(str1[i], "%c%c%c%c", str[i*4], str[i*4+1], str[i*4+2], str[i*4+3]);
		wdata[i] = (INT16U)strtoul(str1[i], 0, 16);
	}

	writecmd.hWnd = this->m_hWnd;
	writecmd.bank = (RFIDTagBank)m_cmbBank.GetCurSel();
	writecmd.wlength = wlength;
	writecmd.offset = offset;
	memcpy(writecmd.wdata, wdata, wlength*2);
	writecmd.accpwd = accpwd;

	status = UHF_Write(&writecmd);
	if (RFID_STATUS_OK != status)
	{
		MessageBox(_T("RFID Write Fail!"));
	}
}

void CUHFAccessDlg::OnBnClickedLock()
{
	RFID_STATUS status;
	RFIDLockCmd lock;
	INT32U accpwd;

	UpdateData(TRUE);

	accpwd = wcstoul(m_strLockPwd, 0, 16);

	lock.hWnd = this->m_hWnd;
	lock.lockkillpwd = (RFIDLockPermission)m_cmbKillPwd.GetCurSel();
	lock.lockaccesspwd = (RFIDLockPermission)m_cmbAccPwd.GetCurSel();
	lock.lockepc = (RFIDLockPermission)m_cmbEPC.GetCurSel();
	lock.locktid = (RFIDLockPermission)m_cmbTID.GetCurSel();
	lock.lockuser = (RFIDLockPermission)m_cmbUser.GetCurSel();
	lock.accpwd = accpwd;

	status = UHF_Lock(&lock);

	if(RFID_STATUS_OK != status)
	{
		MessageBox(_T("RFID Lock Fail!"));
	}
}

void CUHFAccessDlg::OnBnClickedKill()
{
	RFID_STATUS status;
	RFIDKillCmd kill;
	INT32U killpwd;

	UpdateData(TRUE);

	killpwd = wcstoul(m_strKillPwd, 0, 16);

	kill.hWnd = this->m_hWnd;
	kill.killpwd = killpwd;

	status = UHF_Kill(&kill);
	if(RFID_STATUS_OK != status)
	{
		MessageBox(_T("RFID Kill Fail!"));
	}
}

void CUHFAccessDlg::OnEnChangeRwpwd()
{
	UpdateData(TRUE);
	m_strLockPwd = m_strRWPwd;
	UpdateData(FALSE);
}

void CUHFAccessDlg::OnEnChangeLockpwd()
{
	UpdateData(TRUE);
	m_strRWPwd = m_strLockPwd;
	UpdateData(FALSE);
}
