#pragma once
#define UHF_API __declspec(dllexport)

typedef unsigned __int8     INT8U;
typedef unsigned __int16    INT16U;
typedef unsigned __int32    INT32U;
typedef signed   __int32    BOOL32;
typedef unsigned __int32	HANDLE32;
typedef HANDLE32    RFID_RADIO_HANDLE;

#define WM_MSG_INVENTORY	0x5001
#define WM_MSG_ACCESS		0x5002
#define WM_MSG_POWER		0x5010
#define UHF_OPEN_EVENT		L"UHF_OPEN_EVENT"	

typedef enum
{	
	BATTERY_ERROR,
	BATTERY_0,
	BATTERY_1,
	BATTERY_2,
	BATTERY_3,
	BATTERY_FULL
}BATTERY_STATUS;

typedef enum
{
	TAG_OTHERERROR			= 0x0,
	TAG_SUCCESS				= 0x1,
	TAG_MEMORYOVERRUN		= 0x3,
	TAG_MEMORYLOCKED		= 0x4,
	TAG_INSUFFICIENTPOWER	= 0xB,
	TAG_NONSPECIFICERROR	= 0xF,
	MAC_NOERROR				= 0x10,
	MAC_HANDLEMISSMATCH		= 0x11,
	MAC_CRCERROR			= 0x12,
	MAC_NOTAGREPLY			= 0x13,
	MAC_INVALIDPASSWD		= 0x14,
	MAC_ZEROKILLPASSWD		= 0x15,
	MAC_TAGLOST				= 0x16,
	MAC_COMMANDFORMATERROR	= 0x17,
	MAC_READCOUNTINVALID	= 0x18,
	MAC_OUTOFRETRIES		= 0x19,
}RFIDErrorcode;

typedef enum
{
	TAG_RESERVED,
	TAG_EPC,
	TAG_TID,
	TAG_USER
}RFIDTagBank;

typedef enum
{
	RFID_REGION_KOREA_NEW,
	RFID_REGION_KOREA_WEAK,
	RFID_REGION_KOREA_OLD,
	RFID_REGION_USA,
	RFID_REGION_EURO,
	RFID_REGION_EURO_NEW,
	RFID_REGION_JAPAN,
	RFID_REGION_CHINA,
	RFID_REGION_AUSTRALIA,
	RFID_REGION_BRAZIL,
	RFID_REGION_MALAYSIA,
	RFID_REGION_TAIWAN
}RFIDRegion;

typedef enum 
{
	SELECT_EPC = 1,
	SELECT_TID = 2,
	SELECT_USER = 3
}RFIDSelectBank;

typedef enum 
{
	PERMISSION_ACCESSIBLE,
	PERMISSION_ALWAYS_ACCESSIBLE,
	PERMISSION_SECURED_ACCESSIBLE,
	PERMISSION_ALWAYS_NOT_ACCESSIBLE,
	PERMISSION_NO_CHANGE
}RFIDLockPermission;

enum
{
    /* Success                                                                */
    RFID_STATUS_OK,
    /* Attempted to open a radio that is already open                         */
    RFID_ERROR_ALREADY_OPEN     = -9999,                             /* -9999 */
    /* Buffer supplied is too small                                           */
    RFID_ERROR_BUFFER_TOO_SMALL,                                     /* -9998 */
    /* General failure                                                        */
    RFID_ERROR_FAILURE,                                              /* -9997 */
    /* Failed to load radio bus driver                                        */
    RFID_ERROR_DRIVER_LOAD,                                          /* -9996 */
    /* Library cannot use version of radio bus driver present on system       */
    RFID_ERROR_DRIVER_MISMATCH,                                      /* -9995 */
    /* This error code is no longer used, maintain slot in enum in case 
     * anyone is using hard-coded error codes for some reason                 */
    RFID_ERROR_RESERVED_01,                                          /* -9994 */
    /* Antenna number is invalid                                              */
    RFID_ERROR_INVALID_ANTENNA,                                      /* -9993 */
    /* Radio handle provided is invalid                                       */
    RFID_ERROR_INVALID_HANDLE,                                       /* -9992 */
    /* One of the parameters to the function is invalid                       */
    RFID_ERROR_INVALID_PARAMETER,                                    /* -9991 */
    /* Attempted to open a non-existent radio                                 */
    RFID_ERROR_NO_SUCH_RADIO,                                        /* -9990 */
    /* Library has not been successfully initialized                          */
    RFID_ERROR_NOT_INITIALIZED,                                      /* -9989 */
    /* Function not supported                                                 */
    RFID_ERROR_NOT_SUPPORTED,                                        /* -9988 */
    /* Operation was cancelled by call to cancel operation, close radio, or   */
    /* shut down the library                                                  */
    RFID_ERROR_OPERATION_CANCELLED,                                  /* -9987 */
    /* Library encountered an error allocating memory                         */
    RFID_ERROR_OUT_OF_MEMORY,                                        /* -9986 */
    /* The operation cannot be performed because the radio is currently busy  */
    RFID_ERROR_RADIO_BUSY,                                           /* -9985 */
    /* The underlying radio module encountered an error                       */
    RFID_ERROR_RADIO_FAILURE,                                        /* -9984 */
    /* The radio has been detached from the system                            */
    RFID_ERROR_RADIO_NOT_PRESENT,                                    /* -9983 */
    /* The RFID library function is not allowed at this time.                 */
    RFID_ERROR_CURRENTLY_NOT_ALLOWED,                                /* -9982 */
    /* The radio module's MAC firmware is not responding to requests.         */
    RFID_ERROR_RADIO_NOT_RESPONDING,                                 /* -9981 */
    /* The MAC firmware encountered an error while initiating the nonvolatile */
    /* memory update.  The MAC firmware will return to its normal idle state  */
    /* without resetting the radio module.                                    */
    RFID_ERROR_NONVOLATILE_INIT_FAILED,                              /* -9980 */
    /* An attempt was made to write data to an address that is not in the     */
    /* valid range of radio module nonvolatile memory addresses.              */
    RFID_ERROR_NONVOLATILE_OUT_OF_BOUNDS,                            /* -9979 */
    /* The MAC firmware encountered an error while trying to write to the     */
    /* radio module's nonvolatile memory region.                              */
    RFID_ERROR_NONVOLATILE_WRITE_FAILED,                             /* -9978 */
    /* The underlying transport layer detected that there was an overflow     */
    /* error resulting in one or more bytes of the incoming data being        */
    /* dropped.  The operation was aborted and all data in the pipeline was   */
    /* flushed.                                                               */
    RFID_ERROR_RECEIVE_OVERFLOW,                                     /* -9977 */
    /* An unexpected value was returned to this function by the MAC firmware  */
    RFID_ERROR_UNEXPECTED_VALUE,                                     /* -9976 */
    /* The MAC firmware encountered CRC errors while trying to                */
    /* write to the radio module's nonvolatile memory region.                 */
    RFID_ERROR_NONVOLATILE_CRC_FAILED,                               /* -9975 */
    /* The MAC firmware encountered unexpected values in the packet header    */
    RFID_ERROR_NONVOLATILE_PACKET_HEADER,                            /* -9974 */
    /* The MAC firmware received more than the specified maximum packet size  */
    RFID_ERROR_NONVOLATILE_MAX_PACKET_LENGTH                         /* -9973 */
}typedef RFID_STATUS;

typedef struct {
	/* The major version (i.e, in 1.x.x.x, the 1)                               */
	INT32U  major;
	/* The minor version (i.e., in x.1.x.x, the 1)                              */
	INT32U  minor;
	/* The maintenance number (i.e., in x.x.1.x, the 1)                          */
	INT32U  maintenance;
	/* The release number (i.e., in x.x.x.1, the 1)                             */
	INT32U  release;
} RFID_VERSION;

typedef struct
{
	HWND hWnd; //Diag handle Receive for Message
	RFIDTagBank bank;
	INT8U wlength;
	INT8U offset;
	INT32U accpwd;
}RFIDReadCmd;

typedef struct
{
	HWND hWnd; //Diag handle Receive for Message
	RFIDTagBank bank;
	INT8U wlength;
	INT8U offset;
	INT16U wdata[32];
	INT32U accpwd;
}RFIDWriteCmd;

typedef struct
{
	HWND hWnd; //Diag handle Receive for Message
	RFIDLockPermission lockkillpwd;
	RFIDLockPermission lockaccesspwd;
	RFIDLockPermission lockepc;
	RFIDLockPermission locktid;
	RFIDLockPermission lockuser;
	INT32U accpwd;
}RFIDLockCmd;


typedef struct
{
	HWND hWnd; //Diag handle Receive for Message
	INT32U killpwd;
}RFIDKillCmd;

EXTERN_C UHF_API RFIDErrorcode UHF_GetError();
EXTERN_C UHF_API BOOL UHF_IsReady(); 
EXTERN_C UHF_API RFID_STATUS UHF_Init (HWND hDlgWnd);
EXTERN_C UHF_API RFID_STATUS UHF_Close();
EXTERN_C UHF_API int UHF_GetData (INT8U *data);
EXTERN_C UHF_API RFID_STATUS UHF_GetPower(INT32U *plevel);
EXTERN_C UHF_API RFID_STATUS UHF_SetPower(INT32U plevel);
EXTERN_C UHF_API void UHF_Inventory(HWND hWnd);
EXTERN_C UHF_API void UHF_InventoryStop();
EXTERN_C UHF_API RFID_STATUS UHF_Read(RFIDReadCmd *cmd);
EXTERN_C UHF_API RFID_STATUS UHF_Write(RFIDWriteCmd *cmd);
EXTERN_C UHF_API RFID_STATUS UHF_Lock(RFIDLockCmd *cmd);
EXTERN_C UHF_API RFID_STATUS UHF_Kill(RFIDKillCmd *cmd);
EXTERN_C UHF_API RFID_STATUS UHF_SetRegionFrequency(RFIDRegion region);
EXTERN_C UHF_API RFIDRegion UHF_GetRegionFrequency();
EXTERN_C UHF_API RFID_STATUS UHF_ReadBattery(INT32U *nADCValue, float *fVolt);
EXTERN_C UHF_API RFID_STATUS UHF_ReadBatteryStatus(BATTERY_STATUS *step);
EXTERN_C UHF_API BOOL UHF_Version(RFID_VERSION *LibVer, RFID_VERSION *MacVer, TCHAR *tzDllVersion);

// Not Using in SDK 20140425 JJ
EXTERN_C UHF_API RFID_STATUS UHF_SetRegion(RFIDRegion region, bool oemwrite);
//EXTERN_C UHF_API RFIDFrequency UHF_MakeRegionFrequency(RFIDRegion region);
//EXTERN_C UHF_API RFID_STATUS UHF_GetPowerMode(RFID_RADIO_POWER_STATE *powermode);
//EXTERN_C UHF_API RFID_STATUS UHF_SetPowerMode(RFID_RADIO_POWER_STATE powermode);
//EXTERN_C UHF_API RFID_STATUS UHF_GetConfiguration(RFID_Config *config);
//EXTERN_C UHF_API RFID_STATUS UHF_SetConfiguration(RFID_Config *config);
//EXTERN_C UHF_API RFID_STATUS UHF_GetLinkProfile(INT32U *linkprofilenum);
//EXTERN_C UHF_API RFID_STATUS UHF_SetLinkProfile(INT32U linkprofilenum);
//EXTERN_C UHF_API RFID_STATUS UHF_GetAlgorithm(RFID_Algorithm *algo);
//EXTERN_C UHF_API RFID_STATUS UHF_SetAlgorithm(RFID_Algorithm *algo);
//EXTERN_C UHF_API RFID_STATUS UHF_MacWriteOemData(RFID_RADIO_HANDLE handle,INT32U address,INT32U* pCount,const INT32U* pData);
//EXTERN_C UHF_API RFID_STATUS UHF_MacReadRegister(RFID_RADIO_HANDLE handle,INT16U address,INT32U* pValue);
//EXTERN_C UHF_API RFID_STATUS UHF_MacWriteRegister(RFID_RADIO_HANDLE handle,INT16U address,INT32U value);
//EXTERN_C UHF_API RFID_STATUS UHF_CarrierWaveOn(INT32U freq, RFIDFrequency *frequency);
//EXTERN_C UHF_API RFID_STATUS UHF_CarrierWaveOff();
//EXTERN_C UHF_API RFID_STATUS UHF_SetInterface(RFIDInterface hwif);
//EXTERN_C UHF_API RFID_STATUS UHF_GetInterface(RFIDInterface* hwif);
//EXTERN_C UHF_API RFID_STATUS UHF_SetSelect(RFIDSelectParam *param);
//EXTERN_C UHF_API RFID_STATUS UHF_SetFrequency(RFIDFrequency *freq);
