﻿// 2014-04-24 JJ UHF NET SDK 매뉴얼 제작하면서 기능 보완 v.1.0.1
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.WindowsCE.Forms;
using System.Threading;
using System.Runtime.InteropServices;

using RFID_UHF_Net;

using INT8U = System.Byte;
using INT16U = System.UInt16;
using INT32U = System.UInt32;
using BOOL32 = System.Int32;
using HANDLE32 = System.UInt32;

namespace UHF_Gun_Net_Test
{
    public partial class Form_Main : Form
    {
        RFIDUHF UHFNet;

        public const float m_fCutOffValue = 3.4f;

        public bool m_bSoundPlay = true;
        public bool m_bOpen = false;
        public bool m_bStartInventory = false;
        public bool m_bTriggerUp = true;

        private const int SERIAL_EPC = 0;
        private const int SERIAL_CNT = 1;

        public Form_Main()
        {
            InitializeComponent();

            UHFNet = new RFIDUHF();

            listView_Result.Columns.Add("EPC", 150, HorizontalAlignment.Left);
            listView_Result.Columns.Add("Count", 50, HorizontalAlignment.Left);

            if (UHFNet.IsCEDevice())
            {
                label_Title.Visible = false;
            }
        }

        private void Form_Main_Load(object sender, EventArgs e)
        {
            if (!OpenRFID(true))
            {
                label_Result.Text = "Rfid Init Error";

                MessageBox.Show(label_Result.Text);
            }

            UHFNet.MessageClass.InventoryFunc += new ReceivedInventory(OnReceivedInventory);
            UHFNet.MessageClass.PowerFunc += new ReceivedPower(OnReceivedPower);

            m_bOpen = true;

            //Key Event catch
            this.KeyPreview = true;

            // Emul Test
            this.textBox_Emul_Result.Focus();
        }

        public void OnReceivedPower(bool a_bPowerOn)
        {

            Cursor.Current = Cursors.WaitCursor;

            if (a_bPowerOn == true)
            {
                if (m_bOpen == false)
                {
                    if (OpenRFID(true))
                    {
                        m_bOpen = true;
                    }
                }
            }
            else
            {
                if (m_bOpen == true)
                {
                    OpenRFID(false);
                    m_bOpen = false;
                }

            }
            Cursor.Current = Cursors.Default;
        }

        public bool IsEnoughBattery()
        {
            RFIDUHF.RFID_STATUS status = new RFIDUHF.RFID_STATUS();

            INT32U nADC = 0;

            float fVolt = 0;

            status = UHFNet.ReadBattery(ref nADC, ref fVolt);

            if (fVolt < m_fCutOffValue & status == RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        private void OnReceivedInventory()
        {
            if (m_bStartInventory == false)
                return;

            int nTaglenth = 0;
            String strTagData = null;
            StringBuilder strData = new StringBuilder(260);

            nTaglenth = UHFNet.GetData(strData);

            if (checkBox_CRC.Checked == true)
            {
                strTagData = strData.ToString().Substring(0, nTaglenth);
            }
            else if(checkBox_CRC.Checked == false)
            {
                strTagData = strData.ToString().Substring(0, nTaglenth - 2);
            }

            InsertListView(strTagData);

            if (checkBox_Once.Checked == true)
            {
                Inventory(false);

                m_bTriggerUp = true;
            }
        }

        public void Inventory(bool bStart)
        {
            if (!m_bOpen)
            {
                return;
            }

            if (bStart)
            {
                if (!IsEnoughBattery())
                {
                    MessageBox.Show("It need more battery power.");

                    if (m_bOpen == true)
                    {
                        OpenRFID(false);
                        m_bOpen = false;
                    }
                }

                UHFNet.Inventory();
                m_bStartInventory = true;

                button_Start.Text = "STOP";
                label_Result.Text = "Read Inventory";
            }
            else
            {
                UHFNet.InventoryStop();
                m_bStartInventory = false;

                button_Start.Text = "START";
                label_Result.Text = "Stop Read";
            }
        }

        public bool OpenRFID(bool bOpen)
        {
            if (bOpen)
            {
                RFIDUHF.RFID_STATUS status = new RFIDUHF.RFID_STATUS();
                String strstatus = null;

                status = UHFNet.Init();

                if (status != RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
                {
                    strstatus = String.Format("RFID Init Error-{0:G}", status);

                    return false;
                }
                label_Result.Text = "Open UHF";
            }
            else
            {
                RFIDUHF.RFID_STATUS status = new RFIDUHF.RFID_STATUS();
                String strstatus = null;

                status = UHFNet.Close();
                if (status != RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
                {
                    strstatus = String.Format("{0:G}", status);

                    return false;
                }
                label_Result.Text = "Close UHF";
            }
            return true;
        }

        private void button_Start_Click(object sender, EventArgs e)
        {
            Inventory(!m_bStartInventory);
        }

        public void InsertListView(String strTagData)
        {

            int nTagCount = 0;
            String strExistedTagData = null;

            nTagCount = listView_Result.Items.Count;

            if (nTagCount > 200)
            {
                listView_Result.Items.Clear();
                nTagCount = listView_Result.Items.Count;
            }

            int index = -1;

            for (int i = 0; i < nTagCount; i++)
            {
                strExistedTagData = listView_Result.Items[i].SubItems[SERIAL_EPC].Text;

                if (strTagData == strExistedTagData)
                {
                    index = i;

                    int nNum = int.Parse(listView_Result.Items[i].SubItems[SERIAL_CNT].Text) + 1;
                    listView_Result.Items[i].SubItems[SERIAL_CNT].Text = nNum.ToString();
                    break;
                }
            }

            if (index == -1)
            {
                ListViewItem list_view = new ListViewItem(strTagData);
                list_view.SubItems.Add("1");
                listView_Result.Items.Insert(0, list_view);

                if (m_bSoundPlay == true)
                {
                    UHFNet.Sound("\\Windows\\voicbeep.wav", 0, (int)(RFIDUHF.SND.SND_ASYNC | RFIDUHF.SND.SND_FILENAME));
                }
            }

            nTagCount = listView_Result.Items.Count;
            label_Tag_Count.Text = String.Format("TAG - {0:G}", nTagCount);
        }

        public IntPtr ReceivedPower(IntPtr wParam, IntPtr lParam)
        {
            IntPtr bPowerOn = wParam;

            Cursor.Current = Cursors.WaitCursor;

            if (bPowerOn != null)
            {
                if (m_bOpen == false)
                {
                    if (OpenRFID(true))
                    {
                        m_bOpen = true;
                    }
                }
            }
            else
            {
#pragma warning disable
                if (m_bOpen == true)
                {
                    OpenRFID(false);
                    m_bOpen = false;
                }
#pragma warning restore
            }
            Cursor.Current = Cursors.Default;
            return IntPtr.Zero;
        }

        private void button_Clear_Click(object sender, EventArgs e)
        {
            listView_Result.Items.Clear();
            label_Tag_Count.Text = String.Format("TAG COUNT");
        }

        private void button_Open_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            OpenRFID(true);
            Cursor.Current = Cursors.Default;
        }

        private void button_Close_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            OpenRFID(false);
            Cursor.Current = Cursors.Default;
        }

        private void Form_Main_KeyDown(object sender, KeyEventArgs e)
        {
            if ((e.KeyCode == System.Windows.Forms.Keys.F14 || e.KeyCode == System.Windows.Forms.Keys.F22))
            {
                if (m_bTriggerUp == true)
                {
                    Inventory(true);
                    m_bTriggerUp = false;
                }     
            }
            if (e.KeyCode == System.Windows.Forms.Keys.Return)
            {
                if (textBox_Emul_Result.TextLength > 0)
                {
                    InsertListView(textBox_Emul_Result.ToString());

                    textBox_Emul_Result.Text = "";
                }
                return;
            }
        }

        private void Form_Main_KeyUp(object sender, KeyEventArgs e)
        {

            if ((e.KeyCode == System.Windows.Forms.Keys.F14 || e.KeyCode == System.Windows.Forms.Keys.F22))
            {
                if (m_bTriggerUp == false)
                {
                    Inventory(false);
                    m_bTriggerUp = true;
                }
            }
        }

        private void menuItem_Access_Click(object sender, EventArgs e)
        {
            if (m_bOpen == false)
                return;

            Form_Access access = new Form_Access(UHFNet);
            access.ShowDialog();
        }

        private void menuItem_Config_Click(object sender, EventArgs e)
        {
            Form_Antenna antenna = new Form_Antenna(UHFNet);
            antenna.ShowDialog();
        }

    }
}