﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using RFID_UHF_Net;

using INT8U = System.Byte;
using INT16U = System.UInt16;
using INT32U = System.UInt32;
using BOOL32 = System.Int32;
using HANDLE32 = System.UInt32;
using RFID_RADIO_HANDLE = System.UInt32;

namespace UHF_Gun_Net_Test
{
    public partial class Form_Antenna : Form
    {

        RFIDUHF _UHFNet;
        RFIDUHF.RFIDRegion[] _nRegionIndex = new RFIDUHF.RFIDRegion[9];

        public Form_Antenna(RFIDUHF uhf)
        {
            InitializeComponent();

            _UHFNet = uhf;

            _nRegionIndex[0] = RFIDUHF.RFIDRegion.RFID_REGION_KOREA_NEW;
            _nRegionIndex[1] = RFIDUHF.RFIDRegion.RFID_REGION_USA;
            _nRegionIndex[2] = RFIDUHF.RFIDRegion.RFID_REGION_EURO_NEW;
            _nRegionIndex[3] = RFIDUHF.RFIDRegion.RFID_REGION_JAPAN;
            _nRegionIndex[4] = RFIDUHF.RFIDRegion.RFID_REGION_CHINA;
            _nRegionIndex[5] = RFIDUHF.RFIDRegion.RFID_REGION_AUSTRALIA;
            _nRegionIndex[6] = RFIDUHF.RFIDRegion.RFID_REGION_BRAZIL;
            _nRegionIndex[7] = RFIDUHF.RFIDRegion.RFID_REGION_MALAYSIA;
            _nRegionIndex[8] = RFIDUHF.RFIDRegion.RFID_REGION_TAIWAN;

            listBox_Region.Items.Add("KOREAN_NEW");
            listBox_Region.Items.Add("USA");
            listBox_Region.Items.Add("EURO_NEW");
            listBox_Region.Items.Add("JAPAN");
            listBox_Region.Items.Add("CHINA");
            listBox_Region.Items.Add("AUSTRAILIA");
            listBox_Region.Items.Add("BRAZIL");
            listBox_Region.Items.Add("MALAYSIA");
            listBox_Region.Items.Add("TAIWAN");
            listBox_Region.SelectedIndex = 0;

            INT32U data = 0;
            RFIDUHF.RFID_STATUS status = new RFIDUHF.RFID_STATUS();
            RFIDUHF.RFIDRegion region;
            int nRegionIndex = 0;

            region = _UHFNet.GetRegionFrequency();

            for (int i = 0; i < listBox_Region.Items.Count; i++)
            {
                if (_nRegionIndex[i] == region)
                {
                    nRegionIndex = (int)i;
                    break;
                }
            }
            listBox_Region.SelectedIndex = nRegionIndex;

            status = _UHFNet.GetPower(ref data);

            if (status != RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
            {
                MessageBox.Show("UHF_GetPower Fail!");
            }

            textBox_Power.Text = String.Format("{0:G}", data);

            SetVersion();

            if (_UHFNet.IsCEDevice()) mainMenu1.Dispose();


        }

        private void SetVersion()
        {
            RFIDUHF.RFID_VERSION LibVer = new RFIDUHF.RFID_VERSION();
            RFIDUHF.RFID_VERSION MacVer = new RFIDUHF.RFID_VERSION();
            StringBuilder strVersion = new StringBuilder(260);

            _UHFNet.Version(ref LibVer, ref MacVer, strVersion);

            label_Version.Text = String.Format("Firmware: {0}.{1}.{2} App: {3}", MacVer.major, MacVer.minor, MacVer.maintenance, Program.APP_VERSION);
        }

        private void SetConfig()
        {
            RFIDUHF.RFID_STATUS status = new RFIDUHF.RFID_STATUS();
            INT32U powerlevel = 0;

            powerlevel = (INT32U)int.Parse(textBox_Power.Text);

            if (powerlevel <= 0 | powerlevel > 300)
            {
                MessageBox.Show("The value must be set from 0 to 300");
                return;
            }

            Cursor.Current = Cursors.WaitCursor;
            
            status = _UHFNet.SetRegionFrequency(_nRegionIndex[listBox_Region.SelectedIndex]);

            if(status != RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
            {
                MessageBox.Show("SetRegionFrequency Set Fail!");
                Cursor.Current = Cursors.Default;
                return;
            }

            status = _UHFNet.SetPower(powerlevel);
            Cursor.Current = Cursors.Default;

            if (status != RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
            {
                MessageBox.Show("SetPower Fail!");
            } 
            else
            {
                Close();  
            }
        }

        private void menuItem_OK_Click(object sender, EventArgs e)
        {
            SetConfig();
            Close();
        }

        private void menuItem_Cancel_Click(object sender, EventArgs e)
        {

            Close();
        }

    }
}