#ifdef RHHM3OLEG42USBSDK_EXPORTS
#define RHHM3OLEG42USBSDK_API __declspec(dllexport)
#else
#define RHHM3OLEG42USBSDK_API __declspec(dllimport)
#endif

#include "Error.h"

#define SDKHANDLE	void*


enum ECARDTYPE
{
	ECARD_LEGIC			= 0x00,
	ECARD_ISO15693,
	ECARD_ISO14443A,
	ECARD_ISO14443B,
	ECARD_INSIDESECURE,
	ECARD_SONYFELICA
};

enum EREADER_FEATURE
{
	ERD_LEDS,
	ERD_BUZZER,
	ERD_READER_TYPE,
	ERD_HARDWARE_REV,
	ERD_POWER,
	ERD_BOOT_LOADER,
	ERD_FIRMWARE,
	ERD_CRYPT_MODE,
	ERD_CARD,
	ERD_SELECT_FILE,
};

enum EFILETYPE
{
	FILE_IGNORE_SEG		= 0x00,
	FILE_MT				= 0x20,
	FILE_DATA_SEG		= 0x40,
	FILE_LEGIC_SEG		= 0x50,
	FILE_MT_PLUS		= 0xC0
};


RHHM3OLEG42USBSDK_API SDKHANDLE	OpenReader(UINT nCom);

RHHM3OLEG42USBSDK_API EERROR ReadData(SDKHANDLE hReader, DWORD dwAddress, BYTE* pData, DWORD& dwLen);
RHHM3OLEG42USBSDK_API EERROR WriteData(SDKHANDLE hReader, DWORD dwAddress, BYTE* pData, DWORD dwLen);
RHHM3OLEG42USBSDK_API EERROR SetReaderCaps(SDKHANDLE hReader, EREADER_FEATURE eRdFeat, BYTE* pData, DWORD dwCount);
RHHM3OLEG42USBSDK_API EERROR GetReaderCaps(SDKHANDLE hReader, EREADER_FEATURE eRdFeat, BYTE* pData, DWORD& dwCount);
RHHM3OLEG42USBSDK_API void	CloseReader(SDKHANDLE hReader);

