#include "stdafx.h"
#include "R-HH-M3O-LEG42-USB-SDK-DEMO.h"
#include "DlgCardScan.h"

static SCAN_TYPE tbScanType[]=
{
	{ECARD_LEGIC,			_T("Card Legic")		},
	{ECARD_ISO15693,		_T("Card Iso15693")		},
	{ECARD_ISO14443A,		_T("Card Iso14443A")	},
	{ECARD_ISO14443B,		_T("Card Iso14443B")	},
	{ECARD_INSIDESECURE,	_T("Card Inside Secure")},
	{ECARD_SONYFELICA,		_T("Card Sony Felica")	},
};

IMPLEMENT_DYNAMIC(CDlgCardScan, CPropertyPage)

CDlgCardScan::CDlgCardScan()
	: CPropertyPage(CDlgCardScan::IDD)
{

}

CDlgCardScan::~CDlgCardScan()
{
}

void CDlgCardScan::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_CARD, m_ctrlCard);
}


BEGIN_MESSAGE_MAP(CDlgCardScan, CPropertyPage)
	ON_BN_CLICKED(IDOK, &CDlgCardScan::OnBnClickedOk)
END_MESSAGE_MAP()


void CDlgCardScan::InsertColumn(UINT nCol, TCHAR* szData, UINT nMaxLen)
{
	if(szData != NULL)
	{
		LV_COLUMN stLvc;
		stLvc.mask		= LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
		stLvc.iSubItem	= nCol;
		stLvc.pszText	= szData;
		stLvc.cx		= nMaxLen;
		stLvc.fmt		= LVCFMT_LEFT;
		m_ctrlCard.InsertColumn(nCol, &stLvc);
		// m_ctrlData.SetColumnWidth( nCol, LVSCW_AUTOSIZE_USEHEADER);
	}
}

void CDlgCardScan::InsertItem(UINT nIntem, UINT nSubItem, TCHAR* szString, UINT nImage)
{
	LVITEM stLvItem;
	::ZeroMemory(&stLvItem, sizeof(LVITEM));

	stLvItem.iItem = nIntem;
	stLvItem.iSubItem = nSubItem;
	stLvItem.mask = LVIF_TEXT | LVIF_STATE;
	if(nImage != -1)
	{
		stLvItem.mask |= LVIF_IMAGE;
		stLvItem.iImage	 = nImage;
	}
	stLvItem.pszText = szString;
	stLvItem.cchTextMax = (int)_tcslen(szString) + 1;

	if(nSubItem == 0x00)
	{
		// set the default count to 1 - in item data
		//
		m_ctrlCard.SetItemData(m_ctrlCard.InsertItem(&stLvItem), 0x01);
	}

	if(nSubItem > 0x00)
		m_ctrlCard.SetItem(&stLvItem);
}

#define ICON_SIZE	0x10
BOOL CDlgCardScan::OnInitDialog()
{
	CDialog::OnInitDialog();

	InsertColumn(0, _T("Card type"), 80);
	InsertColumn(1, _T("Card id"), 150);

	m_lstImage.Create(ICON_SIZE, ICON_SIZE, ILC_COLOR16 | ILC_MASK, 0x01, 0x02);

	HICON hIcon = AfxGetApp()->LoadIcon(IDI_CARD);
	m_lstImage.Add(hIcon);
	m_ctrlCard.SetImageList(&m_lstImage, LVSIL_SMALL);

	m_ctrlCard.ModifyStyle(0, LVS_SHOWSELALWAYS | LVS_REPORT);
	m_ctrlCard.SetExtendedStyle( /*LVS_EX_FLATSB |*/LVS_EX_FULLROWSELECT);

	// m_ctrlStatus.SetWindowText(_T("Wellcome to iDTronic - Legic demo program !"));

	return TRUE;
}

CString CDlgCardScan::ByteToString(BYTE* pData, UINT nSize)
{
	CString strRet = _T("");
	if((pData != NULL) && (nSize > 0))
	{
		CHAR szData[MAX_PATH];
		for(UINT nCount = 0; nCount < nSize; nCount++)
		{
			sprintf(szData, "%02X", pData[nCount]);
			strRet += szData;
		}
	}
	return strRet;
}

void CDlgCardScan::OnBnClickedOk()
{
	m_ctrlCard.DeleteAllItems();
	SDKHANDLE hReader = OpenReader(0x01);
	if(hReader != NULL)
	{
		USES_CONVERSION;
		DWORD dwTotalCards = 0x00;
		for(UINT nCount = ECARD_LEGIC; nCount <= ECARD_SONYFELICA; nCount++)
		{
			BYTE pDataRet[MAX_PATH]; DWORD dwDataRet = MAX_PATH;
			*((DWORD*)pDataRet) = nCount;
			EERROR eRet = GetReaderCaps(hReader, ERD_CARD, pDataRet, dwDataRet);
			if(eRet == ER_OK)
			{
				dwTotalCards += *((DWORD*)pDataRet);
				DWORD dwNav = sizeof(DWORD);
				for(DWORD dwCard = 0; dwCard < *((DWORD*)pDataRet); dwCard++)
				{
					// display cards id !!!
					InsertItem(0, 0, tbScanType[nCount].szMsg, -1);
					InsertItem(0, 1, (TCHAR*)(LPCTSTR)ByteToString(pDataRet + dwNav + 1, pDataRet[dwNav]), -1);

					m_ctrlCard.SetItemData(0, 0);
					if(tbScanType[nCount].eCardType == ECARD_LEGIC)
					{
						m_ctrlCard.SetItemData(0, dwCard + 0x01);
					}
					dwNav += pDataRet[dwNav] + 0x01;
				}
			}

			m_ctrlCard.SetItemState(0, LVIS_SELECTED, LVIS_SELECTED);
		}
		CloseReader(hReader);
	}
}
