﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using RFIDNet;

namespace RfidTestNet
{
    public partial class Form_TagIt : Form
    {
        RFIDCommon m_Common;
        RFIDTagIt m_TagIt = new RFIDTagIt();
        public SOUND_MODE m_VibrationMode = SOUND_MODE.SOUND_NO;
        public SOUND_MODE m_SoundMode = SOUND_MODE.SOUND_1;

        public Form_TagIt(RFIDCommon rfid)
        {
            InitializeComponent();

            m_Common = rfid;
        }

        private void Form_TagIt_Load(object sender, EventArgs e)
        {
            label_Inventory.Text = "";
            label_Result.Text = "";
            textBox_Block.Text = "01";
            textBox_BlockData.Text = "";
        }

        private void button_Inventory_Click(object sender, EventArgs e)
        {
            StringBuilder strSerial = new StringBuilder(512);

            if(m_TagIt.Inventory(strSerial))
            {
                m_Common.SoundPlay(m_SoundMode);
                m_Common.SoundPlay(m_VibrationMode);

                label_Inventory.Text = strSerial.ToString();
                label_Result.Text = "Result: Read Success";
            }
            else
            {
                label_Inventory.Text = "";
                label_Result.Text = "Result: No tag in the field";
            }
        }

        private void button_Read_Click(object sender, EventArgs e)
        {
            StringBuilder strBlock = new StringBuilder(512);

            if (textBox_Block.Text.Length != 2)
            {
                label_Result.Text = "Input correct data";
                return;
            }

            if(m_TagIt.ReadBlock(Convert.ToInt32(textBox_Block.Text), strBlock))
            {
                m_Common.SoundPlay(m_SoundMode);
                m_Common.SoundPlay(m_VibrationMode);
                textBox_BlockData.Text = strBlock.ToString();

                label_Result.Text = "Result: Read Success";
            }
            else
            {
                label_Result.Text = "Result: Read Fail";

            }
        }

        private void button_Write_Click(object sender, EventArgs e)
        {
            StringBuilder strWriteResult = new StringBuilder(512);

            if (textBox_Block.Text.Length != 2)
            {
                label_Result.Text = "Input correct data";
                return;
            }

            if (m_TagIt.WriteBlock(Convert.ToInt32(textBox_Block.Text), textBox_BlockData.Text, strWriteResult))
            {
                m_Common.SoundPlay(m_SoundMode);
                m_Common.SoundPlay(m_VibrationMode);

                textBox_BlockData.Text = strWriteResult.ToString();
                label_Result.Text = "Result: Write Success";

            }
            else
            {
                label_Result.Text = "Result: Write Fail";

            }

                        

        }

        private void button_Clear_Click(object sender, EventArgs e)
        {
            label_Inventory.Text = "";
            label_Result.Text = "";
            textBox_BlockData.Text = "";
        }

    }
}