﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using RFIDNet;

namespace RfidTestNet
{
    public partial class Form_PayPass : Form
    {
        RFIDCommon RfidCommon;
        public SOUND_MODE m_VibrationMode = SOUND_MODE.SOUND_NO;
        public SOUND_MODE m_SoundMode = SOUND_MODE.SOUND_1;

        public Form_PayPass(RFIDCommon rfid)
        {
            InitializeComponent();
            RfidCommon = rfid;

            int type = RfidCommon.SetTagType((int)TAG_TYPE_HF.ISO_14443_TYPE_B);
            System.Diagnostics.Debug.WriteLine("Initialize: " + (TAG_TYPE_HF)type);
            label_Status.Text = "Result: TagType - ISO_14443_TYPE_B";
        }

        private void menuItem_Close_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void button_Select_Click(object sender, EventArgs e)
        {
            StringBuilder strSerial = new StringBuilder();

            RfidCommon.SendCommand("s", "");
            if (RfidCommon.GetData(strSerial))
            // if(RfidCommon.SelectTag(strSerial))
            {
                label_Serial.Text = strSerial.ToString();
                label_Status.Text = "Result: Read Success.";

            }
            else
            {
                label_Status.Text = "Result: No Tag In The Field.";
            }

        }

        private void button_Send_Click(object sender, EventArgs e)
        {
            // Make sending packet
            String strCommandParam = String.Empty;
            String strToggleByte = String.Empty;

            if(radioButton_Toggle02h.Checked == true)
            {
                strToggleByte = "02";
            }
            else if(radioButton_Toggle03h.Checked == true)
            {
                strToggleByte = "03";
            }
            else
            {
                strToggleByte = "00";
            }

            int nApduLength = ((strToggleByte + textBox_APDU.Text).Length) / 2;

            strCommandParam = String.Format("{0:X2}0F{1}{2}", nApduLength, strToggleByte, textBox_APDU.Text);

            System.Diagnostics.Debug.WriteLine("RFIDTestNet: tCommand-[" + strCommandParam + "]");

            // Send
            RfidCommon.SendTransferCommand(strCommandParam);

            StringBuilder strOutput = new StringBuilder(1024);
            StringBuilder strCheckData = new StringBuilder(1024);

            RfidCommon.GetData(strOutput);



            if (RfidCommon.CheckResult(strOutput.ToString(), strCheckData))
            {
                textBox_Result.Text = strOutput.ToString();

                label_Status.Text = "Result: Send APDU Success.";            
            }
            else
            {

                label_Status.Text = "Result: No Tag In The Field."; 
            }

        }

        private void radioButton_Apdu_CheckedChanged(object sender, EventArgs e)
        {

            if(radioButton_Apdu_Select.Checked == true)
            {
                textBox_APDU.Text = "00A4040007A000000004101000";
            }
            else if(radioButton_Apdu_Read.Checked == true)
            {
                textBox_APDU.Text = "00B2010C00";
            }
            
        }

    }
}