﻿/********************************************************************
	created:	2012/01/10
	created:	10:1:2012   13:52
	filename: 	D:\M3 work\11. APPLICATION.SVN\RFID\RENEWAL\RFID_SDK\NET\RFID_TEST_NET\Form_Main.cs
	file path:	D:\M3 work\11. APPLICATION.SVN\RFID\RENEWAL\RFID_SDK\NET\RFID_TEST_NET
	file base:	Form_Main
	file ext:	cs
	author:		JJ
	
	purpose:	
*********************************************************************/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using RFIDNet;

namespace RfidTestNet
{
    public partial class Form_Main : Form
    {

        RFIDCommon RfidCommon;
        RFID_TYPE m_Type;

        SOUND_MODE m_SoundMode = SOUND_MODE.SOUND_1;
        SOUND_MODE m_VibrationMode = SOUND_MODE.VIB_1;

        public Form_Main()
        {
            InitializeComponent();

            RfidCommon = new RFIDCommon();
                    
        }

        private void Form_Main_Load(object sender, EventArgs e)
        {
            m_Type = RfidCommon.Open();

            UpdateInformation();
            
        }

        private void UpdateInformation()
        {
            StringBuilder strFwVersion = new StringBuilder(260);
            StringBuilder strReaderDllVersion = new StringBuilder(260);
            StringBuilder strDllVersion = new StringBuilder(260);
            StringBuilder strNetDllVersion = new StringBuilder(260);
            StringBuilder strTagType = new StringBuilder(260);

            RfidCommon.GetVersion2(strFwVersion, strReaderDllVersion, strDllVersion, strNetDllVersion);
            RfidCommon.GetTagTypeToString(strTagType);

            String strInformation;

            strInformation ="RFID FW: " + strFwVersion.ToString() + "\n" +
                            "RFID Reader Dll: " + strReaderDllVersion.ToString() + "\n" +
                            "RFID Dll: " + strDllVersion.ToString() + "\n" +
                            "RFIDNet Dll: " + strNetDllVersion.ToString() + "\n" +
                            "RFID Type: " + m_Type.ToString() + "\n" +
                            "Tag Type: " + strTagType.ToString();

            label_Inform.Text = strInformation;


            System.Diagnostics.Debug.WriteLine("==========\nRFIDTestNet-button_Open_Click \n" + strInformation + "\n==========");

        }

        private void Form_Main_Closed(object sender, EventArgs e)
        {
            RfidCommon.PowerSupply(false);
                     
        }

        private void menuItem_Close_Click(object sender, EventArgs e)
        {

            Close();
        }

        private void button_Continuous_Click(object sender, EventArgs e)
        {
            Form_Continuous FormContinuous = new Form_Continuous(RfidCommon);
            FormContinuous.m_SoundMode = m_SoundMode;
            FormContinuous.m_VibrationMode = m_VibrationMode;
            FormContinuous.ShowDialog();

            UpdateInformation();

        }

        private void button_Memory_Click(object sender, EventArgs e)
        {
            Form_Block FormBlock = new Form_Block(RfidCommon);
            FormBlock.m_SoundMode = m_SoundMode;
            FormBlock.m_VibrationMode = m_VibrationMode;
            FormBlock.ShowDialog();


            UpdateInformation();
        }

        private void button_TagIt_Click(object sender, EventArgs e)
        {
            Form_TagIt formTagIt = new Form_TagIt(RfidCommon);
            formTagIt.m_SoundMode = m_SoundMode;
            formTagIt.m_VibrationMode = m_VibrationMode;

            formTagIt.ShowDialog();

            UpdateInformation();

        }

        private void button_PayPass_Click(object sender, EventArgs e)
        {
            Form_PayPass formPayPass = new Form_PayPass(RfidCommon);
            formPayPass.m_SoundMode = m_SoundMode;
            formPayPass.m_VibrationMode = m_VibrationMode;
            formPayPass.ShowDialog();


            UpdateInformation();
        }

        private void button_Option_Click(object sender, EventArgs e)
        {

            Form_Option formOption = new Form_Option(RfidCommon);
            formOption.m_SoundMode = m_SoundMode;
            formOption.m_VibrationMode = m_VibrationMode;

            formOption.m_RfidType = m_Type;

            formOption.ShowDialog();

            if (formOption.m_bOK)
            {
                m_SoundMode = formOption.m_SoundMode;
                m_VibrationMode = formOption.m_VibrationMode;
            }

            UpdateInformation();
        }

        // Antenna Control for FLAMAGAS
        bool m_bAntenna = false;
        private void button_Antenna_Click(object sender, EventArgs e)
        {
            if (m_bAntenna)
            {
                m_bAntenna = false ;
                RfidCommon.SetAntenna(false);
                button_Antenna.Text = "Antenna OFF";
            }
            else
            {
                m_bAntenna = true;
                RfidCommon.SetAntenna(true);
                button_Antenna.Text = "Antenna ON";
            }
        }
        //
    }
}