﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using RFIDNet;

namespace RfidTestNet
{
    public partial class Form_Block : Form
    {
        RFIDCommon m_Rfid;
        public SOUND_MODE m_VibrationMode = SOUND_MODE.SOUND_NO;
        public SOUND_MODE m_SoundMode = SOUND_MODE.SOUND_1;

        public String m_strKeyType = "AA";
        public String m_strKeySector = "00";
        public String m_strKey = "FFFFFFFFFFFF";
        public bool m_bMifareUse = false;

        private RFID_TYPE m_RfidType = RFID_TYPE.RFID_HF;

        public Form_Block(RFIDCommon rfid)
        {
            InitializeComponent();

            m_Rfid = rfid;
            InitControl();

            m_RfidType = m_Rfid.GetRadioType();

            if (m_RfidType != RFID_TYPE.RFID_HF)
            {
                textBox_BlockCount.Enabled = false;
                label_Memory_BlockCount.Enabled = false;
                textBox_BlockCount.Text = "01";
            }
        }

        private void InitControl()
        {
            label_Memory_Serial.Text = "";
            label_MemoryForm_Status.Text = "";
            textBox_StartBlock.Text = "01";
            textBox_BlockCount.Text = "02";
            textBox_Memory_Result.Text = "";
        }

        private void button_Memory_Select_Click(object sender, EventArgs e)
        {
            StringBuilder strSerial = new StringBuilder(512);

            if(m_Rfid.SelectTag(strSerial))
            {
                m_Rfid.SoundPlay(m_SoundMode);
                m_Rfid.SoundPlay(m_VibrationMode);

                label_Memory_Serial.Text = strSerial.ToString();
                label_MemoryForm_Status.Text = "Result: Read Success";
            }
            else
            {
                label_Memory_Serial.Text = "";
                label_MemoryForm_Status.Text = "Result: No tag in the field";
            }
        }

        private void button_Memory_Read_Click(object sender, EventArgs e)
        {

            if (textBox_StartBlock.Text.Length != 2 || textBox_BlockCount.Text.Length != 2)
            {
                label_MemoryForm_Status.Text = "Status: please Input correct value.";
                return;
            }

            const int nMaxData = 1024;
            StringBuilder strData = new StringBuilder(nMaxData);
            StringBuilder strOutData = new StringBuilder(nMaxData);

            if(textBox_BlockCount.Text == "01")
            {
                m_Rfid.ReadBlock(textBox_StartBlock.Text, strData);
            }
            else
            {
                m_Rfid.ReadMultiBlock(textBox_StartBlock.Text, textBox_BlockCount.Text, strData);
            }

            if (m_Rfid.CheckResult(strData.ToString(), strOutData))
            {
                m_Rfid.SoundPlay(m_SoundMode);
                m_Rfid.SoundPlay(m_VibrationMode);
                label_MemoryForm_Status.Text = "Result: Read Success";
                textBox_Memory_Result.Text = strData.ToString();
            }
            else
            {
                label_MemoryForm_Status.Text = "Result: " + strOutData.ToString();
            }
        }

        private void button_Memory_Write_Click(object sender, EventArgs e)
        {
            if (textBox_StartBlock.Text.Length != 2 || textBox_BlockCount.Text.Length != 2)
            {
                label_MemoryForm_Status.Text = "please Input correct value.";
                return;
            }

            const int nMaxData = 1024;
            StringBuilder strOutData = new StringBuilder(nMaxData);
            StringBuilder strCheckData = new StringBuilder(nMaxData);

            if (textBox_BlockCount.Text == "01")
            {
                m_Rfid.WriteBlock(textBox_StartBlock.Text, textBox_Memory_Result.Text, strOutData);
                textBox_Memory_Result.Text = strOutData.ToString();
            }
            else
            {
                m_Rfid.WriteMultiBlock(textBox_StartBlock.Text, textBox_BlockCount.Text, textBox_Memory_Result.Text, strOutData);
            }

            if (m_Rfid.CheckResult(strOutData.ToString(), strCheckData))
            {
                m_Rfid.SoundPlay(m_SoundMode);
                m_Rfid.SoundPlay(m_VibrationMode);
                label_MemoryForm_Status.Text = "Result: Write Success";
                textBox_Memory_Result.Text = strOutData.ToString();
            }
            else
            {
                label_MemoryForm_Status.Text = "Result: " + strCheckData.ToString();
            }
                         
        }


        private void button_Memory_Login_Click(object sender, EventArgs e)
        {
            Form_Login loginForm = new Form_Login();

            loginForm.m_strKey = m_strKey;

            loginForm.m_RfidType = m_RfidType;
            loginForm.m_bMifareUse = m_bMifareUse;
            loginForm.m_strKeySector = m_strKeySector;
            loginForm.m_strKeyType = m_strKeyType;

            loginForm.ShowDialog();

            if(loginForm.m_bOK == true)
            {
                String strMifareKey;

                m_strKey = loginForm.m_strKey;

                m_bMifareUse = loginForm.m_bMifareUse;
                m_strKeySector = loginForm.m_strKeySector;
                m_strKeyType = loginForm.m_strKeyType;

                if(m_bMifareUse == true && m_RfidType == RFID_TYPE.RFID_HF)
                {
                    strMifareKey = m_strKeySector + m_strKeyType + m_strKey;
                }
                else
                {
                    strMifareKey = m_strKey;
                }

                String strResult = "";

                strResult = m_Rfid.LoginTag(strMifareKey).ToString();

                if (strResult[0] == 'L' || strResult[0] == 'l')
                {
                    label_MemoryForm_Status.Text = "Result: Login success!";
                }
                else
                {
                    StringBuilder strLoginResult = new StringBuilder(512);

                    m_Rfid.CheckResult(strResult, strLoginResult);
                    label_MemoryForm_Status.Text = "Result: " + strLoginResult.ToString();
                }

            }
        }

        private void button_Result_Clear_Click(object sender, EventArgs e)
        {
            InitControl();
        }

    }
}