// TagItPage.cpp : implementation file
//

#include "stdafx.h"
#include "RfidTest.h"
#include "TagItDlg.h"

#include "OtherFunctions.h"
// CTagItDlg dialog

IMPLEMENT_DYNAMIC(CTagItDlg, CDialog)

CTagItDlg::CTagItDlg(CWnd* pParent)
	: CDialog(CTagItDlg::IDD, pParent)
{
	
}

CTagItDlg::~CTagItDlg()
{

}

void CTagItDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CTagItDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_TI_INVENTORY, &CTagItDlg::OnBnClickedButtonTiInventory)
	ON_BN_CLICKED(IDC_BUTTON_TI_READ, &CTagItDlg::OnBnClickedButtonTiRead)
	ON_BN_CLICKED(IDC_BUTTON_TI_WRITE, &CTagItDlg::OnBnClickedButtonTiWrite)
	ON_BN_CLICKED(IDC_BUTTON_TI_CLEAR, &CTagItDlg::OnBnClickedButtonTiClear)
END_MESSAGE_MAP()

BOOL CTagItDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_INVENTORY), L"");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_TI_BLOCK), L"01");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_TI_RESULT), L"");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_TI_RESULT_MSG), L"");

	RFID_SetTagType(ISO_15693);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_PAYPASS_RESULT_STATUS), L"Result: TagType is ISO_15693");


	LOGFONT LogFont;

	GetDlgItem(IDC_STATIC_TAGIT_TITLE)->GetFont()->GetLogFont(&LogFont);

	LogFont.lfWeight = 700;

	m_cFont.CreateFontIndirect(&LogFont);

	GetDlgItem(IDC_STATIC_TAGIT_TITLE)->SetFont(&m_cFont);


	return 0;

}

// CTagItDlg message handlers

void CTagItDlg::OnBnClickedButtonTiInventory()
{
	TCHAR tzInventory[256] = {0x00};
	memset(tzInventory, 0x00, sizeof(TCHAR) * 256);

	if(RFID_TagItInventory(tzInventory))
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_INVENTORY), tzInventory);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_TI_RESULT_MSG), L"Result: Tag was selected");

		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_TI_RESULT_MSG), L"Result: No tag in the field");
	}
}

void CTagItDlg::OnBnClickedButtonTiRead()
{
	TCHAR tzBlock[8] = {0x00};
	TCHAR tzResult[256] = {0x00};
	WCHAR* wFlag;

	memset(tzResult, 0x00, sizeof(TCHAR) * 256);
	memset(tzBlock,0x00, sizeof(TCHAR) *4);

	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_TI_BLOCK), tzBlock, 8);

	int nBlock = wcstoul(tzBlock, &wFlag, 16);

	if(RFID_TagItReadBlock(nBlock, tzResult))
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_TI_RESULT), tzResult);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_TI_RESULT_MSG), L"Result: Read Success");

		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_TI_RESULT_MSG), L"Result: Read Fail");
	}
}

void CTagItDlg::OnBnClickedButtonTiWrite()
{
	TCHAR tzBlock[8] = {0x00};
	TCHAR tzBlockData[256] = {0x00};
	TCHAR tzResultData[256] = {0x00};
	WCHAR* wFlag;

	memset(tzBlock,0x00, sizeof(TCHAR) *4);
	memset(tzBlockData, 0x00, sizeof(TCHAR) * 256);
	memset(tzResultData, 0x00, sizeof(TCHAR) * 256);

	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_TI_BLOCK), tzBlock, 8);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_TI_RESULT), tzBlockData, 256);

	int nBlock = wcstoul(tzBlock, &wFlag, 16);

	if(RFID_TagItWriteBlock(nBlock, tzBlockData,tzResultData))
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_TI_RESULT), tzResultData);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_TI_RESULT_MSG), L"Result: Write Success");


		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_TI_RESULT_MSG), L"Result: Write Fail");

	}
}

void CTagItDlg::OnBnClickedButtonTiClear()
{
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_INVENTORY), L"");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_TI_RESULT), L"");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_TI_RESULT_MSG), L"");
}
