// RfidInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RfidTest.h"
#include "RFID.h"

#include "RfidInfoDlg.h"

#include "OtherFunctions.h"



// CRfidInfoDlg dialog

IMPLEMENT_DYNAMIC(CRfidInfoDlg, CDialog)

CRfidInfoDlg::CRfidInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRfidInfoDlg::IDD, pParent)
{
	m_RfType =RFID_NOTHING;

}

CRfidInfoDlg::~CRfidInfoDlg()
{

}

void CRfidInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CRfidInfoDlg, CDialog)
END_MESSAGE_MAP()

BOOL CRfidInfoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	

	TCHAR tzRadioType[256] = {0x00};
	m_RfType = RFID_GetType();

	if(m_RfType == RFID_LF)
	{
		wsprintf(tzRadioType, L"Low Frequency");

	}
	else if(m_RfType = RFID_HF)
	{

		wsprintf(tzRadioType, L"High Frequency");
	}
	else
	{
		return FALSE;
	}

	RfidGetVersion(tzRadioType);

	SetStaticTagType();

	LOGFONT LogFont;

	GetDlgItem(IDC_STATIC_VER_TITLE)->GetFont()->GetLogFont(&LogFont);

	LogFont.lfWeight = 700;

	m_cFont.CreateFontIndirect(&LogFont);

	GetDlgItem(IDC_STATIC_VER_TITLE)->SetFont(&m_cFont);


	
	return FALSE;
}
BOOL CRfidInfoDlg::RfidGetVersion(TCHAR* tzRadio)
{
	TCHAR tzMsg[256] = {0x00};
	TCHAR tzRfid[256] = {0x00};
	TCHAR tzDLL[256] = {0x00};
	TCHAR tzReaderDll[256] = {0x00};

	BOOL bRet = RFID_GetVersion(tzRfid, tzReaderDll, tzDLL);

	wsprintf(tzMsg, L"RFID APP: %s (%s)\n"
					L"RFID DLL: %s\n"
					L"ReaderDll: %s\n"
					L"Firmware: %s\n" 
					L"Radio: %s",
					APP_VERSION, APP_RELEASE, tzDLL, tzReaderDll, tzRfid, tzRadio);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_INFORM), tzMsg);

	return bRet;

}


void CRfidInfoDlg::SetStaticTagType()
{
	TCHAR tzTagType[32] = {0x00};
	ZeroMemory(tzTagType, sizeof(TCHAR) * 32);

	TCHAR tzMsg[128] = {0x00};
	ZeroMemory(tzMsg, sizeof(TCHAR) * 128);

	RFID_GetTagTypeToString(tzTagType);
	wsprintf(tzMsg, L"Tag Type: %s", tzTagType);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_TAG_TYPE), tzMsg);
}

