// OptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RfidTest.h"
#include "OptionDlg.h"

#include "OtherFunctions.h"


// COptionDlg dialog

IMPLEMENT_DYNAMIC(COptionDlg, CDialog)

COptionDlg::COptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionDlg::IDD, pParent)
	, m_nReadSound(0)
	, m_nReadVibration(0)
{
	m_RfidType = RFID_NOTHING;
}

COptionDlg::~COptionDlg()
{
}

void COptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_TAG_TYPE, m_cmbTagType);
	DDX_Radio(pDX, IDC_RADIO_SOUND_NONE, m_nReadSound);
	DDX_Radio(pDX, IDC_RADIO_VIB_NONE, m_nReadVibration);
}


BEGIN_MESSAGE_MAP(COptionDlg, CDialog)
	ON_COMMAND(ID_CANCEL, &COptionDlg::OnMenuCancel)
	ON_COMMAND(ID_OK, &COptionDlg::OnMenuOk)
END_MESSAGE_MAP()


// COptionDlg message handlers
BOOL COptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	if(m_RfidType == RFID_HF)
	{
		m_cmbTagType.InsertString(ISO_14443_TYPE_A, L"ISO_14443_TYPE_A");
		m_cmbTagType.InsertString(ISO_14443_TYPE_B, L"ISO_14443_TYPE_B");
		m_cmbTagType.InsertString(ICODE_UID, L"ICODE_UID");
		m_cmbTagType.InsertString(ICODE_EPC, L"ICODE_EPC");
		m_cmbTagType.InsertString(ICODE, L"ICODE");
		m_cmbTagType.InsertString(SR176, L"SR176");
		m_cmbTagType.InsertString(ACTIVATE_ALL_TAG, L"ACTIVATE_ALL_TAG");
		m_cmbTagType.InsertString(ISO_15693, L"ISO_15693");
		m_cmbTagType.SetCurSel(RFID_GetTagType());
		

	}
	else if(m_RfidType == RFID_LF)
	{
		m_cmbTagType.InsertString(ACTIVATE_ALL_TAGS, L"ACTIVATE_ALL_TAGS");
		m_cmbTagType.InsertString(EM4x02, L"EM4x02");
		m_cmbTagType.InsertString(EM4x05, L"EM4x05");
		m_cmbTagType.InsertString(EM4x50, L"EM4x50");
		m_cmbTagType.InsertString(HITAG1_S, L"HITAG1_S");
		m_cmbTagType.InsertString(HITAG2, L"HITAG2");
		m_cmbTagType.InsertString(TI_RFID_SYSTEMS, L"TI_RFID_SYSTEMS");
		m_cmbTagType.InsertString(Q5, L"Q5");
		m_cmbTagType.SetCurSel(RFID_GetTagType());
	}
	else
	{
		m_cmbTagType.InsertString(0, L"need opening RFID");
		m_cmbTagType.SetCurSel(0);
	}

	COtherFunctions::ViewMenu(m_hWnd, IDR_MENU_OK);
	
	LOGFONT LogFont;

	GetDlgItem(IDC_STATIC_OPTION_TITLE)->GetFont()->GetLogFont(&LogFont);

	LogFont.lfWeight = 700;

	m_cFont.CreateFontIndirect(&LogFont);

	GetDlgItem(IDC_STATIC_OPTION_TITLE)->SetFont(&m_cFont);

	m_nReadSound = m_SoundSound;
	m_nReadVibration = SetVibration(m_SoundVibration);
	UpdateData(FALSE);

	return 0;
}

int COptionDlg::SetVibration(SOUND_MODE SoundVibration)
{
	if(SoundVibration > SOUND_3)
	{
		m_nReadVibration = (int)SoundVibration - SOUND_3;
	}

	return m_nReadVibration;
}

SOUND_MODE COptionDlg::GetVibration()
{
	UpdateData();
	SOUND_MODE Vib;
	if(m_nReadVibration < SOUND_3)
	{
		Vib = (SOUND_MODE)(m_nReadVibration + SOUND_3);
	}
	return Vib;
}

void COptionDlg::OnOK()
{
	UpdateData(TRUE);

	m_nTagType = m_cmbTagType.GetCurSel();
	m_SoundVibration = GetVibration();
	m_SoundSound = (SOUND_MODE)m_nReadSound;
	UpdateData(FALSE);

	CDialog::OnOK();
}
void COptionDlg::OnMenuCancel()
{

	CDialog::OnCancel();
}

void COptionDlg::OnMenuOk()
{
	OnOK();
}
