// MemoryPage.cpp : implementation file
//

#include "stdafx.h"
#include "RfidTest.h"
#include "MemoryDlg.h"


#include "LoginDlg.h"
#include "OtherFunctions.h"

// CMemoryDlg dialog

IMPLEMENT_DYNAMIC(CMemoryDlg, CDialog)

CMemoryDlg::CMemoryDlg(CWnd* pParent)
	: CDialog(CMemoryDlg::IDD, pParent)
{
	m_bMifareLogin = FALSE;
	
}

CMemoryDlg::~CMemoryDlg()
{
}

void CMemoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CMemoryDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SELECT, &CMemoryDlg::OnBnClickedButtonSelect)
	ON_BN_CLICKED(IDC_BUTTON_READ, &CMemoryDlg::OnBnClickedButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, &CMemoryDlg::OnBnClickedButtonWrite)
	ON_BN_CLICKED(IDC_BUTTON_LOGIN, &CMemoryDlg::OnBnClickedButtonLogin)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, &CMemoryDlg::OnBnClickedButtonClear)
END_MESSAGE_MAP()

BOOL CMemoryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	TCHAR tzVersion[32] = {0x00};
	TCHAR tzVersion2[32] = {0x00};
	TCHAR tzVersion3[32] = {0x00};
	memset(tzVersion, 0x00, sizeof(TCHAR) * 32);

	RFID_GetVersion(tzVersion, tzVersion2, tzVersion3);

	if(wcscmp(tzVersion, L"MultiISO 1.0") == 0 || m_RfType == RFID_LF)
	{
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_EDIT_BLOCK_COUNT), FALSE);
	}

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_BLOCK), L"04");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_BLOCK_COUNT), L"01");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_SERIAL_RESULT), L"");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"");


	LOGFONT LogFont;

	GetDlgItem(IDC_STATIC_MEMORY_TITLE)->GetFont()->GetLogFont(&LogFont);

	LogFont.lfWeight = 700;

	m_cFont.CreateFontIndirect(&LogFont);

	GetDlgItem(IDC_STATIC_MEMORY_TITLE)->SetFont(&m_cFont);


	return 0;
}
// CMemoryDlg message handlers

void CMemoryDlg::OnBnClickedButtonSelect()
{
	TCHAR tzSerial[32] ={0x00};
	memset(tzSerial, 0x00, sizeof(TCHAR) * 32);

	if(RFID_SelectTag(tzSerial))
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_SERIAL_RESULT), tzSerial);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"Result: Tag was selected");
		
		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"Result: No tag in the field");
	}
}

void CMemoryDlg::OnBnClickedButtonRead()
{
	const int nLength = 8;
	TCHAR tzStartBlock[nLength] = {0x00};
	TCHAR tzBlockCount[nLength] = {0x00};
	const int nMaxData = 1024;
	TCHAR tzData[nMaxData] = {0x00};

	memset(tzStartBlock, 0x00, sizeof(TCHAR) * nLength);
	memset(tzBlockCount, 0x00, sizeof(TCHAR) * nLength);
	memset(tzData, 0x00, sizeof(TCHAR) * nMaxData);

	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_BLOCK), tzStartBlock, nLength);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_BLOCK_COUNT), tzBlockCount, nLength);

	int nBlockLength = wcslen(tzStartBlock);
	int nBlockCountLength = wcslen(tzBlockCount);

	if(nBlockLength < 1 || nBlockLength > nLength || nBlockCountLength < 1 || nBlockCountLength > nLength)
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"Result: Need correct data");
		return;
	}
	
	if(wcscmp(tzBlockCount, L"01") == 0)
	{
		RFID_ReadBlock(tzStartBlock, tzData);
	}
	else
	{
		RFID_ReadMultiBlock(tzStartBlock, tzBlockCount, tzData);
	}

	TCHAR tzMsg[1024] = {0x00};
	memset(tzMsg, 0x00, sizeof(TCHAR) * 1024);

	if(RFID_CheckResult(tzData, tzMsg))
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"Result: Read Success");

		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_RESULT), tzData);

		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"Result: Read Failed");

		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_RESULT), tzMsg);
	}

}

void CMemoryDlg::OnBnClickedButtonWrite()
{
	const int nLength = 8;
	TCHAR tzStartBlock[nLength] = {0x00};
	TCHAR tzBlockCount[nLength] = {0x00};
	const int nMaxData = 1024;
	TCHAR tzData[nMaxData] = {0x00};
	TCHAR tzResultData[nMaxData] = {0x00};
	TCHAR tzOutData[nMaxData] = {0x00};

	memset(tzStartBlock, 0x00, sizeof(TCHAR) * nLength);
	memset(tzBlockCount, 0x00, sizeof(TCHAR) * nLength);
	memset(tzData, 0x00, sizeof(TCHAR) * nMaxData);
	memset(tzResultData, 0x00, sizeof(TCHAR) * nMaxData);
	memset(tzOutData, 0x00, sizeof(TCHAR) * nMaxData);

	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_BLOCK), tzStartBlock, nLength);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_BLOCK_COUNT), tzBlockCount, nLength);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_RESULT), tzData, nMaxData);

	int nBlockLength = wcslen(tzStartBlock);
	int nBlockCountLength = wcslen(tzBlockCount);

	if(nBlockLength < 1 || nBlockLength > nLength || nBlockCountLength < 1 || nBlockCountLength > nLength)
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"Result: Need correct data");
		return;
	}

	if(wcscmp(tzBlockCount, L"01") == 0)
	{
		RFID_WriteBlock(tzStartBlock, tzData, tzOutData);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_RESULT), tzOutData);
	}
	else
	{
		RFID_WriteMultiBlock(tzStartBlock, tzBlockCount, tzData, tzOutData);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_RESULT), tzOutData);
	}

	TCHAR tzMsg[1024] = {0x00};
	memset(tzMsg, 0x00, sizeof(TCHAR) * 1024);

	if(RFID_CheckResult(tzOutData, tzMsg))
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"Result: Write Success");

		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_RESULT), tzOutData);

		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"Result: Write Failed");

		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_RESULT), tzOutData);
	}
}

void CMemoryDlg::OnBnClickedButtonLogin()
{
	CLoginDlg dlg;

	dlg.m_bCheckMifare = m_bMifareLogin;
	if(dlg.DoModal() == IDOK)
	{
		TCHAR tzLoginKey[256] = {0x00};
		memset(tzLoginKey, 0x00, sizeof(TCHAR) * 256);

		if(dlg.m_bCheckMifare == TRUE)
		{
			wsprintf(tzLoginKey, L"%s%s%s", dlg.m_strMifareSector, dlg.m_strMifareKeyType, dlg.m_strLoginKey);
			m_bMifareLogin = TRUE;
		}
		else
		{
			wsprintf(tzLoginKey, L"%s", dlg.m_strLoginKey);
		}

		TCHAR tRet = RFID_LoginTag(tzLoginKey);
		if(tRet == 'L' || tRet == 'l')
		{
			::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"Result: Login success!");

			RFID_SoundPlay(m_nReadSound);
			RFID_SoundPlay(m_nReadVibration);
		}
		else
		{
			TCHAR tzResult[256] = {0x00};
			TCHAR tzMsg[256] = {0x00};
			memset(tzResult, 0x00, sizeof(TCHAR) * 256);
			memset(tzMsg, 0x00, sizeof(TCHAR) * 256);

			RFID_CheckResult(&tRet, tzResult);

			wsprintf(tzMsg, L"Result: %s", tzResult);

			::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), tzMsg);
		}

	}
}

void CMemoryDlg::OnBnClickedButtonClear()
{
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_RESULT), L"");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_SERIAL_RESULT), L"");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_RESULT_MSG), L"");
}
