// ApduDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RfidTest.h"
#include "ApduDlg.h"


// CApduDlg dialog

IMPLEMENT_DYNAMIC(CApduDlg, CDialog)

CApduDlg::CApduDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CApduDlg::IDD, pParent)
{

}

CApduDlg::~CApduDlg()
{
}

void CApduDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CApduDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_APDU_SEND, &CApduDlg::OnBnClickedButtonApduSend)
	ON_BN_CLICKED(IDC_BUTTON_APDU_SELECT, &CApduDlg::OnBnClickedButtonApduSelect)
	ON_BN_CLICKED(IDC_BUTTON_APDU_FF, &CApduDlg::OnBnClickedButtonApduFf)
	ON_EN_CHANGE(IDC_EDIT_APDU_INPUT, &CApduDlg::OnEnChangeEditApduInput)
END_MESSAGE_MAP()


// CApduDlg message handlers
BOOL CApduDlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APDU_RESULT), L"");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APDU_SERIAL), L"");


	LOGFONT LogFont;

	GetDlgItem(IDC_STATIC_APDU_TITLE)->GetFont()->GetLogFont(&LogFont);

	LogFont.lfWeight = 700;

	m_cFont.CreateFontIndirect(&LogFont);

	GetDlgItem(IDC_STATIC_APDU_TITLE)->SetFont(&m_cFont);

	return 0;
}

void CApduDlg::OnBnClickedButtonApduSelect()
{


	TCHAR tzSerial[256] = {0x00};
	memset(tzSerial, 0x00, sizeof(TCHAR) * 256);
	TCHAR tzMsg[256] = {0x00};
	memset(tzMsg, 0x00, sizeof(TCHAR) * 256);

	if(RFID_HighSelectTag(tzSerial))
	{
		wsprintf(tzMsg, L"Serial: %s", tzSerial);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APDU_SERIAL), tzMsg);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APDU_RESULT), L"");

		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APDU_SERIAL), L"");
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APDU_RESULT), L"Result: No tag in the field");
	}

}

void CApduDlg::OnBnClickedButtonApduSend()
{
	TCHAR tzOutData[1024] = {0x00};

	TCHAR tzAPDU[1024] = {0x00};
	TCHAR tzCLA[16] = {0x00};
	TCHAR tzINS[16] = {0x00};
	TCHAR tzP1[16] = {0x00};
	TCHAR tzP2[16] = {0x00};
	TCHAR tzLc[16] = {0x00};
	TCHAR tzLe[16] = {0x00};
	TCHAR tzInputData[1024] = {0x00};

	TCHAR tzCommand[1024] = {0x00};

	memset(tzOutData, 0x00, sizeof(TCHAR) * 1024);

	memset(tzAPDU, 0x00, sizeof(TCHAR) * 1024);
	memset(tzCLA, 0x00, sizeof(TCHAR) * 16);
	memset(tzINS, 0x00, sizeof(TCHAR) * 16);
	memset(tzP1, 0x00, sizeof(TCHAR) * 16);
	memset(tzP2, 0x00, sizeof(TCHAR) * 16);
	memset(tzLc, 0x00, sizeof(TCHAR) * 16);
	memset(tzLe, 0x00, sizeof(TCHAR) * 16);
	memset(tzInputData, 0x00, sizeof(TCHAR) * 1024);

	memset(tzCommand, 0x00, sizeof(TCHAR) * 1024);

	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_CLA), tzCLA, 16);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_INS), tzINS, 16);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_P1), tzP1, 16);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_P2), tzP2, 16);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_LC), tzLc, 16);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_LE), tzLe, 16);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_INPUT), tzInputData, 1024);

	wsprintf(tzAPDU, L"%s%s%s%s%s%s%s", tzCLA, tzINS, tzP1, tzP2, tzLc, tzInputData, tzLe);

	if(RFID_APDUCommandGetDataEx(tzAPDU, tzOutData))
	{
		RETAILMSG(RT_MSG, (L"CApduDlg::OnBnClickedButtonApduSend GetData- [%s]\r\n", tzOutData));

		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_OUTPUT), tzOutData);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APDU_RESULT), L"Result: Get Data Success");

		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);

	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_OUTPUT), L"");
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APDU_RESULT), L"Result: Get Data Failed");
	}

}


void CApduDlg::OnBnClickedButtonApduFf()
{
	TCHAR tzFF[1024] = {0x00};
	memset(tzFF, 0x00, sizeof(TCHAR) * 1024);

// 	int Number = 0x00;
// 	for(int i = 0x00; i<0xFF; i++)
// 	{
// 		TCHAR tzNumber[8] = {0x00};
// 		wsprintf(tzNumber, L"%02x", Number++);
// 		wcscat(tzFF, tzNumber);
// 	}

  	wsprintf(tzFF, L"1234567890123456000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009192939495969798999a9b9c9d9e9f");
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_INPUT), tzFF);
	
	OnEnChangeEditApduInput();
	
}

void CApduDlg::OnEnChangeEditApduInput()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	TCHAR tzData[1024] = {0x00};
	memset(tzData, 0x00, sizeof(TCHAR) * 1024);

	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_APDU_INPUT), tzData, 1024);

	int nLength = wcslen(tzData)/2;

	wsprintf(tzData, L"%02X", nLength);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_APDU_IN_LENGTH), tzData);

}
