using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace R_HH_M3O_UHF_SDK.NET_DEMO
{
    class Convertor
    {
        //[Serializable]
        [StructLayout(LayoutKind.Sequential)]
        public struct ATTENUATION
        {
            [MarshalAsAttribute(UnmanagedType.U2)]
            public short shMaxAttenuation;

            [MarshalAsAttribute(UnmanagedType.U2)]
            public short shAttenuation;
        }

        public struct SENSIVITY
        {
            [MarshalAsAttribute(UnmanagedType.U2)]
            public short shMaxSensivity;

            [MarshalAsAttribute(UnmanagedType.U2)]
            public short shMinSensivity;

            [MarshalAsAttribute(UnmanagedType.U2)]
            public short shSensivity;
        }

        public struct FREQUENCY
        {
            [MarshalAsAttribute(UnmanagedType.U1)]
            public byte bFreq;

            [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 0x10)]
            public UInt32[] arrFreq;
        }

        public struct READ_WRITE_INFO
        {
            [MarshalAsAttribute(UnmanagedType.U1)]
            public byte bCardIdLen;

            [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 0x20)]
            public byte[] arrCardId;

            [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 0x04)]
            public byte[] arrPass;

            [MarshalAsAttribute(UnmanagedType.U1)]
            public byte bBank;

            [MarshalAsAttribute(UnmanagedType.U4)]
            public UInt32 nAddress;
        }

        public struct KILL_TAG_INFO
        {
            [MarshalAsAttribute(UnmanagedType.U1)]
            public byte bCardIdLen;

            [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 0x20)]
            public byte[] arrCardId;

            [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 0x04)]
            public byte[] arrPass;
        };

        public struct LOCK_INFO
        {
            [MarshalAsAttribute(UnmanagedType.U1)]
            public byte bCardIdLen;

            [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 0x20)]
            public byte[] arrCardId;

            [MarshalAsAttribute(UnmanagedType.ByValArray, SizeConst = 0x04)]
            public byte[] arrPass;

            [MarshalAsAttribute(UnmanagedType.U1)]
            public byte bBank;

            [MarshalAsAttribute(UnmanagedType.U1)]
            public byte bLockType;
        };

        public ATTENUATION GetAttenuation(byte[] bufData)
        {
            ATTENUATION stAttenuation = new ATTENUATION();

            int size = Marshal.SizeOf(stAttenuation);
            IntPtr ptr = Marshal.AllocHGlobal(size);

            Marshal.Copy(bufData, 0, ptr, size);

            stAttenuation = (ATTENUATION)Marshal.PtrToStructure(ptr, stAttenuation.GetType());
            Marshal.FreeHGlobal(ptr);

            return stAttenuation;
        }

        public SENSIVITY GetSensivity(byte[] bufData)
        {
            SENSIVITY stSensivity = new SENSIVITY();

            int size = Marshal.SizeOf(stSensivity);
            IntPtr ptr = Marshal.AllocHGlobal(size);

            Marshal.Copy(bufData, 0, ptr, size);

            stSensivity = (SENSIVITY)Marshal.PtrToStructure(ptr, stSensivity.GetType());
            Marshal.FreeHGlobal(ptr);

            return stSensivity;
        }

        public FREQUENCY GetFreq(byte[] bufData)
        {
            FREQUENCY stFreq = new FREQUENCY();

            int size = Marshal.SizeOf(stFreq);
            IntPtr ptr = Marshal.AllocHGlobal(size);

            Marshal.Copy(bufData, 0, ptr, size);

            stFreq = (FREQUENCY)Marshal.PtrToStructure(ptr, stFreq.GetType());
            Marshal.FreeHGlobal(ptr);

            return stFreq;
        }

        public byte[] GetFreq(FREQUENCY stFreq)
        {
            int iSize = Marshal.SizeOf(stFreq);
            byte[] arrByte = new byte[iSize];
            IntPtr pStruct = Marshal.AllocHGlobal(iSize);

            Marshal.StructureToPtr(stFreq, pStruct, true);
            Marshal.Copy(pStruct, arrByte, 0, iSize);
            Marshal.FreeHGlobal(pStruct);

            return arrByte;
        }

        public byte[] StringToHex(string strDataSplit)
        {
            string[] strSplit = strDataSplit.Split('-');
            string strData = "";
            foreach (string strDataWrite in strSplit)
            {
                strData += strDataWrite;
            }

            byte[] arrData = new byte[strData.Length / 2];
            for (int iCount = 0; iCount <= strData.Length - 0x02; iCount += 0x02)
            {
                arrData[iCount / 0x02] = (byte)Int32.Parse(strData.Substring(iCount, 2), System.Globalization.NumberStyles.HexNumber);
            }
            return arrData;
        }

        public byte[] GetReadWriteInfo(READ_WRITE_INFO stReadWriteInfo)
        {
            int iSize = Marshal.SizeOf(stReadWriteInfo);
            byte[] arrByte = new byte[iSize];
            IntPtr pStruct = Marshal.AllocHGlobal(iSize);

            Marshal.StructureToPtr(stReadWriteInfo, pStruct, true);
            Marshal.Copy(pStruct, arrByte, 0, iSize);
            Marshal.FreeHGlobal(pStruct);

            return arrByte;
        }

        public byte[] GetKillTagInfo(KILL_TAG_INFO stKillTagInfo)
        {
            int iSize = Marshal.SizeOf(stKillTagInfo);
            byte[] arrByte = new byte[iSize];
            IntPtr pStruct = Marshal.AllocHGlobal(iSize);

            Marshal.StructureToPtr(stKillTagInfo, pStruct, true);
            Marshal.Copy(pStruct, arrByte, 0, iSize);
            Marshal.FreeHGlobal(pStruct);

            return arrByte;
        }

        public byte[] GetLockInfo(LOCK_INFO stLockInfo)
        {
            int iSize = Marshal.SizeOf(stLockInfo);
            byte[] arrByte = new byte[iSize];
            IntPtr pStruct = Marshal.AllocHGlobal(iSize);

            Marshal.StructureToPtr(stLockInfo, pStruct, true);
            Marshal.Copy(pStruct, arrByte, 0, iSize);
            Marshal.FreeHGlobal(pStruct);

            return arrByte;
        }
    }
}
