using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;
using System.Threading;


namespace R_HH_M3O_UHF_SDK.NET_DEMO
{
    public partial class Main : Form
    {
        [DllImport("R-HH-M3O-UHF-SDK.dll")]
        public static extern IntPtr OpenReader();

        [DllImport("R-HH-M3O-UHF-SDK.dll")]
        public static extern UInt32 GetReaderCaps(IntPtr hReader, UInt32 nRdFeat, byte[] pData, ref UInt32 nCount);

        [DllImport("R-HH-M3O-UHF-SDK.dll")]
        public static extern UInt32 SetReaderCaps(IntPtr hReader, UInt32 nRdFeat, byte[] pData, UInt32 nCount);

        [DllImport("R-HH-M3O-UHF-SDK.dll")]
        public static extern UInt32 ReadData(IntPtr hReader, byte[] pData, ref UInt32 dwCount);

        [DllImport("R-HH-M3O-UHF-SDK.dll")]
        public static extern UInt32 WriteData(IntPtr hReader, byte[] pData, UInt32 dwCount);

        [DllImport("R-HH-M3O-UHF-SDK.dll")]
        public static extern void CloseReader(IntPtr hReader);


        public enum EREADER_FEATURE
        {
            ERD_SERIAL_NUMER = 0x00,
            ERD_READER_TYPE,
            ERD_HARDWARE_REV,
            ERD_SOFTWARE_REV,
            ERD_BOOTLOADER_REV,
            ERD_CURRENT_STATE,
            ERD_ATTENUATION,
            ERD_SENSITIVITY,
            ERD_FREQUENCY,
            ERD_REBOOT,
            ERD_RESTORE_SETTINGS,
            ERD_SAVE_SETTINGS,
            ERD_CARD,
            ERD_READ_WRITE_PARAM,
            ERD_KILL_TAG,
            ERD_LOCK_TAG,
        };

        public enum EERROR
        {
            ER_OK = 0x00,
            ER_NOT_IMPLEMENTED,
            ER_INVALID_POINTER,
            ER_FEATURE,
            ER_NO_PROTOCOL,
            ER_OPEN,
            ER_CLOSE,
            ER_WRITE,
            ER_READ,
            ER_SET_SPEED,
            ER_SET_TIMEOUT,
            ER_INVALID_DATA,
            ER_SIZE,
            ER_NO_TRANSPORT,
            ER_BCC,
            ER_MORE_DATA,
            ER_CHECK_PROTOCOL,
            ER_TAG_START,
            ER_TAG_LEN,
            ER_TAG_CMD,
            ER_TAG_DATA,
            ER_TAG_BCC,
            ER_EXEC_CMD,
            ER_COM,
            ER_SOH,
            ER_STX,
            ER_ETX,
            ER_CR,
            ER_ADDRESS,
            ER_NAK,
            ER_DATA_BIT_STOP,
            ER_DATA_BIT_SIZE,
            ER_DATA_SPEED,
            ER_NO_TAG,
            ER_WRONG_ANTENA,
            ER_OTHER_ERROR,
            ER_UNKNOWN = -1,
        };

        public Main()
        {
            InitializeComponent();
        }

        private void buttonInfoGet_Click(object sender, EventArgs e)
        {
            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] bufData = new byte[200]; UInt32 nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_SERIAL_NUMER, bufData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    textInfoSerialNr.Text = BitConverter.ToString(bufData, 0x00, (int)nCount);
                }


                nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_READER_TYPE, bufData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    textInfoReaderType.Text = BitConverter.ToString(bufData, 0x00, (int)nCount);
                }

                nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_HARDWARE_REV, bufData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    textInfoHardwareRev.Text = BitConverter.ToString(bufData, 0x00, (int)nCount);
                }

                nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_SOFTWARE_REV, bufData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    textInfoSoftwareRev.Text = BitConverter.ToString(bufData, 0x00, (int)nCount);
                }

                nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_BOOTLOADER_REV, bufData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    textInfoBootLoader.Text = BitConverter.ToString(bufData, 0x00, (int)nCount);
                }

                nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_CURRENT_STATE, bufData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    switch (bufData[0x00])
                    {
                        case 0x00: textInfoCurrentStatus.Text = "Idle"; break;
                        default: textInfoCurrentStatus.Text = "Unknown"; break;
                    }
                }

                CloseReader(hReader);
            }
        }

        private void buttonGetFreq_Click(object sender, EventArgs e)
        {
            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] bufData = new byte[200]; UInt32 nCount = 200;
 

                nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_ATTENUATION, bufData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    Convertor clsConvert = new Convertor();
                    Convertor.ATTENUATION stAttenuation = clsConvert.GetAttenuation(bufData);
                    numericSetAttenuation.Minimum = 0x00;
                    numericSetAttenuation.Maximum = stAttenuation.shMaxAttenuation;
                    numericSetAttenuation.Value = stAttenuation.shAttenuation;
                }

                nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_SENSITIVITY, bufData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    Convertor clsConvert = new Convertor();
                    Convertor.SENSIVITY stSensivity = clsConvert.GetSensivity(bufData);

                    numericSetSensivity.Maximum = stSensivity.shMinSensivity;
                    numericSetSensivity.Minimum = stSensivity.shMaxSensivity;
                    numericSetSensivity.Value = stSensivity.shSensivity;
                }

                nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_FREQUENCY, bufData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    Convertor clsConvert = new Convertor();
                    Convertor.FREQUENCY stFreq = clsConvert.GetFreq(bufData);

                    byte bCount = 0;
                    while (bCount != stFreq.bFreq)
                    {
                        comboSetFreq.Items.Add(stFreq.arrFreq[bCount++].ToString());
                    }
                    comboSetFreq.SelectedIndex = 0x00;
                }

                CloseReader(hReader);
            }
        }

        private void buttonSetFreq_Click(object sender, EventArgs e)
        {
            Convertor clsConvert = new Convertor();
            Convertor.FREQUENCY stFreq = new Convertor.FREQUENCY();

            stFreq.bFreq = 0x00;
            stFreq.arrFreq = new UInt32[/*comboInfoFrequency.Items.Count*/0x10];
            foreach (string strItem in comboSetFreq.Items)
            {
                stFreq.arrFreq[stFreq.bFreq++] = Convert.ToUInt32(strItem);
            }

            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] bufData = clsConvert.GetFreq(stFreq);
                if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_FREQUENCY, bufData, (UInt32)bufData.Length) == (UInt32)EERROR.ER_OK)
                {
                    Console.WriteLine("Set Freq work !!!");
                }

                CloseReader(hReader);
            }
        }

        private void buttonSetAttenuation_Click(object sender, EventArgs e)
        {
            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] bufData = BitConverter.GetBytes((short)numericSetAttenuation.Value);

                if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_ATTENUATION, bufData, (UInt32)bufData.Length) == (UInt32)EERROR.ER_OK)
                {
                    Console.WriteLine("Set attenuation work !!!");
                }

                CloseReader(hReader);
            }
        }

        private void buttonSetSensivity_Click(object sender, EventArgs e)
        {
            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] bufData = BitConverter.GetBytes((short)numericSetSensivity.Value);

                if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_SENSITIVITY, bufData, (UInt32)bufData.Length) == (UInt32)EERROR.ER_OK)
                {
                    Console.WriteLine("Set Sensivity work !!!");
                }

                CloseReader(hReader);
            }
        }

        private void buttonScanCards_Click(object sender, EventArgs e)
        {
            listScanCards.Items.Clear();

            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] arrData = new byte[200]; UInt32 nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_CARD, arrData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    Convertor clsConv = new Convertor();
                    int iNav = 0x01;
                    for (UInt32 nStep = 0x00; nStep < arrData[0x00]; nStep++)
                    {
                        ListViewItem clsLstItem = new ListViewItem(new string[] { "UHF", BitConverter.ToString(arrData, iNav + 0x01, (int)arrData[iNav]) });
                        listScanCards.Items.Add(clsLstItem);
                        iNav += arrData[iNav] + 0x01;
                    }
                }
                CloseReader(hReader);
            }
        }

        private void buttonRWScan_Click(object sender, EventArgs e)
        {
            comboRWCardID.Items.Clear();

            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] arrData = new byte[200]; UInt32 nCount = 200;
                if (GetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_CARD, arrData, ref nCount) == (UInt32)EERROR.ER_OK)
                {
                    Convertor clsConv = new Convertor();
                    int iNav = 0x01;
                    for (UInt32 nStep = 0x00; nStep < arrData[0x00]; nStep++)
                    {
                        comboRWCardID.Items.Add(BitConverter.ToString(arrData, iNav + 0x01, (int)arrData[iNav]));
                        iNav += arrData[iNav] + 0x01;
                    }
                    comboRWCardID.SelectedIndex = 0x00;
                }
                CloseReader(hReader);
            }
        }

        private void buttonRWRead_Click(object sender, EventArgs e)
        {
            if ((comboRWCardID.SelectedIndex != -1) && (comboRWBank.SelectedIndex != -1))
            {
                IntPtr hReader = OpenReader();
                if (hReader != null)
                {
                    Convertor clsConv = new Convertor();
                    Convertor.READ_WRITE_INFO stReadInfo = new Convertor.READ_WRITE_INFO();

                    byte[] arrCardId        = clsConv.StringToHex(comboRWCardID.Text);
                    stReadInfo.arrCardId    = new byte[0x20];
                    arrCardId.CopyTo(stReadInfo.arrCardId, 0x00);
                    stReadInfo.bCardIdLen   = (byte)arrCardId.Length;
                    stReadInfo.arrPass      = clsConv.StringToHex(textRWPass.Text);
                    stReadInfo.bBank        = (byte)comboRWBank.SelectedIndex;
                    stReadInfo.nAddress     = Convert.ToUInt32(textRWAddress.Text);

                    byte[] arrReadWriteInfo = clsConv.GetReadWriteInfo(stReadInfo);
                    if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_READ_WRITE_PARAM, arrReadWriteInfo, (UInt32)arrReadWriteInfo.Length) == (UInt32)EERROR.ER_OK)
                    {
                        UInt32 nReadData = (UInt32)Convert.ToInt32(textRWNrBytes.Text);
                        byte[] arrReadData = new byte[nReadData];

                        if (ReadData(hReader, arrReadData, ref nReadData) == (UInt32)EERROR.ER_OK)
                        {
                            textRWData.Text = BitConverter.ToString(arrReadData, 0x00, (int)arrReadData.Length);
                        }
                    }
                    CloseReader(hReader);
                }
            }
        }

        private void buttonRWWrite_Click(object sender, EventArgs e)
        {
            if ((comboRWCardID.SelectedIndex != -1) && (comboRWBank.SelectedIndex != -1))
            {
                IntPtr hReader = OpenReader();
                if (hReader != null)
                {
                    Convertor clsConv = new Convertor();
                    Convertor.READ_WRITE_INFO stWriteInfo = new Convertor.READ_WRITE_INFO();

                    byte[] arrCardId        = clsConv.StringToHex(comboRWCardID.Text);
                    stWriteInfo.arrCardId   = new byte[0x20];
                    arrCardId.CopyTo(stWriteInfo.arrCardId, 0x00);
                    stWriteInfo.bCardIdLen  = (byte)arrCardId.Length;
                    stWriteInfo.arrPass     = clsConv.StringToHex(textRWPass.Text);
                    stWriteInfo.bBank       = (byte)comboRWBank.SelectedIndex;
                    stWriteInfo.nAddress    = Convert.ToUInt32(textRWAddress.Text);

                    byte[] arrReadWriteInfo = clsConv.GetReadWriteInfo(stWriteInfo);
                    if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_READ_WRITE_PARAM, arrReadWriteInfo, (UInt32)arrReadWriteInfo.Length) == (UInt32)EERROR.ER_OK)
                    {
                        UInt32 nWriteData = (UInt32)Convert.ToInt32(textRWNrBytes.Text);
                        byte[] arrWriteData = clsConv.StringToHex(textRWData.Text);

                        if (WriteData(hReader, arrWriteData, nWriteData) == (UInt32)EERROR.ER_OK)
                        {
                            textRWData.Text = BitConverter.ToString(arrWriteData, 0x00, (int)arrWriteData.Length);
                        }
                    }
                    CloseReader(hReader);
                }
            }
        }

        private void buttonWRKill_Click(object sender, EventArgs e)
        {
            if ((comboRWCardID.SelectedIndex != -1) && (comboRWBank.SelectedIndex != -1))
            {
                IntPtr hReader = OpenReader();
                if (hReader != null)
                {
                    Convertor clsConv = new Convertor();
                    Convertor.KILL_TAG_INFO stKillTagInfo = new Convertor.KILL_TAG_INFO();

                    byte[] arrCardId = clsConv.StringToHex(comboRWCardID.Text);

                    stKillTagInfo.arrCardId     = new byte[0x20];
                    arrCardId.CopyTo(stKillTagInfo.arrCardId, 0x00);

                    stKillTagInfo.bCardIdLen    = (byte)arrCardId.Length;
                    stKillTagInfo.arrPass       = clsConv.StringToHex(textRWPass.Text);

                    byte[] arrTagInfoInfo       = clsConv.GetKillTagInfo(stKillTagInfo);
                    if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_KILL_TAG, arrTagInfoInfo, (UInt32)arrTagInfoInfo.Length) == (UInt32)EERROR.ER_OK)
                    {
                        Console.WriteLine("Kill tag finish with no error !!!");
                    }
                    CloseReader(hReader);
                }
            }
        }

        private void buttonSetReboot_Click(object sender, EventArgs e)
        {
            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] arrReboot = new byte[0x01];
                arrReboot[0x00] = 0x01;

                if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_REBOOT, arrReboot, 0x01) == (UInt32)EERROR.ER_OK)
                {
                    Console.WriteLine("Reboot correct done !!!");
                }
                CloseReader(hReader);
            }
        }

        private void buttonSetRestoreSet_Click(object sender, EventArgs e)
        {
            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] arrRest = new byte[0x01];
                arrRest[0x00] = 0x01;

                if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_RESTORE_SETTINGS, arrRest, 0x01) == (UInt32)EERROR.ER_OK)
                {
                    Console.WriteLine("Restore settings done !!!");
                }
                CloseReader(hReader);
            }
        }

        private void buttonSetSaveSet_Click(object sender, EventArgs e)
        {
            IntPtr hReader = OpenReader();
            if (hReader != null)
            {
                byte[] arrSave = new byte[0x01];
                arrSave[0x00] = 0x01;

                if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_SAVE_SETTINGS, arrSave, 0x01) == (UInt32)EERROR.ER_OK)
                {
                    Console.WriteLine("Save settings done !!!");
                }
                CloseReader(hReader);
            }
        }

        private void buttonLockSet_Click(object sender, EventArgs e)
        {
            if ((comboLockCardID.SelectedIndex != -1) &&
                (comboLockBank.SelectedIndex != -1) && (comboLockType.SelectedIndex != -1))
            {
                IntPtr hReader = OpenReader();
                if (hReader != null)
                {
                    Convertor clsConv = new Convertor();
                    Convertor.LOCK_INFO stLockInfo = new Convertor.LOCK_INFO();

                    byte[] arrCardId = clsConv.StringToHex(comboLockCardID.Text);

                    stLockInfo.arrCardId = new byte[0x20];
                    arrCardId.CopyTo(stLockInfo.arrCardId, 0x00);

                    stLockInfo.bCardIdLen = (byte)arrCardId.Length;
                    stLockInfo.arrPass = clsConv.StringToHex(textRWPass.Text);

                    stLockInfo.bBank = (byte)comboLockBank.SelectedIndex;
                    stLockInfo.bLockType = (byte)comboLockType.SelectedIndex;

                    byte[] arrLockInfo = clsConv.GetLockInfo(stLockInfo);
                    if (SetReaderCaps(hReader, (UInt32)EREADER_FEATURE.ERD_LOCK_TAG, arrLockInfo, (UInt32)arrLockInfo.Length) == (UInt32)EERROR.ER_OK)
                    {
                        Console.WriteLine("Kill tag finish with no error !!!");
                    }
                    CloseReader(hReader);
                }
            }
        }

        private void Main_Load(object sender, EventArgs e)
        {
            textRWAddress.Text = "0";
            textRWPass.Text = "00000000";
            textRWNrBytes.Text = "1";

            comboRWBank.Items.Add("Reserved");
            comboRWBank.Items.Add("EPC");
            comboRWBank.Items.Add("TID");
            comboRWBank.Items.Add("USER");
            comboRWBank.SelectedIndex = 0x00;

            textLockPass.Text = "00000000";

            comboLockBank.Items.Add("Reserved");
            comboLockBank.Items.Add("EPC");
            comboLockBank.Items.Add("TID");
            comboLockBank.Items.Add("USER");
            comboLockBank.SelectedIndex = 0x00;


            comboLockType.Items.Add("Writable");
            comboLockType.Items.Add("Always writable");
            comboLockType.Items.Add("Secure writable");
            comboLockType.Items.Add("Always not writable");
            comboLockType.Items.Add("No change");
            comboLockType.SelectedIndex = 0x00;
        }
    }
}