#ifdef RHHM3OUHFSDK_EXPORTS
#define RHHM3OUHFSDK_API __declspec(dllexport)
#else
#define RHHM3OUHFSDK_API __declspec(dllimport)
#endif

#include "Error.h"
#define SDKHANDLE	void*

enum EREADER_FEATURE
{
	ERD_SERIAL_NUMER	= 0x00,
	ERD_READER_TYPE,
	ERD_HARDWARE_REV,
	ERD_SOFTWARE_REV,
	ERD_BOOTLOADER_REV,
	ERD_CURRENT_STATE,
	ERD_ATTENUATION,
	ERD_SENSITIVITY,
	ERD_FREQUENCY,
	ERD_REBOOT,
	ERD_RESTORE_SETTINGS,
	ERD_SAVE_SETTINGS,
	ERD_CARD,
	ERD_READ_WRITE_PARAM,
	ERD_KILL_TAG,
	ERD_LOCK_TAG,
};

RHHM3OUHFSDK_API SDKHANDLE OpenReader();
RHHM3OUHFSDK_API EERROR GetReaderCaps(SDKHANDLE hReader, EREADER_FEATURE eRdFeat, BYTE* pData, DWORD& dwCount);
RHHM3OUHFSDK_API EERROR SetReaderCaps(SDKHANDLE hReader, EREADER_FEATURE eRdFeat, BYTE* pData, DWORD dwCount);
RHHM3OUHFSDK_API EERROR ReadData(SDKHANDLE hReader, BYTE* pData, DWORD& dwCount);
RHHM3OUHFSDK_API EERROR WriteData(SDKHANDLE hReader, BYTE* pData, DWORD dwCount);
RHHM3OUHFSDK_API void	CloseReader(SDKHANDLE hReader);
