#include "stdafx.h"
#include "R-HH-M3O-UHF-SDK-DEMO.h"
#include "DlgSettings.h"

#include "Def.h"
#include "R-HH-M3O-UHF-SDK.h"



IMPLEMENT_DYNAMIC(CDlgSettings, CPropertyPage)

CDlgSettings::CDlgSettings()
	: CPropertyPage(CDlgSettings::IDD)
{

}

CDlgSettings::~CDlgSettings()
{
}

void CDlgSettings::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_ATTENUATION, m_ctrlAttenuation);
	DDX_Control(pDX, IDC_SPIN_ATTENUATION, m_ctrlSpinAttenuation);
	DDX_Control(pDX, IDC_EDIT_SENSIVITY, m_ctrlSensitivity);
	DDX_Control(pDX, IDC_SPIN_SENSIVITY, m_ctrlSpinSensitivity);
	DDX_Control(pDX, IDC_COMBO_FREQ, m_ctrlFreq);
}


BEGIN_MESSAGE_MAP(CDlgSettings, CPropertyPage)
	ON_BN_CLICKED(IDC_BUTTON_ATTENUATION, &CDlgSettings::OnBnClickedButtonAttenuation)
	ON_BN_CLICKED(IDOK, &CDlgSettings::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BUTTON_SENSIVITY, &CDlgSettings::OnBnClickedButtonSensivity)
	ON_BN_CLICKED(IDC_BUTTON_FREQ, &CDlgSettings::OnBnClickedButtonFreq)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_ATTENUATION, &CDlgSettings::OnDeltaposSpinAttenuation)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_SENSIVITY, &CDlgSettings::OnDeltaposSpinSensivity)
	ON_BN_CLICKED(IDC_BUTTON_REBOOT, &CDlgSettings::OnBnClickedButtonReboot)
	ON_BN_CLICKED(IDC_BUTTON_RESTORE_SET, &CDlgSettings::OnBnClickedButtonRestoreSet)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_SET, &CDlgSettings::OnBnClickedButtonSaveSet)
END_MESSAGE_MAP()


void CDlgSettings::OnBnClickedOk()
{
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		CString strTmp = _T("");
		BYTE pData[MAX_PATH]; DWORD dwSize = MAX_PATH;
		DATA_STRUCT* pDataStruct = (DATA_STRUCT*)pData;


		ZeroMemory(pData, MAX_PATH); dwSize = MAX_PATH;
		if(GetReaderCaps(hSdk, ERD_ATTENUATION, pData, dwSize) == ER_OK)
		{
			strTmp.Format(_T("%d"), pDataStruct->stAttenuation.shAttenuation);
			m_ctrlAttenuation.SetWindowText(strTmp);

			m_ctrlSpinAttenuation.SetRange(0, pDataStruct->stAttenuation.shMaxAttenuation);
			m_ctrlSpinAttenuation.SetPos(pDataStruct->stAttenuation.shAttenuation);
		}

		ZeroMemory(pData, MAX_PATH); dwSize = MAX_PATH;
		if(GetReaderCaps(hSdk, ERD_SENSITIVITY, pData, dwSize) == ER_OK)
		{
			strTmp.Format(_T("%d"), pDataStruct->stSensitivity.shSensitivity);
			m_ctrlSensitivity.SetWindowText(strTmp);

			m_ctrlSpinSensitivity.SetRange(pDataStruct->stSensitivity.shMinSensitivity, pDataStruct->stSensitivity.shMaxSensitivity);
			m_ctrlSpinSensitivity.SetPos(pDataStruct->stSensitivity.shSensitivity);
		}

		ZeroMemory(pData, MAX_PATH); dwSize = MAX_PATH;
		if(GetReaderCaps(hSdk, ERD_FREQUENCY, pData, dwSize) == ER_OK)
		{
			for(UINT nCount = 0; nCount < pData[0x00]; nCount++)
			{
				strTmp.Format(_T("%d"), pDataStruct->stFrequency.lFreq[nCount]);
				m_ctrlFreq.SetItemData(m_ctrlFreq.AddString(strTmp), pDataStruct->stFrequency.lFreq[nCount]);
			}
			m_ctrlFreq.SetCurSel(0);
		}

		CloseReader(hSdk);
	}
}

void CDlgSettings::OnBnClickedButtonAttenuation()
{
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		short shAttn = (short)m_ctrlSpinAttenuation.GetPos();
		if(SetReaderCaps(hSdk, ERD_ATTENUATION, (BYTE*)&shAttn, sizeof(short)) == ER_OK)
		{
			TRACE(_T("Set attenuation done !!! \r\n"));
		}
		CloseReader(hSdk);
	}
}
void CDlgSettings::OnBnClickedButtonSensivity()
{
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		short shSens = (short)m_ctrlSpinSensitivity.GetPos();
		if(SetReaderCaps(hSdk, ERD_SENSITIVITY, (BYTE*)&shSens, sizeof(short)) == ER_OK)
		{
			TRACE(_T("Set sensivity done !!! \r\n"));
		}
		CloseReader(hSdk);
	}
}

void CDlgSettings::OnBnClickedButtonFreq()
{
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		BYTE pData[MAX_PATH]; DWORD dwSize = 0x00;
		DATA_STRUCT* pStData = (DATA_STRUCT*)pData;

		pStData->stFrequency.bNrFreq = (BYTE)m_ctrlFreq.GetCount();
		for(UINT nCount = 0; nCount < pStData->stFrequency.bNrFreq; nCount++)
		{
			pStData->stFrequency.lFreq[nCount] = m_ctrlFreq.GetItemData(nCount);
		}

		dwSize = pStData->stFrequency.bNrFreq * sizeof(ULONG) + sizeof(BYTE);
		if(SetReaderCaps(hSdk, ERD_FREQUENCY, pData, dwSize) == ER_OK)
		{
			TRACE(_T("Set frequency done !!! \r\n"));
		}
		CloseReader(hSdk);
	}
}

void CDlgSettings::OnDeltaposSpinAttenuation(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);

	CString strDisplay = _T("");
	SHORT shData = m_ctrlSpinAttenuation.GetPos();
	strDisplay.Format(_T("%d"),shData);
	m_ctrlAttenuation.SetWindowText(strDisplay);

	*pResult = 0;
}

void CDlgSettings::OnDeltaposSpinSensivity(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);

	CString strDisplay = _T("");
	SHORT shData = m_ctrlSpinSensitivity.GetPos();
	strDisplay.Format(_T("%d"),shData);
	m_ctrlSensitivity.SetWindowText(strDisplay);

	*pResult = 0;
}

void CDlgSettings::OnBnClickedButtonReboot()
{
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		BYTE bReboot = 0x01;
		if(SetReaderCaps(hSdk, ERD_REBOOT, &bReboot, 0x01) == ER_OK)
		{
			TRACE(_T("Reboot done !!! \r\n"));
		}
		CloseReader(hSdk);
	}
}

void CDlgSettings::OnBnClickedButtonRestoreSet()
{
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		BYTE bSaveSettings = 0x01;
		if(SetReaderCaps(hSdk, ERD_RESTORE_SETTINGS, (BYTE*)&bSaveSettings, sizeof(BYTE)) == ER_OK)
		{
			TRACE(_T("Set restore settings done !!! \r\n"));
		}
		CloseReader(hSdk);
	}
}

void CDlgSettings::OnBnClickedButtonSaveSet()
{
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		BYTE bSaveSettings = 0x01;
		if(SetReaderCaps(hSdk, ERD_SAVE_SETTINGS, (BYTE*)&bSaveSettings, sizeof(BYTE)) == ER_OK)
		{
			TRACE(_T("Set save settings done !!! \r\n"));
		}
		CloseReader(hSdk);
	}
}
