#include "stdafx.h"
#include "R-HH-M3O-UHF-SDK-DEMO.h"
#include "DlgScan.h"

#include "Def.h"
#include "Utility.h"
#include "R-HH-M3O-UHF-SDK.h"



IMPLEMENT_DYNAMIC(CDlgScan, CPropertyPage)

CDlgScan::CDlgScan()
	: CPropertyPage(CDlgScan::IDD)
{

}

CDlgScan::~CDlgScan()
{
}

void CDlgScan::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_SCAN, m_ctrlCards);
}


BEGIN_MESSAGE_MAP(CDlgScan, CPropertyPage)
	ON_BN_CLICKED(IDOK, &CDlgScan::OnBnClickedOk)
END_MESSAGE_MAP()

BOOL CDlgScan::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_lstImage.Create(IMAGE_SIZE, IMAGE_SIZE, ILC_COLOR16 | ILC_MASK, 0x01, 0x02);

	HICON hIcon = ::AfxGetApp()->LoadIcon(IDR_CARD);
	m_lstImage.Add(hIcon);
	m_ctrlCards.SetImageList(&m_lstImage, TVSIL_NORMAL);

	InsertColumn(0, _T("Card type"),		80	);
	InsertColumn(1, _T("Card id"),			240	);

	return TRUE;
}

void CDlgScan::InsertColumn(UINT nCol, TCHAR* szData, UINT nMaxLen)
{
	if(szData != NULL)
	{
		LV_COLUMN stLvc;
		stLvc.mask		= LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
		stLvc.iSubItem	= nCol;
		stLvc.pszText	= szData;
		stLvc.cx		= nMaxLen;
		stLvc.fmt		= LVCFMT_LEFT;
		m_ctrlCards.InsertColumn(nCol, &stLvc);
		// m_ctrlData.SetColumnWidth( nCol, LVSCW_AUTOSIZE_USEHEADER);
	}
}

void CDlgScan::InsertItem(UINT nIntem, UINT nSubItem, TCHAR* szString, UINT nImage)
{
	LVITEM stLvItem;
	::ZeroMemory(&stLvItem, sizeof(LVITEM));

	stLvItem.iItem = nIntem;
	stLvItem.iSubItem = nSubItem;
	stLvItem.mask = LVIF_TEXT | LVIF_STATE;
	if(nImage != -1)
	{
		stLvItem.mask |= LVIF_IMAGE;
		stLvItem.iImage	 = nImage;
	}
	stLvItem.pszText = szString;
	stLvItem.cchTextMax = (int)_tcslen(szString) + 1;

	if(nSubItem == 0x00)
	{
		// set the default count to 1 - in item data
		//
		m_ctrlCards.InsertItem(&stLvItem);
	}

	if(nSubItem > 0x00)
		m_ctrlCards.SetItem(&stLvItem);
}

void CDlgScan::OnBnClickedOk()
{
	m_ctrlCards.DeleteAllItems();
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		CString strTmp = _T("");
		BYTE pData[MAX_PATH]; DWORD dwSize = MAX_PATH;

		ZeroMemory(pData, MAX_PATH);
		if(GetReaderCaps(hSdk, ERD_CARD, pData, dwSize) == ER_OK)
		{
			UINT nNav = 0x01;
			while(nNav < dwSize)
			{
				DATA_STRUCT* pStData = (DATA_STRUCT*)(pData + nNav);

				InsertItem(0, 0, _T("UHF card"), -1);
				InsertItem(0, 1, (TCHAR*)(LPCTSTR)CUtility::DataToString(pStData->stCardInfo.pCardId, pStData->stCardInfo.nLength), -1);

				nNav += pStData->stCardInfo.nLength + 0x01;
			}
		}
		CloseReader(hSdk);
	}
}
