#include "stdafx.h"
#include "R-HH-M3O-UHF-SDK-DEMO.h"
#include "DlgReadWrite.h"

#include "Def.h"
#include "Utility.h"
#include "R-HH-M3O-UHF-SDK.h"


IMPLEMENT_DYNAMIC(CDlgReadWrite, CPropertyPage)

CDlgReadWrite::CDlgReadWrite()
	: CPropertyPage(CDlgReadWrite::IDD)
{

}

CDlgReadWrite::~CDlgReadWrite()
{
}

void CDlgReadWrite::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_CARDID, m_ctrlCards);
	DDX_Control(pDX, IDC_EDIT1, m_ctrlAddress);
	DDX_Control(pDX, IDC_EDIT_NR_BYTES, m_ctrlNrBytes);
	DDX_Control(pDX, IDC_EDIT_PASS, m_ctrlPass);
	DDX_Control(pDX, IDC_COMBO_BANK, m_ctrlBank);
	DDX_Control(pDX, IDC_EDIT_DATA, m_ctrlData);
}


BEGIN_MESSAGE_MAP(CDlgReadWrite, CPropertyPage)
	ON_BN_CLICKED(IDC_BUTTON_SCAN, &CDlgReadWrite::OnBnClickedButtonScan)
	ON_BN_CLICKED(IDC_BUTTON_READ, &CDlgReadWrite::OnBnClickedButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, &CDlgReadWrite::OnBnClickedButtonWrite)
	ON_BN_CLICKED(IDOK, &CDlgReadWrite::OnBnClickedOk)
END_MESSAGE_MAP()

BOOL CDlgReadWrite::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_ctrlAddress.SetWindowText(_T("0"));
	m_ctrlNrBytes.SetWindowText(_T("1"));
	m_ctrlPass.SetWindowText(_T("00000000"));

	m_ctrlBank.AddString(_T("Reserved"));
	m_ctrlBank.AddString(_T("EPC"));
	m_ctrlBank.AddString(_T("TID"));
	m_ctrlBank.AddString(_T("USER"));
	m_ctrlBank.SetCurSel(0);


	return TRUE;
}

void CDlgReadWrite::OnBnClickedButtonScan()
{
	m_ctrlCards.ResetContent();
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		CString strTmp = _T("");
		BYTE pData[MAX_PATH]; DWORD dwSize = MAX_PATH;

		ZeroMemory(pData, MAX_PATH);
		if(GetReaderCaps(hSdk, ERD_CARD, pData, dwSize) == ER_OK)
		{
			UINT nNav = 0x01;
			while(nNav < dwSize)
			{
				DATA_STRUCT* pStData = (DATA_STRUCT*)(pData + nNav);

				m_ctrlCards.AddString(CUtility::DataToString(pStData->stCardInfo.pCardId, pStData->stCardInfo.nLength, FALSE));

				nNav += pStData->stCardInfo.nLength + 0x01;
			}
		}

		m_ctrlCards.SetCurSel(0);
		CloseReader(hSdk);
	}
}

void CDlgReadWrite::OnBnClickedButtonRead()
{
	if((m_ctrlBank.GetCurSel() != LB_ERR) && (m_ctrlCards.GetCurSel() != LB_ERR))
	{
		SDKHANDLE hSdk = NULL;
		if((hSdk = OpenReader()) != NULL)
		{
			BYTE pData[MAX_PATH]; DWORD dwData = MAX_PATH;
			DATA_STRUCT* pStData = (DATA_STRUCT*)pData;
			if(pStData != NULL)
			{
				pStData->stReadWriteInfo.bBank = (BYTE)m_ctrlBank.GetCurSel();

				// set card ID
				CString strRet = _T("");
				m_ctrlCards.GetLBText(m_ctrlCards.GetCurSel(), strRet);
				BYTE* pDataRet = NULL; DWORD dwDataRet = 0;
				USES_CONVERSION;
				CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strRet), strRet.GetLength(), &pDataRet, dwDataRet);
				memcpy_s(pStData->stReadWriteInfo.pCardId, 0x20, pDataRet, dwDataRet);
				pStData->stReadWriteInfo.bCardIdLen = (BYTE)dwDataRet;

				delete[] pDataRet; pDataRet = NULL; dwDataRet = 0;

				// set pass 
				strRet = _T("");
				m_ctrlPass.GetWindowText(strRet);
				CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strRet), strRet.GetLength(), &pDataRet, dwDataRet);
				memcpy_s(pStData->stReadWriteInfo.pPass, 0x06, pDataRet, dwDataRet);
				delete[] pDataRet; pDataRet = NULL; dwDataRet = 0;

				m_ctrlAddress.GetWindowText(strRet);
				pStData->stReadWriteInfo.ulStartAddress = _ttoi((LPCTSTR)strRet);

				if(SetReaderCaps(hSdk, ERD_READ_WRITE_PARAM, pData, sizeof(pStData->stReadWriteInfo)) == ER_OK)
				{
					m_ctrlNrBytes.GetWindowText(strRet);
					BYTE pDataRead[MAX_PATH]; DWORD dwDataRead = _ttoi((LPCTSTR)strRet);;
					if(ReadData(hSdk, pDataRead, dwDataRead) == ER_OK)
					{
						m_ctrlData.SetWindowText(CUtility::DataToString(pDataRead, dwDataRead, FALSE));
					}
				}
			}
			CloseReader(hSdk);
		}
	}
}

void CDlgReadWrite::OnBnClickedButtonWrite()
{
	if((m_ctrlBank.GetCurSel() != LB_ERR) && (m_ctrlCards.GetCurSel() != LB_ERR))
	{
		SDKHANDLE hSdk = NULL;
		if((hSdk = OpenReader()) != NULL)
		{
			BYTE pData[MAX_PATH]; DWORD dwData = MAX_PATH;
			DATA_STRUCT* pStData = (DATA_STRUCT*)pData;
			if(pStData != NULL)
			{
				pStData->stReadWriteInfo.bBank = (BYTE)m_ctrlBank.GetCurSel();

				// set card ID
				CString strRet = _T("");
				m_ctrlCards.GetLBText(m_ctrlCards.GetCurSel(), strRet);
				BYTE* pDataRet = NULL; DWORD dwDataRet = 0;
				USES_CONVERSION;
				CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strRet), strRet.GetLength(), &pDataRet, dwDataRet);
				memcpy_s(pStData->stReadWriteInfo.pCardId, 0x20, pDataRet, dwDataRet);
				pStData->stReadWriteInfo.bCardIdLen = (BYTE)dwDataRet;

				delete[] pDataRet; pDataRet = NULL; dwDataRet = 0;

				// set pass 
				strRet = _T("");
				m_ctrlPass.GetWindowText(strRet);
				CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strRet), strRet.GetLength(), &pDataRet, dwDataRet);
				memcpy_s(pStData->stReadWriteInfo.pPass, 0x04, pDataRet, dwDataRet);
				delete[] pDataRet; pDataRet = NULL; dwDataRet = 0;

				m_ctrlAddress.GetWindowText(strRet);
				pStData->stReadWriteInfo.ulStartAddress = _ttoi((LPCTSTR)strRet);

				if(SetReaderCaps(hSdk, ERD_READ_WRITE_PARAM, pData, sizeof(pStData->stReadWriteInfo)) == ER_OK)
				{
					m_ctrlNrBytes.GetWindowText(strRet);
					DWORD dwDataWrite = _ttoi((LPCTSTR)strRet);

					m_ctrlData.GetWindowText(strRet);
					CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strRet), strRet.GetLength(), &pDataRet, dwDataRet);
					ASSERT(dwDataWrite == dwDataRet);

					WriteData(hSdk, pDataRet, dwDataRet);

					delete[] pDataRet; pDataRet = NULL; dwDataRet = 0;
				}
			}
			CloseReader(hSdk);
		}
	}
}

void CDlgReadWrite::OnBnClickedOk()
{
	if(m_ctrlCards.GetCurSel() != LB_ERR)
	{
		SDKHANDLE hSdk = NULL;
		if((hSdk = OpenReader()) != NULL)
		{
			BYTE pData[MAX_PATH]; DWORD dwData = MAX_PATH;
			DATA_STRUCT* pStData = (DATA_STRUCT*)pData;
			if(pStData != NULL)
			{
				// set card ID
				CString strRet = _T("");
				m_ctrlCards.GetLBText(m_ctrlCards.GetCurSel(), strRet);
				BYTE* pDataRet = NULL; DWORD dwDataRet = 0;
				USES_CONVERSION;
				CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strRet), strRet.GetLength(), &pDataRet, dwDataRet);
				memcpy_s(pStData->stKillTag.pCardId, 0x20, pDataRet, dwDataRet);
				pStData->stKillTag.bCardIdLen = (BYTE)dwDataRet;

				delete[] pDataRet; pDataRet = NULL; dwDataRet = 0;

				// set pass 
				strRet = _T("");
				m_ctrlPass.GetWindowText(strRet);
				CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strRet), strRet.GetLength(), &pDataRet, dwDataRet);
				memcpy_s(pStData->stKillTag.pPass, 0x04, pDataRet, dwDataRet);
				delete[] pDataRet; pDataRet = NULL; dwDataRet = 0;


				if(SetReaderCaps(hSdk, ERD_KILL_TAG, pData, sizeof(pStData->stKillTag)) == ER_OK)
				{
					TRACE(_T("Kill tag finish with success !!! \r\n"));
				}
			}
			CloseReader(hSdk);
		}
	}
}
