#include "stdafx.h"
#include "R-HH-M3O-UHF-SDK-DEMO.h"
#include "DlgLock.h"

#include "Def.h"
#include "Utility.h"
#include "R-HH-M3O-UHF-SDK.h"



IMPLEMENT_DYNAMIC(CDlgLock, CPropertyPage)

CDlgLock::CDlgLock()
	: CPropertyPage(CDlgLock::IDD)
{

}

CDlgLock::~CDlgLock()
{
}

void CDlgLock::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_BANK, m_ctrlLockBank);
	DDX_Control(pDX, IDC_COMBO_LOCK_TYPE, m_ctrlLockType);
	DDX_Control(pDX, IDC_COMBO_CARDS, m_ctrlCards);
	DDX_Control(pDX, IDC_EDIT_PASS, m_ctrlPass);
}


BEGIN_MESSAGE_MAP(CDlgLock, CPropertyPage)
	ON_BN_CLICKED(IDOK, &CDlgLock::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BUTTON_SCAN, &CDlgLock::OnBnClickedButtonScan)
END_MESSAGE_MAP()


BOOL CDlgLock::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_ctrlPass.SetWindowText(_T("00000000"));

	m_ctrlLockBank.AddString(_T("Reserved"));
	m_ctrlLockBank.AddString(_T("EPC"));
	m_ctrlLockBank.AddString(_T("TID"));
	m_ctrlLockBank.AddString(_T("USER"));
	m_ctrlLockBank.SetCurSel(0);

	m_ctrlLockType.AddString(_T("Writable"));
	m_ctrlLockType.AddString(_T("Always writable"));
	m_ctrlLockType.AddString(_T("Secure writable"));
	m_ctrlLockType.AddString(_T("Always not writable"));
	m_ctrlLockType.AddString(_T("No change"));
	m_ctrlLockType.SetCurSel(0);

	return TRUE;
}

void CDlgLock::OnBnClickedOk()
{
	if((m_ctrlCards.GetCurSel() != LB_ERR) && (m_ctrlLockBank.GetCurSel() != LB_ERR) && (m_ctrlLockType.GetCurSel() != LB_ERR))
	{
		SDKHANDLE hSdk = NULL;
		if((hSdk = OpenReader()) != NULL)
		{
			BYTE pData[MAX_PATH]; DWORD dwData = MAX_PATH;
			DATA_STRUCT* pStData = (DATA_STRUCT*)pData;
			if(pStData != NULL)
			{
				// set card ID
				CString strRet = _T("");
				m_ctrlCards.GetLBText(m_ctrlCards.GetCurSel(), strRet);
				BYTE* pDataRet = NULL; DWORD dwDataRet = 0;
				USES_CONVERSION;
				CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strRet), strRet.GetLength(), &pDataRet, dwDataRet);
				memcpy_s(pStData->stLockInfo.pCardId, 0x20, pDataRet, dwDataRet);
				pStData->stLockInfo.bCardIdLen = (BYTE)dwDataRet;

				delete[] pDataRet; pDataRet = NULL; dwDataRet = 0;

				// set pass 
				strRet = _T("");
				m_ctrlPass.GetWindowText(strRet);
				CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strRet), strRet.GetLength(), &pDataRet, dwDataRet);
				memcpy_s(pStData->stLockInfo.pPass, 0x04, pDataRet, dwDataRet);
				delete[] pDataRet; pDataRet = NULL; dwDataRet = 0;

				pStData->stLockInfo.bBank		= (BYTE)m_ctrlLockBank.GetCurSel();
				pStData->stLockInfo.bLockType	= (BYTE)m_ctrlLockType.GetCurSel();


				if(SetReaderCaps(hSdk, ERD_LOCK_TAG, pData, sizeof(pStData->stLockInfo)) == ER_OK)
				{
					TRACE(_T("Lock tag finish with success !!! \r\n"));
				}
			}
			CloseReader(hSdk);
		}
	}
}

void CDlgLock::OnBnClickedButtonScan()
{
	m_ctrlCards.ResetContent();

	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		CString strTmp = _T("");
		BYTE pData[MAX_PATH]; DWORD dwSize = MAX_PATH;

		ZeroMemory(pData, MAX_PATH);
		if(GetReaderCaps(hSdk, ERD_CARD, pData, dwSize) == ER_OK)
		{
			UINT nNav = 0x01;
			while(nNav < dwSize)
			{
				DATA_STRUCT* pStData = (DATA_STRUCT*)(pData + nNav);

				m_ctrlCards.AddString(CUtility::DataToString(pStData->stCardInfo.pCardId, pStData->stCardInfo.nLength, FALSE));

				nNav += pStData->stCardInfo.nLength + 0x01;
			}
		}

		m_ctrlCards.SetCurSel(0);
		CloseReader(hSdk);
	}	
}
