#include "stdafx.h"
#include "R-HH-M3O-UHF-SDK-DEMO.h"
#include "DlgGeneralInfo.h"

#include "R-HH-M3O-UHF-SDK.h"
#include "Def.h"
#include "Utility.h"



IMPLEMENT_DYNAMIC(CDlgGeneralInfo, CPropertyPage)

CDlgGeneralInfo::CDlgGeneralInfo()
	: CPropertyPage(CDlgGeneralInfo::IDD)
{

}

CDlgGeneralInfo::~CDlgGeneralInfo()
{
}

void CDlgGeneralInfo::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_SERIAL_NUMBER,	m_ctrlSerialNr);
	DDX_Control(pDX, IDC_EDIT_READER_TYPE,		m_ctrlReaderType);
	DDX_Control(pDX, IDC_EDIT_HARDWARE_REV,		m_ctrlHardwareRev);
	DDX_Control(pDX, IDC_EDIT_SOFTWARE_REV,		m_ctrlSoftwareRev);
	DDX_Control(pDX, IDC_EDIT_BOOT_REV,			m_ctrlBootRev);
	DDX_Control(pDX, IDC_EDIT_CURRENT_STATE,	m_ctrlCurrentState);
}


BEGIN_MESSAGE_MAP(CDlgGeneralInfo, CPropertyPage)
	ON_BN_CLICKED(IDOK, &CDlgGeneralInfo::OnBnClickedOk)
END_MESSAGE_MAP()



void CDlgGeneralInfo::OnBnClickedOk()
{
	SDKHANDLE hSdk = NULL;
	if((hSdk = OpenReader()) != NULL)
	{
		CString strTmp = _T("");
		BYTE pData[MAX_PATH]; DWORD dwSize = MAX_PATH;
		DATA_STRUCT* pDataStruct = (DATA_STRUCT*)pData;

		ZeroMemory(pData, MAX_PATH);
		if(GetReaderCaps(hSdk, ERD_SERIAL_NUMER, pData, dwSize) == ER_OK)
		{
			USES_CONVERSION;
			m_ctrlSerialNr.SetWindowText(CUtility::DataToString(pData, dwSize));
		}


		ZeroMemory(pData, MAX_PATH); dwSize = MAX_PATH;
		if(GetReaderCaps(hSdk, ERD_READER_TYPE, pData, dwSize) == ER_OK)
		{
			USES_CONVERSION;
			m_ctrlReaderType.SetWindowText(CUtility::DataToString(pData, dwSize));
		}

		ZeroMemory(pData, MAX_PATH); dwSize = MAX_PATH;
		if(GetReaderCaps(hSdk, ERD_HARDWARE_REV, pData, dwSize) == ER_OK)
		{
			USES_CONVERSION;
			m_ctrlHardwareRev.SetWindowText(CUtility::DataToString(pData, dwSize));
		}

		ZeroMemory(pData, MAX_PATH); dwSize = MAX_PATH;
		if(GetReaderCaps(hSdk, ERD_SOFTWARE_REV, pData, dwSize) == ER_OK)
		{
			USES_CONVERSION;
			m_ctrlSoftwareRev.SetWindowText(CUtility::DataToString(pData, dwSize));
		}

		ZeroMemory(pData, MAX_PATH); dwSize = MAX_PATH;
		if(GetReaderCaps(hSdk, ERD_BOOTLOADER_REV, pData, dwSize) == ER_OK)
		{
			USES_CONVERSION;
			m_ctrlBootRev.SetWindowText(CUtility::DataToString(pData, dwSize));
		}

		ZeroMemory(pData, MAX_PATH); dwSize = MAX_PATH;
		if(GetReaderCaps(hSdk, ERD_CURRENT_STATE, pData, dwSize) == ER_OK)
		{
			switch(pData[0x00])
			{
			case 0x00: m_ctrlCurrentState.SetWindowText(_T("Idle")); break;
			default: m_ctrlCurrentState.SetWindowText(_T("Unknown")); break;
			}
		}
		CloseReader(hSdk);
	}
}
