package com.bx.hfserver;


import java.util.Timer;
import java.util.TimerTask;

import com.example.uhfservice.ScanConfig;
import com.example.uhfservice.UHFService;

import android.app.Activity;
import android.app.AlertDialog.Builder;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {
    private ScanConfig scanConfig;

    private Switch openSwitch;
    private Spinner spinnerPrefix;
    private Spinner spinnerSurfix;
    private CheckBox checkVoice;
    private CheckBox checkRepeat;
    private CheckBox checkCirculate;
    private CheckBox checkF1;
    private CheckBox checkF2;
    private CheckBox checkF3;
    private CheckBox checkF4;
    private CheckBox checkF5;
    private CheckBox checkF6;
    private CheckBox checkF7;
    private TextView tvPrefix ;
    private TextView tvPrefixo ;
    private TextView tvSurfix ;
    private TextView tvSurfixo ;
    private EditText editText_time;
    //set rfid power
    private Button buttonMin;
    private Button buttonPlus;
    private Button buttonSet;
    private EditText editValues;
    private int value = 26;

    private String tabStr;
    private   String spaceStr;
    private   String enterStr;
    private   String noneStr;
    private   String otherStr;
    private String[] fixArray;

    private Dialog dialogLoading ;
    private Dialog dialogOther ;

    private final int MSG_CANSEL_DIALOG = 1003 ;
    private Handler mHandler  = new Handler(){
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG_CANSEL_DIALOG:
                    dialogLoading.cancel() ;
                    scanConfig.setOpen(true) ;
                    break;

                default:
                    break;
            }
        };
    };
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        scanConfig = new ScanConfig(this);
        initView();
//        setTimer();
    }
//    private Timer timer;
//    private void setTimer(){
//        if (timer==null) {
//            timer = new Timer();
//            timer.schedule(new TimerTask() {
//                @Override
//                public void run() {
//                    String timest= editText_time.getText().toString();
//                    if (timest!=null&&timest!="") {
//                        try {
//                            scanConfig.setTime(Integer.valueOf(timest).intValue());
//                        } catch (NumberFormatException e) {
//                            // TODO: handle exception
//                        }
//                    }
//                }
//            }, 200, 200);
//        }
//    }
    private boolean touchFlag = false;
    private void initView() {
        tabStr = getResources().getString(R.string.tab);
        spaceStr = getResources().getString(R.string.space);
        enterStr = getResources().getString(R.string.enter);
        noneStr = getResources().getString(R.string.none);
        otherStr = getResources().getString(R.string.other);
        fixArray = new String[] { tabStr, spaceStr, enterStr, noneStr, otherStr };
        tvPrefix =  findViewById(R.id.text_prefix) ;
        tvSurfix = findViewById(R.id.text_surfix);
        tvPrefixo =  findViewById(R.id.text_prefix_other) ;
        tvSurfixo = findViewById(R.id.text_surfix_other);
        editText_time = (EditText) findViewById(R.id.editText_circulatetime);

        openSwitch = (Switch) findViewById(R.id.switch_scan);
        spinnerPrefix = (Spinner) findViewById(R.id.spinner_prefix);
        spinnerSurfix = (Spinner) findViewById(R.id.spinner_surfix);
        checkVoice = (CheckBox) findViewById(R.id.checkBox_voice);
        checkRepeat = (CheckBox) findViewById(R.id.checkBox_repeat);
        checkCirculate = (CheckBox) findViewById(R.id.checkBox_circulate);
        checkF1 = (CheckBox) findViewById(R.id.checkBox_f1);
        checkF2 = (CheckBox) findViewById(R.id.checkBox_f2);
        checkF3 = (CheckBox) findViewById(R.id.checkBox_f3);
        checkF4 = (CheckBox) findViewById(R.id.checkBox_f4);
        checkF5 = (CheckBox) findViewById(R.id.checkBox_f5);
        checkF6 = (CheckBox) findViewById(R.id.checkBox_f6);
        checkF7 = (CheckBox) findViewById(R.id.checkBox_f7);

        openSwitch.setChecked(scanConfig.isOpen()) ;
        checkF1.setChecked(scanConfig.isF1());
        checkF2.setChecked(scanConfig.isF2());
        checkF3.setChecked(scanConfig.isF3());
        checkF4.setChecked(scanConfig.isF4());
        checkF5.setChecked(scanConfig.isF5());
        checkF6.setChecked(scanConfig.isF6());
        checkF7.setChecked(scanConfig.isF7());
        checkVoice.setChecked(scanConfig.isVoice());
        checkRepeat.setChecked(scanConfig.isRepeat());
        checkCirculate.setChecked(scanConfig.isCirculate());
        editText_time.setText(scanConfig.getTime()+"");

        spinnerPrefix.setAdapter(new ArrayAdapter<String>(this,
                android.R.layout.simple_spinner_dropdown_item, fixArray));
        spinnerPrefix.setSelection(scanConfig.getPrefixIndex());
        spinnerSurfix.setAdapter(new ArrayAdapter<String>(this,
                android.R.layout.simple_spinner_dropdown_item, fixArray));
        spinnerSurfix.setSelection(scanConfig.getSurfixIndex());
        // set key
        checkF1.setOnCheckedChangeListener(new OnCheckedChangeListener() {

            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setF1(isChecked);
            }
        });

        checkF2.setOnCheckedChangeListener(new OnCheckedChangeListener() {

            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setF2(isChecked);
            }
        });
        checkF3.setOnCheckedChangeListener(new OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setF3(isChecked);
            }
        });
        checkF4.setOnCheckedChangeListener(new OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setF4(isChecked);
            }
        });
        checkF5.setOnCheckedChangeListener(new OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setF5(isChecked);
            }
        });
        checkF7.setOnCheckedChangeListener(new OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setF7(isChecked);
            }
        });
        checkF6.setOnCheckedChangeListener(new OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setF6(isChecked);
            }
        });

        checkVoice.setOnCheckedChangeListener(new OnCheckedChangeListener() {

            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setVoice(isChecked);
            }
        });
        checkRepeat.setOnCheckedChangeListener(new OnCheckedChangeListener() {

            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setRepeat(isChecked);
            }
        });
        checkCirculate.setOnCheckedChangeListener(new OnCheckedChangeListener() {

            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                scanConfig.setCirculate(isChecked);
            }
        });
        // open dev
        openSwitch.setOnCheckedChangeListener(new OnCheckedChangeListener() {

            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                                         boolean isChecked) {
                // open scan
                if (isChecked) {
                    createLoaddingDialog() ;
                    Intent toService = new Intent(MainActivity.this, UHFService.class) ;
                    startService(toService) ;
                    Timer timer = new Timer() ;
                    timer.schedule(new TimerTask() {

                        @Override
                        public void run() {
                            Message msg = new Message() ;
                            msg.what = MSG_CANSEL_DIALOG ;
                            mHandler.sendMessage(msg) ;

                        }
                    }, 2000) ;

                } else {
                    Intent toKill = new Intent() ;
                    toKill.setAction("android.rfid.KILL_SERVER") ;
                    toKill.putExtra("kill", true) ;
                    sendBroadcast(toKill) ;
                    scanConfig.setOpen(false) ;
                    UHFService.Close();
                }

            }
        });

        spinnerPrefix.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                touchFlag = true;
                return false;
            }
        });
        spinnerSurfix.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                touchFlag = true;
                return false;
            }
        });
        // prefix
        spinnerPrefix.setOnItemSelectedListener(new OnItemSelectedListener() {

            @Override
            public void onItemSelected(AdapterView<?> parent, View view,
                                       int position, long id) {

//				try {
//			        Field field =       AdapterView.class.getDeclaredField("mOldSelectedPosition");
//			                field.setAccessible(true);  //����mOldSelectedPosition�ɷ���
//			                field.setInt(spinnerPrefix, AdapterView.INVALID_POSITION); //����mOldSelectedPosition��ֵ
//			    } catch (Exception e) {
//			                e.printStackTrace();
//			    }
                if(fixArray[position].equals(tabStr)){
                    scanConfig.setPrefix("\t");
                }else if(fixArray[position].equals(spaceStr)){
                    scanConfig.setPrefix(" ");
                }else if(fixArray[position].equals(enterStr)){
                    scanConfig.setPrefix("0A0D");
                }else if(fixArray[position].equals(noneStr)){
                    scanConfig.setPrefix("");
                }else if(fixArray[position].equals(otherStr)){
                    //dialog input prefix char
                    if (touchFlag)
                    createOtherDialog(true) ;
                }
                scanConfig.setPrefixIndex(position);

            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                Log.e("nothing selected", "") ;

            }
        });

        // surfix
        spinnerSurfix.setOnItemSelectedListener(new OnItemSelectedListener() {

            @Override
            public void onItemSelected(AdapterView<?> parent, View view,
                                       int position, long id) {
                if(fixArray[position].equals(tabStr)){
                    scanConfig.setSurfix("\t");
                }else if(fixArray[position].equals(spaceStr)){
                    scanConfig.setSurfix(" ");
                }else if(fixArray[position].equals(enterStr)){
                    scanConfig.setSurfix("0A0D");
                }else if(fixArray[position].equals(noneStr)){
                    scanConfig.setSurfix("");
                }else if(fixArray[position].equals(otherStr)){
                    //dialog input surfix char
                    if (touchFlag)
                    createOtherDialog(false) ;
                }
                scanConfig.setSurfixIndex(position);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // TODO Auto-generated method stub

            }
        });
        initView2();
        if (scanConfig.getPrefixIndex()==4){
            tvPrefixo.setVisibility(View.VISIBLE);
            tvPrefix.setText(scanConfig.getPrefix());
        }
        if (scanConfig.getSurfixIndex()==4){
            tvSurfix.setVisibility(View.VISIBLE);
            tvSurfix.setText(scanConfig.getSurfix());
        }
        editText_time.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                String time = editText_time.getText().toString().trim();
                if (!time.equals(""))
                scanConfig.setTime(Integer.valueOf(time).intValue());
            }
        });
    }

    private void initView2() {
        buttonMin = (Button) findViewById(R.id.button_min);
        buttonPlus = (Button) findViewById(R.id.button_plus);
        buttonSet = (Button) findViewById(R.id.button_set);
        editValues = (EditText) findViewById(R.id.editText_power);

        buttonMin.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View arg0) {
                if(value > 16){
                    value = value - 1;
                }else {
                    value = 26;
                }
                editValues.setText(value + "");
            }
        });
        buttonPlus.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View arg0) {
                if(value < 26){
                    value = value + 1;
                }else {
                    value = 16;
                }
                editValues.setText(value + "");
            }
        });
        buttonSet.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View arg0) {
                if(scanConfig.setPower(value)){
                    Toast.makeText(getApplicationContext(), R.string._setsuccess, Toast.LENGTH_SHORT).show();
                }else{
                    Toast.makeText(getApplicationContext(), R.string._setfail, Toast.LENGTH_SHORT).show();
                }
            }
        });
        value =  scanConfig.getPower();
        editValues.setText("" +value);
    }
    //create loading dialog
    private void createLoaddingDialog(){
        Builder  builder = new Builder(this) ;
        View view = LayoutInflater.from(this).inflate(R.layout.dialog_loading, null) ;
        builder.setView(view) ;
        dialogLoading = builder.create() ;
        dialogLoading.setCancelable(false) ;
        dialogLoading.show() ;
    }


    private EditText editUserChar ;
    private void createOtherDialog(final boolean isPrefix){
        //Input the customized Char
        Builder  builder = new Builder(this) ;
        View view = LayoutInflater.from(this).inflate(R.layout.dialog_others, null) ;
        editUserChar = (EditText) view.findViewById(R.id.editText_others) ;
        builder.setView(view) ;
        builder.setTitle(getResources().getString(R.string.user_char)) ;
        builder.setNegativeButton(getResources().getString(R.string.cancel), new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialogOther.cancel() ;
            }
        }) ;
        builder.setPositiveButton(getResources().getString(R.string.ok), new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                String userChar = editUserChar.getText().toString() ;
                if(isPrefix){
                    tvPrefix.setText(userChar) ;
                    scanConfig.setPrefix(userChar) ;
                }else{
                    tvSurfix.setText(userChar) ;
                    scanConfig.setSurfix(userChar) ;
                }

                dialogOther.cancel() ;
            }
        }) ;

        dialogOther = builder.create() ;
//		dialogOther.setCancelable(false) ;
        dialogOther.show() ;
    }

}
