package com.pda.scan1dserver;

import java.io.IOException;
import java.lang.ref.WeakReference;

import org.greenrobot.eventbus.EventBus;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import cn.pda.scan.ScanThread;
import cn.pda.serialport.Tools;

public class Scan1DService extends Service {

	private ScanThread scan = null;

	private ScanConfig scanConfig;
	private String prefixStr;
	private String surfixStr;

	private MyHandler mHandler = new MyHandler(Scan1DService.this);
	private static class MyHandler extends Handler {
		private WeakReference<Scan1DService> mWeakReference;
		public MyHandler(Scan1DService scan1dService) {
			mWeakReference = new WeakReference<Scan1DService>(scan1dService);
		}
		public void handleMessage(android.os.Message msg) {
			Scan1DService scan1dService = mWeakReference.get();
			scan1dService.prefixStr = scan1dService.scanConfig.getPrefix();
			scan1dService.surfixStr = scan1dService.scanConfig.getSurfix();
			if (msg.what == ScanThread.SCAN) {
				String data = msg.getData().getString("data");
				Log.e(scan1dService.TAG, "prefixStr=" + scan1dService.prefixStr + "++");
				byte[] surByte = scan1dService.surfixStr.getBytes();
				Log.e(scan1dService.TAG, "surfixStr=" + Tools.Bytes2HexString(surByte, surByte.length) + "++ , surfixStrLen = "
						+ scan1dService.surfixStr.length());
				Log.e(scan1dService.TAG, "data = " + data);
				// input prefix
				if (scan1dService.prefixStr.contains("\t0A0D")) {
					scan1dService.sendToInput("\t", true);
				} else if ("0A0D".equals(scan1dService.prefixStr)) {
					scan1dService.sendToInput("", true);
				} else {
					scan1dService.sendToInput(scan1dService.prefixStr, false);
				}
				// input barcode
				scan1dService.sendToInput(data, false);
				// input prefix
				if (scan1dService.surfixStr.contains("\t0A0D")) {
					scan1dService.sendToInput("\t", true);
				}
				else if ("".equals(scan1dService.surfixStr) || scan1dService.surfixStr.length() == 0) {
					// sendToInput("", fa) ;
				} else if ("0A0D".startsWith(scan1dService.surfixStr)) {
					scan1dService.sendToInput("", true);
				} else {
					scan1dService.sendToInput(scan1dService.surfixStr, false);
				}
				if (scan1dService.scanConfig.isVoice()) {
					Util.play();
				}
				scan1dService.isRuning = false;
			} else if (msg.what == ScanThread.SWITCH_INPUT) {
				Log.i(scan1dService.TAG, "handleMessage, SWITCH_INPUT >>>>>> ");
				scan1dService.isRuning = false;
			}
		};
	};

	private String TAG = "Scan1DService";

	@Override
	public IBinder onBind(Intent intent) {

		return null;
	}

	@Override
	public void onCreate() {
		scanConfig = new ScanConfig(this);
		Util.initSoundPool(this);
		IntentFilter filter = new IntentFilter();
		filter.addAction("android.rfid.KILL_SERVER");
		registerReceiver(killReceiver, filter);
		// listner screen on/off
		IntentFilter screenFilter = new IntentFilter();
		screenFilter.addAction(Intent.ACTION_SCREEN_OFF);
		screenFilter.addAction(Intent.ACTION_SCREEN_ON);
		registerReceiver(powerModeReceiver, screenFilter);
		super.onCreate();
	}

	@Override
	public void onDestroy() {
		unregisterReceiver(killReceiver);
		unregisterReceiver(powerModeReceiver);
		super.onDestroy();
	}

	private boolean isRuning = false;

	private boolean isKeyDown = false;

	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		Log.e(TAG, "+++ onstart command++++");
		if (intent == null) {
			if (scan == null) {
				try {
					scan = new ScanThread(mHandler);
					scan.start();
				} catch (Exception e) {
					e.printStackTrace();
					EventBus.getDefault().post(MainActivity.FLAG_OPEN_FAIL);
				}
			}
			return Service.START_STICKY;
		}
		boolean keyDown = intent.getBooleanExtra("keyDown", false);
		int initFlag = intent.getFlags();
		if (initFlag == 1693) {
			if (scan == null) {
				try {
					scan = new ScanThread(mHandler);
					scan.start();
				} catch (Exception e) {
					e.printStackTrace();
					EventBus.getDefault().post(MainActivity.FLAG_OPEN_FAIL);
				}
			} else {
				isKeyDown = true;
				isRuning = true;
				scan.scan();
			}
		}
		Log.i(TAG, "onStartCommand >>>>>> isKeyDown = " + isKeyDown);
		Log.i(TAG, "onStartCommand >>>>>> keyDown = " + keyDown);
		Log.i(TAG, "onStartCommand >>>>>> isRunning = " + isRuning);
		if (!isKeyDown && keyDown && !isRuning) {
			if (scan == null) {
				try {
					scan = new ScanThread(mHandler);
					scan.start();
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else {
				isKeyDown = true;
				isRuning = true;
				scan.scan();
			}
		} else if (!keyDown) {
			isKeyDown = false;
			isRuning = false;
			// if (scan != null) {
			// scan.stopScan();
			// }
		}

		return Service.START_STICKY;
	}

	private void sendToInput(String data, boolean enterFlag) {
		Intent toBack = new Intent();
		toBack.setAction("android.rfid.INPUT");
		toBack.putExtra("data", data);
		toBack.putExtra("enter", enterFlag);
		sendBroadcast(toBack);
	}

	private BroadcastReceiver killReceiver = new BroadcastReceiver() {

		@Override
		public void onReceive(Context context, Intent intent) {
			if (intent.getBooleanExtra("kill", false)) {
				if (scan != null) {
					scan.close();
					scan = null;
				}
				Scan1DService.this.stopSelf();
			}
		}
	};

	// listner
	private BroadcastReceiver powerModeReceiver = new BroadcastReceiver() {

		@Override
		public void onReceive(Context context, Intent intent) {
			String action = intent.getAction();
			// SCREEN ON ACTION
			if (action.equals(Intent.ACTION_SCREEN_ON)) {
				 Log.e("powerModeReceiver", "screent on +++ ") ;
				// new Thread(initTask).start() ;
				try {
					scan = new ScanThread(mHandler);
					scan.start();
				} catch (SecurityException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			// SCREEN OFF ACTION
			if (action.equals(Intent.ACTION_SCREEN_OFF)) {
				 Log.e("powerModeReceiver", "screent off +++") ;
				// if(scanDev != null){
				// scanDev.close() ;
				// }
				if (scan != null) {
					scan.close();
					scan = null;
				}
			}

		}
	};

}
