/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.a;
import com.rscja.deviceapi.entity.SimpleRFIDEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.util.Arrays;

public class RFIDWithUHF {
    private static RFIDWithUHF a = null;
    protected a config = com.rscja.deviceapi.a.e();

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.a();
    }

    public static synchronized RFIDWithUHF getInstance() throws ConfigurationException {
        if (a == null) {
            a = new RFIDWithUHF();
        }
        return a;
    }

    private RFIDWithUHF() throws ConfigurationException {
    }

    public synchronized boolean init() {
        int n = this.getDeviceAPI().UHFInit();
        if (n == 0) {
            n = this.getDeviceAPI().UHFOpenAndConnect(this.config.j());
            if (n == 0) {
                return true;
            }
            Log.e((String)"RFIDWithUHF", (String)("init() err UHFOpenAndConnect result:" + n));
        } else {
            Log.e((String)"RFIDWithUHF", (String)("init() err UHFInit result:" + n));
        }
        return false;
    }

    public synchronized boolean free() {
        this.getDeviceAPI().UHFCloseAndDisconnect();
        int n = this.getDeviceAPI().UHFFree();
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("free() err UHFFree result:" + n));
        return false;
    }

    public synchronized void crcOn() {
        this.getDeviceAPI().UHFFlagCrcOn();
    }

    public synchronized void crcOff() {
        this.getDeviceAPI().UHFFlafCrcOff();
    }

    public String convertUiiToEPC(String uii) {
        String string;
        if (StringUtility.isEmpty(uii)) {
            return "";
        }
        string = string.replace("-", "").toUpperCase();
        string = string.substring(4, string.length());
        return string;
    }

    public synchronized String getHardwareType() {
        char[] cArray = this.getDeviceAPI().UHFGetHwType();
        if (cArray != null && cArray[0] == '\u0000') {
            cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
            return new String(cArray);
        }
        Log.e((String)"RFIDWithUHF", (String)("getHardwareType() err:" + cArray[0]));
        return null;
    }

    public synchronized int getPower() {
        char[] cArray = this.getDeviceAPI().UHFGetPower();
        if (cArray != null && cArray[0] == '\u0000') {
            return cArray[1];
        }
        Log.e((String)"RFIDWithUHF", (String)("getPower() err :" + cArray[0]));
        return -1;
    }

    public synchronized boolean setPower(int power) {
        int n;
        n = this.getDeviceAPI().UHFSetPower((char)n);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("setPower() err :" + n));
        return false;
    }

    public synchronized int getFrequencyMode() {
        char[] cArray = this.getDeviceAPI().UHFGetFrequency_Ex();
        if (cArray != null && cArray[0] == '\u0000') {
            return cArray[1];
        }
        Log.e((String)"RFIDWithUHF", (String)("getFrequencyMode() err :" + cArray[0]));
        return -1;
    }

    public synchronized boolean setFrequencyMode(byte freMode) {
        int n;
        n = this.getDeviceAPI().UHFSetFrequency_EX((char)n);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("setFrequencyMode() err :" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean startInventory(int flagAnti, int initQ) {
        void var2_2;
        int n;
        n = this.getDeviceAPI().UHFInventory((char)n, (char)var2_2);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("startInventory() err :" + n));
        return false;
    }

    public synchronized String readUidFormBuffer() {
        char[] cArray = this.getDeviceAPI().UHFGetReceived();
        if (cArray == null || cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithUHF", (String)("readUidFormBuffer() err :" + cArray[0]));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized boolean stopInventory() {
        int n = this.getDeviceAPI().UHFStopGet();
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("stopInventory() err :" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean setPwm(int WorkTime, int WaitTime) {
        void var2_2;
        int n;
        n = this.getDeviceAPI().UHFSetPwm(n, (int)var2_2);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("setPwm() err :" + n));
        return false;
    }

    public synchronized int[] getPwm() {
        int[] nArray = this.getDeviceAPI().UHFGetPwm();
        if (nArray == null || nArray[0] != 0) {
            Log.e((String)"RFIDWithUHF", (String)("getPwm() err :" + nArray[0]));
            return null;
        }
        nArray = Arrays.copyOfRange(nArray, 1, nArray[1] + 1);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean setReadMode(SingelModeEnum mode) {
        void var1_1;
        int n = this.getDeviceAPI().UHFSetSingelMode((char)((SingelModeEnum)var1_1).a);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("setReadMode() err :" + n));
        return false;
    }

    public synchronized int getReadMode() {
        char[] cArray = this.getDeviceAPI().UHFGetSingelMode();
        if (cArray == null || cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithUHF", (String)("getReadMode() err :" + cArray[0]));
            return -1;
        }
        return cArray[1];
    }

    public synchronized String lockMem(String accessPwd, String lockCode) {
        char[] cArray;
        char[] cArray2;
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        cArray2 = StringUtility.hexString2Chars((String)cArray2);
        cArray = StringUtility.hexString2Chars((String)cArray);
        cArray2 = this.getDeviceAPI().UHFLockMemSingle(cArray2, cArray);
        if (cArray2[0] != '\u0000') {
            Log.e((String)"RFIDWithUHF", (String)("lockMem() err :" + cArray2[0]));
            return null;
        }
        cArray2 = Arrays.copyOfRange(cArray2, 2, cArray2[1] + 2);
        return StringUtility.chars2HexString(cArray2, cArray2.length);
    }

    public synchronized boolean lockMem(String accessPwd, String lockCode, String uii) {
        char[] cArray;
        char[] cArray2;
        char[] cArray3;
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        cArray3 = StringUtility.hexString2Chars((String)cArray3);
        cArray2 = StringUtility.hexString2Chars((String)cArray2);
        cArray = StringUtility.hexString2Chars((String)cArray);
        int n = this.getDeviceAPI().UHFLockMem(cArray3, cArray, cArray2);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("lockMem() err :" + n));
        return false;
    }

    public synchronized String inventorySingleTag() {
        char[] cArray = this.getDeviceAPI().UHFInventorySingle();
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithUHF", (String)("inventorySingleTag() err :" + cArray[0]));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized SimpleRFIDEntity readData(String accessPwd, BankEnum bank, int ptr, int cnt) {
        void var3_3;
        char[] cArray;
        Object object;
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        object = StringUtility.hexString2Chars((String)object);
        cArray = this.getDeviceAPI().UHFReadDataSingle((char[])object, (char)((BankEnum)cArray).a, (int)var3_3, (char)cnt);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithUHF", (String)("readData() err :" + cArray[0]));
            return null;
        }
        char[] cArray2 = Arrays.copyOfRange(cArray, 3, cArray[2] + 3);
        object = new SimpleRFIDEntity(StringUtility.chars2HexString(cArray2, cArray2.length), "UHF");
        cArray = Arrays.copyOfRange(cArray, 4 + cArray2.length, cArray[3 + cArray2.length] + 4 + cArray2.length);
        ((SimpleRFIDEntity)object).setData(StringUtility.chars2HexString(cArray, cnt << 1));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String readData(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        void var3_3;
        void var2_2;
        char[] cArray;
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return null;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        char[] cArray2 = StringUtility.hexString2Chars(uii);
        cArray = this.getDeviceAPI().UHFReadData(cArray, (char)((BankEnum)var2_2).a, (char)var3_3, (char)cnt, cArray2);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithUHF", (String)("readData() err :" + cArray[0]));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized String writeData(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        char[] cArray;
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return null;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        char[] cArray2 = StringUtility.hexString2Chars(data);
        char[] cArray3 = new char[cnt << 1];
        int n = 0;
        while (n < cArray3.length) {
            cArray3[n] = n < cArray2.length ? cArray2[n] : (char)'\u0000';
            ++n;
        }
        cArray2 = null;
        int n2 = 0;
        while (n2 < cnt) {
            char[] cArray4 = Arrays.copyOfRange(cArray3, n2 << 1, (n2 << 1) + 2);
            cArray2 = this.getDeviceAPI().UHFWriteDataSingle(cArray, (char)bank.a, n2 + ptr, '\u0001', cArray4);
            if (cArray2[0] != '\u0000') {
                Log.e((String)"RFIDWithUHF", (String)("writeData() err :" + cArray2[0]));
                return null;
            }
            ++n2;
        }
        if (cArray2 != null) {
            char[] cArray5 = Arrays.copyOfRange(cArray2, 2, cArray2[1] + 2);
            return StringUtility.chars2HexString(cArray5, cArray5.length);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean writeData(String accessPwd, BankEnum bank, int ptr, int cnt, String data, String uii) {
        void var3_4;
        void var2_3;
        char[] cArray;
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data) || StringUtility.isEmpty(uii)) {
            return false;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        char[] cArray2 = StringUtility.hexString2Chars(uii);
        char[] cArray3 = StringUtility.hexString2Chars(data);
        int n = this.getDeviceAPI().UHFWriteData(cArray, (char)((BankEnum)var2_3).a, (int)var3_4, (char)cnt, cArray2, cArray3);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("writeData() err :" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String eraseData(String accessPwd, BankEnum bank, int ptr, int cnt) {
        void var3_3;
        void var2_2;
        char[] cArray;
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        cArray = this.getDeviceAPI().UHFEraseDataSingle(cArray, (char)((BankEnum)var2_2).a, (int)var3_3, (char)cnt);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithUHF", (String)("eraseData() err :" + cArray[0]));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean eraseData(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        void var3_4;
        void var2_3;
        char[] cArray;
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        char[] cArray2 = StringUtility.hexString2Chars(uii);
        int n = this.getDeviceAPI().UHFEraseData(cArray, (char)((BankEnum)var2_3).a, (int)var3_4, (char)cnt, cArray2);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("eraseData() err :" + n));
        return false;
    }

    public synchronized String killTag(String killPwd) {
        char[] cArray;
        if (StringUtility.isEmpty(killPwd)) {
            return null;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        cArray = this.getDeviceAPI().UHFKillTagSingle(cArray);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithUHF", (String)("killTag() err :" + cArray[0]));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized boolean killTag(String killPwd, String uii) {
        char[] cArray;
        char[] cArray2;
        if (StringUtility.isEmpty(killPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        cArray2 = StringUtility.hexString2Chars((String)cArray2);
        cArray = StringUtility.hexString2Chars((String)cArray);
        int n = this.getDeviceAPI().UHFKillTag(cArray2, cArray);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithUHF", (String)("killTag() err :" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String generateLockCode(LockModeEnum killPwd, LockModeEnum accessPwd, LockModeEnum uii, LockModeEnum tid, LockModeEnum user) {
        void var3_5;
        void var2_3;
        byte by = killPwd.a;
        byte by2 = ((LockModeEnum)var2_3).a;
        byte by3 = ((LockModeEnum)var3_5).a;
        byte by4 = tid.a;
        byte by5 = user.a;
        byte[] byArray = new byte[3];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray2[1] = 0;
        byArray2[2] = 0;
        if (by == 1) {
            byArray2[0] = (byte)(byArray2[0] | 0xC);
            byArray2[1] = (byte)(byArray2[1] | 2);
        } else if (by == 2) {
            byArray2[0] = (byte)(byArray2[0] | 0xC);
            byArray2[1] = byArray2[1];
        } else if (by == 3) {
            byArray2[0] = (byte)(byArray2[0] | 0xC);
            byArray2[1] = (byte)(byArray2[1] | 3);
        } else if (by == 4) {
            byArray2[0] = (byte)(byArray2[0] | 0xC);
            byArray2[1] = (byte)(byArray2[1] | 1);
        } else {
            byArray2[0] = (byte)(byArray2[0] & 3);
            byArray2[1] = (byte)(byArray2[1] & 0xFC);
        }
        if (by2 == 1) {
            byArray2[0] = (byte)(byArray2[0] | 3);
            byArray2[2] = (byte)(byArray2[2] | 0x80);
        } else if (by2 == 2) {
            byArray2[0] = (byte)(byArray2[0] | 3);
            byArray2[2] = byArray2[2];
        } else if (by2 == 3) {
            byArray2[0] = (byte)(byArray2[0] | 3);
            byArray2[2] = (byte)(byArray2[2] | 0xC0);
        } else if (by2 == 4) {
            byArray2[0] = (byte)(byArray2[0] | 3);
            byArray2[2] = (byte)(byArray2[2] | 0x40);
        } else {
            byArray2[0] = (byte)(byArray2[0] & 0xC);
            byArray2[2] = (byte)(byArray2[2] & 0x3F);
        }
        if (by3 == 1) {
            byArray2[1] = (byte)(byArray2[1] | 0xC0);
            byArray2[2] = (byte)(byArray2[2] | 0x20);
        } else if (by3 == 2) {
            byArray2[1] = (byte)(byArray2[1] | 0xC0);
            byArray2[2] = byArray2[2];
        } else if (by3 == 3) {
            byArray2[1] = (byte)(byArray2[1] | 0xC0);
            byArray2[2] = (byte)(byArray2[2] | 0x30);
        } else if (by3 == 4) {
            byArray2[1] = (byte)(byArray2[1] | 0xC0);
            byArray2[2] = (byte)(byArray2[2] | 0x10);
        } else {
            byArray2[1] = (byte)(byArray2[1] & 0x3F);
            byArray2[2] = (byte)(byArray2[2] & 0xCF);
        }
        if (by4 == 1) {
            byArray2[1] = (byte)(byArray2[1] | 0x30);
            byArray2[2] = (byte)(byArray2[2] | 8);
        } else if (by4 == 2) {
            byArray2[1] = (byte)(byArray2[1] | 0x30);
            byArray2[2] = byArray2[2];
        } else if (by4 == 3) {
            byArray2[1] = (byte)(byArray2[1] | 0x30);
            byArray2[2] = (byte)(byArray2[2] | 0xC);
        } else if (by4 == 4) {
            byArray2[1] = (byte)(byArray2[1] | 0x30);
            byArray2[2] = (byte)(byArray2[2] | 4);
        } else {
            byArray2[1] = (byte)(byArray2[1] & 0xCF);
            byArray2[2] = (byte)(byArray2[2] & 0xF3);
        }
        if (by5 == 1) {
            byArray2[1] = (byte)(byArray2[1] | 0xC);
            byArray2[2] = (byte)(byArray2[2] | 2);
        } else if (by5 == 2) {
            byArray2[1] = (byte)(byArray2[1] | 0xC);
            byArray2[2] = byArray2[2];
        } else if (by5 == 3) {
            byArray2[1] = (byte)(byArray2[1] | 0xC);
            byArray2[2] = (byte)(byArray2[2] | 3);
        } else if (by5 == 4) {
            byArray2[1] = (byte)(byArray2[1] | 0xC);
            byArray2[2] = (byte)(byArray2[2] | 1);
        } else {
            byArray2[1] = (byte)(byArray2[1] & 0xF3);
            byArray2[2] = (byte)(byArray2[2] & 0xFC);
        }
        return StringUtility.bytes2HexString(byArray2, byArray2.length);
    }

    public static enum BankEnum {
        RESERVED(0),
        UII(1),
        TID(2),
        USER(3);

        private final byte a;

        public final byte getValue() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        private BankEnum(byte value) {
            void var3_3;
            this.a = var3_3;
        }
    }

    public static enum LockModeEnum {
        HOLD(0),
        LOCK(1),
        UNLOCK(2),
        PLOCK(3),
        PUNLOCK(4);

        private final byte a;

        public final byte getValue() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        private LockModeEnum(byte value) {
            void var3_3;
            this.a = var3_3;
        }
    }

    public static enum SingelModeEnum {
        SINGEL(0),
        MORE(1);

        private final byte a;

        public final byte getValue() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        private SingelModeEnum(byte value) {
            void var3_3;
            this.a = var3_3;
        }
    }
}

